//=============================================================================
// HXOfficeChair.
//=============================================================================
class HXOfficeChair extends HXSeat;

enum ESkinColor
{
	SC_GrayLeather,
	SC_BrownLeather,
	SC_BrownCloth,
	SC_GrayCloth
};

var() ESkinColor SkinColor;

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local OfficeChair OtherOfficeChair;

	// Call Super.
	Super.Succeeds( Other );

	// Special OfficeChair Init.
	OtherOfficeChair = OfficeChair(Other);
	if ( OtherOfficeChair!=None )
	{
		SetPropertyText("SkinColor", OtherOfficeChair.GetPropertyText("SkinColor") );
	}
}

// ----------------------------------------------------------------------------
// BeginPlay()
// ----------------------------------------------------------------------------

simulated function BeginPlay()
{
	Super.BeginPlay();

	if ( Role==ROLE_Authority && !IsInRelevant() )
	{
		switch ( SkinColor )
		{
			case SC_GrayLeather:  Skin = Texture'OfficeChairTex1'; break;
			case SC_BrownLeather: Skin = Texture'OfficeChairTex2'; break;
			case SC_BrownCloth:   Skin = Texture'OfficeChairTex3'; break;
			case SC_GrayCloth:    Skin = Texture'OfficeChairTex4'; break;
		}
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	SitPoint(0)=(X=0.0,Y=-4.0,Z=0.0)
	ItemName="Swivel Chair"
	Mesh=OfficeChair
	Skin=OfficeChairTex1
	CollisionRadius=16.00
	//CollisionHeight=25.55
	CollisionHeight=24.80
	Mass=30.0
	Buoyancy=5.0
}
