//=============================================================================
// HXOrdersTrigger.
//
// Send an NPC on a patrol route.
//=============================================================================
class HXOrdersTrigger extends HXTrigger;

var() Name Orders;
var() Name OrdersTag;

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local OrdersTrigger OtherOrdersTrigger;

	// Call Super.
	Super.Succeeds( Other );

	// Special OrdersTrigger Init.
	OtherOrdersTrigger = OrdersTrigger(Other);
	if ( OtherOrdersTrigger!=None )
	{
		Orders    = OtherOrdersTrigger.Orders;
		OrdersTag = OtherOrdersTrigger.OrdersTag;
	}
}

// ----------------------------------------------------------------------------
// Trigger()
// ----------------------------------------------------------------------------

function Trigger( Actor Other, Pawn Instigator )
{
	StartPatrolling();

	Super.Trigger( Other, Instigator );

	if ( bTriggerOnceOnly )
		Destroy();
}

// ----------------------------------------------------------------------------
// Touch()
// ----------------------------------------------------------------------------

singular function Touch( Actor Other )
{
	if ( !IsRelevant(Other) )
		return;

	StartPatrolling();

	if ( bTriggerOnceOnly )
		Destroy();
}

// ----------------------------------------------------------------------------
// StartPatrolling()
// ----------------------------------------------------------------------------

function StartPatrolling()
{
	local HXScriptedPawn ScriptedPawn;
	local Pawn Pawn;

	if ( Event=='' )
		return;

	// Find the target NPC to start on the patrol route.
	for ( Pawn=Level.PawnList; Pawn!=None; Pawn=Pawn.NextPawn )
	{
		// Does not need to check the Event=='' case to match AllActors interator, as this case was ruled out above.
		if ( Pawn.Tag!=Event )
			continue;

		ScriptedPawn = HXScriptedPawn(Pawn);
		if ( ScriptedPawn==None )
			continue;

		ScriptedPawn.SetOrders( Orders, OrdersTag, true );
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	bTriggerOnceOnly=True
	CollisionRadius=96.0
}
