//=============================================================================
// HXPaulDenton.
//
// Damage type table for Paul Denton:
//
// Shot			- 100%
// Sabot		- 100%
// Exploded		- 100%
// TearGas		- 10%
// PoisonGas	- 10%
// Poison		- 10%
// PoisonEffect	- 10%
// HalonGas		- 10%
// Radiation	- 10%
// Shocked		- 10%
// Stunned		- 0%
// KnockedOut   - 0%
// Flamed		- 0%
// Burned		- 0%
// NanoVirus	- 0%
// EMP			- 0%
//
//=============================================================================
class HXPaulDenton extends HXHumanMilitary;

var localized String ApparentlyNotCain;

function float ShieldDamage(name damageType)
{
	// handle special damage types
	if ((damageType == 'Flamed') || (damageType == 'Burned') || (damageType == 'Stunned') ||
	    (damageType == 'KnockedOut'))
		return 0.0;
	else if ((damageType == 'TearGas') || (damageType == 'PoisonGas') || (damageType == 'HalonGas') ||
			(damageType == 'Radiation') || (damageType == 'Shocked') || (damageType == 'Poison') ||
	        (damageType == 'PoisonEffect'))
		return 0.1;
	else
		return Super.ShieldDamage(damageType);
}

function GotoDisabledState(name damageType, EHitLocation hitPos)
{
	if (!bCollideActors && !bBlockActors && !bBlockPlayers)
		return;
	if (CanShowPain())
		TakeHit(hitPos);
	else
		GotoNextState();
}

// ----------------------------------------------------------------------------
// KillMessage()
// ----------------------------------------------------------------------------

function string KillMessage( Name DamageType, Pawn Other )
{
	return ApparentlyNotCain;
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	ApparentlyNotCain="'s second name was apparently not Cain."
	CarcassType=PaulDentonCarcass
	WalkingSpeed=0.120000
	bImportant=True
	bInvincible=True
	BaseAssHeight=-23.000000
	InitialInventory(0)=(Inventory=Class'WeaponAssaultGun')
	InitialInventory(1)=(Inventory=Class'Ammo762mm',Count=12)
	InitialInventory(2)=(Inventory=Class'WeaponPlasmaRifle')
	InitialInventory(3)=(Inventory=Class'AmmoPlasma')
	InitialInventory(4)=(Inventory=Class'WeaponSword')
	BurnPeriod=0.000000
	bHasCloak=True
	CloakThreshold=100
	Health=200
	HealthHead=200
	HealthTorso=200
	HealthLegLeft=200
	HealthLegRight=200
	HealthArmLeft=200
	HealthArmRight=200
	Mesh=GM_Trench
	MultiSkins(0)=PaulDentonTex0
	MultiSkins(1)=PaulDentonTex2
	MultiSkins(2)=PantsTex8
	MultiSkins(3)=PaulDentonTex0
	MultiSkins(4)=PaulDentonTex1
	MultiSkins(5)=PaulDentonTex2
	MultiSkins(6)=GrayMaskTex
	MultiSkins(7)=BlackMaskTex
	CollisionRadius=20.0
	//CollisionHeight=47.5
	CollisionHeight=43.0
	BindName="PaulDenton"
	FamiliarName="Paul Denton"
	UnfamiliarName="Paul Denton"
}
