//=============================================================================
// HXPersonaBaseWindow
//=============================================================================
class HXPersonaBaseWindow extends PersonaBaseWindow;

/*
var DeusExPlayer player;

// Border and Background Translucency
var bool bDrawBorder;
var EDrawStyle BorderDrawStyle;
var EDrawStyle BackgroundDrawStyle;

// Default Colors
var Color ColBackground;
var Color ColBorder;
var Color ColHeaderText;
var Color ColText;
*/

// ----------------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window
// ----------------------------------------------------------------------------

event InitWindow()
{
	Super(Window).InitWindow();
	
	// Get a pointer to the player
	player = DeusExPlayer(GetRootWindow().parentPawn);

	StyleChanged();
}

// ----------------------------------------------------------------------------
// DrawWindow()
// ----------------------------------------------------------------------------

event DrawWindow( GC Context )
{
	// First draw background then the border.
	DrawBackground( Context );

	// Don't call the DrawBorder routines if they are disabled.
	if ( bDrawBorder )
		DrawBorder( Context );
}

// ----------------------------------------------------------------------------
// DrawBackground()
// ----------------------------------------------------------------------------

function DrawBackground( GC Context );

// ----------------------------------------------------------------------------
// DrawBorder()
// ----------------------------------------------------------------------------

function DrawBorder( GC Context );

// ----------------------------------------------------------------------------
// StyleChanged()
// ----------------------------------------------------------------------------

event StyleChanged()
{
	local ColorTheme theme;

	theme = player.ThemeManager.GetCurrentHUDColorTheme();

	ColBackground = theme.GetColorFromName('HUDColor_Background');
	ColBorder     = theme.GetColorFromName('HUDColor_Borders');
	ColText       = theme.GetColorFromName('HUDColor_NormalText');
	ColHeaderText = theme.GetColorFromName('HUDColor_HeaderText');

	bDrawBorder            = player.GetHUDBordersVisible();

	if (player.GetHUDBorderTranslucency())
		BorderDrawStyle = DSTY_Translucent;
	else
		BorderDrawStyle = DSTY_Masked;

	if (player.GetHUDBackgroundTranslucency())
		BackgroundDrawStyle = DSTY_Translucent;
	else
		BackgroundDrawStyle = DSTY_Masked;
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	bDrawBorder=True
}
