//=============================================================================
// HXPersonaInventoryInfoWindow
//=============================================================================
class HXPersonaInventoryInfoWindow extends HXPersonaInfoWindow;

var TileWindow WinTileAmmo;
var localized String AmmoLabel;
var localized String ShowAmmoDescriptionsLabel;

var PersonaAmmoDetailButton      SelectedAmmoButton;
var PersonaInfoItemWindow        LastAmmoLoaded;
var PersonaInfoItemWindow	       LastAmmoTypes;
var PersonaNormalLargeTextWindow LastAmmoDescription;

var HXAmmoInfoWindow             SelectedAmmoInfoWindow;

// ----------------------------------------------------------------------
// AddAmmoInfoWindow()
// ----------------------------------------------------------------------

function AddAmmoInfoWindow( HXAmmo Ammo, bool bShowDescriptions )
{
	local HXAmmoInfoWindow WinAmmo;
	local PersonaNormalTextWindow WinText;
	local Window WinIcon;

	if ( Ammo!=None )
	{
		WinAmmo = HXAmmoInfoWindow( WinTile.NewChild(Class'HXAmmoInfoWindow') );
		WinAmmo.SetAmmo( Ammo, bShowDescriptions );

		AddLine();
	}
}

// ----------------------------------------------------------------------
// AddAmmoInfoWindow()
// ----------------------------------------------------------------------

function SelectAmmoInfoWindow( HXAmmoInfoWindow SelectedButton )
{
	Log( "SelectAmmoInfoWindow()" );

	// Deselect.
	if ( SelectedAmmoInfoWindow!=None )
	{
		SelectedAmmoInfoWindow.SelectButton( False );
		SelectedAmmoInfoWindow = None;
	}

	// Select.
	if ( SelectedButton!=None )
	{
		SelectedAmmoInfoWindow = SelectedButton;
		SelectedAmmoInfoWindow.SelectButton( True );
	}
}

// ----------------------------------------------------------------------
// AddAmmoCheckbox()
// ----------------------------------------------------------------------

function AddAmmoCheckbox( bool bChecked )
{
	local PersonaCheckboxWindow WinCheck;

	WinCheck = PersonaCheckboxWindow( WinTile.NewChild(Class'PersonaCheckboxWindow') );
	WinCheck.SetFont( Font'FontMenuSmall' );
	WinCheck.SetText( ShowAmmoDescriptionsLabel );
	WinCheck.SetToggle( bChecked );
}

// ----------------------------------------------------------------------
// CreateAmmoTileWindow()
// ----------------------------------------------------------------------

function CreateAmmoTileWindow()
{
	local PersonaNormalTextWindow WinText;

	if ( WinTileAmmo==None )
	{
		WinTileAmmo = TileWindow( WinTile.NewChild(Class'TileWindow') );
		WinTileAmmo.SetOrder( ORDER_Right );
		WinTileAmmo.SetChildAlignments( HALIGN_Left, VALIGN_Full );
		WinTileAmmo.SetWindowAlignments( HALIGN_Full, VALIGN_Top );
		WinTileAmmo.MakeWidthsEqual( False );
		WinTileAmmo.MakeHeightsEqual( True );
		WinTileAmmo.SetMargins( 0, 0 );
		WinTileAmmo.SetMinorSpacing( 4 );

		WinText = PersonaNormalTextWindow( WinTileAmmo.NewChild(Class'PersonaNormalTextWindow') );
		WinText.SetWidth( 70 );
		WinText.SetTextMargins( 0, 6 );
		WinText.SetTextAlignments( HALIGN_Right, VALIGN_Center );
		WinText.SetText( AmmoLabel );
	}
}

// ----------------------------------------------------------------------
// AddAmmo()
// ----------------------------------------------------------------------

function AddAmmo( Class<Ammo> Ammo, bool bHasIt, optional int NewRounds )
{
	local PersonaAmmoDetailButton AmmoButton;

	if ( WinTileAmmo==None )
		CreateAmmoTileWindow();

	AmmoButton = PersonaAmmoDetailButton( WinTileAmmo.NewChild(Class'PersonaAmmoDetailButton') );
	AmmoButton.SetAmmo( Ammo, bHasIt, NewRounds );
}

// ----------------------------------------------------------------------
// AddAmmoLoadedItem()
// ----------------------------------------------------------------------

function AddAmmoLoadedItem( String NewLabel, String NewText )
{
	LastAmmoLoaded = AddInfoItem( NewLabel, NewText );
}

// ----------------------------------------------------------------------
// UpdateAmmoLoaded()
// ----------------------------------------------------------------------

function UpdateAmmoLoaded( String NewText )
{
	if ( LastAmmoLoaded!=None )
		LastAmmoLoaded.SetItemText( NewText );
}

// ----------------------------------------------------------------------
// AddAmmoTypesItem()
// ----------------------------------------------------------------------

function AddAmmoTypesItem( String NewLabel, String NewText )
{
	LastAmmoTypes = AddInfoItem( NewLabel, NewText );
}

// ----------------------------------------------------------------------
// UpdateAmmoTypes()
// ----------------------------------------------------------------------

function UpdateAmmoTypes( String NewText )
{
	if ( LastAmmoTypes!=None )
		LastAmmoTypes.SetItemText( NewText );
}

// ----------------------------------------------------------------------
// AddAmmoDescription()
// ----------------------------------------------------------------------

function AddAmmoDescription( String NewDesc )
{
	LastAmmoDescription = SetText( NewDesc );
}

// ----------------------------------------------------------------------
// UpdateAmmoDescription()
// ----------------------------------------------------------------------

function UpdateAmmoDescription( String NewDesc )
{
	if ( LastAmmoDescription!=None )
		LastAmmoDescription.SetText( NewDesc );
}

// ----------------------------------------------------------------------
// GetSelectedAmmo()
// ----------------------------------------------------------------------

function Class<Ammo> GetSelectedAmmo()
{
	local Window CurrentWindow;

	if ( SelectedAmmoButton!=None )
	{
		return SelectedAmmoButton.GetAmmo();
	}
	else
	{
		CurrentWindow = WinTileAmmo.GetTopChild();
		while( CurrentWindow!=None )
		{
			if ( PersonaAmmoDetailButton(CurrentWindow)!=None )
			{
				if ( PersonaAmmoDetailButton(CurrentWindow).IsLoaded() )
				{
					return PersonaAmmoDetailButton(CurrentWindow).GetAmmo();
					break;
				}
			}
			CurrentWindow = CurrentWindow.GetLowerSibling();
		}
	}

	return None;
}

// ----------------------------------------------------------------------
// SetLoaded()
//
// Loops through all the ammo, setting the background color to green if
// the ammo is loaded, otherwise black.
// ----------------------------------------------------------------------

function SetLoaded( Class<Ammo> Ammo )
{
	local Window CurrentWindow;

	CurrentWindow = WinTileAmmo.GetTopChild();
	while( CurrentWindow!=None )
	{
		if ( PersonaAmmoDetailButton(CurrentWindow)!=None )
		{
			PersonaAmmoDetailButton(CurrentWindow).SetLoaded(CurrentWindow.GetClientObject()==Ammo );
			PersonaAmmoDetailButton(CurrentWindow).SelectButton(CurrentWindow.GetClientObject()==Ammo );

			// Keep track of the selected button
			if ( CurrentWindow.GetClientObject()==Ammo )
				SelectedAmmoButton = PersonaAmmoDetailButton(CurrentWindow);
		}
		CurrentWindow = CurrentWindow.GetLowerSibling();
	}
}

// ----------------------------------------------------------------------
// SelectAmmoButton()
// ----------------------------------------------------------------------

function SelectAmmoButton( PersonaAmmoDetailButton SelectedButton )
{
	local Window currentWindow;

	CurrentWindow = winTileAmmo.GetTopChild();
	while( CurrentWindow!=None )
	{
		if ( PersonaAmmoDetailButton(CurrentWindow)!=None )
		{
			PersonaAmmoDetailButton(CurrentWindow).SetLoaded( SelectedButton==CurrentWindow );
			PersonaAmmoDetailButton(CurrentWindow).SelectButton( SelectedButton==CurrentWindow );
		}
		CurrentWindow = CurrentWindow.GetLowerSibling();
	}

	// Keep track of the selected button
	SelectedAmmoButton = SelectedButton;
}

// ----------------------------------------------------------------------
// Clear()
// ----------------------------------------------------------------------

function Clear()
{
	Super.Clear();
	WinTileAmmo = None;
	SelectedAmmoInfoWindow = None;
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	AmmoLabel="Ammo:"
	ShowAmmoDescriptionsLabel="Show Ammo Descriptions"
}
