//=============================================================================
// PersonaInventoryObjectBelt
//=============================================================================
class HXPersonaInventoryObjectBelt extends HXWindow;

var HXPersonaScreenInventory winInventory;	// Pointer to inventory window
var HXHUDObjectBelt objBelt;			// Our local object Belt
var HXHUDObjectBelt hudBelt;			// HUD Object Belt

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window
// ----------------------------------------------------------------------

event InitWindow()
{
	local HXRootWindow root;
	local float hudBeltWidth, hudBeltHeight;

	Super.InitWindow();

	SetSize(631, 69);

	hudBelt = HXDeusExHUD(HXRootWindow(GetRootWindow()).hud).hxbelt;

	// Create our local object belt, then get a pointer to the HUD belt
	objBelt = HXHUDObjectBelt(NewChild(Class'HXHUDObjectBelt'));
	objBelt.SetPos(90, 0);
	objBelt.SetVisibility(True);
	objBelt.SetInteractive(True);

	if ( !hudBelt.IsVisible() )
	{
		hudBelt.Show();
		hudBelt.Hide();
	}

	// Copy the items from HUD belt into our local belt
	//CopyObjectBeltInventory();
}

// ----------------------------------------------------------------------
// DestroyWindow()
// ----------------------------------------------------------------------

event DestroyWindow()
{
	hudBelt.AssignWinInv(None);

	Super.DestroyWindow();
}

// ----------------------------------------------------------------------
// SetInventoryWindow()
// ----------------------------------------------------------------------

function SetInventoryWindow( HXPersonaScreenInventory newWinInventory )
{
	winInventory = newWinInventory;

	// Set all the object belt winInv 
	objBelt.AssignWinInv(newWinInventory);
}

// ----------------------------------------------------------------------
// AssignObjectBeltByKey()
// ----------------------------------------------------------------------

function AssignObjectBeltByKey(Inventory invItem, EInputKey key)
{
	local int ObjectNum;

	if ( key<IK_1 || key>IK_9 )
		return;

	// Typecasting EInputKey to int doesn't seem to work.
	// All I have to say to that is BAH.

	// 0 (Zero) cannot be assigned because that position is used
	// by the NanoKeyRing

	switch( key ) 
	{
		case IK_1:
			objectNum = 1;
			break;
		case IK_2:
			objectNum = 2;
			break;
		case IK_3:
			objectNum = 3;
			break;
		case IK_4:
			objectNum = 4;
			break;
		case IK_5:
			objectNum = 5;
			break;
		case IK_6:
			objectNum = 6;
			break;
		case IK_7:
			objectNum = 7;
			break;
		case IK_8:
			objectNum = 8;
			break;
		case IK_9:
			objectNum = 9;
			break;
	}

	PlayerPawn.AddObjectToBelt( InvItem, ObjectNum, false );
}

// ----------------------------------------------------------------------
// SelectObject()
// ----------------------------------------------------------------------

function SelectObject( Inventory Item, bool bNewToggle )
{
	local int objectIndex;

	for ( objectIndex=0; objectIndex<10; objectIndex++ )
	{
		if ( objBelt.objects[objectIndex].GetItem()==Item )
		{
			if (!objBelt.objects[objectIndex].GetToggle())
				objBelt.objects[objectIndex].SetToggle(bNewToggle);
		}
		else
		{
			// Make sure no other objects are toggled.
			objBelt.objects[objectIndex].SetToggle(False);		
			objBelt.objects[objectIndex].HighlightSelect(False);
		}
	}
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
}
