//=============================================================================
// HXPersonaScreenAugmentationsMedBot.
//=============================================================================
class HXPersonaScreenAugmentationsMedBot extends HXPersonaScreenAugmentations;

var PersonaActionButtonWindow InstallButton;
var TileWindow winAugsTile;

var HXMedicalBot MedBot;

var localized string AvailableAugsText;
var localized string MedbotInterfaceText;
var localized string InstallButtonLabel;
var localized string NoCansAvailableText;
var localized string AlreadyHasItText;
var localized string SlotFullText;
var localized string SelectAnotherText;

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window
// ----------------------------------------------------------------------

event InitWindow()
{
	Super.InitWindow();

	HXHUDMedBotNavBarWindow(winNavBar).AugsButton.SetSensitivity( false );

	PopulateAugCanList();

	//EnableButtons();

	//bTickEnabled = true;
}

// ----------------------------------------------------------------------
// DestroyWindow()
//
// Let the MedBot go about its business.
// ----------------------------------------------------------------------

event DestroyWindow()
{
	local HXPlayerPawn HXPlayerPawn;

	if ( MedBot!=None )
	{
		HXPlayerPawn = HXPlayerPawn(Player);

		// I.. lets say it's debug output..
		if ( Player!=Player.GetPlayerPawn() )
		{
			Log( "DestroyWindow() ==============>Player mismatch!!!! ", Name );
		}
		else if ( HXPlayerPawn.ActivePawn==MedBot )
		{
			HXPlayerPawn.ClosePawn( MedBot );
			HXPlayerPawn.ActivePawn = None;
		}
	}

	Super.DestroyWindow();
}

// ----------------------------------------------------------------------
// CreateControls()
// ----------------------------------------------------------------------

function CreateControls()
{
	CreateNavBarWindow();
	CreateClientBorderWindow();
	CreateClientWindow();

	CreateTitleWindow(9, 5, AugmentationsTitleText);
	CreateInfoWindow();
	CreateButtons();
	CreateAugmentationLabels();
	CreateAugmentationHighlights();
	CreateAugmentationButtons();
	CreateOverlaysWindow();
	CreateBodyWindow();
	CreateAugsLabel();
	CreateAugCanList();
	CreateMedbotLabel();
}

// ----------------------------------------------------------------------
// CreateNavBarWindow()
// ----------------------------------------------------------------------

function CreateNavBarWindow()
{
	winNavBar = HXPersonaNavBarBaseWindow(NewChild(Class'HXHUDMedBotNavBarWindow')); 
	winNavBar.SetPos(0, 0);
}

// ----------------------------------------------------------------------
// CreateButtons()
// ----------------------------------------------------------------------

function CreateButtons()
{
	local PersonaButtonBarWindow winActionButtons;

	winActionButtons = PersonaButtonBarWindow(winClient.NewChild(Class'PersonaButtonBarWindow'));
	winActionButtons.SetPos(346, 371);
	winActionButtons.SetWidth(96);

	InstallButton = PersonaActionButtonWindow(winActionButtons.NewChild(Class'PersonaActionButtonWindow'));
	InstallButton.SetButtonText(InstallButtonLabel);
}

// ----------------------------------------------------------------------
// CreateInfoWindow()
// ----------------------------------------------------------------------

function CreateInfoWindow()
{
	winInfo = HXPersonaInfoWindow(winClient.NewChild(Class'HXPersonaInfoWindow'));
	winInfo.SetPos(348, 158);
	winInfo.SetSize(238, 210);
}

// ----------------------------------------------------------------------
// CreateAugsLabel()
// ----------------------------------------------------------------------

function CreateAugsLabel()
{
	CreatePersonaHeaderText(349, 15, AvailableAugsText, winClient);
}

// ----------------------------------------------------------------------
// CreateMedbotLabel()
// ----------------------------------------------------------------------

function CreateMedbotLabel()
{
	local PersonaHeaderTextWindow txtLabel;

	txtLabel = PersonaHeaderTextWindow(NewChild(Class'PersonaHeaderTextWindow'));
	txtLabel.SetPos(305, 9);
	txtLabel.SetSize(250, 16);
	txtLabel.SetTextAlignments(HALIGN_Right, VALIGN_Center);
	txtLabel.SetText(MedbotInterfaceText);
}

// ----------------------------------------------------------------------
// CreateAugCanList()
// ----------------------------------------------------------------------

function CreateAugCanList()
{
	local PersonaScrollAreaWindow winScroll;

	// First create the scroll window
	winScroll = PersonaScrollAreaWindow(winClient.NewChild(Class'PersonaScrollAreaWindow'));
	winScroll.SetPos(348, 34);
	winScroll.SetSize(238, 116);

	winAugsTile = TileWindow(winScroll.ClipWindow.NewChild(Class'TileWindow'));
	winAugsTile.MakeWidthsEqual(False);
	winAugsTile.MakeHeightsEqual(False);
	winAugsTile.SetMinorSpacing(1);
	winAugsTile.SetMargins(0, 0);
	winAugsTile.SetOrder(ORDER_Down);
}

// ----------------------------------------------------------------------
// PopulateAugCanList()
// ----------------------------------------------------------------------

function PopulateAugCanList()
{
	local Inventory item;
	local int canCount;
	local HXHUDMedBotAugCanWindow augCanWindow;
	local PersonaNormalTextWindow txtNoCans;

	winAugsTile.DestroyAllChildren();

	// Loop through all the Augmentation Cannisters in the player's 
	// inventory, adding one row for each can.
	item = player.Inventory;

	while(item != None)
	{
		if (item.IsA('HXAugmentationCannister'))
		{
			augCanWindow = HXHUDMedBotAugCanWindow(winAugsTile.NewChild(Class'HXHUDMedBotAugCanWindow'));
			augCanWindow.SetCannister(HXAugmentationCannister(item));

			canCount++;
		}
		item = item.Inventory;
	}

	// If we didn't add any cans, then display "No Aug Cannisters Available!"
	if (canCount == 0)
	{
		txtNoCans = PersonaNormalTextWindow(winAugsTile.NewChild(Class'PersonaNormalTextWindow'));
		txtNoCans.SetText(NoCansAvailableText);
		txtNoCans.SetTextMargins(4, 4);
		txtNoCans.SetTextAlignments(HALIGN_Left, VALIGN_Center);
	}
}

// ----------------------------------------------------------------------
// UpdateAugCanList()
// ----------------------------------------------------------------------

function UpdateAugCanList(class FreshAugClass, int cranialCount, int eyeCount, int torsoCount, int armCount, int legCount, int skinCount)
{
	local HXAugmentationCannister augCan;
	local Window win;
	local string augDesc;

	win = winAugsTile.firstChild;

	while ( win != None )
	{
		if ( win.isA('HXHUDMedBotAugCanWindow') )
		{
			augCan = HXHUDMedBotAugCanWindow(win).GetCannister();

			if (!HXHUDMedBotAugCanWindow(win).btnAug1.bHasIt)
				if (augCan.GetAugmentation(0).class == FreshAugClass)
					HXHUDMedBotAugCanWindow(win).btnAug1.bHasIt = true;

			if (!HXHUDMedBotAugCanWindow(win).btnAug2.bHasIt)
				if (augCan.GetAugmentation(1).class == FreshAugClass)
					HXHUDMedBotAugCanWindow(win).btnAug2.bHasIt = true;

			switch (augCan.GetAugmentation(0).AugmentationLocation)
			{
				case LOC_Cranial:
					if (cranialCount > 0)
						HXHUDMedBotAugCanWindow(win).btnAug1.bSlotFull = true;
					break;
				case LOC_Eye:
					if (eyeCount > 0)
						HXHUDMedBotAugCanWindow(win).btnAug1.bSlotFull = true;
					break;
				case LOC_Torso:
					if (torsoCount > 2)
						HXHUDMedBotAugCanWindow(win).btnAug1.bSlotFull = true;
					break;
				case LOC_Arm:
					if (armCount > 0)
						HXHUDMedBotAugCanWindow(win).btnAug1.bSlotFull = true;
					break;
				case LOC_Leg:
					if (legCount > 0)
						HXHUDMedBotAugCanWindow(win).btnAug1.bSlotFull = true;
					break;
				case LOC_Subdermal:
					if (skinCount > 1)
						HXHUDMedBotAugCanWindow(win).btnAug1.bSlotFull = true;
					break;		
			}

			switch (augCan.GetAugmentation(1).AugmentationLocation)
			{
				case LOC_Cranial:
					if (cranialCount > 0)
						HXHUDMedBotAugCanWindow(win).btnAug2.bSlotFull = true;
					break;
				case LOC_Eye:
					if (eyeCount > 0)
						HXHUDMedBotAugCanWindow(win).btnAug2.bSlotFull = true;
					break;
				case LOC_Torso:
					if (torsoCount > 2)
						HXHUDMedBotAugCanWindow(win).btnAug2.bSlotFull = true;
					break;
				case LOC_Arm:
					if (armCount > 0)
						HXHUDMedBotAugCanWindow(win).btnAug2.bSlotFull = true;
					break;
				case LOC_Leg:
					if (legCount > 0)
						HXHUDMedBotAugCanWindow(win).btnAug2.bSlotFull = true;
					break;
				case LOC_Subdermal:
					if (skinCount > 1)
						HXHUDMedBotAugCanWindow(win).btnAug2.bSlotFull = true;
					break;		
			}
		}

		win = win.nextSibling;
	}
}

// ----------------------------------------------------------------------
// ButtonActivated()
// ----------------------------------------------------------------------

function bool ButtonActivated( Window ButtonPressed )
{
	switch( ButtonPressed )
	{
		case InstallButton:
			InstallAugmentation();
			return true;
			break;

		default:
			return Super.ButtonActivated( ButtonPressed );
			break;
	}
}

// ----------------------------------------------------------------------
// Tick()
// ----------------------------------------------------------------------

event Tick( float DeltaTime )
{
	if ( MedBot==None || MedBot.bDeleteMe )
	{
		// Hope this won't trigger straight ahead on opening.
		Root.PopWindow();
	}
	else
	{
		// Update.
	
	}
}

// ----------------------------------------------------------------------
// SelectAugmentation()
// ----------------------------------------------------------------------

function SelectAugmentation(PersonaItemButton buttonPressed)
{
	// Don't do extra work.
	if (selectedAugButton != buttonPressed)
	{
		// Deselect current button
		if (selectedAugButton != None)
			selectedAugButton.SelectButton(False);

		selectedAugButton = buttonPressed;
		selectedAug       = Augmentation(selectedAugButton.GetClientObject());

		// Check to see if this augmentation has already been installed
		if (HXHUDMedBotAugItemButton(buttonPressed).bHasIt)
		{
			winInfo.Clear();
			winInfo.SetTitle(selectedAug.AugmentationName);
			winInfo.SetText(AlreadyHasItText);
			winInfo.SetText(SelectAnotherText); 
			selectedAug = None;
			selectedAugButton = None;
		}
		else if (HXHUDMedBotAugItemButton(buttonPressed).bSlotFull) 
		{
			winInfo.Clear();
			winInfo.SetTitle(selectedAug.AugmentationName);
			winInfo.SetText(SlotFullText);
			winInfo.SetText(SelectAnotherText); 
			selectedAug = None;
			selectedAugButton = None;
		}
		else
		{
			selectedAug.UsingMedBot(True);
			selectedAug.UpdateInfo(winInfo);
			selectedAugButton.SelectButton(True);
		}

		EnableButtons();
	}
}

// ----------------------------------------------------------------------
// InstallAugmentation()
// ----------------------------------------------------------------------

function InstallAugmentation()
{
	local HXAugmentationCannister augCan;
	local Augmentation aug;
	local int augX, augY;
	local int cranialCount, eyeCount, torsoCount, armCount, legCount, skinCount;
	local int augCount;

	if (HXHUDMedBotAugItemButton(selectedAugButton) == None)
		return;
		
	// Iterate through the augmentations, creating a unique button for each
	aug = player.AugmentationSystem.FirstAug;

	while( aug != None )
	{
		if (( aug.AugmentationName != "" ) && ( aug.bHasIt ))
		{
			switch (aug.AugmentationLocation)
			{
				case LOC_Cranial:
					cranialCount++;
					break;
				case LOC_Eye:
					eyeCount++;
					break;
				case LOC_Torso:
					torsoCount++;
					break;
				case LOC_Arm:
					armCount++;
					break;
				case LOC_Leg:
					legCount++;
					break;
				case LOC_Subdermal:
					skinCount++;
					break;
			}

		}

		aug = aug.next;
	}

	// Get pointers to the AugmentationCannister and the 
	// Augmentation Class

	augCan = HXHUDMedBotAugItemButton(selectedAugButton).GetAugCan();
	aug    = HXHUDMedBotAugItemButton(selectedAugButton).GetAugmentation();

	// Add this augmentation (if we can get this far, then the augmentation
	// to be added is a valid one, as the checks to see if we already have
	// the augmentation and that there's enough space were done when the 
	// AugmentationAddButtons were created)

	HXAugmentationManager(player.AugmentationSystem).MPGivePlayerAugmentation( aug.class, augCan, MedBot );

	// play a cool animation
	//MedBot.PlayAnim('Scan');

	// Now Destroy the Augmentation cannister
	//player.DeleteInventory(augCan);

	// Now remove the cannister from our list
	selectedAugButton.GetParent().Destroy();
	selectedAugButton = None;
	selectedAug       = None;

	// Update the Installed Augmentation Icons
	//DestroyAugmentationButtons();
	//CreateAugmentationButtons();

	for( augCount=0; augCount < arrayCount( augItems ) && augItems[augCount] != None; augCount++ );

	augX = augLocs[int(aug.AugmentationLocation)].x;
	augY = augLocs[int(aug.AugmentationLocation)].y;

	// Show the highlight graphic for this augmentation slot as long
	// as it's not the Default slot (for which there is no graphic)
	if (aug.AugmentationLocation < arrayCount(augHighlightWindows))
		augHighlightWindows[aug.AugmentationLocation].Show();

	// Torso
	if (int(aug.AugmentationLocation) == 2)
		augY += torsoCount * augSlotSpacingY;

	// Subdermal
	else if (int(aug.AugmentationLocation) == 5)
		augY += skinCount * augSlotSpacingY;

	augItems[augCount] = CreateAugButton( aug, augX, augY, 0 );

	// If the augmentation is active, make sure the button draws it 
	// appropriately
	augItems[augCount].SetActive( aug.IsActive() );

	// Need to update the aug list
	UpdateAugCanList(aug.class, cranialCount, eyeCount, torsoCount, armCount, legCount, skinCount);
}


// ----------------------------------------------------------------------
// DestroyAugmentationButtons()
// ----------------------------------------------------------------------

function DestroyAugmentationButtons()
{
	local int buttonIndex;

	for(buttonIndex=0; buttonIndex<arrayCount(augItems); buttonIndex++)
	{
		if (augItems[buttonIndex] != None)
			augItems[buttonIndex].Destroy();
	}
}

// ----------------------------------------------------------------------
// EnableButtons()
// ----------------------------------------------------------------------

function EnableButtons()
{
	// Only enable the Install button if the player has an 
	// Augmentation Cannister aug button selected.
	InstallButton.EnableWindow( HXHUDMedBotAugItemButton(SelectedAugButton)!=None );
}

// ----------------------------------------------------------------------
// SetMedicalBot()
// ----------------------------------------------------------------------

function SetMedicalBot( HXMedicalBot InMedBot )
{
	MedBot = InMedBot;
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	AvailableAugsText="Available Augmentations"
	MedbotInterfaceText="MedBot INTERFACE"
	InstallButtonLabel="|&Install"
	NoCansAvailableText="No Augmentation Cannisters Available!"
	AlreadyHasItText="You already have this augmentation, therefore you cannot install it a second time."
	SlotFullText="The slot that this augmentation occupies is already full, therefore you cannot install it."
	SelectAnotherText="Please select another augmentation to install."
	ClientTextures(0)=HUDMedbotBackground_1
	ClientTextures(1)=HUDMedbotBackground_2
	ClientTextures(2)=HUDMedbotBackground_3
	ClientTextures(3)=HUDMedbotBackground_4
	ClientTextures(4)=HUDMedbotBackground_5
	ClientTextures(5)=HUDMedbotBackground_6
	ClientBorderTextures(0)=HUDMedBotAugmentationsBorder_1
	ClientBorderTextures(1)=HUDMedBotAugmentationsBorder_2
	ClientBorderTextures(2)=HUDMedBotAugmentationsBorder_3
	ClientBorderTextures(3)=HUDMedBotAugmentationsBorder_4
	ClientBorderTextures(4)=HUDMedBotAugmentationsBorder_5
	ClientBorderTextures(5)=HUDMedBotAugmentationsBorder_6
}
