//=============================================================================
// HXPersonaScreenHealthMedBot.
//=============================================================================
class HXPersonaScreenHealthMedBot extends HXPersonaScreenHealth;

var ProgressBarWindow       WinHealthBar;
var TextWindow              WinHealthBarText;
var PersonaNormalTextWindow WinHealthInfoText;

var HXMedicalBot MedBot;

var localized string MedbotInterfaceText;
var localized string HealthInfoTextLabel;
var localized string MedBotRechargingLabel;
var localized string MedBotReadyLabel;
var localized string MedBotYouAreHealed;
var localized string SecondsPluralLabel;
var localized string SecondsSingularLabel;
var localized string ReadyLabel;

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window
// ----------------------------------------------------------------------

event InitWindow()
{
	Super.InitWindow();

	HXHUDMedBotNavBarWindow(WinNavBar).HealthButton.SetSensitivity( false );

	//bTickEnabled = true;

	//EnableButtons();
}

// ----------------------------------------------------------------------
// DestroyWindow()
//
// Let the medbot go about its business.
// ----------------------------------------------------------------------

event DestroyWindow()
{
	local HXPlayerPawn HXPlayerPawn;

	if ( MedBot!=None )
	{
		HXPlayerPawn = HXPlayerPawn(Player);

		// I.. lets say it's debug output..
		if ( Player!=Player.GetPlayerPawn() )
		{
			Log( "DestroyWindow() ==============>Player mismatch!!!! ", Name );
		}
		else if ( HXPlayerPawn.ActivePawn==MedBot )
		{
			HXPlayerPawn.ClosePawn( MedBot );
			HXPlayerPawn.ActivePawn = None;
		}
	}

	Super.DestroyWindow();
}

// ----------------------------------------------------------------------
// CreateControls()
// ----------------------------------------------------------------------

function CreateControls()
{
	CreateNavBarWindow();
	CreateClientBorderWindow();
	CreateClientWindow();

	CreateTitleWindow( 9, 5, HealthTitleText );
	CreateInfoWindow();
	CreateOverlaysWindow();
	CreateBodyWindow();
	CreateRegionWindows();
	CreateButtons();
	CreatePartButtons();
	CreateRegionWindows();
	CreateMedbotLabel();
	CreateMedBotDisplay();
	CreateStatusWindow();
}

// ----------------------------------------------------------------------
// CreateStatusWindow()
// ----------------------------------------------------------------------

function CreateStatusWindow()
{
	WinStatus = PersonaStatusLineWindow(WinClient.NewChild(Class'PersonaStatusLineWindow'));
	WinStatus.SetPos( 15, 410 );
	WinStatus.SetWidth( 291 );
}

// ----------------------------------------------------------------------
// CreateNavBarWindow()
// ----------------------------------------------------------------------

function CreateNavBarWindow()
{
	WinNavBar = HXPersonaNavBarBaseWindow(NewChild(Class'HXHUDMedBotNavBarWindow')); 
	WinNavBar.SetPos( 0, 0 );
}

// ----------------------------------------------------------------------
// CreateInfoWindow()
// ----------------------------------------------------------------------

function CreateInfoWindow()
{
	WinInfo = HXPersonaInfoWindow(WinClient.NewChild(Class'HXPersonaInfoWindow'));
	WinInfo.SetPos( 348, 22 );
	WinInfo.SetSize( 238, 243);
}

// ----------------------------------------------------------------------
// CreateButtons()
// ----------------------------------------------------------------------

function CreateButtons()
{
	local PersonaButtonBarWindow WinActionButtons;

	WinActionButtons = PersonaButtonBarWindow(WinClient.NewChild(Class'PersonaButtonBarWindow'));
	WinActionButtons.SetPos( 346, 346 );
	WinActionButtons.SetWidth( 97 );
	WinActionButtons.FillAllSpace( false );

	BtnHealAll = PersonaActionButtonWindow(WinActionButtons.NewChild(Class'PersonaActionButtonWindow'));
	BtnHealAll.SetButtonText( HealAllButtonLabel );
}

// ----------------------------------------------------------------------
// CreateOverlaysWindow()
// ----------------------------------------------------------------------

function CreateOverlaysWindow()
{
	WinOverlays = PersonaOverlaysWindow(WinClient.NewChild(Class'HUDMedBotHealthOverlaysWindow'));
	WinOverlays.SetPos( 24, 36 );
	WinOverlays.Lower();
}

// ----------------------------------------------------------------------
// CreateMedbotLabel()
// ----------------------------------------------------------------------

function CreateMedbotLabel()
{
	local PersonaHeaderTextWindow MedbotLabel;

	MedbotLabel = PersonaHeaderTextWindow(NewChild(Class'PersonaHeaderTextWindow'));
	MedbotLabel.SetPos( 305, 9 );
	MedbotLabel.SetSize( 250, 16 );
	MedbotLabel.SetTextAlignments( HALIGN_Right, VALIGN_Center );
	MedbotLabel.SetText( MedbotInterfaceText );
}

// ----------------------------------------------------------------------
// CreateMedBotDisplay()
// ----------------------------------------------------------------------

function CreateMedBotDisplay()
{
	WinHealthBar = ProgressBarWindow(WinClient.NewChild(Class'ProgressBarWindow'));

	WinHealthBar.SetPos( 446, 348) ;
	WinHealthBar.SetSize( 140, 12 );
	WinHealthBar.SetValues( 0, 100 );
	WinHealthBar.UseScaledColor( true );
	WinHealthBar.SetVertical( false );
	WinHealthBar.SetScaleColorModifier( 0.5 );
	WinHealthBar.SetDrawBackground( false );

	WinHealthBarText = TextWindow(WinClient.NewChild(Class'TextWindow'));
	WinHealthBarText.SetPos( 446, 349 );
	WinHealthBarText.SetSize( 140, 12 );
	WinHealthBarText.SetTextMargins( 0, 0 );
	WinHealthBarText.SetTextAlignments( HALIGN_Center, VALIGN_Center );
	WinHealthBarText.SetFont( Font'FontMenuSmall_DS' );
	WinHealthBarText.SetTextColorRGB( 255, 255, 255 );

	WinHealthInfoText = PersonaNormalTextWindow(WinClient.NewChild(Class'PersonaNormalTextWindow'));
	WinHealthInfoText.SetPos( 348, 293 );
	WinHealthInfoText.SetSize( 238, 50 );
	WinHealthInfoText.SetTextMargins( 2, 0 );
}

// ----------------------------------------------------------------------
// ButtonActivated()
// ----------------------------------------------------------------------

function bool ButtonActivated( Window ButtonPressed )
{
	switch( ButtonPressed )
	{
		case BtnHealAll:
			MedBotHealPlayer();
			return true;
			break;

		default:
			return Super.ButtonActivated( ButtonPressed );
			break;
	}
}

// ----------------------------------------------------------------------
// Tick()
// ----------------------------------------------------------------------

event Tick( float DeltaTime )
{
	if ( MedBot!=None && !MedBot.bDeleteMe )
	{
		UpdateMedBotDisplay();
		UpdateRegionWindows();

		EnableButtons();
	}
	else
	{
		// Hope this won't trigger straight ahead on opening.
		Root.PopWindow();
	}
}

// ----------------------------------------------------------------------
// EnableButtons()
// ----------------------------------------------------------------------

function EnableButtons()
{
	local bool bEnableHealAllButton;

	if ( MedBot!=None )
		bEnableHealAllButton = IsPlayerDamaged() && MedBot.CanHeal();

	BtnHealAll.EnableWindow( bEnableHealAllButton );
}

// ----------------------------------------------------------------------
// UpdateMedBotDisplay()
// ----------------------------------------------------------------------

function UpdateMedBotDisplay()
{
	local string HealthBarText, HealthInfoText;
	local float  SecondsRemaining;
	local int    HealthBarPercent;

	if ( MedBot!=None )
	{
		HealthInfoText = Sprintf( HealthInfoTextLabel, MedBot.HealAmount );

		// Update the bar
		if ( MedBot.CanHeal() )
		{		
			HealthBarPercent = 100;
			HealthBarText    = ReadyLabel;

			if ( IsPlayerDamaged() )
				HealthInfoText = HealthInfoText $ MedBotReadyLabel;
			else
				HealthInfoText = HealthInfoText $ MedBotYouAreHealed;
		}
		else
		{
			HealthBarPercent = MedBot.GetRefreshPercent();

			SecondsRemaining = Ceil( MedBot.GetRefreshTimeRemaining() );

			if ( SecondsRemaining==1 )
				HealthBarText = Sprintf( SecondsSingularLabel, SecondsRemaining );
			else
				HealthBarText = Sprintf( SecondsPluralLabel, SecondsRemaining );

			if ( IsPlayerDamaged() )
				HealthInfoText = HealthInfoText $ MedBotRechargingLabel;
			else
				HealthInfoText = HealthInfoText $ MedBotYouAreHealed;
		}

		WinHealthBar.SetCurrentValue( HealthBarPercent );
		WinHealthBarText.SetText( HealthBarText );
		WinHealthInfoText.SetText( HealthInfoText );
	}

	EnableButtons();
}

// ----------------------------------------------------------------------
// MedBotHealPlayer()
// ----------------------------------------------------------------------

function MedBotHealPlayer()
{
	HXPlayerPawn(Player).MedicalBotHealPlayer( MedBot );
}

// ----------------------------------------------------------------------
// SetMedicalBot()
// ----------------------------------------------------------------------

function SetMedicalBot( HXMedicalBot InMedBot )
{
	MedBot = InMedBot;
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	MedbotInterfaceText="MEDBOT INTERFACE"
	HealthInfoTextLabel="The MedBot will heal up to %d units, which are distributed evenly among your damaged body regions."
	MedBotRechargingLabel="|nThe MedBot is currently Recharging.  Please Wait."
	MedBotReadyLabel="|nThe MedBot is Ready, you may now be Healed."
	MedBotYouAreHealed="|nYou are currently in Full Health."
	SecondsPluralLabel="Recharging: %d seconds"
	SecondsSingularLabel="Recharging: %d second"
	ReadyLabel="Ready!"
	bShowHealButtons=False
	HealAllButtonLabel="  H|&eal All  "
	ClientTextures(0)=HUDMedbotHealthBackground_1
	ClientTextures(1)=HUDMedbotHealthBackground_2
	ClientTextures(2)=HUDMedbotHealthBackground_3
	ClientTextures(3)=HUDMedbotHealthBackground_4
	ClientTextures(4)=HUDMedbotHealthBackground_5
	ClientTextures(5)=HUDMedbotHealthBackground_6
	ClientBorderTextures(0)=HUDMedBotHealthBorder_1
	ClientBorderTextures(1)=HUDMedBotHealthBorder_2
	ClientBorderTextures(2)=HUDMedBotHealthBorder_3
	ClientBorderTextures(3)=HUDMedBotHealthBorder_4
	ClientBorderTextures(4)=HUDMedBotHealthBorder_5
	ClientBorderTextures(5)=HUDMedBotHealthBorder_6
}
