//=============================================================================
// HXPersonaScreenInventory.
//=============================================================================
class HXPersonaScreenInventory extends HXPersonaScreenBaseWindow;

var PersonaActionButtonWindow BtnEquip;
var PersonaActionButtonWindow BtnUse;
var PersonaActionButtonWindow BtnDrop;
var PersonaActionButtonWindow BtnChangeAmmo;

var HXWindow                      WinItems;
var HXPersonaInventoryInfoWindow  WinInfo;
var PersonaItemButton             SelectedItem;	// Currently Selected Inventory item
var HXAmmoInfoWindow              SelectedAmmo; // Currently selected Ammo in list for dropping.
var PersonaInventoryCreditsWindow WinCredits;
var PersonaItemDetailWindow       WinNanoKeyRing;
var PersonaItemDetailWindow       WinAmmo;

var Bool bUpdatingAmmoDisplay;
var float TimeSinceLastUpdate;

// Inventory object belt
var HXPersonaInventoryObjectBelt invBelt;
var HXHUDObjectSlot		       selectedSlot;

var	int invButtonWidth;
var int	invButtonHeight;

var int	smallInvWidth;									// Small Inventory Button Width
var int	smallInvHeight;									// Small Inventory Button Heigth

// Drag and Drop Stuff
var Bool         bDragging;
var ButtonWindow DragButton;							// Button we're dragging around
var ButtonWindow LastDragOverButton;
var Window       lastDragOverWindow;
var Window       destroyWindow;							// Used to defer window destroy

var localized String InventoryTitleText;
var localized String EquipButtonLabel;
var localized String UnequipButtonLabel;
var localized String UseButtonLabel;
var localized String DropButtonLabel;
var localized String ChangeAmmoButtonLabel;
var localized String NanoKeyRingInfoText;
var localized String NanoKeyRingLabel;
var localized String DroppedLabel;
var localized String AmmoLoadedLabel;
var localized String WeaponUpgradedLabel;
//var localized String CannotBeDroppedLabel;
var localized String AmmoInfoText;
var localized String AmmoTitleLabel;
var localized String NoAmmoLabel;

var localized String EquippedLabel;
var localized String UneEquippedLabel;

// copied off DeusExPlayer
var byte	invSlots[30];		// 5x6 grid of inventory slots
var int		maxInvRows;			// Maximum number of inventory rows
var int		maxInvCols;			// Maximum number of inventory columns

// ----------------------------------------------------------------------
// CreateNavBarWindow()
// ----------------------------------------------------------------------

function CreateNavBarWindow()
{
	winNavBar = HXPersonaNavBarBaseWindow(NewChild(Class'HXPersonaNavBarWindow'));
	winNavBar.SetPos(0, 0);
}


// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window
// ----------------------------------------------------------------------

event InitWindow()
{
	Super.InitWindow();

	HXPersonaNavBarWindow(winNavBar).btnInventory.SetSensitivity(False);

	EnableButtons();
	//Force an update
	SignalRefresh();

	bTickEnabled = True;
}

// ---------------------------------------------------------------------
// Tick()
//
// Used to destroy windows that need to be destroyed during 
// MouseButtonReleased calls, which normally causes a CRASH
// ----------------------------------------------------------------------

function Tick( float DeltaTime )
{
	// Handle DestroyWindow.
	if ( DestroyWindow!=None )
	{
		DestroyWindow.Destroy();
		DestroyWindow = None;
		//bTickEnabled = False;
	}

	// Update buttons.
	EnableButtons();

	// Update Credits.
	WinCredits.SetCredits( HXPlayerPawn(Player).ClientCredits );
}

// ----------------------------------------------------------------------
// CreateControls()
// ----------------------------------------------------------------------

function CreateControls()
{
	Super.CreateControls();

	CreateTitleWindow(9, 5, InventoryTitleText);
	CreateInfoWindow();
	CreateCreditsWindow();
	CreateObjectBelt();
	CreateButtons();
	CreateItemsWindow();
	CreateNanoKeyRingWindow();
	CreateAmmoWindow();
	CreateInventoryButtons();
	CreateStatusWindow();
}

// ----------------------------------------------------------------------
// CreateStatusWindow()
// ----------------------------------------------------------------------

function CreateStatusWindow()
{
	winStatus = PersonaStatusLineWindow(winClient.NewChild(Class'PersonaStatusLineWindow'));
	winStatus.SetPos(337, 243);
}

// ----------------------------------------------------------------------
// CreateButtons()
// ----------------------------------------------------------------------

function CreateButtons()
{
	local PersonaButtonBarWindow winActionButtons;

	winActionButtons = PersonaButtonBarWindow(winClient.NewChild(Class'PersonaButtonBarWindow'));
	winActionButtons.SetPos(9, 339);
	winActionButtons.SetWidth(267);

	btnChangeAmmo = PersonaActionButtonWindow(winActionButtons.NewChild(Class'PersonaActionButtonWindow'));
	btnChangeAmmo.SetButtonText(ChangeAmmoButtonLabel);

	btnDrop = PersonaActionButtonWindow(winActionButtons.NewChild(Class'PersonaActionButtonWindow'));
	btnDrop.SetButtonText(DropButtonLabel);

	btnUse = PersonaActionButtonWindow(winActionButtons.NewChild(Class'PersonaActionButtonWindow'));
	btnUse.SetButtonText(UseButtonLabel);

	btnEquip = PersonaActionButtonWindow(winActionButtons.NewChild(Class'PersonaActionButtonWindow'));
	btnEquip.SetButtonText(EquipButtonLabel);
}

// ----------------------------------------------------------------------
// CreateInfoWindow()
// ----------------------------------------------------------------------

function CreateInfoWindow()
{
	winInfo = HXPersonaInventoryInfoWindow(winClient.NewChild(Class'HXPersonaInventoryInfoWindow'));
	winInfo.SetPos(337, 17);
	winInfo.SetSize(238, 218);
}

// ----------------------------------------------------------------------
// CreateObjectBelt()
// ----------------------------------------------------------------------

function CreateObjectBelt()
{
	invBelt = HXPersonaInventoryObjectBelt(NewChild(Class'HXPersonaInventoryObjectBelt'));
	invBelt.SetWindowAlignments(HALIGN_Right, VALIGN_Bottom, 0, 0);
	invBelt.SetInventoryWindow(Self);
//	invBelt.AskParentForReconfigure();
}

// ----------------------------------------------------------------------
// CreateCreditsWindow()
// ----------------------------------------------------------------------

function CreateCreditsWindow()
{
	winCredits = PersonaInventoryCreditsWindow(winClient.NewChild(Class'PersonaInventoryCreditsWindow'));
	winCredits.SetPos(165, 3);
	winCredits.SetWidth(108);
	winCredits.SetCredits( HXPlayerPawn(Player).ClientCredits );
}

// ----------------------------------------------------------------------
// CreateNanoKeyRingWindow()
// ----------------------------------------------------------------------

function CreateNanoKeyRingWindow()
{
	winNanoKeyRing = PersonaItemDetailWindow(winClient.NewChild(Class'PersonaItemDetailWindow'));
	winNanoKeyRing.SetPos(335, 285);
	winNanoKeyRing.SetWidth(121);
	winNanoKeyRing.SetTextAlignments(HALIGN_Center, VALIGN_Center);

	UpdateNanoKeyRingWindow();
}

// ----------------------------------------------------------------------
// UpdateNanoKeyRingWindow()
//
// Updates the nanokeywindow based on the presense of the NanoKeyRing.
// ----------------------------------------------------------------------

function UpdateNanoKeyRingWindow()
{
	local Inventory KeyRing;

	KeyRing = HXPlayerPawn(player).HXKeyRing;
	if ( KeyRing!=None )
	{
		winNanoKeyRing.SetText( NanoKeyRingInfoText );
		winNanoKeyRing.SetCountLabel( NanoKeyRingLabel );
		winNanoKeyRing.SetIconSensitivity( true );
		winNanoKeyRing.SetIcon( KeyRing.LargeIcon );
		winNanoKeyRing.SetItem( DeusExPickup(KeyRing) ); // !!
		winNanoKeyRing.SetCount(int(KeyRing.InventoryCapsFloat('KeyCount',None,None)));
	}
	else
	{
		winNanoKeyRing.SetText( "" );
		winNanoKeyRing.SetCountLabel( "" );
		winNanoKeyRing.SetIconSensitivity( false );
		winNanoKeyRing.SetIcon( None );
		winNanoKeyRing.SetItem( None );
		winNanoKeyRing.SetCount(0);	
	}
}

// ----------------------------------------------------------------------
// CreateAmmoWindow()
// ----------------------------------------------------------------------

function CreateAmmoWindow()
{
	winAmmo = PersonaItemDetailWindow(winClient.NewChild(Class'PersonaItemDetailWindow'));
	winAmmo.SetPos(456, 285);
	winAmmo.SetWidth(120);
	winAmmo.SetIcon(Class'AmmoShell'.Default.LargeIcon);
	winAmmo.SetIconSize(Class'AmmoShell'.Default.largeIconWidth, Class'AmmoShell'.Default.largeIconHeight);
	winAmmo.SetText(AmmoInfoText);
	winAmmo.SetTextAlignments(HALIGN_Center, VALIGN_Center);
	winAmmo.SetIgnoreCount(True);
	winAmmo.SetIconSensitivity(True);
}

// ----------------------------------------------------------------------
// CreateItemsWindow()
// ----------------------------------------------------------------------

function CreateItemsWindow()
{
	winItems = HXWindow(winClient.NewChild(Class'HXWindow'));
	winItems.SetPos(9, 19);
	winItems.SetSize(266, 319);
}

// ----------------------------------------------------------------------
// CreateInventoryButtons()
//
// Loop through all the Inventory items and draw them in our Inventory 
// grid as buttons
//
// As we're doing this, we're going to regenerate the inventory grid
// stored in the player, since it sometimes (very rarely) gets corrupted
// and this is a nice hack to make sure it stays clean should that
// occur.  Ooooooooooo did I say "nice hack"?
// ----------------------------------------------------------------------

function CreateInventoryButtons()
{
	local Inventory anItem;
	local HXPersonaInventoryItemButton newButton;

	// First, clear the player's inventory grid.
	// DEUS_EX AMSD Due to not being able to guarantee order of delivery for functions,
	// do NOT clear inventory in multiplayer, else we risk clearing AFTER a lot of the sets
	// below.
	//if (player.Level.NetMode == NM_Standalone)	
		//player.ClearInventorySlots();
	ClearInventorySlots();

	// Iterate through the inventory items, creating a unique button for each
	anItem = player.Inventory;

	while(anItem != None)
	{
		if (anItem.bDisplayableInv)
		{
			// Create another button
			newButton = HXPersonaInventoryItemButton(winItems.NewChild(Class'HXPersonaInventoryItemButton'));
			newButton.SetClientObject(anItem);
			newButton.SetInventoryWindow(Self);

			// If the item has a large icon, use it.  Otherwise just use the 
			// smaller icon that's also shared by the object belt 

			if ( anItem.largeIcon != None )
			{
				newButton.SetIcon(anItem.largeIcon);
				newButton.SetIconSize(anItem.largeIconWidth, anItem.largeIconHeight);
			}
			else
			{
				newButton.SetIcon(anItem.icon);
				newButton.SetIconSize(smallInvWidth, smallInvHeight);
			}

			newButton.SetSize(
				(invButtonWidth  * anItem.invSlotsX) + 1, 
				(invButtonHeight * anItem.invSlotsY) + 1);

			// Okeydokey, update the player's inventory grid with this item.
			//player.SetInvSlots(anItem, 1);
			SetInvSlots(anItem, 1);

			// If this item is currently equipped, notify the button
			if ( anItem == player.inHand )
				newButton.SetEquipped( True );

			// If this inventory item already has a position, use it.
			if (( anItem.invPosX != -1 ) && ( anItem.invPosY != -1 ))
			{
				SetItemButtonPos(newButton, anItem.invPosX, anItem.invPosY);
			}
			else
			{
				Log( Self @ "Found invalid item position for " @ anItem );
				// Find a place for it.
				//if (player.FindInventorySlot(anItem))
					//SetItemButtonPos(newButton, anItem.invPosX, anItem.invPosY);
				//else
					newButton.Destroy();		// Shit!
			}
		}

		anItem = anItem.Inventory;
	}	
}

// ----------------------------------------------------------------------
// SetItemButtonPos()
// ----------------------------------------------------------------------

function SetItemButtonPos(HXPersonaInventoryItemButton moveButton, int slotX, int slotY)
{
	moveButton.dragPosX = slotX;
	moveButton.dragPosY = slotY;

	moveButton.SetPos(
		moveButton.dragPosX * (invButtonWidth), 
		moveButton.dragPosY * (invButtonHeight)
		);
}

// ----------------------------------------------------------------------
// ButtonActivated()
// ----------------------------------------------------------------------

function bool ButtonActivated( Window ButtonPressed )
{
	local HXAmmoInfoWindow PreviousSelectedAmmo;
	local Class<HXAmmo> AmmoClass;
	local bool bHandled;

	//Log( Self $ ".ButtonActivated( " $ ButtonPressed $ " )" );

	bHandled = True;

	// Updated selected Ammo button.
	PreviousSelectedAmmo = SelectedAmmo;
	SelectedAmmo = None;

	// First check to see if this is an Ammo button.
	if ( ButtonPressed.IsA('PersonaAmmoDetailButton') )
	{
		if ( HXWeapon(SelectedItem.GetClientObject())!=None )
		{
			// Before doing anything, check to see if this button is already selected.
			if ( !PersonaAmmoDetailButton(ButtonPressed).bSelected )
			{
				WinInfo.SelectAmmoButton( PersonaAmmoDetailButton(ButtonPressed) );
				AmmoClass = LoadAmmo();
				HXWeapon(SelectedItem.GetClientObject()).UpdateAmmoInfo( WinInfo, AmmoClass );
				EnableButtons();
			}
		}
	}
	// Check to see if this is the Ammo button.
	else if ( ButtonPressed.IsA('PersonaItemDetailButton') && PersonaItemDetailButton(buttonPressed).Icon==Class'AmmoShell'.Default.LargeIcon )
	{
		SelectInventory( PersonaItemButton(ButtonPressed) );
		UpdateAmmoDisplay();
	}
	// Now check to see if it's an Inventory button.
	else if ( ButtonPressed.IsA('PersonaItemButton') )
	{
		//Log( buttonPressed );
		WinStatus.ClearText();
		SelectInventory( PersonaItemButton(ButtonPressed) );
	}
	// Check for ammo selection.
	else if ( ButtonPressed.IsA('HXAmmoInfoWindow') )
	{
		WinInfo.SelectAmmoInfoWindow( HXAmmoInfoWindow(ButtonPressed) );
		SelectedAmmo = HXAmmoInfoWindow(ButtonPressed);
		EnableButtons();
	}
	// Otherwise must be one of our action buttons.
	else
	{
		SelectedAmmo = PreviousSelectedAmmo;

		switch( ButtonPressed )
		{
			case BtnChangeAmmo:
				WeaponChangeAmmo();
				break;

			case BtnEquip:
				EquipSelectedItem();
				break;

			case BtnUse:
				UseSelectedItem();
				break;

			case BtnDrop:
				DropSelectedItem();
				break;

			default:
				//SelectedAmmo = None;
				bHandled = False;
				break;
		}
	}

	if ( !bHandled )
		bHandled = Super.ButtonActivated( ButtonPressed );

	return bHandled;
}

// ----------------------------------------------------------------------
// ToggleChanged()
// ----------------------------------------------------------------------

event bool ToggleChanged(Window button, bool bNewToggle)
{
	SelectedAmmo = None;

	if (button.IsA('HXHUDObjectSlot') && (bNewToggle))
	{
		if ((selectedSlot != None) && (selectedSlot != HXHUDObjectSlot(button)))
			selectedSlot.HighlightSelect(False);

		selectedSlot = HXHUDObjectSlot(button);

		// Only allow to be highlighted if the slot isn't empty
		if (selectedSlot.GetItem() != None)
		{
			selectedSlot.HighlightSelect(bNewToggle);
			SelectInventoryItem(selectedSlot.GetItem());
		}
		else
		{
			selectedSlot = None;
		}
	}
	else if (button.IsA('PersonaCheckboxWindow'))
	{
		player.bShowAmmoDescriptions = bNewToggle;
		player.SaveConfig();
		UpdateAmmoDisplay();
	}

	EnableButtons();

	return True;
}

// ----------------------------------------------------------------------
// VirtualKeyPressed()
//
// Called when a key is pressed; provides a virtual key value
// ----------------------------------------------------------------------

event bool VirtualKeyPressed(EInputKey key, bool bRepeat)
{
	local int keyIndex;
	local bool bKeyHandled;

	bKeyHandled = True;

	if ( IsKeyDown( IK_Alt ) || IsKeyDown( IK_Shift ) || IsKeyDown( IK_Ctrl ))
		return False;

	// If a number key was pressed and we have a selected inventory item,
	// then assign the hotkey
	if (( key >= IK_1 ) && ( key <= IK_9 ) && (selectedItem != None) && (Inventory(selectedItem.GetClientObject()) != None))
	{
		invBelt.AssignObjectBeltByKey(Inventory(selectedItem.GetClientObject()), key);
	}
	else
	{
		switch( key ) 
		{	
			// Allow a selected object to be dropped
			// TODO: Use the actual key(s) assigned to drop

			case IK_Backspace:
				DropSelectedItem();
				break;

			case IK_Delete:
				ClearSelectedSlot();
				break;

			case IK_Enter:
				UseSelectedItem();
				break;

			default:
				bKeyHandled = False;
		}
	}

	if (!bKeyHandled)
		return Super.VirtualKeyPressed(key, bRepeat);
	else
		return bKeyHandled;
}

// ----------------------------------------------------------------------
// UpdateAmmoDisplay()
//
// Displays a list of ammo inside the info window (when the user clicks
// on the Ammo button)
// ----------------------------------------------------------------------

function UpdateAmmoDisplay()
{
	local Inventory inv;
	local HXAmmo ammo;
	local int ammoCount;

	if (!bUpdatingAmmoDisplay)
	{
		bUpdatingAmmoDisplay = True;

		winInfo.Clear();
		winInfo.SetTitle(AmmoTitleLabel);
		winInfo.AddAmmoCheckbox(player.bShowAmmoDescriptions);
		winInfo.AddLine();
		
		inv = Player.Inventory;
		while(inv != None)
		{
			ammo = HXAmmo(inv);

			if ((ammo != None) && (ammo.bShowInfo))
			{
				winInfo.AddAmmoInfoWindow(ammo, player.bShowAmmoDescriptions);
				ammoCount++;	
			}

			inv = inv.Inventory;
		}

		if (ammoCount == 0)
		{
			winInfo.Clear();
			winInfo.SetTitle(AmmoTitleLabel);
			winInfo.SetText(NoAmmoLabel);
		}

		bUpdatingAmmoDisplay = False;
	}
}

// ----------------------------------------------------------------------
// SelectInventory()
// ----------------------------------------------------------------------

function SelectInventory(PersonaItemButton buttonPressed)
{
	local Inventory anItem;

	//Log( Self @ ".SelectInventory()" );

	// Don't do extra work.
	if (buttonPressed != None) 
	{
		if (selectedItem != buttonPressed)
		{
			// Deselect current button
			if (selectedItem != None)
				selectedItem.SelectButton(False);

			selectedItem = buttonPressed;

			ClearSpecialHighlights();
			HighlightSpecial(Inventory(selectedItem.GetClientObject()));
			SelectObjectBeltItem(Inventory(selectedItem.GetClientObject()), True);

			selectedItem.SelectButton(True);

			anItem = Inventory(selectedItem.GetClientObject());

			//Log( selectedItem.GetClientObject() );
			//Log( Actor(selectedItem.GetClientObject()).Owner );
			//Log( Actor(selectedItem.GetClientObject()).Role );

			if (anItem != None)
				anItem.UpdateInfo(winInfo);

			EnableButtons();
		}
	}
	else
	{
		if (selectedItem != None)
			HXPersonaInventoryItemButton(selectedItem).SelectButton(False);

		if (selectedSlot != None)
			selectedSlot.SetToggle(False);

		selectedItem = None;
	}
}

// ----------------------------------------------------------------------
// SelectInventoryItem()
//
// Searches through the inventory items for the item passed in and
// selects it.
// ----------------------------------------------------------------------

function SelectInventoryItem(Inventory item)
{
	local HXPersonaInventoryItemButton itemButton;
	local Window itemWindow;

	// Special case for NanoKeyRing
	if (item != None)
	{
		if (item.IsA('HXNanoKeyRing')) 
		{   
			if (winNanoKeyRing != None)
			{
				SelectInventory(winNanoKeyRing.GetItemButton());
			}
		}
		else if (winItems != None)
		{
			// Search through the buttons
			itemWindow = winItems.GetTopChild();
			while(itemWindow != None)
			{
				itemButton = HXPersonaInventoryItemButton(itemWindow);
				if (itemButton != None)
				{
					if (itemButton.GetClientObject() == item)
					{
						SelectInventory(itemButton);
						break;
					}
				}

				itemWindow = itemWindow.GetLowerSibling();
			}
		}
	}
}

// ----------------------------------------------------------------------
// RefreshInventoryItemButtons()
//
// Refreshes all inventory item buttons.
// ----------------------------------------------------------------------
 
function RefreshInventoryItemButtons()
{
    local Window itemWindow;
    local HXPersonaInventoryItemButton itemButton;
    local Inventory SelectedInventory;

    if (winItems == None)
        return;

    //record selected item
    if (selectedItem != None)
        SelectedInventory = Inventory(selectedItem.GetClientObject());
    else
        SelectedInventory = None;

    //Delete buttons
    itemWindow = winItems.GetTopChild();

    selecteditem = None;
    while (itemWindow != None)
    {
        itemButton = HXPersonaInventoryItemButton(itemWindow);
        itemWindow = itemWindow.GetLowerSibling();
        if (itemButton != None)
        {          
            itemButton.Destroy();
        }
    }

    //Create buttons
    CreateInventoryButtons();

    //Select new button version of selected item.
    //We don't use the selectinventoryitem call because the constant
    //item.update(wininfo) calls cause quite a slowdown when any item
    //is selected.  Since we aren't really selecting a different item,
    //we don't need to do that update.
	if (SelectedInventory != None)
	{
        // Search through the buttons
        itemWindow = winItems.GetTopChild();
        while(itemWindow != None)
        {
            itemButton = HXPersonaInventoryItemButton(itemWindow);
            if (itemButton != None)
            {
                if (itemButton.GetClientObject() == SelectedInventory)
                {
                    selecteditem = itemButton;
                    selectedItem.SelectButton(True);
                    break;
                }
            }
            
            itemWindow = itemWindow.GetLowerSibling();
        }
	}

   // if this does special highlighting, refresh that.
   if (SelectedInventory != None)			   
      HighlightSpecial(SelectedInventory);
}

// ----------------------------------------------------------------------
// SelectObjectBeltItem()
// ----------------------------------------------------------------------

function SelectObjectBeltItem(Inventory item, bool bNewToggle)
{
	invBelt.SelectObject(item, bNewToggle);
}

// ----------------------------------------------------------------------
// UseSelectedItem()
// ----------------------------------------------------------------------

function UseSelectedItem()
{
	local Inventory inv;
	local int numCopies;

	inv = Inventory(selectedItem.GetClientObject());

	if (inv != None)
	{
		// If this item was equipped in the inventory screen, 
		// make sure we set inHandPending to None so it's not
		// drawn when we exit the Inventory screen

		//if (player.inHandPending == inv)
			//player.SetInHandPending(None);

		// If this is a binoculars, then it needs to be equipped
		// before it can be activated
		//if (inv.IsA('HXBinoculars')) 
			//player.PutInHand(inv);

		//inv.Activate();
		HXPlayerPawn(player).ActivateItemFromInventoryScreen( inv );

		// Check to see if this is a stackable item, and keep track of 
		// the count
		//if ((inv.IsA('HXPickup')) && (HXPickup(inv).bCanHaveMultipleCopies))
			//numCopies = HXPickup(inv).NumCopies - 1;
		//else
			//numCopies = 0;

		// Update the object belt
		//invBelt.UpdateBeltText(inv);

		// Refresh the info!
		//if (numCopies > 0)
			//UpdateWinInfo(inv);

		// Immediate update for listen player, as otherwise the spot remains occupied.
		if ( Player.Level.NetMode!=NM_Client )
		{
			RefreshWindow( 1.0 );
		}
	}
}

// ----------------------------------------------------------------------
// DropSelectedItem()
// ----------------------------------------------------------------------

function DropSelectedItem()
{
	local Inventory Item;

	//Log( "DropSelectedItem()" );
	//Log( "SelectedAmmo=" $ SelectedAmmo );
	//Log( "SelectedItem=" $ SelectedItem );

	// Ammo dropping.
	if ( SelectedAmmo!=None )
	{
		HXPlayerPawn(Player).DropAmmo( SelectedAmmo.GetAmmoClass(), True );
	}
	// Weapon/Pickup dropping.
	else if ( SelectedItem!=None )
	{
		Item = Inventory(SelectedItem.GetClientObject());
		
		if ( Item!=None )
		{
			// DropItem only return true for listen player as DropItem is a RPC.
			if ( Player.DropItem(Item,true) ) 
			{
				// However, only the client will cause external UI update trigger, so we need to manually update here,
				// so the inventory slot won't remain marked as used.
				RefreshWindow( 1.0 );
			}
		}
	}
}

// ----------------------------------------------------------------------
// RemoveSelectedItem()
// ----------------------------------------------------------------------

function RemoveSelectedItem()
{
	local Inventory inv;

	if (selectedItem == None)
		return;

	inv = Inventory(selectedItem.GetClientObject());

	if (inv != None)
	{
		// Destroy the button
		selectedItem.Destroy();
		selectedItem = None;

		// Remove it from the object belt
		Player.RemoveObjectFromBelt( inv );

		// Remove it from the inventory screen
		UnequipItemInHand();

		ClearSpecialHighlights();

		SelectInventory(None);

		winInfo.Clear();
		EnableButtons();
	}
}

// ----------------------------------------------------------------------
// WeaponChangeAmmo()
// ----------------------------------------------------------------------

function WeaponChangeAmmo()
{
	local HXWeapon aWeapon;

	aWeapon = HXWeapon(selectedItem.GetClientObject());

	if ( aWeapon != None )
	{
		aWeapon.CycleAmmo();	

		// Send status message and update info window
		//winStatus.AddText(Sprintf(AmmoLoadedLabel, aWeapon.ammoType.itemName));
		aWeapon.UpdateAmmoInfo(winInfo, Class<HXAmmo>(aWeapon.AmmoName));
		winInfo.SetLoaded(aWeapon.AmmoName);

		// Update the object belt
		//invBelt.UpdateBeltText(aWeapon);
	}
}

// ----------------------------------------------------------------------
// LoadAmmo()
// ----------------------------------------------------------------------

function Class<HXAmmo> LoadAmmo()
{
	local HXWeapon aWeapon;
	local Class<HXAmmo> ammo;

	aWeapon = HXWeapon(selectedItem.GetClientObject());

	if ( aWeapon != None )
	{	
		ammo = Class<HXAmmo>(winInfo.GetSelectedAmmo());

		// Only change if this is a different kind of ammo

		if ((ammo != None) && (ammo != aWeapon.AmmoName))
		{
			aWeapon.LoadAmmoClass(ammo);
			
			// Send status message
			//winStatus.AddText(Sprintf(AmmoLoadedLabel, ammo.Default.itemName));

			// Update the object belt
			//invBelt.UpdateBeltText(aWeapon);
		}
	}

	return ammo;
}

// ----------------------------------------------------------------------
// EquipSelectedItem()
// ----------------------------------------------------------------------

function EquipSelectedItem()
{
	local Inventory inv;

	// If the object's in-hand, then unequip
	// it.  Otherwise put this object in-hand.

	inv = Inventory(selectedItem.GetClientObject());
	
	if ( inv != None )
	{
		// Make sure the Binoculars aren't activated.
		if ((player.inHand != None) && (player.inHand.IsA('HXBinoculars')))
			HXBinoculars(player.inHand).Activate();
		else if ((player.inHandPending != None) && (player.inHandPending.IsA('HXBinoculars')))
			HXBinoculars(player.inHandPending).Activate();

		if ((inv == player.inHand) || (inv == player.inHandPending))
		{
			UnequipItemInHand();
		}
		else
		{
			player.PutInHand(inv);
			winStatus.AddText(Sprintf(EquippedLabel, inv.itemName));
			HXPersonaInventoryItemButton(selectedItem).SetEquipped(True);
		}

		EnableButtons();
	}
}

// ----------------------------------------------------------------------
// UnequipItemInHand()
// ----------------------------------------------------------------------

function UnequipItemInHand()
{
	if ((HXPersonaInventoryItemButton(selectedItem) != None) && ((player.inHand != None) || (player.inHandPending != None)))
	{
		winStatus.AddText(Sprintf(UneEquippedLabel, player.inHand.itemName));
		
		player.PutInHand(None);
		player.SetInHandPending(None);
		
		HXPersonaInventoryItemButton(selectedItem).SetEquipped(False);
		EnableButtons();
	}
}

// ----------------------------------------------------------------------
// UpdateWinInfo()
// ----------------------------------------------------------------------

function UpdateWinInfo(Inventory inv)
{
	winInfo.Clear();

	if (inv != None)
	{
		winInfo.SetTitle(inv.ItemName);
		winInfo.SetText(inv.Description);
	}
}

// ----------------------------------------------------------------------
// RefreshWindow()
// ----------------------------------------------------------------------

function RefreshWindow(float DeltaTime)
{
	TimeSinceLastUpdate = TimeSinceLastUpdate + DeltaTime;
	if (TimeSinceLastUpdate >= 0.25)
	{
		TimeSinceLastUpdate = 0;
		if (!bDragging)
		{
			RefreshInventoryItemButtons();
			CleanBelt();
		}
	}

	Super.RefreshWindow(DeltaTime);
}
// ----------------------------------------------------------------------
// SignalRefresh()
// ----------------------------------------------------------------------

function SignalRefresh()
{
	//Put it about a quarter of a second back from an update, so that 
	//server has time to propagate.
	TimeSinceLastUpdate = 0;
	//TimeSinceLastUpdate = 0.25;
}

// ----------------------------------------------------------------------
// CleanBelt()
// ----------------------------------------------------------------------

function CleanBelt()
{
	local Inventory CurrentItem;

	//invBelt.hudBelt.ClearBelt();
	//invBelt.objBelt.ClearBelt();
	//invBelt.objBelt.PopulateBelt();
	if (selectedItem != None)    
		SelectObjectBeltItem(Inventory(selectedItem.GetClientObject()), True);
}


// ----------------------------------------------------------------------
// RemoveItem()
//
// Removes this item from the screen.  If this is the selected item, 
// does some additional processing.
// ----------------------------------------------------------------------

function RemoveItem(Inventory item)
{
	local Window itemWindow;

	if (item == None)
		return;

	// Remove it from the object belt
	Player.RemoveObjectFromBelt( item );

	if ((selectedItem != None) && (item == selectedItem.GetClientObject()))
	{
		RemoveSelectedItem();
	}
	else
	{	
		// Loop through the PersonaInventoryItemButtons looking for a match
		itemWindow = winItems.GetTopChild();
		while( itemWindow != None )
		{
			if (itemWindow.GetClientObject() == item)
			{
				DeferDestroy(itemWindow);
//				itemWindow.Destroy();
				break;
			}
			
			itemWindow = itemWindow.GetLowerSibling();
		}
	}
}

// ----------------------------------------------------------------------
// DeferDestroy()
// ----------------------------------------------------------------------

function DeferDestroy( Window NewDestroyWindow )
{
	DestroyWindow = NewDestroyWindow;

	//if ( destroyWindow!=None )
		//bTickEnabled = True;
}

// ----------------------------------------------------------------------
// InventoryDeleted()
//
// Called when some external force needs to remove an inventory 
// item from the player. For instance, when an item is "used" and it's
// a single-use item, it destroys itself, which will ultimately 
// result in this ItemDeleted() call.
// ----------------------------------------------------------------------

function InventoryDeleted( Inventory item )
{
	if ( Item!=None )
	{
		// Remove the item from the screen
		RemoveItem( Item );
	}
}

// ----------------------------------------------------------------------
// ClearSelectedSlot()
// ----------------------------------------------------------------------

function ClearSelectedSlot()
{
	local Inventory Item;

	if ( SelectedSlot==None )
		return;

	Item = SelectedSlot.GetItem();

	// Make sure the item isn't pinned.
	if ( Item!=None && !HXPlayerPawn(Player).BeltPositionPinned(SelectedSlot.ObjectNum) )
	{
		SelectedSlot.SetToggle( false );

		Player.RemoveObjectFromBelt( Item );

		SelectedSlot = None;
		WinInfo.Clear();
		EnableButtons();
	}
}

// ----------------------------------------------------------------------
// EnableButtons()
// ----------------------------------------------------------------------

function EnableButtons()
{
	local Inventory Item;
	local HXAmmo Ammo;

	// Make sure all the buttons exist!
	if ( BtnChangeAmmo==None || BtnDrop==None || BtnEquip==None || BtnUse==None )
		return;

	if ( SelectedAmmo!=None )
	{
		BtnChangeAmmo.DisableWindow();
		BtnEquip.DisableWindow();
		BtnUse.DisableWindow();

		Ammo = SelectedAmmo.GetAmmo();
		if ( Ammo!=None && Ammo.AmmoAmount>0 )
		{
			BtnDrop.EnableWindow();
		}
		else
		{
			BtnDrop.DisableWindow();
		}
	}
	else if ( SelectedItem==None )
	{
		BtnChangeAmmo.DisableWindow();
		BtnDrop.DisableWindow();
		BtnEquip.DisableWindow();
		BtnUse.DisableWindow();
	}
	else
	{
		BtnChangeAmmo.EnableWindow();
		BtnEquip.EnableWindow();
		BtnUse.EnableWindow();
		BtnDrop.EnableWindow();

		Item = Inventory(SelectedItem.GetClientObject());

		if ( Item!=None )
		{
			// Anything can be dropped, except the NanoKeyRing.
			BtnDrop.EnableWindow();

			if ( Item.IsA('HXWeaponMod') )
			{
				BtnUse.DisableWindow();

				BtnChangeAmmo.DisableWindow();
			}
			else if ( Item.IsA('HXNanoKeyRing') )
			{
				BtnUse.DisableWindow();

				BtnChangeAmmo.DisableWindow();
				BtnDrop.DisableWindow();
				BtnEquip.DisableWindow();
				
			}
			// Augmentation (Upgrade) Cannisters cannot be used on this screen.
			else if ( Item.IsA('HXAugmentationCannister') || Item.IsA('HXAugmentationUpgradeCannister') )
			{
				BtnUse.DisableWindow();

				BtnChangeAmmo.DisableWindow();
			}
			// Ammo can't be used or equipped
			else if ( Item.IsA('Ammo') )
			{
				BtnUse.DisableWindow();

				BtnEquip.DisableWindow();
			}
			else 
			{
				if ( Item==Player.InHand || Item==Player.InHandPending )
					BtnEquip.SetButtonText( UnequipButtonLabel );
				else
					BtnEquip.SetButtonText( EquipButtonLabel );
			}

			// If this is a weapon, check to see if this item has more than 
			// one type of ammo in the player's inventory that can be
			// equipped.  If so, enable the "AMMO" button.
			if ( Item.IsA('HXWeapon') )
			{
				BtnUse.DisableWindow();

				if ( HXWeapon(Item).NumAmmoTypesAvailable()<2 )
					BtnChangeAmmo.DisableWindow();
			}
			else
			{
				BtnChangeAmmo.DisableWindow();
			}
		}
		else
		{
			BtnChangeAmmo.DisableWindow();
			BtnDrop.DisableWindow();
			BtnEquip.DisableWindow();
			BtnUse.DisableWindow();
		}
	}
}

// ----------------------------------------------------------------------
// UpdateDragMouse()
// ----------------------------------------------------------------------

function UpdateDragMouse(float newX, float newY)
{
	local Window FindWin;
	local Float relX, relY;
	local Int slotX, slotY;
	local HXPersonaInventoryItemButton invButton;
	local HXHUDObjectSlot ObjSlot;
	local Bool bValidDrop;
	local Bool bOverrideButtonColor;

	FindWin = FindWindow(newX, newY, relX, relY);

	// If we're dragging an inventory button, behave one way, if we're
	// dragging a hotkey button, behave another

	if (DragButton.IsA('HXPersonaInventoryItemButton'))
	{
		invButton = HXPersonaInventoryItemButton(DragButton);

		// If we're over the Inventory Items window, check to see 
		// if there's enough space to deposit this item here.

		bValidDrop = False;
		bOverrideButtonColor = False;

		if ((FindWin == winItems) || (FindWin == DragButton ))
		{
			if ( FindWin == DragButton )
				ConvertCoordinates(Self, newX, newY, winItems, relX, relY);

			bValidDrop = CalculateItemPosition(
				Inventory(DragButton.GetClientObject()), 
				relX, relY, 
				slotX, slotY);

			// If the mouse is still in the window, don't actually hide the 
			// button just yet.

			//if (bValidDrop && (player.IsEmptyItemSlot(Inventory(invButton.GetClientObject()), slotX, slotY)))
			if (bValidDrop && (IsEmptyItemSlot(Inventory(invButton.GetClientObject()), slotX, slotY)))
				SetItemButtonPos(invButton, slotX, slotY);
		}

		// Check to see if we're over the Object Belt
		else if (HXHUDObjectSlot(FindWin) != None)
		{
			bValidDrop = HXHUDObjectSlot(FindWin).GetItem()==None || !HXPlayerPawn(Player).BeltPositionPinned(HXHUDObjectSlot(FindWin).ObjectNum);

			HXHUDObjectSlot(FindWin).SetDropFill( bValidDrop );
		}

		// Check to see if we're over another inventory item
		else if (HXPersonaInventoryItemButton(FindWin) != None)
		{
			// If we're dragging a weapon mod and we're over a weapon, check to 
			// see if the mod can be dropped here.  
			//
			// Otherwise this is a bad drop location

			HXPersonaInventoryItemButton(FindWin).SetDropFill(False);

			// Check for weapon mods being dragged over weapons
			if ((DragButton.GetClientObject().IsA('HXWeaponMod')) && (FindWin.GetClientObject().IsA('HXWeapon')))
			{
				if (HXWeaponMod(invButton.GetClientObject()).CanUpgradeWeapon(HXWeapon(FindWin.GetClientObject())))
				{
					bValidDrop = True;
					HXPersonaInventoryItemButton(FindWin).SetDropFill(True);
					invButton.bValidSlot = False;
					invButton.bDimIcon   = False;
					bOverrideButtonColor = True;

					invButton.ResetFill();
				}
			}

			// Check for ammo being dragged over weapons
			else if ((DragButton.GetClientObject().IsA('HXAmmo')) && (FindWin.GetClientObject().IsA('HXWeapon')))
			{
				if (HXWeapon(FindWin.GetClientObject()).CanLoadAmmoType(HXAmmo(DragButton.GetClientObject())))
				{
					bValidDrop = True;
					HXPersonaInventoryItemButton(FindWin).SetDropFill(True);
					invButton.bValidSlot = False;
					invButton.bDimIcon   = False;
					bOverrideButtonColor = True;

					invButton.ResetFill();
				}
			}
		}

		if (!bOverrideButtonColor)
		{
			invButton.SetDropFill(bValidDrop);
			invButton.bDimIcon = !bValidDrop;

			if (HXHUDObjectSlot(FindWin) != None)
				invButton.bValidSlot = False;
			else
				invButton.bValidSlot = bValidDrop;
		}
	}
	else
	{
		// This is an Object Belt item we're dragging.
		ObjSlot    = HXHUDObjectSlot(DragButton);
		bValidDrop = false;

		// Can only be dragged over another object slot
		if ( FindWin.IsA('HXHUDObjectSlot') )
		{
			bValidDrop = HXHUDObjectSlot(FindWin).GetItem()==None || !HXPlayerPawn(Player).BeltPositionPinned(HXHUDObjectSlot(FindWin).ObjectNum);

			HXHUDObjectSlot(FindWin).SetDropFill( bValidDrop );
		}
		
		ObjSlot.bDimIcon = !bValidDrop;
	}

	// Unhighlight the previous window we were over	
	if ((LastDragOverButton != None) && (LastDragOverButton != FindWin))
	{
		if (LastDragOverButton.IsA('HXHUDObjectSlot'))
		{
			HXHUDObjectSlot(LastDragOverButton).ResetFill();
		}
		else if (LastDragOverButton.IsA('HXPersonaInventoryItemButton'))
		{
			HXPersonaInventoryItemButton(LastDragOverButton).ResetFill();
		}
	}	
		
	// Keep track of the last button window we were over
	LastDragOverButton = ButtonWindow(FindWin);	
	lastDragOverWindow = FindWin;
}

// ----------------------------------------------------------------------
// CalculateItemPosition()
//
// Calculates exactly where this item belongs in the window based on 
// the position passed in (relative to "winItems") and the inventory 
// item.  
//
// Returns TRUE if this is a valid drop slot (not out of bounds)
// ----------------------------------------------------------------------

function bool CalculateItemPosition(
	Inventory item, 
	float pointX, 
	float pointY, 
	out int slotX, 
	out int slotY)
{
	local int invWidth;
	local int invHeight;
	local int adjustX;
	local int adjustY;
	local bool bResult;

	bResult = True;

	// First get the width and height of the inventory icon
	invWidth  = item.largeIconWidth;
	invHeight = item.largeIconHeight;

	// Calculate the first square that represents where this object is
	adjustX = 0;
	adjustY = 0;

	if (invWidth > invButtonWidth)
		adjustX = ((invWidth/2) - (invButtonWidth / 2));

	if (invWidth > invButtonwidth)
		adjustY = ((invHeight/2) - (invButtonHeight /2));

	// Check to see if we're outside the range of where the 
	// slots are located.
	//if ((pointX - adjustX) > (invButtonWidth  * player.maxInvCols))
	if ((pointX - adjustX) > (invButtonWidth  * maxInvCols))
	{
		//slotX = player.maxInvCols - 1;
		slotX = maxInvCols - 1;
		if (slotX < 0)
			slotX = 0;

		bResult = False;
	}
	else
	{
		slotX = (pointX - adjustX) / invButtonWidth;

		if (slotX < 0)
			slotX = 0;
	}

	//if ((pointY - adjustY) > (invButtonHeight * player.maxInvRows))
	if ((pointY - adjustY) > (invButtonHeight * maxInvRows))
	{
		//slotY = player.maxInvRows - 1;
		slotY = maxInvRows - 1;
		bResult = False;
	}
	else
	{
		slotY = (pointY - adjustY) / invButtonHeight;
	}

	return bResult;
}

// ----------------------------------------------------------------------
// StartButtonDrag()
// ----------------------------------------------------------------------

function StartButtonDrag(ButtonWindow newDragButton)
{
	// Show the object belt
	DragButton = newDragButton;

	ClearSpecialHighlights();

	if (DragButton.IsA('HXPersonaInventoryItemButton'))
	{
		SelectInventory(None);

		// Clear the space used by this button in the grid so we can
		// still place the button here. 
		//player.SetInvSlots(Inventory(DragButton.GetClientObject()), 0);
		SetInvSlots(Inventory(DragButton.GetClientObject()), 0);
	}
	else
	{
		// Make sure no hud icon is selected
		if (selectedSlot != None)
			selectedSlot.SetToggle(False);
	}

    SignalRefresh();
	bDragging  = True;
}

// ----------------------------------------------------------------------
// FinishButtonDrag()
// ----------------------------------------------------------------------

function FinishButtonDrag()
{
	local int BeltSlot;
	local Inventory DragItem, DraggedOnItem;
	local HXPersonaInventoryItemButton dragTarget;
	local HXHUDObjectSlot ItemSlot;
	local int DragSlot, DraggedOnSlot;

	// Take a look at the last window we were over to determine
	// what to do now.  If we were over the Inventory Items window,
	// then move the item to a new slot.  If we were over the Object belt,
	// then assign this item to the appropriate key

	if (DragButton == None)
	{
		EndDragMode();
		return;
	}

	if (DragButton.IsA('HXPersonaInventoryItemButton'))
	{	
		DragItem    = Inventory(DragButton.GetClientObject());
		dragTarget = HXPersonaInventoryItemButton(LastDragOverButton);

		// Check if this is a weapon mod and we landed on a weapon
		if ( (DragItem.IsA('HXWeaponMod')) && (dragTarget != None) && (dragTarget.GetClientObject().IsA('HXWeapon')) )
		{
			if (HXWeaponMod(DragItem).CanUpgradeWeapon(HXWeapon(dragTarget.GetClientObject())))
			{
				// 0.  Unhighlight highlighted weapons
				// 1.  Apply the weapon upgrade
				// 2.  Remove from Object Belt
				// 3.  Destroy the upgrade (will cause button to be destroyed)
				// 4.  Highlight the weapon.

				HXWeaponMod(DragItem).ApplyMod(HXWeapon(dragTarget.GetClientObject()));
				
				Player.RemoveObjectFromBelt( DragItem );

				// Send status message
				winStatus.AddText(Sprintf(WeaponUpgradedLabel, HXWeapon(dragTarget.GetClientObject()).itemName));

        //DEUS_EX AMSD done here for multiplayer propagation.
        HXWeaponMod(DragItem).DestroyMod();
				//player.DeleteInventory(DragItem);

				DragButton = None;
				SelectInventory(dragTarget);
			}
			else
			{
				// move back to original spot
				ReturnButton(HXPersonaInventoryItemButton(DragButton));
			}
		}
		else
		{
			if (dragTarget == DragButton)
			{
				MoveItemButton(HXPersonaInventoryItemButton(DragButton), HXPersonaInventoryItemButton(DragButton).dragPosX, HXPersonaInventoryItemButton(DragButton).dragPosY );
			}
			else if ( HXHUDObjectSlot(LastDragOverButton) != None )	
			{
				BeltSlot = HXHUDObjectSlot(LastDragOverButton).objectNum;

				// Don't allow to be moved over pinned items.
				if ( !HXPlayerPawn(Player).BeltPositionPinned(BeltSlot) )
					HXPlayerPawn(Player).AddObjectToBelt( DragItem, BeltSlot, false );

				// Restore item to original slot
				ReturnButton(HXPersonaInventoryItemButton(DragButton));
			}
			else if (LastDragOverButton != DragButton)
			{
				// move back to original spot
				ReturnButton(HXPersonaInventoryItemButton(DragButton));
			}
		}
	}
	else		// 'ObjectSlot'
	{
		//
		// Check to see if this is a valid drop location (which are only other object slots).
		//
		// Swap the two items and select the one that was dragged
		// but make sure the target isn't pinned (e.g. the NanoKeyRing).
		//
		ItemSlot = HXHUDObjectSlot(LastDragOverButton);

		if ( ItemSlot!=None )
		{
			DragItem      = HXHUDObjectSlot(DragButton).GetItem();
			DraggedOnItem = ItemSlot.GetItem();
			
			DragSlot      = HXHUDObjectSlot(DragButton).ObjectNum;
			DraggedOnSlot = ItemSlot.ObjectNum;

			//if ( ItemSlot.GetItem()==None || !HXPlayerPawn(Player).BeltPositionPinned(ItemSlot.ObjectNum) )
			if ( DraggedOnItem==None || !HXPlayerPawn(Player).BeltPositionPinned(DraggedOnSlot) )
			{
				Player.AddObjectToBelt( DragItem, DraggedOnSlot, false );
				Player.AddObjectToBelt( DraggedOnItem, DragSlot, false );

				//Player.AddObjectToBelt( HXHUDObjectSlot(DragButton).GetItem(), ItemSlot.ObjectNum, false );
				//Player.AddObjectToBelt( ItemSlot.GetItem(), HXHUDObjectSlot(DragButton).ObjectNum, false );

				ItemSlot.SetToggle( true );
			}
		}
		else
		{
			// If the player drags the item outside the object belt, then remove it.
			Player.RemoveObjectFromBelt( HXHUDObjectSlot(DragButton).GetItem() );
		}
	}

	EndDragMode();
}

// ----------------------------------------------------------------------
// EndDragMode()
// ----------------------------------------------------------------------

function EndDragMode()
{
	// Make sure the last inventory item dragged over isn't still highlighted
	if (LastDragOverButton != None)
	{
		if (LastDragOverButton.IsA('HXPersonaInventoryItemButton'))
			HXPersonaInventoryItemButton(LastDragOverButton).ResetFill();
		else
			HXHUDObjectSlot(LastDragOverButton).ResetFill();

		LastDragOverButton = None;
	}

	bDragging = False;

	// Select the item
	if (DragButton != None)
	{
		if (DragButton.IsA('HXPersonaInventoryItemButton'))
			SelectInventory(HXPersonaInventoryItemButton(DragButton));
		else if (DragButton.IsA('ToggleWindow'))
			ToggleWindow(DragButton).SetToggle(True);

		DragButton = None;
	}
    
	SignalRefresh();
}

// ----------------------------------------------------------------------
// MoveItemButton()
// ----------------------------------------------------------------------

function MoveItemButton(HXPersonaInventoryItemButton anItemButton, int col, int row)
{
	//player.SetInvSlots(Inventory(anItemButton.GetClientObject()), 0);
	SetInvSlots(Inventory(anItemButton.GetClientObject()), 0);

	//player.PlaceItemInSlot(Inventory(anItemButton.GetClientObject()), col, row );
	HXPlayerPawn(Player).RequestInventoryTransaction( Inventory(anItemButton.GetClientObject()), col, row );

	SetItemButtonPos(anItemButton, col, row);

	//Set it to refresh again
	// HX_NOTE: AckInventoryTransaction bounces back a refresh
	//SignalRefresh();
}

// ----------------------------------------------------------------------
// ReturnButton()
// ----------------------------------------------------------------------

function ReturnButton(HXPersonaInventoryItemButton anItemButton)
{
	local Inventory inv;

	inv = Inventory(anItemButton.GetClientObject());

	//player.PlaceItemInSlot(inv, inv.invPosX, inv.invPosY);
	PlaceItemInSlot(inv, inv.invPosX, inv.invPosY);
	SetItemButtonPos(anItemButton, inv.invPosX, inv.invPosY);
}

// ----------------------------------------------------------------------
// HighlightSpecial()
// ----------------------------------------------------------------------

function HighlightSpecial(Inventory item)
{
	if (item != None)
	{
		if (item.IsA('HXWeaponMod'))
			HighlightModWeapons(HXWeaponMod(item));
		else if (item.IsA('HXAmmo'))
			HighlightAmmoWeapons(HXAmmo(item));
	}
}

// ----------------------------------------------------------------------
// HighlightModWeapons()
// 
// Highlights/Unhighlights any weapons that can be upgraded with the 
// weapon mod passed in
// ----------------------------------------------------------------------

function HighlightModWeapons(HXWeaponMod weaponMod)
{
	local Window itemWindow;
	local HXPersonaInventoryItemButton itemButton;
	local Inventory anItem;

	// Loop through all our children and check to see if 
	// we have a match.

	itemWindow = winItems.GetTopChild();
	while( itemWindow != None )
	{
		itemButton = HXPersonaInventoryItemButton(itemWindow);
		if (itemButton != None)
		{
			anItem = Inventory(itemButton.GetClientObject());
			if ((anItem != None) && (anItem.IsA('HXWeapon')))
			{
				if ((weaponMod != None) && (weaponMod.CanUpgradeWeapon(HXWeapon(anItem))))
				{
					itemButton.HighlightWeapon(True);
				}
			}
			else
			{
				itemButton.ResetFill();
			}
		}	
		itemWindow = itemWindow.GetLowerSibling();
	}
}

// ----------------------------------------------------------------------
// HighlightAmmoWeapons()
// 
// Highlights/Unhighlights any weapons that can be used with the 
// selected ammo
// ----------------------------------------------------------------------

function HighlightAmmoWeapons(HXAmmo ammo)
{
	local Window itemWindow;
	local HXPersonaInventoryItemButton itemButton;
	local Inventory anItem;

	// Loop through all our children and check to see if 
	// we have a match.

	itemWindow = winItems.GetTopChild();
	while( itemWindow != None )
	{
		itemButton = HXPersonaInventoryItemButton(itemWindow);
		if (itemButton != None)
		{
			anItem = Inventory(itemButton.GetClientObject());
			if ((anItem != None) && (anItem.IsA('HXWeapon')))
			{
				if ((ammo != None) && (HXWeapon(anItem).CanLoadAmmoType(ammo)))
				{
					itemButton.HighlightWeapon(True);
				}
			}
			else
			{
				itemButton.ResetFill();
			}
		}	
		itemWindow = itemWindow.GetLowerSibling();
	}
}

// ----------------------------------------------------------------------
// ClearSpecialHighlights()
// ----------------------------------------------------------------------

function ClearSpecialHighlights()
{
	local Window itemWindow;
	local HXPersonaInventoryItemButton itemButton;
	local Inventory anItem;

	// Loop through all our children and check to see if 
	// we have a match.

	itemWindow = winItems.GetTopChild();
	while( itemWindow != None )
	{
		itemButton = HXPersonaInventoryItemButton(itemWindow);
		if (itemButton != None)
		{
			itemButton.ResetFill();
		}

		itemWindow = itemWindow.GetLowerSibling();
	}
}

// ----------------------------------------------------------------------
// UpdateAmmoSelected()
// ----------------------------------------------------------------------

function UpdateAmmoSelected( class WeaponClass, class NewAmmoClass )
{
	Log( "TODO: " $ Self $ ".UpdateAmmoSelected()" );
}

// ----------------------------------------------------------------------
// IsEmptyItemSlot()
//
// Returns True if the item will fit in this slot
// ----------------------------------------------------------------------

function Bool IsEmptyItemSlot( Inventory anItem, int col, int row )
{
	local int slotsCol;
	local int slotsRow;
	local Bool bEmpty;

	if ( anItem == None )
		return False;

	// First make sure the item can fit horizontally
	// and vertically
	if (( col + anItem.invSlotsX > maxInvCols ) ||
		( row + anItem.invSlotsY > maxInvRows ))
			return False;

	//if ((Level.NetMode != NM_Standalone) && (bBeltIsMPInventory))
		//return True;

	// Now check this and the needed surrounding slots
	// to see if all the slots are empty

	bEmpty = True;
	for( slotsRow=0; slotsRow < anItem.invSlotsY; slotsRow++ )
	{
		for ( slotsCol=0; slotsCol < anItem.invSlotsX; slotsCol++ )
		{
			if ( invSlots[((slotsRow + row) * maxInvCols) + (slotsCol + col)] == 1 )
			{
				bEmpty = False;
				break;
			}
		}

		if ( !bEmpty )
			break;
	}

	return bEmpty;
}

// ----------------------------------------------------------------------
// SetInvSlots()
// ----------------------------------------------------------------------

function SetInvSlots( Inventory anItem, int newValue )
{
	local int slotsCol;
	local int slotsRow;

	if ( anItem == None )
		return;

	// Make sure this item is located in a valid position
	if (( anItem.invPosX != -1 ) && ( anItem.invPosY != -1 ))
	{
		// fill inventory slots
		for( slotsRow=0; slotsRow < anItem.invSlotsY; slotsRow++ )
			for ( slotsCol=0; slotsCol < anItem.invSlotsX; slotsCol++ )
				invSlots[((slotsRow + anItem.invPosY) * maxInvCols) + (slotsCol + anItem.invPosX)] = newValue;
	}
}

// ----------------------------------------------------------------------
// PlaceItemInSlot()
//
// Copied off DeusExPlayer (only used for UI now)
// ----------------------------------------------------------------------

function PlaceItemInSlot( Inventory anItem, int col, int row )
{
	// Save in the original Inventory item also
	anItem.invPosX = col;
	anItem.invPosY = row;

	SetInvSlots(anItem, 1);
}

// ----------------------------------------------------------------------
// RemoveItemFromSlot()
//
// Copied off DeusExPlayer (only used for UI now)
// ----------------------------------------------------------------------

function RemoveItemFromSlot( Inventory anItem )
{
	if (anItem != None)
	{
		SetInvSlots(anItem, 0);
		anItem.invPosX = -1;
		anItem.invPosY = -1;
	}
}

// ----------------------------------------------------------------------
// ClearInventorySlots()
//
// Copied off DeusExPlayer (only used for UI now)
// ----------------------------------------------------------------------

function ClearInventorySlots()
{
	local int slotIndex;

	for(slotIndex=0; slotIndex<arrayCount(invSlots); slotIndex++)
		invSlots[slotIndex] = 0;
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------
// DescendantRemoved() : Called when a descendant window is removed

event DescendantRemoved(Window descendant)
{
	Super.DescendantRemoved( Descendant );

	if ( Descendant==SelectedAmmo )
		SelectedAmmo = None;
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	invButtonWidth=53
	invButtonHeight=53
	smallInvWidth=40
	smallInvHeight=35
	InventoryTitleText="Inventory"
	EquipButtonLabel="|&Equip"
	UnequipButtonLabel="Un|&equip"
	UseButtonLabel="|&Use"
	DropButtonLabel="|&Drop"
	ChangeAmmoButtonLabel="Change Amm|&o"
	NanoKeyRingInfoText="Click icon to see a list of Nanokeys."
	NanoKeyRingLabel="Keys: %s"
	DroppedLabel="%s dropped"
	AmmoLoadedLabel="%s loaded"
	WeaponUpgradedLabel="%s upgraded"
	//CannotBeDroppedLabel="%s cannot be dropped here"
	AmmoInfoText="Click icon to see a list of Ammo."
	AmmoTitleLabel="Ammunition"
	NoAmmoLabel="No Ammo Available"
	clientBorderOffsetY=33
	ClientWidth=585
	ClientHeight=361
	clientOffsetX=33
	clientOffsetY=10
	clientTextures(0)=Texture'DeusExUI.UserInterface.InventoryBackground_1'
	clientTextures(1)=Texture'DeusExUI.UserInterface.InventoryBackground_2'
	clientTextures(2)=Texture'DeusExUI.UserInterface.InventoryBackground_3'
	clientTextures(3)=Texture'DeusExUI.UserInterface.InventoryBackground_4'
	clientTextures(4)=Texture'DeusExUI.UserInterface.InventoryBackground_5'
	clientTextures(5)=Texture'DeusExUI.UserInterface.InventoryBackground_6'
	clientBorderTextures(0)=Texture'DeusExUI.UserInterface.InventoryBorder_1'
	clientBorderTextures(1)=Texture'DeusExUI.UserInterface.InventoryBorder_2'
	clientBorderTextures(2)=Texture'DeusExUI.UserInterface.InventoryBorder_3'
	clientBorderTextures(3)=Texture'DeusExUI.UserInterface.InventoryBorder_4'
	clientBorderTextures(4)=Texture'DeusExUI.UserInterface.InventoryBorder_5'
	clientBorderTextures(5)=Texture'DeusExUI.UserInterface.InventoryBorder_6'
	clientTextureRows=2
	clientTextureCols=3
	clientBorderTextureRows=2
	clientBorderTextureCols=3
	EquippedLabel="%s equipped"
	UneEquippedLabel="%s unequipped"
	maxInvRows=6
	maxInvCols=5
}
