//=============================================================================
// HXPhone.
//=============================================================================
class HXPhone extends HXElectronicDevices;

enum ERingSound
{
	RS_Office1,
	RS_Office2
};

enum EAnswerSound
{
	AS_Dialtone,
	AS_Busy,
	AS_OutOfService,
	AS_CircuitsBusy
};

var() ERingSound RingSound;
var() EAnswerSound AnswerSound;
var() float RingFreq;
var float RingTimer;
var bool bUsing;

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local Phone OtherPhone;

	// Call Super.
	Super.Succeeds( Other );

	// Special Phone Init.
	OtherPhone = Phone(Other);
	if ( OtherPhone!=None )
	{
		SetPropertyText( "RingSound", OtherPhone.GetPropertyText("RingSound") );
		SetPropertyText( "AnswerSound", OtherPhone.GetPropertyText("AnswerSound") );
		RingFreq = OtherPhone.RingFreq;
	}
}

// ----------------------------------------------------------------------------
// Tick()
// ----------------------------------------------------------------------------

function Tick( float DeltaTime )
{
	Super.Tick( DeltaTime );

	if ( !bUsing )
	{
		RingTimer += DeltaTime;

		if ( RingTimer>=1.0 )
		{
			RingTimer -= 1.0;

			if ( FRand()<RingFreq )
			{
				switch ( RingSound )
				{
					case RS_Office1:
						PlaySound( Sound'PhoneRing1', SLOT_Misc,,, 256 );
						break;
					case RS_Office2:
						PlaySound( Sound'PhoneRing2', SLOT_Misc,,, 256 );
						break;
				}
			}
		}
	}
}

// ----------------------------------------------------------------------------
// Timer()
// ----------------------------------------------------------------------------

function Timer()
{
	bUsing = False;
}

// ----------------------------------------------------------------------------
// Frob()
// ----------------------------------------------------------------------------

function Frob( Actor Frobber, Inventory FrobWith )
{
	local Sound RandomSound;
	local float SoundDuration;
	local float Rnd;

	Super.Frob( Frobber, FrobWith );

	if ( bUsing )
		return;

	// Prevent other sounds playing if we have just started a conversation.
	// (These states might not get set if bAvoidState is true).
	if ( IsInState('Conversation') || IsInState('FirstPersonConversation') )
		return;

	bUsing = True;

	Rnd = FRand();
	if ( Rnd<0.1 )
		RandomSound = Sound'PhoneBusy';
	else if ( Rnd<0.2 )
		RandomSound = Sound'PhoneDialtone';
	else if ( Rnd<0.4 )
		RandomSound = Sound'PhoneVoice1';
	else if ( Rnd<0.6 )
		RandomSound = Sound'PhoneVoice2';
	else if ( Rnd<0.8 )
		RandomSound = Sound'PhoneVoice3';
	else
		RandomSound = Sound'PhoneVoice4';

	SoundDuration = GetSoundDuration( RandomSound );
	PlaySound( RandomSound, SLOT_Misc,,, 256 );

	// Previous timer was 3.0s.
	// Sounds are up to 2s.
	SetTimer( SoundDuration + 3.0, False );
}

// ----------------------------------------------------------------------------
// state Conversation.
// ----------------------------------------------------------------------------

state Conversation
{
	ignores Bump, Frob;

	// Stop any possible currently playing ring sound.
	function BeginState()
	{
		StopSoundSlot( SLOT_Misc );

		Super.BeginState();
	}

	// Prevent Phone from ringing during conversations.
	function Tick( float DeltaTime )
	{
		Super.Tick( DeltaTime );
	}

Idle:
	Sleep( 1.0 );
	goto( 'Idle' );

Begin:
	// Make sure we're not on fire!
	ExtinguishFire();

	goto( 'Idle' );
}

// ----------------------------------------------------------------------------
// state FirstPersonConversation.
// ----------------------------------------------------------------------------

state FirstPersonConversation
{
	ignores Bump, Frob;

	// Stop any possible currently playing ring sound.
	function BeginState()
	{
		StopSoundSlot( SLOT_Misc );

		Super.BeginState();
	}

	// Prevent Phone from ringing during conversations.
	function Tick( float DeltaTime )
	{
		Super.Tick( DeltaTime );
	}

Idle:
	Sleep(1.0);
	goto('Idle');

Begin:
	goto('Idle');
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	RingFreq=0.01
	ItemName="Telephone"
	Mesh=Phone
	CollisionRadius=11.87
	//CollisionHeight=3.78
	CollisionHeight=3.03
	Mass=20.0
	Buoyancy=15.0
}
