//=============================================================================
// HXPickupDistributor.
//
// Distributes NanoKeys at the start of a level, then destroys itself.
//=============================================================================
class HXPickupDistributor extends HXKeypoint;

// Copied from NanoKey.
enum ESkinColor
{
	SC_Level1,
	SC_Level2,
	SC_Level3,
	SC_Level4
};

struct SNanoKeyInitStruct
{
	var() Name             ScriptedPawnTag;
	var() Name             KeyID;
	var() localized String Description;
	var() ESkinColor       SkinColor;
};

var() localized SNanoKeyInitStruct NanoKeyData[8];

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local PickupDistributor OtherPickupDistributor;
	local int i;
	local byte b;

	// Call Super.
	Super.Succeeds( Other );

	// Special PickupDistributor Init.
	OtherPickupDistributor = PickupDistributor(Other);
	if ( OtherPickupDistributor!=None )
	{
		// PickupDistributor.
		for ( i=0; i<ArrayCount(NanoKeyData); i++ )
		{
			NanoKeyData[i].ScriptedPawnTag = OtherPickupDistributor.NanoKeyData[i].ScriptedPawnTag;
			NanoKeyData[i].KeyID           = OtherPickupDistributor.NanoKeyData[i].KeyID;
			NanoKeyData[i].Description     = OtherPickupDistributor.NanoKeyData[i].Description;

			// Does this work with Set/GetPropertyText?
			switch ( OtherPickupDistributor.NanoKeyData[i].SkinColor )
			{
				case SC_Level1: NanoKeyData[i].SkinColor = SC_Level1; break; 
				case SC_Level2: NanoKeyData[i].SkinColor = SC_Level2; break; 
				case SC_Level3: NanoKeyData[i].SkinColor = SC_Level3; break; 
				case SC_Level4: NanoKeyData[i].SkinColor = SC_Level4; break; 
			}
		}
	}
}

// ----------------------------------------------------------------------------
// PostBeginPlay()
// ----------------------------------------------------------------------------

function PostBeginPlay()
{
	local int i;
	local Pawn P;
	local HXNanoKey NanoKey;

	Super.PostBeginPlay();

	if ( bDeleteMe )
		return;
	
	if ( !IsInRelevant() )
	{
		for ( i=0; i<ArrayCount(NanoKeyData); i++ )
		{
			if ( NanoKeyData[i].ScriptedPawnTag!='' )
			{
				//Log("NanoKeyData[" $ i $"].ScriptedPawnTag is" @ NanoKeyData[i].ScriptedPawnTag);
				foreach AllActors( class'Pawn', P, NanoKeyData[i].ScriptedPawnTag )
				{
					NanoKey = Spawn( class'HXNanoKey', P );
					if ( NanoKey!=None )
					{
						NanoKey.KeyID = NanoKeyData[i].KeyID;
						NanoKey.Description = NanoKeyData[i].Description;
						NanoKey.SetPropertyText( "SkinColor", "SC_Level" $ (NanoKeyData[i].SkinColor+1) );
						NanoKey.InitialState = 'Idle2';
						NanoKey.GiveTo(P);
						NanoKey.SetBase(P);
					}

					//Log("HXPickupDistributor: gave NanoKey" @ NanoKey.KeyID @ "to" @ P @ "of class" @ P.class );
				}
			}
		}

		Destroy();
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	bStatic=False
}
