//=============================================================================
// HXPlayerPawn.
//
// TODO:
//  * Unify IsHighlighted and IsFrobbable.
//=============================================================================
class HXPlayerPawn extends DeusExPlayer
	native
	abstract;

const INDEX_NONE = -1;

var transient HXGameInfo Game;

var Texture Portrait; // Portrait used for PlayerClass selection screen.

var Vector CurrentFlashFog; // Used because FlashFog gets reset if under a threshold.

var float LipSynchTime; // Used for getting LipSynchTimer() messages .

var travel Inventory HXKeyRing;		// Inventory Item

var HXMedicalBot CurrentMedicalBot;
var HXRepairBot CurrentRepairBot;	

var HXInformationDevices CurrentInformationDevice;

// For closing comptuers if the server quits
var HXComputers HXActiveComputer;
var HXScriptedPawn ActivePawn;

//var bool bIsInSaveGame;
var bool bPostLoginRun;
var bool bClientDoLipSynch;
var bool bClientIsSpeaking;		// are we speaking now
var bool bClientWasSpeaking;		// were we speaking last frame?  (should we close our mouth?)
var bool bThirdOptionsSynced;
var bool bForthOptionsSynced;
var bool bOnCinematicMap; // whether in Intro or Endgame
var travel bool bAugsGranted; // Whether intial Augs/AugUps were already applied.

var HXSpyDrone aHXDrone;

var transient HXConWindowActive conWinThird;		// First-Person Conversation Window

var bool bInThirdPersonCameraOverride;
var bool bCloakOn; // For now just used to avoid updating display style every time.

// calculated by ConCamera (valid if bInThirdPersonCameraOverride)
var vector	ThirdPersonCameraLocation;
var rotator	ThirdPersonCameraRotation;
var Actor		ThirdPersonCameraViewActor;

var int ClientCredits; // As Credits are not replicated.
var int AugMuscleClassLevel; // for simulated decoration bump code

var HXFlagReplicationInfo FlagReplicationInfo;
var HXImageReplicationInfo ImageReplicationInfo;
var HXNanoKeyReplicationInfo NanoKeyReplicationInfo;

var() globalconfig int AugUpPrefs[9]; //List of aug preferences.
var globalconfig int WindowScale;
var globalconfig float ChatTimeout; // Log Timeout Value for say/teamsay messages.

var int bPlayerViewedImage[48];
var int ClientSoundIDMapping[16]; // 16 should be enough

struct AugCannisterInfo
{
	var int MuscleCombat;
	var int SpeedStealth;
	var int DefenseDrone;
	var int VisionTarget;
	var int CloakRadarTrans;
	var int BallisticEMP;
	var int EnviroAqualung;
	var int HealingShield;
	var int PowerHeartLung;
};

var AugCannisterInfo AugCannisterAppearance[16];

var Actor HXConversationActor;

struct InventoryCol
{
	var Inventory Content[6];
};

// travel didn't work here anyway
var InventoryCol InventoryGrid[5];

//struct InventoryBeltSlot
//{
	//var travel Inventory Item;
	//var travel int bPinned;
//};
//var travel InventoryBeltSlot InventoryBelt[10]; // Belt inventory.
var travel Inventory InventoryBelt[10]; // Belt inventory.
var travel byte      InventoryBeltPinned[10];

var DeusExLevelInfo DeusExLevelInfo;

var const localized string DroppedLabel;
var const localized string CannotBeDroppedLabel;
var const localized string ATMLessCreditsAvailable;
var const localized string ATMAccountEmpty;
var const localized string AllSkillsAwardMessage;
var const localized string AllSkillPointsAwardMessage;
var const localized string AddSkillPointsAwardMessage;

var const localized string MsgHealedPoint;
var const localized string MsgHealedPoints;
var const localized string MsgRechargedPoint;
var const localized string MsgRechargedPoints;

//
// Variables intended to be used by MissionScripts when needed.
// Mod authors should use them as they please if needed to store
// Player associated data. Best practice is to not access them 
// direct, but by add getter/setter functions for a feature.
// (e.g. SetInventoryMovedToArmory() / GetInventoryMovedToArmory())
// See HXMission05 for an example.
//
// Currently used by HX:
//  * bMissionScriptBoolean0 -- Whether Inventory was put in Armory in Mission05
//
var travel bool   bMissionScriptBoolean0, bMissionScriptBoolean1, bMissionScriptBoolean2, bMissionScriptBoolean3;
var travel byte   MissionScriptBytes[4];
var travel int    MissionScriptInst[4];
var travel float  MissionScriptFloats[4];
var travel Name   MissionScriptNames[4];
var travel String MissionScriptStrings[4];
var travel Class  MissionScriptClasses[4];
var travel Actor  MissionScriptActors[4];

// Goals.
const NUM_CLIENT_GOALS = 32;
struct GoalInfo
{
	var Name GoalName; // Goal name, "GOAL_somestring"
	var String GoalText;   // Actual goal text
	var bool bPrimaryGoal;		// True if Primary Goal
	var bool bCompleted;			// True if Completed
};
var GoalInfo ClientGoals[32];

var transient Actor ClientInterpolationDummy;

// Scaled BreathPercent (e.g. ScaledBreathPercent=255 equals 100%).
var byte ScaledBreathPercent;

// length of time player can stay underwater
// modified by SkillSwimming, AugAqualung, and Rebreather
// HX_HAN: Needed to replace DiveDuration/Timer because they were
//         replicated client->server, which despite beeing awful,
//         broke the rebreather.
var float DiveDuration;
var float DiveTimer;

// NanoVirus infection.
var travel bool  bNanoVirusInfected;
var travel float NanoVirusDelay;              // Shrinking delay for NanoVirusTimer.
var travel float NanoVirusTime;               // Used for NanoVirusTimer;
var          int NanoVirusDamage;             // Nanovirus caught damage.

//
// Walktexture event notifies us about beeing on a ladder, but there is no
// direct way of querying whether we are on a ladder, so store information
// here.
//
var transient bool bOnLadder;
var transient Texture LadderTexture;
var transient vector LadderStepLocation;
var transient vector LadderStepNormal;

//
// Fixed and extended version of TraceTexture() which also returns
// the Texture hit (Hint: There are Sound properties on Texture).
//
native(3300) final iterator function TraceTextures
(
	Class<Actor> BaseClass,
	out actor Actor,
	out Texture Tex,
	out name TexName,
	out name TexGroup,
	out int Flags,
	out vector HitLoc,
	out vector HitNorm,
	vector End,
	optional vector Start,
	optional vector Extent
);

//
// First Hit variant of TraceTextures.
// (The same as Trace is to TraceActors)
//
native(3301) final function Actor TraceSingleTexture
(
	Class<Actor> BaseClass,
	out Texture  Texture,
	out Name     TextureName,
	out Name     TextureGroup,
	out int      TextureFlags,
	out Vector   HitLocation,
	out Vector   HitNormal,
	Vector       TraceEnd,
	optional Vector TraceStart,
	optional bool bTraceActors,
	optional Vector TraceExtent
);

//
// Behaves the same FastTrace but returns the
// surface texture if a hit occured.
//
/*native(3302) final function bool FastTextureTrace
(
	Vector          TraceEnd,
	out Texture     Texture,
	out Name        TextureName,
	out Name        TextureGroup,
	out int         TextureFlags,
	optional Vector TraceStart
);*/

//
// Returns true if did not hit non transparent world geometry.
// This might not be exact as this might check a coplanar bsp surface.
// However most windows are on a different plane, so this works
// fine nearly all the time (expect for maybe ugly maps) so it would
// not be worth the additional performance hit.
//
// Code was kindly donated by Smirftsch (oldunreal.com).
//
native(3303) final function bool FastRepTrace
(
	vector          TraceEnd,
	optional vector TraceStart
);

// Travel related stuff.
//native(3310) final function bool PreExportClean();
native(3311) final function bool ExportTravel();

// Non HXGameEngine is no good.
native(3312) final function bool CompareGameEngine( class<GameEngine> EngineClass );

// String to Name conversion.
native(3313) static final function Name StringToName( Coerce string Str );

// Additional view support.
native(3314) final function bool AddAdditionalView( Actor AddMe );
native(3315) final function RemoveAdditionalView( Actor RemoveMe );
native(3316) final function RemoveAllAdditionalViews();

//
// Call 'function bool CanBeDropped()' on Item.
//
// Returns true if function is not found, otherwise it returns
// the return value of CanBeDropped.
//
//event bool CanBeDropped( optional bool bSilent );
native(3317) final function bool DuckCallCanBeDropped( Inventory Item, optional bool bSilent );

//
// Stops the specified or all sound slots for an Actor.
//
// These functions do work in network. However, ClientHearSound() is NOT
// reliable, so it could happen that the PlaySound() call reaches the client
// after the StopSoundId/StopSoundSlot/StopAllSoundSlots call. So try to avoid 
// starting the sound and stopping it at the same or next few ticks and you
// are safe (the same applies to stop the sound to just play another).
//
native(3217) final function StopSoundSlot( ESoundSlot Slot );
native(3218) final function StopAllSoundSlots();
native simulated event DemoStopSoundSlot( ESoundSlot Slot );
native simulated event DemoStopAllSoundSlots();

// Support for StopSoundSlot() / StopAllSoundSlots(). You NEVER want to call this directly.
native simulated event ClientStopSound( int ActorIndex, int SlotMask );

// ----------------------------------------------------------------------------
// Network replication.
// ----------------------------------------------------------------------------

replication
{
	// Network support for stopping sound slots.
	reliable if ( (!bDemoRecording || bClientDemoRecording && bClientDemoNetFunc) && Role==ROLE_Authority )
		ClientStopSound;
	reliable if( bDemoRecording )
		DemoStopSoundSlot, DemoStopAllSoundSlots;

	// CustomCommand request.
	reliable if ( Role<ROLE_Authority )
		CustomCommand;

	// DebugInfo command requests.
	reliable if ( Role<ROLE_Authority )
		GetState, GetPhysics, GetMyState, GetMyPhysics;

	// DebugInfo command permits.
	reliable if ( Role==ROLE_Authority )
		GetLocalState, GetLocalPhysics, GetMyLocalState, GetMyLocalPhysics;

	// MapChange command requests declared inside PlayerPawn.
	//reliable if( Role<ROLE_Authority )
		//SwitchLevel, SwitchCoopLevel;

	// CheatSummon command requests.
	reliable if ( Role<ROLE_Authority )
		ServerSpawnMass, ServerAllWeapons, ServerAllAmmo,
		AllPickups, AllChargedPickups, AllSkilledTools, AllDrugs,
		AllFoods, AllSnacks, AllBeverages, AllWeaponMods;

	// CheatSummon command requests declared inside PlayerPawn.
	//reliable if( Role<ROLE_Authority )
		//Summon, AllAmmo;

  // server to client
  reliable if ( bNetOwner && Role==ROLE_Authority )
		HXKeyRing, ClientCredits,
		FlagReplicationInfo, ImageReplicationInfo, NanoKeyReplicationInfo;

  reliable if (Role == ROLE_Authority)
		HXAddChargedDisplay, HXRemoveChargedDisplay, AugMuscleClassLevel,
		ClientAddNote, ClientDeleteAllNotes, ClientAddGoal, ClientDeleteGoalByName, ClientGoalCompleted,
		ClientDeleteAllGoals, ClientResetGoals, /* ClientAddImage, */ ClientAddLog, ClientClearLog,
		ClientFrobInformationDevices, HXInvokeComputerScreen, aHXDrone,
		HXCloseThisComputer, InvokeRepairBot, InvokeMedicalBot, CloseThisPawn, SetRepairBotChargeTime, SetMedicalBotHealTime,
		ClientStartDataLinkTransmission, ClientResumeDataLinks, ClientAddReceivedItemDisplay,
		ClientActivateScopeView, ClientDeactivateScopeView,
		ClientTechGogglesChargedPickupBegin, ClientTechGogglesChargedPickupEnd,
		ClientUpdatePersonaStatusLineWindow, ClientUpdatePersonaScreenInventoryAmmoSelected,
		SendActorOnPath, BroadcastInterpolationOptions;

  reliable if (Role == ROLE_Authority)
		ClientPlayActorSpeech, ClientPlayActorCinematicSpeech, ClientStopActorSpeech,
		ClientCreateConWinThird, ClientDestroyConWinThird,
		ClientDisplayConWinThirdLine, ClientAddConWinThirdLine, ClientDisplayConWinThirdChoice;

	// camera overides
  reliable if ((Role == ROLE_Authority) && (bNetOwner))
		bInThirdPersonCameraOverride, ThirdPersonCameraLocation, ThirdPersonCameraRotation, ThirdPersonCameraViewActor,
		bOnCinematicMap, ClientStartCinematicCamera;

	// lipsynch
	reliable if (Role == ROLE_Authority)
//		bClientDoLipSynch,
			bClientIsSpeaking;
//		bClientWasSpeaking, HXConversationActor;

	// Cloak stuff.
	/*reliable if ( Role==ROLE_Authority )
		bCloakOn;*/

	reliable if ((Role == ROLE_Authority) && (bNetOwner))
		ClientJoltView, HXActivateKeyPadWindow, UpdateClientCredits, UpdateClientSkillPoints, ClientAddBarkDisplay;

	// Functions the client can call
	reliable if (Role < ROLE_Authority)
		HXKeypadRunUntriggers, HXKeypadRunEvents, HXKeypadToggleLocks, HXCloseComputerScreen,
		HXSetComputerHackTime, HXUpdateCameraRotation, HXToggleCameraState, HXSetTurretTrackMode,
		HXSetTurretState, TakeHackDetectedDamage, WithdrawCreditsAndModBalance, ClosePawn,
		RepairBotChargePlayer, MedicalBotHealPlayer, ActivateItemFromInventoryScreen,
		ServerPlayNextConPlayEvent, ServerPlayConPlayChoice, ActivateSpecialComputerOption,
		ComputerToggleDoorLock, ComputerTriggerDoor, ReceiveThirdOptionSync, ReceiveForthOptionSync,
		NotifyUp, DropAmmo, AugReset, AugAddDefault;

	// Augmentation handling.
	reliable if ( Role<ROLE_Authority )
		_ActivateAugmentation, DeactivateAugmentation, ToggleAugmentation;

	// Cheats the client can call
	reliable if ( Role<ROLE_Authority )
		ServerTantalus, ServerOpenSesame, ServerAllHealth, ServerDamagePart, ServerDamageAll,
		ServerAllEnergy, ServerAllCredits, ServerAllSkills, ServerAllSkillPoints, ServerAllAugs,
		ServerAllImages, ServerTrig, ServerUnTrig, ServerIAmWarren, ServerDXDumpInfo, ServerAddCredits, ServerAddSkillPoints,
		ServerRemoveNanoKey, ServerGiveNanoKey, ServerSetState, ServerSetFlag;

	//reliable if (Role == ROLE_Authority)
		//ClientStartWalk;

	reliable if (RemoteRole == ROLE_AutonomousProxy)
		ClientEnterConversation, ClientLeaveConversation;

	// inventory system
	reliable if ((Role == ROLE_Authority) && (bNetOwner))
		AckInventoryTransaction, InventoryBelt, InventoryBeltPinned;

	reliable if (Role < ROLE_Authority)
		RequestInventoryTransaction;

	// GameEngine checks
  reliable if (Role == ROLE_Authority)
		VerifyGameEngine;

	reliable if (Role < ROLE_Authority)
		FailGameEngineCheck;

	// Oxygen bar.
	reliable if ( Role==ROLE_Authority && bNetOwner )
		ScaledBreathPercent;







}

// ----------------------------------------------------------------------------
// Spawned()
// ----------------------------------------------------------------------------

simulated event Spawned()
{
	if ( Level.bStartup )
		bGameRelevant = true;

	Game = HXGameInfo(Level.Game);
}

// ----------------------------------------------------------------------------
// PreBeginPlay()
// ----------------------------------------------------------------------------

simulated function PreBeginPlay()
{
	local class<Actor> ActorClass;

	AddPawn();

	bIsPlayer = true;

	// Added angular size computation - DEUS_EX STM
	MinAngularSize = tan(AngularResolution*0.5*Pi/180.0);
	MinAngularSize *= MinAngularSize;

	// Set instigator to self.
	Instigator = Self;
	DesiredRotation = Rotation;
	SightCounter = 0.2 * FRand();  //offset randomly 
	if ( Level.Game != None )
		Skill += Level.Game.Difficulty; 
	Skill = FClamp(Skill, 0, 3);
	PreSetMovement();

	if (PlayerReplicationInfoClass != None)
		PlayerReplicationInfo = Spawn(PlayerReplicationInfoClass, Self,,vect(0,0,0),rot(0,0,0));
	else
		PlayerReplicationInfo = Spawn(class'PlayerReplicationInfo', Self,,vect(0,0,0),rot(0,0,0));
	InitPlayerReplicationInfo();

	if ( menuname == "" )
		menuname = GetItemName(string(class));

	if (SelectionMesh == "")
		SelectionMesh = string(Mesh);

	foreach AllActors( Class'DeusExLevelInfo', DeusExLevelInfo )
		break;

	if ( Level.NetMode!=NM_Client )
	{
		if ( DropWhenKilled!=None )
		{
			Game.ModifyInventoryClass( DropWhenKilled );
		}
		if ( CarcassType!=None )
		{
			ActorClass = CarcassType;
			Game.ModifyActorClass( ActorClass );
			CarcassType = Class<Carcass>(ActorClass);
		}
	}
}

// ----------------------------------------------------------------------------
// PostBeginPlay()
//
// set up the augmentation and skill systems
// ----------------------------------------------------------------------------

function PostBeginPlay()
{
	local DeusExLevelInfo info;
	local int levelInfoCount;

	SplashTime = 0;

	if (Level.LevelEnterText != "" )
		ClientMessage(Level.LevelEnterText);
	if ( Level.NetMode != NM_Client )
	{
		HUDType = Level.Game.HUDType;
		ScoringType = Level.Game.ScoreboardType;
		MyAutoAim = FMax(MyAutoAim, Level.Game.AutoAim);
	}

	bIsPlayer = true;
	DodgeClickTime = FMin(0.3, DodgeClickTime);
	DesiredFOV = DefaultFOV;
	EyeHeight = BaseEyeHeight;
	if ( Level.Game.IsA('SinglePlayer') && (Level.NetMode == NM_Standalone) )
		FlashScale = vect(0,0,0);

	// Check to make sure there's only *ONE* DeusExLevelInfo and 
	// go fucking *BOOM* if we find more than one.

	levelInfoCount = 0;
	foreach AllActors(class'DeusExLevelInfo', info)
		levelInfoCount++;

	Assert(levelInfoCount <= 1);
	
	// give us a shadow
   if (Level.Netmode == NM_Standalone)   
      CreateShadow();

	//InitializeSubSystems();
	// Spawn the Color Manager
	CreateColorThemeManager();
  ThemeManager.SetOwner(self);

   DXGame = Level.Game;
   ShieldStatus = SS_Off;
	ServerTimeLastRefresh = 0;

	// Safeguard so no cheats in multiplayer
	if ( Level.NetMode != NM_Standalone )
		bCheatsEnabled = False;
}

// ----------------------------------------------------------------------
// PostPostBeginPlay()
// ----------------------------------------------------------------------

simulated function PostPostBeginPlay()
{
	// This may need to be reset, as a new GameInfo is spawned each time.
	Game = HXGameInfo(Level.Game);

	// Bind any conversation events to this DeusExPlayer
	ConBindEvents();

	// Restore colors that the user selected (as opposed to those
	// stored in the savegame)
	if ( ThemeManager!=None )
	{
		ThemeManager.SetMenuThemeByName(MenuThemeName);
		ThemeManager.SetHUDThemeByName(HUDThemeName);
	}

	//if ((Level.NetMode != NM_Standalone) && ( killProfile == None )
		//killProfile = Spawn(class'KillerProfile', Self);)

	//SpeechTime = 4.0;

	if ( Level.NetMode == NM_ListenServer )
		NotifyUp();
}

// ----------------------------------------------------------------------
// PostNetBeginPlay()
// ----------------------------------------------------------------------

simulated function PostNetBeginPlay()
{
	// Other player.
	if ( Role==ROLE_SimulatedProxy )
	{
		DrawShield();
		CreatePlayerTracker();

		if ( NintendoImmunityTimeLeft > 0.0 )
			DrawInvulnShield();

		return;
	}

	// Local player.
	if ( Role==ROLE_AutonomousProxy )
	{
		// Omnited simulated keyword in LevelInfo.PreBeginPlay() prevents skybox linking in ZoneInfo.PreBeginPlay().
		// Could add FUNC_Simulated flag in C++ though.

		Level.LinkToSkybox();
	}

	// Take care of the theme manager
	//DEUS_EX AMSD In multiplayer, we need to do this for our local theme manager, since
	//PostBeginPlay isn't called to set these up, and the Thememanager can be local, it
	//doesn't have to sync with the server.
	if (ThemeManager == NONE)
	{
		CreateColorThemeManager();

		ThemeManager.SetOwner(self);
		ThemeManager.SetCurrentHUDColorTheme(ThemeManager.GetFirstTheme(1));		
		ThemeManager.SetCurrentMenuColorTheme(ThemeManager.GetFirstTheme(0)); 
		ThemeManager.SetMenuThemeByName(MenuThemeName);	 
		ThemeManager.SetHUDThemeByName(HUDThemeName);

		if (HXRootWindow(rootWindow) != None)
			HXRootWindow(rootWindow).ChangeStyle();        
	}

	ReceiveFirstOptionSync(AugPrefs[0], AugPrefs[1], AugPrefs[2], AugPrefs[3], AugPrefs[4]);
	ReceiveSecondOptionSync(AugPrefs[5], AugPrefs[6], AugPrefs[7], AugPrefs[8]);
	ReceiveThirdOptionSync(AugUpPrefs[0], AugUpPrefs[1], AugUpPrefs[2], AugUpPrefs[3], AugUpPrefs[4]);
	ReceiveForthOptionSync(AugUpPrefs[5], AugUpPrefs[6], AugUpPrefs[7], AugUpPrefs[8]);

	NotifyUp();

	ShieldStatus = SS_Off;
	bCheatsEnabled = False;

	ServerSetAutoReload( bAutoReload );
}

// ----------------------------------------------------------------------
// NotifyUp()
// ----------------------------------------------------------------------

function NotifyUp()
{
	local HXMissionScript Scr;
	local HXGoal goal;

	foreach AllActors( class'HXMissionScript', Scr )
	{
		if ( Scr.bCinematicMap )
		{
			// HX_NOTE: Do things here
			bOnCinematicMap = True;
			ClientCreateConWinThird( True );
			SetCollision( False, False, False );
			RelevantRadius = 800;
			GotoState( 'Paralyzed', 'LetterBox' );
		}

		Scr.NotifyPlayerUp( Self );
	}

	goal = HXGameInfo(Level.Game).Steve.FirstGoal;

	while( goal != None )
	{
		ClientAddGoal( goal.goalName, goal.bPrimaryGoal, goal.text, goal.bCompleted );

		goal = goal.next;
	}
}

// ----------------------------------------------------------------------
// ReceiveFirstOptionSync()
// DEUS_EX AMSD I have to enumerate every 2#%#@%Ing argument???
// ----------------------------------------------------------------------

function ReceiveFirstOptionSync( Name PrefZero, Name PrefOne, Name PrefTwo, Name PrefThree, Name PrefFour)
{
	local int i;
	local Name AugPriority[5];

	if (bFirstOptionsSynced == true)
	{
		return;
	}

	AugPriority[0] = PrefZero;
	AugPriority[1] = PrefOne;
	AugPriority[2] = PrefTwo;
	AugPriority[3] = PrefThree;
	AugPriority[4] = PrefFour;

	for (i = 0; ((i < ArrayCount(AugPrefs)) && (i < ArrayCount(AugPriority))); i++)
	{   
		AugPrefs[i] = AugPriority[i];
	}
	bFirstOptionsSynced = true;

	if (Role == ROLE_Authority)
	{
		if ((HXGameInfo(Level.Game) != None)
			&& bSecondOptionsSynced
			&& bThirdOptionsSynced
			&& bForthOptionsSynced)
		{
			HXGameInfo(Level.Game).SetupAbilities(self);
		}
	}
}

// ----------------------------------------------------------------------
// ReceiveSecondOptionSync()
// DEUS_EX AMSD I have to enumerate every 2#%#@%Ing argument???
// ----------------------------------------------------------------------

function ReceiveSecondOptionSync( Name PrefFive, Name PrefSix, Name PrefSeven, Name PrefEight )
{
	local int i;
	local Name AugPriority[9];

	if (bSecondOptionsSynced == true)
	{
		return;
	}

	AugPriority[5] = PrefFive;
	AugPriority[6] = PrefSix;
	AugPriority[7] = PrefSeven;
	AugPriority[8] = PrefEight;

	for (i = 5; ((i < ArrayCount(AugPrefs)) && (i < ArrayCount(AugPriority))); i++)
	{   
		AugPrefs[i] = AugPriority[i];
	}
	bSecondOptionsSynced = true;

	if (Role == ROLE_Authority)
	{
		if ((HXGameInfo(Level.Game) != None)
			&& bFirstOptionsSynced
			&& bThirdOptionsSynced
			&& bForthOptionsSynced)
		{
			HXGameInfo(Level.Game).SetupAbilities(self);
		}
	}
}

// ----------------------------------------------------------------------
// ReceiveThirdOptionSync()
// DEUS_EX AMSD I have to enumerate every 2#%#@%Ing argument???
// ----------------------------------------------------------------------

function ReceiveThirdOptionSync( int PrefZero, int PrefOne, int PrefTwo, int PrefThree, int PrefFour )
{
	local int i;
	local int AugUpPriority[5];

	if (bThirdOptionsSynced == true)
	{
		return;
	}

	AugUpPriority[0] = PrefZero;
	AugUpPriority[1] = PrefOne;
	AugUpPriority[2] = PrefTwo;
	AugUpPriority[3] = PrefThree;
	AugUpPriority[4] = PrefFour;

	for (i = 0; ((i < ArrayCount(AugUpPrefs)) && (i < ArrayCount(AugUpPriority))); i++)
	{   
		AugUpPrefs[i] = AugUpPriority[i];
	}
	bThirdOptionsSynced = true;

	if (Role == ROLE_Authority)
	{
		if ((HXGameInfo(Level.Game) != None)
			&& bFirstOptionsSynced
			&& bSecondOptionsSynced
			&& bForthOptionsSynced )
		{
			HXGameInfo(Level.Game).SetupAbilities(self);
		}
	}
}

// ----------------------------------------------------------------------
// ReceiveForthOptionSync()
// DEUS_EX AMSD I have to enumerate every 2#%#@%Ing argument???
// ----------------------------------------------------------------------

function ReceiveForthOptionSync( int PrefFive, int PrefSix, int PrefSeven, int PrefEight )
{
	local int i;
	local int AugUpPriority[9];

	if (bForthOptionsSynced == true)
	{
		return;
	}

	AugUpPriority[5] = PrefFive;
	AugUpPriority[6] = PrefSix;
	AugUpPriority[7] = PrefSeven;
	AugUpPriority[8] = PrefEight;

	for (i = 5; ((i < ArrayCount(AugUpPrefs)) && (i < ArrayCount(AugUpPriority))); i++)
	{   
		AugUpPrefs[i] = AugUpPriority[i];
	}
	bForthOptionsSynced = true;

	if (Role == ROLE_Authority)
	{
		if ((HXGameInfo(Level.Game) != None)
			&& bFirstOptionsSynced
			&& bSecondOptionsSynced
			&& bThirdOptionsSynced )
		{
			HXGameInfo(Level.Game).SetupAbilities(self);
		}
	}
}

// ----------------------------------------------------------------------
// FellOutOfWorld()
// ----------------------------------------------------------------------

event FellOutOfWorld()
{
	if ( Level.NetMode==NM_Client )
		return;

	Health = -1;
	SetPhysics( PHYS_None );
	Weapon = None;
	Died( None, 'Fell', Location );
}

// ----------------------------------------------------------------------
// GibbedBy()
// ----------------------------------------------------------------------

function GibbedBy( Actor Other )
{
	local Pawn InstigatedBy;

	if ( Level.NetMode==NM_Client )
		return;

	InstigatedBy = pawn(Other);
	if ( InstigatedBy==None )
		InstigatedBy = Other.Instigator;

	Health = -1000; //make sure gibs

	Died( InstigatedBy, 'Gibbed', Location );
}

// ----------------------------------------------------------------------
// Player name handling routines.
// ----------------------------------------------------------------------

exec function SetName( coerce string InName )
{
	if ( Len(InName)>28 )
		InName = Left(InName,28);

	class'HXActor'.static.ReplaceText( InName, " ", "_" );
	ChangeName( InName );
	UpdateURL( "Name", InName, true );
	SaveConfig();
}

// ----------------------------------------------------------------------
// GrantAugs()
//
// Grants augs in order of priority.
// ----------------------------------------------------------------------

function GrantAugs( int MissionLevel )
{
	local AugCannisterInfo TotalCannisters;
	local Augmentation CurrentAug;
	local int i;

	if (Role < ROLE_Authority)
		return;

	MissionLevel = Max( 0, Min( MissionLevel, ArrayCount(AugCannisterAppearance)-1 ) );

	//Log( Self $ ".GrantAugs() MissionLevel = " $ MissionLevel );

	// calculate total amount of cannisters available
	for ( i=0; i<MissionLevel; i++ )
	{
		TotalCannisters.MuscleCombat		+= AugCannisterAppearance[i].MuscleCombat;
		TotalCannisters.SpeedStealth		+= AugCannisterAppearance[i].SpeedStealth;
		TotalCannisters.DefenseDrone		+= AugCannisterAppearance[i].DefenseDrone;
		TotalCannisters.VisionTarget		+= AugCannisterAppearance[i].VisionTarget;
		TotalCannisters.CloakRadarTrans	+= AugCannisterAppearance[i].CloakRadarTrans;
		TotalCannisters.BallisticEMP		+= AugCannisterAppearance[i].BallisticEMP;
		TotalCannisters.EnviroAqualung	+= AugCannisterAppearance[i].EnviroAqualung;
		TotalCannisters.HealingShield		+= AugCannisterAppearance[i].HealingShield;
		TotalCannisters.PowerHeartLung	+= AugCannisterAppearance[i].PowerHeartLung;
	}

	//Log( TotalCannisters.MuscleCombat );
	//Log( TotalCannisters.SpeedStealth );
	//Log( TotalCannisters.DefenseDrone );
	//Log( TotalCannisters.VisionTarget );
	//Log( TotalCannisters.CloakRadarTrans );
	//Log( TotalCannisters.BallisticEMP );
	//Log( TotalCannisters.EnviroAqualung );
	//Log( TotalCannisters.HealingShield );
	//Log( TotalCannisters.PowerHeartLung );

	for ( i = 0; i < ArrayCount(AugPrefs); i++ )
	{
		//Log( "AugPrefs[i] = " $ String(AugPrefs[i]) );

		if ( !( AugPrefs[i] == '' ) )
		{
			for ( CurrentAug = AugmentationSystem.FirstAug; CurrentAug != None; CurrentAug = CurrentAug.next )
			{
				//Log( "CurrentAug.Class.Name = " $ CurrentAug.Class.Name );

				// check if aug can be installed
				if ( ( CurrentAug.Class.Name == AugPrefs[i] ) && ( CurrentAug.bHasIt == False ) && !AugmentationSystem.AreSlotsFull( CurrentAug ) )
				{
					// now check if this aug is available
					if ( ( CurrentAug.IsA('HXAugMuscle') || CurrentAug.IsA('HXAugCombat') ) && TotalCannisters.MuscleCombat > 0 )
					{
						AugmentationSystem.GivePlayerAugmentation( CurrentAug.Class );

						if ( CurrentAug.bHasIt )
							TotalCannisters.MuscleCombat -= 1;
					}
					else if ( ( CurrentAug.IsA('HXAugSpeed') || CurrentAug.IsA('HXAugStealth') ) && TotalCannisters.SpeedStealth > 0 )
					{
						AugmentationSystem.GivePlayerAugmentation( CurrentAug.Class );

						if ( CurrentAug.bHasIt )
							TotalCannisters.SpeedStealth -= 1;
					}
					else if ( ( CurrentAug.IsA('HXAugDefense') || CurrentAug.IsA('HXAugDrone') ) && TotalCannisters.DefenseDrone > 0 )
					{
						AugmentationSystem.GivePlayerAugmentation( CurrentAug.Class );

						if ( CurrentAug.bHasIt )
							TotalCannisters.DefenseDrone -= 1;
					}
					else if ( ( CurrentAug.IsA('HXAugVision') || CurrentAug.IsA('HXAugTarget') ) && TotalCannisters.VisionTarget > 0 )
					{
						AugmentationSystem.GivePlayerAugmentation( CurrentAug.Class );

						if ( CurrentAug.bHasIt )
							TotalCannisters.VisionTarget -= 1;
					}
					else if ( ( CurrentAug.IsA('HXAugCloak') || CurrentAug.IsA('HXAugRadarTrans') ) && TotalCannisters.CloakRadarTrans > 0 )
					{
						AugmentationSystem.GivePlayerAugmentation( CurrentAug.Class );

						if ( CurrentAug.bHasIt )
							TotalCannisters.CloakRadarTrans -= 1;
					}
					else if ( ( CurrentAug.IsA('HXAugBallistic') || CurrentAug.IsA('HXAugEMP') ) && TotalCannisters.BallisticEMP > 0 )
					{
						AugmentationSystem.GivePlayerAugmentation( CurrentAug.Class );

						if ( CurrentAug.bHasIt )
							TotalCannisters.BallisticEMP -= 1;
					}
					else if ( ( CurrentAug.IsA('HXAugEnviro') || CurrentAug.IsA('HXAugAqualung') ) && TotalCannisters.EnviroAqualung > 0 )
					{
						AugmentationSystem.GivePlayerAugmentation( CurrentAug.Class );

						if ( CurrentAug.bHasIt )
							TotalCannisters.EnviroAqualung -= 1;
					}
					else if ( ( CurrentAug.IsA('HXAugHealing') || CurrentAug.IsA('HXAugShield') ) && TotalCannisters.HealingShield > 0 )
					{
						AugmentationSystem.GivePlayerAugmentation( CurrentAug.Class );

						if ( CurrentAug.bHasIt )
							TotalCannisters.HealingShield -= 1;
					}
					else if ( ( CurrentAug.IsA('HXAugPower') || CurrentAug.IsA('HXAugHeartLung') ) && TotalCannisters.PowerHeartLung > 0 )
					{
						AugmentationSystem.GivePlayerAugmentation( CurrentAug.Class );

						if ( CurrentAug.bHasIt )
							TotalCannisters.PowerHeartLung -= 1;
					}
				
				}
			}
		}
	}
}

// ----------------------------------------------------------------------
// GrantAugUpgrades()
//
// Grants aug upgrades in order of priority.
// ----------------------------------------------------------------------

function GrantAugUpgrades( int NumAugUpgrades )
{
	local int RemainingAugs, Pass, PrefIndex;
	local Augmentation PreferredAugs[9];
	local Augmentation CurrentAug;

	if (Role < ROLE_Authority)
		return;

	//Log( Self $ ".GrantAugUpgrades( " $ NumAugUpgrades $ " )" );

	// Cache preferred augs
	for ( PrefIndex = 0; PrefIndex < ArrayCount(AugPrefs); PrefIndex++ )
		if ( AugPrefs[PrefIndex] != '' )
			for ( CurrentAug = AugmentationSystem.FirstAug; CurrentAug != None; CurrentAug = CurrentAug.next )
				if ( CurrentAug.Class.Name == AugPrefs[PrefIndex] && CurrentAug.bHasIt )	
					PreferredAugs[PrefIndex] = CurrentAug;

	RemainingAugs = NumAugUpgrades;

	// 0..-2 are 3 passes, so even priority zero augs get up to three upgrades
	for ( Pass = 26; Pass > -3 && RemainingAugs > 0; Pass-- )
	{
		for ( PrefIndex = 0; PrefIndex < ArrayCount(AugPrefs) && PrefIndex < ArrayCount(AugUpPrefs); PrefIndex++ )
		{
			if ( AugUpPrefs[PrefIndex] >= Pass && PreferredAugs[PrefIndex] != None )
			{
				if ( RemainingAugs == 0 )
					break;

				if ( PreferredAugs[PrefIndex].CurrentLevel < PreferredAugs[PrefIndex].MaxLevel )
				{
					if ( PreferredAugs[PrefIndex].bIsActive )
								PreferredAugs[PrefIndex].Deactivate();

					// Upgrade.
					PreferredAugs[PrefIndex].CurrentLevel++;
					RemainingAugs--;
				}
				else
				{
					// Remove from list.
					PreferredAugs[PrefIndex] = None;
				}
			}
		}
	}
}

// ----------------------------------------------------------------------
// event HeadZoneChange
// ----------------------------------------------------------------------

event HeadZoneChange(ZoneInfo newHeadZone)
{
	local float mult, augLevel;
	
	// hack to get the zone's ambientsound working until Tim fixes it
	if (newHeadZone.AmbientSound != None)
		newHeadZone.SoundRadius = 255;
	if (HeadRegion.Zone.AmbientSound != None)
		HeadRegion.Zone.SoundRadius = 0;

	if (newHeadZone.bWaterZone && !HeadRegion.Zone.bWaterZone)
	{
		// make sure we're not crouching when we start swimming
		bIsCrouching = False;
		bCrouchOn = False;
		bWasCrouchOn = False;
		bDuck = 0;
		lastbDuck = 0;
		Velocity = vect(0,0,0);
		Acceleration = vect(0,0,0);

		// HX_NOTE: fix spawning in water:
		if ( SkillSystem!=None )
			mult = SkillSystem.GetSkillLevelValue(class'HXSkillSwimming');
		else
			mult = 1.0; // default value

		DiveDuration = UnderWaterTime * mult;
		DiveTimer = DiveDuration;

		// 0.5 is a heuristic value measured with a stopwatch.
		if ( Level.NetMode==NM_Standalone )
			WaterSpeed = Default.WaterSpeed * mult;
		else
			WaterSpeed = Default.WaterSpeed * mult * 0.5;
	}

	Super(PlayerPawnExt).HeadZoneChange(newHeadZone);
}

// ----------------------------------------------------------------------
// RestoreScopeView()
// ----------------------------------------------------------------------

function RestoreScopeView()
{
	if (inHand != None)
	{
		if (inHand.IsA('HXBinoculars') && (inHand.bActive))
			HXBinoculars(inHand).RefreshScopeDisplay(Self, True);
		else if ((HXWeapon(inHand) != None) && (HXWeapon(inHand).bZoomed))
			HXWeapon(inHand).RefreshScopeDisplay(Self, True, True);
	}
}

// ----------------------------------------------------------------------
// ClientActivateScopeView()
// ----------------------------------------------------------------------

function ClientActivateScopeView(int newFOV, bool bNewBinocs, bool bInstant)
{
	HXRootWindow(rootWindow).scopeView.ActivateView( newFOV, bNewBinocs, bInstant );
}

// ----------------------------------------------------------------------
// ClientDeactivateScopeView()
// ----------------------------------------------------------------------

function ClientDeactivateScopeView()
{
	HXRootWindow(rootWindow).scopeView.DeactivateView();
}

// ----------------------------------------------------------------------
// RefreshChargedPickups()
// ----------------------------------------------------------------------

function RefreshChargedPickups()
{
	local HXChargedPickup anItem;

	// Loop through all the ChargedPicksups and look for charged pickups
	// that are active.  If we find one, add to the user-interface.

	foreach AllActors(class'HXChargedPickup', anItem)
	{
		if ((anItem.Owner == Self) && (anItem.IsActive()))
		{
			// Make sure tech goggles display is refreshed
			if (anItem.IsA('HXTechGoggles'))
				HXTechGoggles(anItem).UpdateHUDDisplay(Self);

			HXAddChargedDisplay(anItem);
		}
	}
}


// ----------------------------------------------------------------------
// ClientTechGogglesChargedPickupBegin()
// ----------------------------------------------------------------------

function ClientTechGogglesChargedPickupBegin()
{
	HXRootWindow(rootWindow).hud.augDisplay.activeCount++;

	//if ((HXRootWindow(rootWindow).hud.augDisplay.activeCount == 0) && (IsActive()))
		//HXRootWindow(rootWindow).hud.augDisplay.activeCount++;
	
	HXRootWindow(rootWindow).hud.augDisplay.bVisionActive = True;
	HXRootWindow(rootWindow).hud.augDisplay.visionLevel = 0;
	HXRootWindow(rootWindow).hud.augDisplay.visionLevelValue = 0;
}


// ----------------------------------------------------------------------
// ClientTechGogglesChargedPickupEnd()
// ----------------------------------------------------------------------

function ClientTechGogglesChargedPickupEnd()
{
	if (--HXRootWindow(rootWindow).hud.augDisplay.activeCount == 0)
		HXRootWindow(rootWindow).hud.augDisplay.bVisionActive = False;	
}

// ----------------------------------------------------------------------
// ClientUpdatePersonaStatusLineWindow()
// ----------------------------------------------------------------------

function ClientUpdatePersonaStatusLineWindow( string newText )
{
	local HXPersonaScreenBaseWindow PersonaTopWindow;

	if ( !PlayerIsClient() )
		return;

	if ( HXRootWindow(rootWindow) != None )
	{
		PersonaTopWindow = HXPersonaScreenBaseWindow( HXRootWindow(rootWindow).GetTopWindow() );
	
		if ( PersonaTopWindow != None && PersonaTopWindow.winStatus != None )
			PersonaTopWindow.winStatus.AddText( newText );
	}
}

// ----------------------------------------------------------------------
// ClientUpdatePersonaScreenInventoryAmmoSelected()
// ----------------------------------------------------------------------

function ClientUpdatePersonaScreenInventoryAmmoSelected( class WeaponClass, class NewAmmoClass )
{
	local HXPersonaScreenInventory InvWin;

	if ( !PlayerIsClient() )
		return;

	if ( HXRootWindow(rootWindow) != None )
	{
		InvWin = HXPersonaScreenInventory( HXRootWindow(rootWindow).GetTopWindow() );

		if ( InvWin != None )
			InvWin.UpdateAmmoSelected( WeaponClass, NewAmmoClass );
	}
}

// ----------------------------------------------------------------------
// ClientJoltView()
// ----------------------------------------------------------------------

function ClientJoltView( float NewJoltMagnitude )
{
	if ( Abs(JoltMagnitude)<Abs(NewJoltMagnitude) )
		JoltMagnitude = NewJoltMagnitude;
}

// ----------------------------------------------------------------------
// AddAugmentationDisplay()
// ----------------------------------------------------------------------

function AddAugmentationDisplay( Augmentation Aug )
{
	local HXRootWindow Root;
	
	Aug  = HXAugmentation(Aug);
	Root = HXRootWindow(RootWindow);

	if ( Root!=None && Aug!=None )
		Root.AddAugmentationDisplay( Aug );
}

// ----------------------------------------------------------------------
// RemoveAugmentationDisplay()
// ----------------------------------------------------------------------

function RemoveAugmentationDisplay( Augmentation Aug )
{
	local HXRootWindow Root;
	
	Aug  = HXAugmentation(Aug);
	Root = HXRootWindow(RootWindow);

	if ( Root!=None && Aug!=None )
		Root.RemoveAugmentationDisplay( Aug );
}

// ----------------------------------------------------------------------
// ClearAugmentationDisplay()
// ----------------------------------------------------------------------

function ClearAugmentationDisplay()
{
	local HXRootWindow Root;
	
	Root = HXRootWindow(RootWindow);
	if ( Root!=None )
		Root.ClearAugmentationDisplay();
}

// ----------------------------------------------------------------------
// UpdateAugmentationDisplayStatus()
// ----------------------------------------------------------------------

function UpdateAugmentationDisplayStatus( Augmentation Aug )
{
	local HXRootWindow Root;
	
	Aug  = HXAugmentation(Aug);
	Root = HXRootWindow(RootWindow);

	if ( Root!=None && Aug!=None )
		Root.UpdateAugmentationDisplayStatus( Aug );
}

// ----------------------------------------------------------------------
// HXAddChargedDisplay()
// ----------------------------------------------------------------------

function HXAddChargedDisplay( HXChargedPickup Item )
{
	local HXRootWindow Root;

	Root = HXRootWindow(RootWindow);
	if ( Root!=None )
		//if ( PlayerIsClient() || Level.NetMode==NM_Standalone )
			Root.AddChargedDisplay( Item );
}

// ----------------------------------------------------------------------
// HXRemoveChargedDisplay()
// ----------------------------------------------------------------------

function HXRemoveChargedDisplay( HXChargedPickup Item )
{
	local HXRootWindow Root;

	Root = HXRootWindow(RootWindow);
	if ( Root!=None )
		//if ( PlayerIsClient() || Level.NetMode==NM_Standalone )
			Root.RemoveChargedDisplay( Item );
}

// ----------------------------------------------------------------------
// ClientAddReceivedItemDisplay()
//
// TODO: Rework. Make this clientside variables beeing monitored by ui
//       code.
// ----------------------------------------------------------------------

function ClientAddReceivedItemDisplay( class<Inventory> InventoryClass, int Count, optional bool bClearFirst )
{
	local HUDReceivedDisplay rd;
	local HUDReceivedDisplayItem item;
	local String labelText;

	//Log( Self $ ".ClientAddReceivedItemDisplay( "$ InventoryClass $ ", " $ Count $ ", " $ bClearFirst $ " ) called." );

	rd = HXRootWindow(rootWindow).hud.receivedItems;
	
	if ( bClearFirst )
		rd.RemoveItems();

	if ( InventoryClass != None )
	{
		item = HUDReceivedDisplayItem(rd.winTile.NewChild(Class'HUDReceivedDisplayItem'));

		// SetItem()
		item.winIcon = item.NewChild(Class'Window');
		item.winIcon.SetSize(42, 37);
		item.winIcon.SetBackgroundStyle(DSTY_Masked);
		item.winIcon.SetBackground(InventoryClass.default.Icon);

		item.winLabel = TextWindow(item.NewChild(Class'TextWindow'));
		item.winLabel.SetFont(item.fontLabel);
		item.winLabel.SetTextColor(item.colText);
		item.winLabel.SetTextAlignments(HALIGN_Center, VALIGN_Top);

		labelText = InventoryClass.default.beltDescription;

		if (Count > 1)
			labelText = labelText $ " (" $ String(count) $ ")";

		item.winLabel.SetText(labelText);

		rd.displayTimer = 0.0;
		rd.Show();
		rd.bTickEnabled = True;
		rd.AskParentForReconfigure();
	}
}


// ----------------------------------------------------------------------
// ActivateKeypadWindow()
// DEUS_EX AMSD Has to be here because player doesn't own keypad, so
// func rep doesn't work right.
// ----------------------------------------------------------------------
function HXActivateKeypadWindow(HXKeypad KPad, bool bHacked)
{
   KPad.ActivateKeypadWindow(Self, bHacked);
}

function HXKeypadRunUntriggers(HXKeypad KPad)
{
   KPad.RunUntriggers(Self);
}

function HXKeypadRunEvents(HXKeypad KPad, bool bSuccess)
{
   KPad.RunEvents(Self, bSuccess);
}

function HXKeypadToggleLocks(HXKeypad KPad)
{
   KPad.ToggleLocks(Self);
}

//server->client (computer to frobber)
function HXInvokeComputerScreen(HXComputers computerToActivate, float CompHackTime, float ServerLevelTime)
{
	local HXNetworkTerminal termwindow;
	local HXRootWindow root;

	computerToActivate.LastHackTime = CompHackTime + (Level.TimeSeconds - ServerLevelTime);

	HXActiveComputer = ComputerToActivate;

	//only allow for clients or standalone
	if ((Level.NetMode != NM_Standalone) && (!PlayerIsClient()))
	{
		HXActiveComputer = None;
		HXCloseComputerScreen(computerToActivate);
		return;
	}

	root = HXRootWindow(rootWindow);
	if (root != None)
	{
		termwindow = HXNetworkTerminal(root.InvokeUIScreen(computerToActivate.terminalType, True));
		if (termwindow != None)
		{
			computerToActivate.termwindow = termwindow;
			termWindow.SetCompOwner(computerToActivate);
			// If multiplayer, start hacking if there are no users
			//if ((Level.NetMode != NM_Standalone) && (!termWindow.bHacked) && (computerToActivate.NumUsers() == 0) && 
			//(termWindow.winHack != None) && (termWindow.winHack.btnHack != None))
			//{
				//termWindow.winHack.StartHack();
				//termWindow.winHack.btnHack.SetSensitivity(False);
				//termWindow.FirstScreen=None;
			//}
			termWindow.ShowFirstScreen();
		}
	}
	if ((termWindow == None)  || (root == None))
	{
		HXCloseComputerScreen(computerToActivate);
		HXActiveComputer = None;
	}
}


// CloseThisComputer is for the client (used at the end of a mp match)

function HXCloseThisComputer( HXComputers comp )
{
	if ((comp != None) && ( comp.termwindow != None ))
		comp.termwindow.CloseScreen("EXIT");
}

//client->server (window to player)
function HXCloseComputerScreen(HXComputers computerToClose)
{
	computerToClose.CloseOut();
}

//client->server (window to player)
function HXSetComputerHackTime(HXComputers computerToSet, float HackTime, float ClientLevelTime)
{
	computerToSet.lastHackTime = HackTime + (Level.TimeSeconds - ClientLevelTime);
}

//client->server (window to player)
function HXUpdateCameraRotation(HXSecurityCamera camera, Rotator rot)
{
	camera.DesiredRotation = rot;
}

//client->server (window to player)
function HXToggleCameraState(HXSecurityCamera cam, HXElectronicDevices compOwner)
{
   if (cam.bActive)
   {
      cam.UnTrigger(compOwner, self);	
      //cam.team = -1;
   }
   else            
   {
      //HXMakeCameraAlly(cam);
      cam.Trigger(compOwner, self);
   }
         
   // Make sure the camera isn't in bStasis=True
   // so it responds to our every whim.
   cam.bStasis = False;         
}

//client->server (window to player)
function HXSetTurretState( HXDecoration Turret, bool bActive, bool bDisabled )
{
	// Avoid hardcoding.
	Turret.SetPropertyText( "bActive",        String(bActive)   );
	Turret.SetPropertyText( "bDisabled",      String(bDisabled) );
	Turret.SetPropertyText( "bComputerReset", String(False)     );
}

//client->server (window to player)
function HXSetTurretTrackMode( HXDecoration Computer, HXDecoration Turret, bool bTrackPlayers, bool bTrackPawns )
{
	// Avoid hardcoding.
	Turret.SetPropertyText( "bTrackPlayersOnly", String(bTrackPlayers) );
	Turret.SetPropertyText( "bTrackPawnsOnly",   String(bTrackPawns)   );
	Turret.SetPropertyText( "bComputerReset",    String(False)         );
}

//client->server (window to player)
function TakeHackDetectedDamage()
{
	// Shock the crap out of the player (drain BE and play a sound)
	// Highly skilled players take less damage
	TakeDamage( 200 - 50 * SkillSystem.GetSkillLevel(Class'HXSkillComputer'), None, vect(0,0,0), vect(0,0,0), 'EMP' );	
	PlaySound( Sound'ProdFire' );
}

//client->server (window to player)
function WithdrawCreditsAndModBalance( HXATM ATM, int UserIndex, int NumCredits, bool bSync, float Ratio )
{
	local float BalanceModifier;
	local int Balance;

	// Sanity checks.
	if ( ATM==None )
	{
		Warn( "ATM is None" );
		return;
	}
	if ( NumCredits<=0 )
	{
		Log( Self $ " tried to withdraw negative amout of credits." );
		return;
	}

	// Verify request.
	// Notes:
	//  * 0.5 is hardcoded in window code too.
	//  * GetBalance() handles hacking, so mod is not applied to non hacked withdrawel.
	BalanceModifier = SkillSystem.GetSkillLevel(Class'HXSkillComputer') * 0.5;
	Balance = ATM.GetBalance( UserIndex, BalanceModifier );

	if ( Balance<NumCredits )
	{
		if ( Balance>0 )
		{
			ClientMessage( ATMLessCreditsAvailable );
			NumCredits = Balance;
		}
		else
		{
			ClientMessage( ATMAccountEmpty );
			return;
		}
	}

	ATM.ModBalance( UserIndex, NumCredits, bSync, BalanceModifier * Ratio );
	Credits += NumCredits;
	UpdateClientCredits( Credits );
}

//server->client
function UpdateClientCredits( int NewCredits )
{
	Credits				= NewCredits;
	ClientCredits	= NewCredits;
}

// ----------------------------------------------------------------------
// Multiplayer ScriptedPawn functions
// ----------------------------------------------------------------------

//server->client (repbot to frobber)
function InvokeRepairBot(HXRepairBot repairBotToActivate, float lastChargeTime, float ServerLevelTime)
{
	local HXHUDRechargeWindow chargewin;
	local HXRootWindow root;

	repairBotToActivate.lastChargeTime = lastChargeTime + (Level.TimeSeconds - ServerLevelTime);

	//Log("Called " $ Self $ ".InvokeRepairBot( "$ repairBotToActivate $" )");

	ActivePawn = repairBotToActivate;

	//only allow for clients or standalone
	if ((Level.NetMode != NM_Standalone) && (!PlayerIsClient()))
	{
		ActivePawn = None;
		ClosePawn(repairBotToActivate);
		return;
	}

	root = HXRootWindow(rootWindow);

	if (root != None)
	{
		chargewin = HXHUDRechargeWindow(root.InvokeUIScreen(Class'HXHUDRechargeWindow', True));

		if (chargewin != None)
		{
			//repairBotToActivate.RechargeWindow = chargewin;
			chargewin.SetRepairBot(repairBotToActivate);
			root.MaskBackground( True );
		}
	}
	if ((chargewin == None)  || (root == None))
	{
		ClosePawn(repairBotToActivate);
		ActivePawn = None;
	}
}

//server->client (medbot to frobber)
function InvokeMedicalBot(HXMedicalBot medBotToActivate, float lastHealTime, float ServerLevelTime)
{
	local HXPersonaScreenBaseWindow PersonaScreen;
	local HXAugmentationCannister augCan;
	local HXRootWindow root;

	medBotToActivate.lastHealTime = lastHealTime + (Level.TimeSeconds - ServerLevelTime);

	//Log("Called " $ Self $ ".InvokeMedicalBot( "$ medBotToActivate $" )");

	ActivePawn = medBotToActivate;

	//only allow for clients or standalone
	if ((Level.NetMode != NM_Standalone) && (!PlayerIsClient()))
	{
		ActivePawn = None;
		ClosePawn(medBotToActivate);
		return;
	}

	root = HXRootWindow(rootWindow);

	if (root != None)
	{
		augCan = HXAugmentationCannister(FindInventoryType(Class'HXAugmentationCannister'));

		if (augCan != None)
		{
			PersonaScreen = HXPersonaScreenBaseWindow(root.InvokeUIScreen(Class'HXPersonaScreenAugmentationsMedBot', True));

			if (PersonaScreen != None)
			{
				//medBotToActivate.PersonaScreen = PersonaScreen;
				HXPersonaScreenAugmentationsMedBot(PersonaScreen).SetMedicalBot(medBotToActivate);
				root.MaskBackground( True );
			}
		}
		else
		{
			PersonaScreen = HXPersonaScreenBaseWindow(root.InvokeUIScreen(Class'HXPersonaScreenHealthMedBot', True));

			if (PersonaScreen != None)
			{
				//medBotToActivate.PersonaScreen = PersonaScreen;
				HXPersonaScreenHealthMedBot(PersonaScreen).SetMedicalBot(medBotToActivate);
				root.MaskBackground( True );
			}
		}
	}
	if ((PersonaScreen == None)  || (root == None))
	{
		ClosePawn(medBotToActivate);
		ActivePawn = None;
	}
}

//server->client (player to client)
function SetRepairBotChargeTime(HXRepairBot repairBotToSet, float ChargeTime, float ServerLevelTime)
{
	repairBotToSet.lastChargeTime = ChargeTime + (Level.TimeSeconds - ServerLevelTime);
}

//server->client (player to client)
function SetMedicalBotHealTime(HXMedicalBot medBotToSet, float HealTime, float ServerLevelTime)
{
	medBotToSet.lastHealTime = HealTime + (Level.TimeSeconds - ServerLevelTime);
}

// CloseThisPawn is for the client (used at the end of a mp match)
function CloseThisPawn(HXScriptedPawn Pawn)
{
	//Log("Called " $ Self $ ".CloseThisPawn( "$ Pawn $" )");

	if ( Pawn != None )
	{
		if ( Pawn.isA('HXMedicalBot') )
		{
			//if (HXMedicalBot(Pawn).PersonaScreen != None)
				//HXMedicalBot(Pawn).PersonaScreen.Destroy();
		}
		else if ( Pawn.isA('HXRepairBot') )
		{
			//if (HXRepairBot(Pawn).RechargeWindow != None)
				//HXRepairBot(Pawn).RechargeWindow.Destroy();		
		}
	}
}

//client->server (window to player)
function ClosePawn(HXScriptedPawn pawnToClose)
{
	//Log("Called " $ Self $ ".ClosePawn( "$ pawnToClose $" )");

	pawnToClose.CloseOut();
}

//client->server (window to player)
function RepairBotChargePlayer(HXRepairBot RepairBot)
{
	if ( RepairBot.ChargePlayer(Self) != 0)
		RepairBot.PlayAnim('Clamp'); // play a cool animation
}


//client->server (window to player)
function MedicalBotHealPlayer(HXMedicalBot MedBot)
{
	MedBot.HealPlayer(self);
}

// ----------------------------------------------------------------------
// Destroyed()
// ----------------------------------------------------------------------

simulated event Destroyed()
{
	local Inventory Inv;
	local Pawn OtherPawn;

	//Log( Self $ ".Destroyed() called." );

	// Does some cleanup. This prevents the game from crashing if you are in inventory screen
	// in windowed mode and just close the game window.
	/*if ( HXRootWindow(RootWindow)!=None ) // Took this out again as this can cause regressions --han
		HXRootWindow(RootWindow).ClearWindowStackNoUnPauseGame();*/

	if ( GlobalDebugObj!=None )
		CriticalDelete( GlobalDebugObj );

	if ( Level.NetMode==NM_Standalone || PlayerIsClient() )
		ClearAugmentationDisplay();

	if ( Shadow!=None )
		Shadow.Destroy();

	RemovePawn();

	if ( myHud!=None )
		myHud.Destroy();
	if ( Scoring!=None )
		Scoring.Destroy();

	while ( FreeMoves!=None )
	{
		FreeMoves.Destroy();
		FreeMoves = FreeMoves.NextMove;
	}

	while ( SavedMoves!=None )
	{
		SavedMoves.Destroy();
		SavedMoves = SavedMoves.NextMove;
	}

	if ( Role<ROLE_Authority )
		return;

	PutInHand( None );

	// Force Decoration Drop.. ugly.. and probably buggy.. but...
	if ( CarriedDecoration!=None )
	{
		CarriedDecoration.bWasCarried = True;
		CarriedDecoration.SetBase( None );
		CarriedDecoration.SetPhysics( PHYS_Falling );

		//CarriedDecoration.Instigator = ExitingPlayer;
		CarriedDecoration.Instigator = None;

		// turn off translucency
		CarriedDecoration.Style = CarriedDecoration.Default.Style;
		CarriedDecoration.bUnlit = CarriedDecoration.Default.bUnlit;

		if ( CarriedDecoration.IsA('DeusExDecoration') )
			DeusExDecoration(CarriedDecoration).ResetScaleGlow();

		CarriedDecoration = None;
	}

	if ( HXAugmentationManager(AugmentationSystem)!=None )
		HXAugmentationManager(AugmentationSystem).ForceDeactivateAll();

	// TODO: maybe remove all augs, etc.

	Weapon = None;
	PendingWeapon = None;

	if ( bIsPlayer && Level.Game!=None )
		Level.Game.Logout( Self );

	for ( OtherPawn=Level.PawnList; OtherPawn!=None; OtherPawn=OtherPawn.NextPawn )
		OtherPawn.Killed( None, Self, '' );

	// Null out references (might fix crash issues)
	//if ( Level.NetMode == NM_ListenServer )
	//PreExportClean();

	// Now save player
	ExportTravel();

	// Remove inventory.
	for( Inv=Inventory; Inv!=None; Inv=Inv.Inventory ) 
		Inv.Destroy();
	Inventory = None;

	if ( PlayerReplicationInfo!=None )
		PlayerReplicationInfo.Destroy();

	Super(Actor).Destroyed();
}

// ----------------------------------------------------------------------
// SpawnCarcass()
//
// Copied from Engine.PlayerPawn, modified to let carcasses
// have inventories.
// ----------------------------------------------------------------------

function Carcass SpawnCarcass()
{
	local Inventory Item, NextItem, LastItem;
	local HXCarcass Carcass;
	local Vector AdjustedLocation;

	// Don't spawn a carcass if we've been gibbed.
	if ( Health<-80 ) // !! FIX-ME !! This should be handled by the callee --han
		return None;

	Carcass = HXCarcass( Spawn(CarcassType) );
	if ( Carcass==None )
		return None;

	// Move it down to the ground.
	AdjustedLocation    = Location;
	AdjustedLocation.z += Carcass.CollisionHeight - CollisionHeight;
	Carcass.SetLocation( AdjustedLocation );
	
	// Setup ItemName, pose, etc.
	Carcass.bPlayerCarcass = true;
	Carcass.InitFor( Self );

	MoveTarget = Carcass; // For Player 3rd person views (broken?).

	// Give the carcass the player's inventory.
	if ( Inventory!=None )
	{
		Item     = Inventory;
		NextItem = Item.Inventory;
		LastItem = Item; // Circular Inventory list shenanigans? --han

		do
		{
			if ( Item!=None )
			{
				// Ammo.
				if ( Item.IsA('HXAmmo') )
				{
					// Only add non empty non weirdo Ammo.
					if ( HXAmmo(Item).AmmoAmount>0 && Item.Class!=Class'HXAmmoNone' ) // Do I need to check for further special ammunition?
					{
						DeleteInventory( Item );
						Carcass.AddInventory( Item );
					}
				}
				// bDisplayableInv masks out POVCorpse, NanoKeyRing, etc.
				else if ( Item.bDisplayableInv )
				{
					// Weapons.
					if ( Item.IsA('HXWeapon'))
					{
						// Make sure everything is turned off !! Figure out a better way to do this! --han
						HXWeapon(Item).ScopeOff();
						HXWeapon(Item).LaserOff();

						// Remove any Ammo, as we pick up Ammo seperate.
						HXWeapon(Item).PickupAmmoCount = 0;

						DeleteInventory( Item );
						Carcass.AddInventory( Item );
					}
					// Pickups.
					else if ( Item.IsA('HXPickup') )
					{
						// This should be somehow fixed to reduce the count.
						if ( HXPickup(Item).bActive )
							HXPickup(Item).Activate();

   					if ( Item.IsA('HXChargedPickup') )
						{
							HXRemoveChargedDisplay(HXChargedPickup(Item));

							// Remove charged items which are not at full charge.
							if ( Item.Charge!=Item.Default.Charge ) // Does this really have to be destroyed here? --han
							{
								DeleteInventory( Item );
								Item.Destroy();
							}
							else
							{
								DeleteInventory( Item );
								Carcass.AddInventory( Item );
							}
						}
						// Ordinary Pickup.
						else
						{
							DeleteInventory( Item );
							Carcass.AddInventory( Item );
						}
					}
				}
			}

			Item = NextItem;
			if ( Item!=None )
				NextItem = Item.Inventory;
		}
		until ( Item==None || Item==LastItem );
		if ( Item==LastItem )
			Warn( "Circular inventory loop detected while spawning carcass for"@Self );
	}

	return Carcass;
}

// ----------------------------------------------------------------------
// IsHighlighted()
//
// checks to see if we should highlight this actor
// ----------------------------------------------------------------------

function bool IsHighlighted( Actor Actor )
{
	local DeusExDecoration DeusExDecoration;
	local DeusExMover DeusExMover;
	local HXThrownProjectile ThrownProjectile;
	local HXProjectile Projectile;
	local HXDecoration Decoration;
	local HXScriptedPawn ScriptedPawn;
	local HXCarcass Carcass;
	local HXMover Mover;

	if ( bBehindView || Actor==None || Actor.bDeleteMe || Actor.bHidden )
		return False;

	// Pawns.
	if ( Actor.bIsPawn )
	{
		// Highlight all Players.
		if ( Actor.IsA('HXPlayerPawn') )
		{
			return True;
		}
		// For other Pawns respect the setting.
		else if ( !bNPCHighlighting )
		{
			return False;
		}
		else
		{
			ScriptedPawn = HXScriptedPawn(Actor);
			if ( ScriptedPawn!=None )
				return ScriptedPawn.bHighlight; // Is False for Fishes, Flies, etc.
			else
				return False;
		}
	}
	// Movers.
	else if ( Actor.bIsMover )
	{
		Mover = HXMover(Actor);
		if ( Mover!=None )
			return Mover.bHighlight;
		//DeusExMover = DeusExMover(Actor)
		//if ( DeusExMover!=None )
			//return DeusExMover.bHighlight;

		// Don't highlight other Movers.
		return False;
	}
	// Inventory.
	else if ( Actor.IsA('Inventory') )
	{
		return True;
	}
	// Decorations including Carcasses.
	else if ( Actor.IsA('Decoration') )
	{
		// Nearly all Decorations are HXDecorations, so handle them first.
		Decoration = HXDecoration(Actor);
		if ( Decoration!=None )
			return Decoration.bClientHighlight;

		// There are still some bStatic/bNoDelete non HXDecorations around,
		// mostly because they have some light/color settings applied which does
		// not always get replicated over network, which results in trees changing
		// brightness the next time you look at them.
		DeusExDecoration = DeusExDecoration(Actor);
		if ( DeusExDecoration!=None )
			return DeusExDecoration.bHighlight;

		// Carcasses.
		Carcass = HXCarcass(Actor);
		if ( Carcass!=None )
			return Carcass.bHighlight;

		// Don't highlight everything else (Should not happen).
		return False;
	}
	else
	{
		// Projectiles.
		Projectile = HXProjectile(Actor);
		if ( Projectile!=None )
			return Projectile.bHighlight;
		//{
			//ThrownProjectile = HXThrownProjectile(Projectile);
			//if ( ThrownProjectile!=None )
				//return ThrownProjectile.bHighlight;
			//return Projectile.bStuck;
		//}
	}

	// Ugly fallback for all other stuff like Inventory.
	return True;
}

// ----------------------------------------------------------------------
// IsFrobbable() -- is this actor frobbable?
//
// Notes:
//  * Should probably be (partially) merged with IsHighlighted.
//  * Trash is a Decoration and due to it's small size will easily
//    rule out other objects in HighlightCenterObject(). Yet another
//    reason why it should be a Fragment (I opted against adding an
//    IsA() check for it here).
// ----------------------------------------------------------------------

function bool IsFrobbable( Actor Actor )
{
	if ( Actor==None || Actor.bHidden || Actor.bDeleteMe )
		return False;

	// Scripted and PlayerPawns.
	if ( Actor.bIsPawn )
		//return Actor.IsA('HXScriptedPawn') || Pawn(Actor).bIsPlayer;
		return True; // Try this for now.

	// Movers.
	if ( Actor.bIsMover )
		return True;
	
	// Decorations (Note: HXDecorations are for now DeusExDecorations, and
	// there are still some bStatic/bNoDelete DeusExDecorations in the Maps).
	if ( Actor.IsA('Decoration') )
		//return /*Actor.IsA('HXDecoration') ||*/ Actor.IsA('DeusExDecoration') || Actor.IsA('HXCarcass');
		return True; // Try this for now (What is ScaledSprite?).
	
	// Inventory (Note: I'm not sure if I like it that way).
	if ( Actor.IsA('Inventory') )
		return True; 

	// Projectiles.
	if ( Actor.IsA('HXProjectile') )
		return True;

	// Not handled.
	return False;
}

// ----------------------------------------------------------------------
// HighlightCenterObject()
//
// checks to see if an object can be frobbed, if so, then highlight it
// ----------------------------------------------------------------------

function HighlightCenterObject()
{
	local Actor Target, SmallestTarget;
	local Vector HitLoc, HitNormal, StartTrace, EndTrace;
	local float ReducedMinVolume, ReducedTempVolume; // Volume/(2PI).
	local bool bFirstTarget;

	// Needed for TraceTextures.
	local Texture HitTexture;
	local Name TextureName, TextureGroup;
	local int TextureFlags;


	FrobTime = 1.0;
	Super(DeusExPlayer).HighlightCenterObject();
	return;



	if ( IsInState('Dying') )
		return;

	// Before code was rune just about every 100ms, which is rather slow
	// when it comes to input related code. Also Deus Ex does an awful
	// amount of Traces, AllActors, etc. each Tick, so doing this trace
	// just about each 100ms was a bad tradeoff. Do this now each PlayerTick().

	// Figure out how far ahead we should trace.
	StartTrace = Location;
	EndTrace   = Location + (Vector(ViewRotation) * MaxFrobDistance);

	// adjust for the eye height
	StartTrace.Z += BaseEyeHeight;
	EndTrace.Z   += BaseEyeHeight;

	SmallestTarget   = None;
	ReducedMinVolume = 9999999999999.9;
	bFirstTarget     = True;

	// Find the object that we are looking at
	// make sure we don't select the object that we're carrying
	// use the last traced object as the target...this will handle
	// smaller items under larger items for example
	// ScriptedPawns always have precedence, though
	//foreach TraceActors( Class'Actor', Target, HitLoc, HitNormal, EndTrace, StartTrace )
	foreach TraceTextures( Class'Actor', Target, HitTexture, TextureName, TextureGroup, TextureFlags, HitLoc, HitNormal, EndTrace, StartTrace )
	{
		//Log( "Target=" $ Target, 'HighlightCenterObject' );

		// Make bsp block frobbing.
		if ( Target==Level )
		{
			//Log( "HitTexture=" $ HitTexture );
			//Log( "TextureFlags=" $ TextureFlags );

			// In 10_Paris_Club some of the vent shafts first hit the Level, but 
			// Have no Texture and no TextureFlags, but I don't know (yet) what
			// is going on here, so this check is more like a hack. However, the 
			// really bad news is that probably other places in code which do use
			// TraceActors/TraceTextures (and maybe MultiLineCheck() based Traces
			// are probably affected too.
			if ( HitTexture!=None && TextureFlags!=0 )
				break;

			continue;
		}

		// Don't frob what we carry.
		if ( Target==CarriedDecoration )
			continue;

		if ( !IsFrobbable(Target) )
			continue;

		// Pawns.
		if ( Target.bIsPawn )
		{
			SmallestTarget = Target;
			break;
		}

		// Movers.
		if ( Target.bIsMover && bFirstTarget )
		{
			SmallestTarget = Target;
			break;
		}

		// Changed the ~Radius to a ~Volume based approach.
		ReducedTempVolume = Target.CollisionRadius*Target.CollisionRadius*Target.CollisionHeight;
		if ( ReducedTempVolume<ReducedMinVolume )
		{
			ReducedMinVolume = ReducedTempVolume;
			SmallestTarget   = Target;
			bFirstTarget     = False;
		}
	}

	FrobTarget = SmallestTarget;
}

// ----------------------------------------------------------------------
// HCO()
// ----------------------------------------------------------------------

exec function HCO()
{
	local Actor Target, SmallestTarget;
	local Vector HitLoc, HitNormal, StartTrace, EndTrace;
	local float ReducedMinVolume, ReducedTempVolume; // Volume/(2PI).
	local bool bFirstTarget;

	// Needed for TraceTextures.
	local Texture HitTexture;
	local Name TextureName, TextureGroup;
	local int TextureFlags;

	// Before code was rune just about every 100ms, which is rather slow
	// when it comes to input related code. Also Deus Ex does an awful
	// amount of Traces, AllActors, etc. each Tick, so doing this trace
	// just about each 100ms was a bad tradeoff. Do this now each PlayerTick().

	// Figure out how far ahead we should trace.
	StartTrace = Location;
	EndTrace   = Location + (Vector(ViewRotation) * MaxFrobDistance);

	// adjust for the eye height
	StartTrace.Z += BaseEyeHeight;
	EndTrace.Z   += BaseEyeHeight;

	SmallestTarget   = None;
	ReducedMinVolume = 9999999999999.9;
	bFirstTarget     = True;

	// Find the object that we are looking at
	// make sure we don't select the object that we're carrying
	// use the last traced object as the target...this will handle
	// smaller items under larger items for example
	// ScriptedPawns always have precedence, though
	foreach TraceActors( Class'Actor', Target, HitLoc, HitNormal, EndTrace, StartTrace )
	//foreach TraceTextures( Class'Actor', Target, HitTexture, TextureName, TextureGroup, TextureFlags, HitLoc, HitNormal, EndTrace, StartTrace )
	{
		ClientMessage( "Target=" $ Target, 'HighlightCenterObject' );

		// Make bsp block frobbing.
		if ( Target==Level )
		{
			Log( "HitTexture=" $ HitTexture );
			Log( "TextureFlags=" $ TextureFlags );

			// In 10_Paris_Club some of the vent shafts first hit the Level, but 
			// Have no Texture and no TextureFlags, but I don't know (yet) what
			// is going on here, so this check is more like a hack. However, the 
			// really bad news is that probably other places in code which do use
			// TraceActors/TraceTextures (and maybe MultiLineCheck() based Traces
			// are probably affected too.
			//if ( HitTexture!=None && TextureFlags!=0 )
			if ( true )
			{
				ClientMessage( "break due to (HitTexture!=None && TextureFlags!=0)" );
				break;
			}

			ClientMessage( "continue due to !(HitTexture!=None && TextureFlags!=0)" );
			continue;
		}

		// Don't frob what we carry.
		if ( Target==CarriedDecoration )
		{
			ClientMessage( "continue due to Target==CarriedDecoration" );
			continue;
		}

		if ( !IsFrobbable(Target) )
		{
			ClientMessage( "continue, due to !IsFrobbable(Target)" );
			continue;
		}

		// Pawns.
		if ( Target.bIsPawn )
		{
			ClientMessage( "break and final SmallestTarget, due to Target.bIsPawn" );
			SmallestTarget = Target;
			break;
		}

		// Movers.
		if ( Target.bIsMover && bFirstTarget )
		{
			ClientMessage( "break and final SmallestTarget, due to (Target.bIsMover && bFirstTarget)" );
			SmallestTarget = Target;
			break;
		}

		// Changed the ~Radius to a ~Volume based approach.
		ReducedTempVolume = Target.CollisionRadius*Target.CollisionRadius*Target.CollisionHeight;
		ClientMessage( "ReducedTempVolume=" $ ReducedTempVolume );
		if ( ReducedTempVolume<ReducedMinVolume )
		{
			ClientMessage( "New SmallestTarget" );

			ReducedMinVolume = ReducedTempVolume;
			SmallestTarget   = Target;
			bFirstTarget     = False;
		}
	}

	ClientMessage( "Final: FrobTarget=" $ FrobTarget );
}

// ----------------------------------------------------------------------
// ParseLeftClick()
// ----------------------------------------------------------------------

exec function ParseLeftClick()
{
	local HXPickup InHandPickup;

	//
	// ParseLeftClick deals with things in your HAND
	//
	// Precedence:
	// - Detonate spy drone
	// - Fire (handled automatically by user.ini bindings)
	// - Use inHand
	//

	if ( Level.NetMode==NM_Client )
		return;

	// if the spy drone augmentation is active, blow it up
	if (bSpyDroneActive)
	{
		DroneExplode();
		return;
	}

	if ( bInHandTransition || InHand==None )
		return;

	// I should probably be updating my FrobTarget right now,
	// or at least do some validation on it...

	InHandPickup = HXPickup(InHand);

	// Activateable Item.
	if ( InHand.bActivatable )
	{
		if ( InHandPickup!=None )
			InHandPickup.ActivateOn( FrobTarget );
		else
			InHand.Activate();
		return;
	}

	if (FrobTarget != None)
	{
		// special case for using keys or lockpicks on doors
		if (FrobTarget.IsA('HXMover') || FrobTarget.IsA('DeusExMover'))
			if (inHand.IsA('HXNanoKeyRing') || inHand.IsA('HXLockpick'))
				DoFrob(Self, inHand);

		// special case for using multitools on hackable things
		if ( FrobTarget.IsA('HXHackableDevices') && InHand.IsA('HXMultitool') )
		{
			DoFrob(Self, inHand);
		}

		return;
	}
}

// ----------------------------------------------------------------------
// ParseRightClick()
// ----------------------------------------------------------------------

exec function ParseRightClick()
{
	//
	// ParseRightClick deals with things in the WORLD
	//
	// Precedence:
	// - Pickup highlighted Inventory
	// - Frob highlighted object
	// - Grab highlighted Decoration
	// - Put away (or drop if it's a deco) inHand
	//

	local HXAutoTurret turret;
	local int ViewIndex;
	local bool bPlayerOwnsIt;
  local Inventory oldFirstItem;
	local Inventory oldInHand;
	local Decoration oldCarriedDecoration;
	local Vector loc;

	if ( Level.NetMode==NM_Client )
		return;

	// I should probably be updating my FrobTarget right now,
	// or at least do some validation on it...

  oldFirstItem = Inventory;
	oldInHand = inHand;
	oldCarriedDecoration = CarriedDecoration;

	if (FrobTarget != None)
		loc = FrobTarget.Location;

	if (FrobTarget != None)
	{
		// First check if this is a NanoKey, in which case we just
		// want to add it to the NanoKeyRing without disrupting
		// what the player is holding
		if (FrobTarget.IsA('HXNanoKey'))
		{
			HXGameInfo(Level.Game).PickupNanoKey(HXNanoKey(FrobTarget));
			FrobTarget.Destroy();
			FrobTarget = None;
			return;
		}
		else if (FrobTarget.IsA('Inventory'))
		{
			// If this is an item that can be stacked, check to see if 
			// we already have one, in which case we don't need to 
			// allocate more space in the inventory grid.
			// 
			// TODO: This logic may have to get more involved if/when 
			// we start allowing other types of objects to get stacked.

			//if (HandleItemPickup(FrobTarget, True) == False)
				//return;

			if ( HandleItemPickup( Inventory(FrobTarget)) )
				FrobTarget = None;
			else
				return;

			//Log( "FrobTarget =" @ FrobTarget );
			//if ( FrobTarget != None )
				//Log( "FrobTarget.Owner =" @ FrobTarget.Owner );

			//Log( "Inventory =" @ Inventory );
			//if ( Inventory != None )
				//Log( "Inventory.Owner =" @ Inventory.Owner );

			//Log( "oldFirstItem =" @ oldFirstItem );
			//if ( oldFirstItem != None )
				//Log( "oldFirstItem.Owner =" @ oldFirstItem.Owner );

			// if the frob succeeded, put it in the player's inventory
			//DEUS_EX AMSD ARGH! Because of the way respawning works, the item I pick up
			//is NOT the same as the frobtarget if I do a pickup.  So how do I tell that
			//I've successfully picked it up?  Well, if the first item in my inventory 
			//changed, I picked up a new item.
			//if ( ((Level.NetMode == NM_Standalone) && (Inventory(FrobTarget).Owner == Self)) ||
      //        ((Level.NetMode != NM_Standalone) && (oldFirstItem != Inventory)) )
			//{
				//if (Level.NetMode == NM_Standalone)
					//FindInventorySlot(Inventory(FrobTarget));
				//else
					//FindInventorySlot(Inventory);

				//FrobTarget = None;
			//}


			// HX_INV: change this back, this we won't get a copy anymore
			//if ( Inventory(FrobTarget).Owner == Self )
			//if ( oldFirstItem != Inventory )
			//{
				//FindInventorySlot(Inventory(FrobTarget));
				//FindInventorySlot(Inventory(FrobTarget));

				//FrobTarget = None;
			//}
		}
		else if (FrobTarget.IsA('Decoration'))
		{
			if (Decoration(FrobTarget).bPushable)
			{
				GrabDecoration();
			}
			else if (FrobTarget.IsA('HXInformationDevices'))
			{
				ClientFrobInformationDevices( HXInformationDevices(FrobTarget) );
				DoFrob(Self, None);
			}
			else
			{
				DoFrob(Self, None);
			}
		}
		else
		{
			// otherwise, just frob it
			DoFrob(Self, None);
		}
	}
	else
	{
		// if there's no FrobTarget, put away an inventory item or drop a decoration
		// or drop the corpse
		if ((inHand != None) && inHand.IsA('POVCorpse'))
			DropItem();
		else
			PutInHand(None);
	}

	if ((oldInHand == None) && (inHand != None))
		PlayPickupAnim(loc);
	else if ((oldCarriedDecoration == None) && (CarriedDecoration != None))
		PlayPickupAnim(loc);
}

// ----------------------------------------------------------------------
// DoFrob()
// 
// Frob the target
// ----------------------------------------------------------------------

function DoFrob(Actor Frobber, Inventory frobWith)
{
	local HXRootWindow root;
	local Ammo ammo;
	local Inventory item;
	local Actor A;

	if ( Level.NetMode==NM_Client )
		return;

	if ( FrobTarget==None || FrobTarget.bDeleteMe )
		return;
	
	// make sure nothing is based on us if we're an inventory
	if (FrobTarget.IsA('Inventory'))
		foreach FrobTarget.BasedActors(class'Actor', A)
			A.SetBase(None);

	FrobTarget.Frob(Frobber, frobWith);

	// if the object destroyed itself, get out
	if ( FrobTarget==None || FrobTarget.bDeleteMe )
		return;

	// if the inventory item aborted it's own pickup, get out
	if (FrobTarget.IsA('Inventory') && (FrobTarget.Owner != Self))
		return;

	// alert NPCs that I'm messing with stuff
	if (FrobTarget.bOwned)
		AISendEvent('Futz', EAITYPE_Visual);

	// play an animation
	PlayPickupAnim(FrobTarget.Location);

	// set the base so the inventory follows us around correctly
	if (FrobTarget.IsA('Inventory'))
		FrobTarget.SetBase(Frobber);
}

// ----------------------------------------------------------------------
// PutInHand()
//
// put the object in the player's hand and draw it in front of the player
// ----------------------------------------------------------------------

exec function PutInHand( optional Inventory Item )
{
	if ( Level.NetMode==NM_Client )
		return;

	// This doesn't have to be cheating, will happen through delay as well.
	if ( Item!=None && (Item.bDeleteMe || Item.Owner!=Self) )
		return;

	// can't put anything in hand if you're using a spy drone
	if ((inHand == None) && bSpyDroneActive)
		return;

	// can't do anything if you're carrying a corpse
	if ((inHand != None) && inHand.IsA('POVCorpse'))
		return;

	if ( Item!=None )
	{
		// can't put ammo in hand
		if ( Item.IsA('Ammo') )
			return;

		// Can't put an active charged item in hand
		if ((Item.IsA('HXChargedPickup')) && (HXChargedPickup(Item).IsActive()))
			return;
	}

	if (CarriedDecoration != None)
		DropDecoration();

	SetInHandPending(Item);
}

// ----------------------------------------------------------------------
// UpdateTranslucency()
// DEUS_EX AMSD Try to make the player harder to see if he is in darkness.
// ----------------------------------------------------------------------

function UpdateTranslucency( float DeltaTime )
{
	local HXGameInfo Game;
	//local float DarkVis, CamoVis;
	local bool bMakeTranslucent;

	// Don't do it in singleplayer (What about mirrors?).
	if ( Level.NetMode==NM_Standalone ) 
		return;

	// Weired check for server in the end?
	Game = HXGameInfo(Level.Game);
	if ( Game==None )
		return;

	// Check cloaking.
	if ( AugmentationSystem.GetAugLevelValue(Class'HXAugCloak')!=-1.0 )
	{
		bMakeTranslucent = True;
	}
	// Go through the actor list looking for owned AdaptiveArmor
	// since they aren't in the inventory anymore after they are used.
	else if ( HXUsingChargedPickup(Class'HXAdaptiveArmor') )
	{
		bMakeTranslucent = True;
	}
	else
	{
		bMakeTranslucent = False;
	}

	//Translucent is <0.1, untranslucent if >0.2, not same edge to prevent sharp breaks.
	UpdateTranslucencyDispay( bMakeTranslucent );
}

// ----------------------------------------------------------------------
// UpdateTranslucencyDispay()
//
// Used to change skins on transluence change.
// ----------------------------------------------------------------------

function UpdateTranslucencyDispay( bool bMakeTranslucent )
{
	// Nothing to change.
	if ( bMakeTranslucent==bCloakOn )
		return;

	// Apply effect.
	if ( bMakeTranslucent )
	{
		SetSkinStyle( STY_Translucent, Texture'WhiteStatic', 0.05 );
		KillShadow();
		bCloakOn = True;
	}
	// Remove effect.
	else
	{
		ResetSkinStyle();
		CreateShadow();
		bCloakOn = False;
	}
}

// ----------------------------------------------------------------------------
// GetStyleTexture()
// ----------------------------------------------------------------------------

function Texture GetStyleTexture( ERenderStyle InStyle, texture OriginalTexture, optional Texture ReplacementTexture )
{
	local Texture MaskTexture;

	switch ( InStyle )
	{
		case STY_Translucent:
			MaskTexture = Texture'BlackMaskTex';
			break;
		case STY_Modulated:
			MaskTexture = Texture'GrayMaskTex';
			break;
		case STY_Masked:
			MaskTexture = Texture'PinkMaskTex';
			break;
		default:
			MaskTexture = Texture'BlackMaskTex';
			break;
	}

	if ( OriginalTexture==None )
		return MaskTexture;

	switch ( OriginalTexture.Name )
	{
		case 'BlackMaskTex':
			return Texture'BlackMaskTex'; // Hack. Unsure why --han
			break;
		case 'GrayMaskTex':
		case 'PinkMaskTex':
			return MaskTexture;
			break;
	}

	if ( ReplacementTexture!=None )
		return ReplacementTexture;

	return OriginalTexture;
}

// ----------------------------------------------------------------------------
// SetSkinStyle()
// ----------------------------------------------------------------------------

function SetSkinStyle( ERenderStyle InStyle, optional Texture InTexture, optional float InScaleGlow )
{
	local int i;
	
	if ( InScaleGlow==0.0 )
		InScaleGlow = ScaleGlow;

	for ( i=0; i<8; i++ )
		MultiSkins[i] = GetStyleTexture( InStyle, GetMeshTexture(i), InTexture );

	Skin      = GetStyleTexture( InStyle, Skin, InTexture );
	Texture   = GetStyleTexture( InStyle, Skin, InTexture );
	ScaleGlow = InScaleGlow;
	Style     = InStyle;
}

// ----------------------------------------------------------------------------
// ResetSkinStyle()
// ----------------------------------------------------------------------------

function ResetSkinStyle()
{
	local int i;

	for ( i=0; i<8; i++ )
		MultiSkins[i] = default.MultiSkins[i];

	Skin      = default.Skin;
	Texture   = default.Texture;
	ScaleGlow = default.ScaleGlow;
	Style     = default.Style;
}

// ----------------------------------------------------------------------
// StartPoison()
// 
// Gakk!  We've been poisoned!
// ----------------------------------------------------------------------

function StartPoison( Pawn poisoner, int Damage )
{
	local float augLevel;

	//if ( Level.NetMode != NM_Standalone )
	//{
		// Don't do poison and drug effects if in multiplayer and AugEnviro is on
		//augLevel = AugmentationSystem.GetAugLevelValue(class'HXAugEnviro');
		//if ( augLevel != -1.0 )
			//return;
	//}

	myPoisoner = poisoner;

	if (Health <= 0)  // no more pain -- you're already dead!
		return;

	if (InConversation())  // kinda hacky...
		return;

	poisonCounter = 4;    // take damage no more than four times (over 8 seconds)
	poisonTimer   = 0;    // reset pain timer
	if (poisonDamage < Damage)  // set damage amount
		poisonDamage = Damage;

	drugEffectTimer += 4;  // make the player vomit for the next four seconds

	// In multiplayer, don't let the effect last longer than 30 seconds
	//if ( Level.NetMode != NM_Standalone )
	//{
		//if ( drugEffectTimer > 30 )
			//drugEffectTimer = 30;
	//}
}


// ----------------------------------------------------------------------
// DXReduceDamage()
//
// Calculates reduced damage from augmentations and from inventory items
// Also calculates a scalar damage reduction based on the mission number
// ----------------------------------------------------------------------
function bool DXReduceDamage(int Damage, name damageType, vector hitLocation, out int adjustedDamage, bool bCheckOnly)
{
	local float newDamage;
	local float augLevel, skillLevel;
	local float pct;
	//local HazMatSuit suit;
	//local BallisticArmor armor;
	local bool bReduced;

	bReduced = False;
	newDamage = Float(Damage);

	if ((damageType == 'TearGas') || (damageType == 'PoisonGas') || (damageType == 'Radiation') || (damageType == 'HalonGas')  || (damageType == 'PoisonEffect') || (damageType == 'Poison'))
	{
		if (AugmentationSystem != None)
			augLevel = AugmentationSystem.GetAugLevelValue(class'HXAugEnviro');

		if (augLevel >= 0.0)
			newDamage *= augLevel;

		// get rid of poison if we're maxed out
		if (newDamage ~= 0.0)
		{
			StopPoison();
			drugEffectTimer -= 4;	// stop the drunk effect
			if (drugEffectTimer < 0)
				drugEffectTimer = 0;
		}

		// go through the actor list looking for owned HazMatSuits
		// since they aren't in the inventory anymore after they are used


      //foreach AllActors(class'HazMatSuit', suit)
//			if ((suit.Owner == Self) && suit.bActive)
      if (HXUsingChargedPickup(class'HXHazMatSuit'))
			{
				skillLevel = SkillSystem.GetSkillLevelValue(class'HXSkillEnviro');
				newDamage *= 0.75 * skillLevel;
			}
	}

	if ((damageType == 'Shot') || (damageType == 'Sabot') || (damageType == 'Exploded') || (damageType == 'AutoShot'))
	{
		// go through the actor list looking for owned BallisticArmor
		// since they aren't in the inventory anymore after they are used
      if (HXUsingChargedPickup(class'HXBallisticArmor'))
			{
				skillLevel = SkillSystem.GetSkillLevelValue(class'HXSkillEnviro');
				newDamage *= 0.5 * skillLevel;
			}
	}

	if (damageType == 'HalonGas')
	{
		if (bOnFire && !bCheckOnly)
			ExtinguishFire();
	}

	if ((damageType == 'Shot') || (damageType == 'AutoShot'))
	{
		if (AugmentationSystem != None)
			augLevel = AugmentationSystem.GetAugLevelValue(class'HXAugBallistic');

		if (augLevel >= 0.0)
			newDamage *= augLevel;
	}

	if (damageType == 'EMP')
	{
		if (AugmentationSystem != None)
			augLevel = AugmentationSystem.GetAugLevelValue(class'HXAugEMP');

		if (augLevel >= 0.0)
			newDamage *= augLevel;
	}

	if ((damageType == 'Burned') || (damageType == 'Flamed') || (damageType == 'Exploded') || (damageType == 'Shocked'))
	{
		if (AugmentationSystem != None)
			augLevel = AugmentationSystem.GetAugLevelValue(class'HXAugShield');

		if (augLevel >= 0.0)
			newDamage *= augLevel;
	}

	if (newDamage < Damage)
	{
		if (!bCheckOnly)
		{
			pct = 1.0 - (newDamage / Float(Damage));
			SetDamagePercent(pct);
			ClientFlash(0.01, vect(0, 0, 50));
		}
		bReduced = True;
	}
	else
	{
		if (!bCheckOnly)
			SetDamagePercent(0.0);
	}


	//
	// Reduce or increase the damage based on the combat difficulty setting
	//
	if ((damageType == 'Shot') || (damageType == 'AutoShot'))
	{
		newDamage *= HXGameInfo(Level.Game).CombatDifficulty;

		// always take at least one point of damage
		if ((newDamage <= 1) && (Damage > 0))
			newDamage = 1;
	}

	adjustedDamage = Int(newDamage);

	return bReduced;
}

// ----------------------------------------------------------------------
// BuySkills()
// ----------------------------------------------------------------------

exec function BuySkills()
{
	// Empty.
}

// ----------------------------------------------------------------------
// ClientDeath()
// 
// Does client side cleanup on death.
// ----------------------------------------------------------------------

function ClientDeath()
{   
   if (!PlayerIsClient())
      return;

   FlashTimer = 0;

	// Reset skill notification
	//HXRootWindow(rootWindow).hud.hms.bNotifySkills = False;

	HXRootWindow(rootWindow).hud.activeItems.winItemsContainer.RemoveAllIcons();
	//HXRootWindow(rootWindow).hud.belt.ClearBelt();

	// This should get rid of the scope death problem in multiplayer
	if (( HXRootWindow(rootWindow).scopeView != None ) && HXRootWindow(rootWindow).scopeView.bViewVisible )
	   HXRootWindow(rootWindow).scopeView.DeactivateView();

	if ( HXRootWindow(rootWindow).hud.augDisplay != None )
	{
		HXRootWindow(rootWindow).hud.augDisplay.bVisionActive = False;
		HXRootWindow(rootWindow).hud.augDisplay.activeCount = 0;
	}

	if ( bOnFire )
		ExtinguishFire();

	// Don't come back to life drugged or posioned
	poisonCounter		= 0;
	poisonTimer			= 0;
	drugEffectTimer	= 0;

	// Don't come back to life crouched
	bCrouchOn			= False;
	bWasCrouchOn		= False;
	bIsCrouching		= False;
	bForceDuck			= False;
	lastbDuck			= 0;
	bDuck					= 0;

	// No messages carry over
	mpMsgCode = 0;
	mpMsgTime = 0;

	bleedrate = 0;
	dropCounter = 0;
}

// ----------------------------------------------------------------------
// CalculatePlayerVisibility()
// ----------------------------------------------------------------------

function float CalculatePlayerVisibility( ScriptedPawn Pawn )
{
	local HXScriptedPawn ScriptedPawn;
	local float Vis;
	//local AdaptiveArmor armor;

	ScriptedPawn = HXScriptedPawn(Pawn);

	Vis = 1.0;
	if ( ScriptedPawn!=None && AugmentationSystem!=None )
	{
		if ( ScriptedPawn.bIsRobot )
		{
			// If the aug is on, give the player full invisibility.
			if ( AugmentationSystem.GetAugLevelValue(Class'HXAugRadarTrans')!=-1.0 )
				Vis = 0.0;
		}
		else
		{
			// If the aug is on, give the player full invisibility.
			if ( AugmentationSystem.GetAugLevelValue(Class'HXAugCloak')!=-1.0 )
				Vis = 0.0;
		}

		// Go through the actor list looking for owned AdaptiveArmor.
		// since they aren't in the inventory anymore after they are used. [sic!]
		// HX_HAN: They apparently have changed that.
		if ( !(Vis~=0.0) && HXUsingChargedPickup(Class'HXAdaptiveArmor') )
		{
			Vis = 0.0;
		}
	}
	return Vis;
}

// ----------------------------------------------------------------------
// UsingChargedPickup
// ----------------------------------------------------------------------

function bool HXUsingChargedPickup(class<HXChargedPickup> itemclass)
{
   local inventory CurrentItem;
   local bool bFound;

   bFound = false;
   
   for (CurrentItem = Inventory; ((CurrentItem != None) && (!bFound)); CurrentItem = CurrentItem.inventory)
   {
      if ((CurrentItem.class == itemclass) && (CurrentItem.bActive))
         bFound = true;
   }

   return bFound;
}

// ----------------------------------------------------------------------
// ShowMainMenu()
// ----------------------------------------------------------------------

exec function ShowMainMenu()
{
	local HXRootWindow Root;
	//local DeusExLevelInfo Info;
	//local MissionEndgame Script;

	//if (bIgnoreNextShowMenu)
	//{
		//bIgnoreNextShowMenu = False;
		//return;
	//}

	//info = GetLevelInfo();

	// Special case baby!
	// 
	// If the Intro map is loaded and we get here, that means the player
	// pressed Escape and we want to either A) start a new game 
	// or B) return to the dx.dx screen.  Either way we're going to 
	// abort the Intro by doing this. 
	//
	// If this is one of the Endgames (which have a mission # of 99)
	// then we also want to call the Endgame's "FinishCinematic" 
	// function

	// force the texture caches to flush
	//ConsoleCommand("FLUSH");

	//if ((info != None) && (info.MissionNumber == 98)) 
	//{
		//bIgnoreNextShowMenu = True;
		//PostIntro();
	//}
	//else if ((info != None) && (info.MissionNumber == 99))
	//{
		//foreach AllActors(class'MissionEndgame', Script)
			//break;

		//if (Script != None)
			//Script.FinishCinematic();
	//}
	//else
	//{
		Root = HXRootWindow(RootWindow);
		if ( Root!=None )
			Root.InvokeMenu(Class'HXMenuMain');
	//}
}

// ----------------------------------------------------------------------
// ShowInventoryWindow()
// ----------------------------------------------------------------------

exec function ShowInventoryWindow()
{
	local HXRootWindow Root;

	if ( RestrictInput() )
		return;

	Root = HXRootWindow(RootWindow);
	if ( Root!=None )
		Root.ShowInventoryWindow();
}

// ----------------------------------------------------------------------
// ShowSkillsWindow()
// ----------------------------------------------------------------------

exec function ShowSkillsWindow()
{
	local HXRootWindow Root;

	if ( RestrictInput() )
		return;

	Root = HXRootWindow(RootWindow);
	if ( Root!=None )
		Root.ShowSkillsWindow();
}

// ----------------------------------------------------------------------
// ShowHealthWindow()
// ----------------------------------------------------------------------

exec function ShowHealthWindow()
{
	local HXRootWindow Root;

	if ( RestrictInput() )
		return;

	Root = HXRootWindow(RootWindow);
	if ( Root!=None )
		Root.ShowHealthWindow();
}

// ----------------------------------------------------------------------
// ShowImagesWindow()
// ----------------------------------------------------------------------

exec function ShowImagesWindow()
{
	local HXRootWindow Root;

	if ( RestrictInput() )
		return;

	Root = HXRootWindow(RootWindow);
	if ( Root!=None )
		Root.ShowImagesWindow();
}

// ----------------------------------------------------------------------
// ShowConversationsWindow()
// ----------------------------------------------------------------------

exec function ShowConversationsWindow()
{
	local HXRootWindow Root;

	if ( RestrictInput() )
		return;

	Root = HXRootWindow(RootWindow);
	if ( Root!=None )
		Root.ShowConversationsWindow();
}

// ----------------------------------------------------------------------
// ShowAugmentationsWindow()
// ----------------------------------------------------------------------

exec function ShowAugmentationsWindow()
{
	local HXRootWindow Root;

	if ( RestrictInput() )
		return;

	Root = HXRootWindow(RootWindow);
	if ( Root!=None )
		Root.ShowAugmentationsWindow();
}

// ----------------------------------------------------------------------
// ShowGoalsWindow()
// ----------------------------------------------------------------------

exec function ShowGoalsWindow()
{
	local HXRootWindow Root;

	if ( RestrictInput() )
		return;

	Root = HXRootWindow(RootWindow);
	if ( Root!=None )
		Root.ShowGoalsWindow();
}

// ----------------------------------------------------------------------
// ShowLogsWindow()
// ----------------------------------------------------------------------

exec function ShowLogsWindow()
{
	local HXRootWindow Root;

	if ( RestrictInput() )
		return;

	Root = HXRootWindow(RootWindow);
	if ( Root!=None )
		Root.ShowLogsWindow();
}

// ----------------------------------------------------------------------
// ShowAugmentationAddWindow()
// ----------------------------------------------------------------------

exec function ShowAugmentationAddWindow()
{
	local HXRootWindow Root;

	if ( RestrictInput() || !bCheatsEnabled )
		return;

	Root = HXRootWindow(RootWindow);
	if ( Root!=None )
		Root.ShowAugmentationAddWindow();
}

// ----------------------------------------------------------------------
// AddDamageDisplay() -- Now passed to RootWindow.
// ----------------------------------------------------------------------

function AddDamageDisplay( Name DamageType, Vector HitOffset )
{
	local HXRootWindow Root;
	Root = HXRootWindow(RootWindow);
	if ( Root!=None )
		Root.AddDamageDisplay( DamageType, HitOffset );
}

// ----------------------------------------------------------------------
// SetDamagePercent() -- Now passed to RootWindow.
// ----------------------------------------------------------------------

function SetDamagePercent( float Percent )
{
	local HXRootWindow Root;
	Root = HXRootWindow(RootWindow);
	if ( Root!=None )
		Root.SetDamagePercent( Percent );
}

// ----------------------------------------------------------------------
// InitializeSubSystems()
// ----------------------------------------------------------------------

function InitializeSubSystems()
{
	// Spawn the Color Manager
	//CreateColorThemeManager();
  //ThemeManager.SetOwner(self);

	// install the augmentation system if not found
	if (AugmentationSystem == None)
	{
		AugmentationSystem = Spawn(class'HXAugmentationManager', Self);
		AugmentationSystem.CreateAugmentations(Self);
		AugmentationSystem.AddDefaultAugmentations();        
    AugmentationSystem.SetOwner(Self);       
	}
	else
	{
		AugmentationSystem.SetPlayer(Self);
    AugmentationSystem.SetOwner(Self);
	}

	// install the skill system if not found
	if (SkillSystem == None)
	{
		SkillSystem = Spawn(class'HXSkillManager', Self);
		SkillSystem.CreateSkills(Self);
	}
	else
	{
		SkillSystem.SetPlayer(Self);
	}

	//if ((Level.Netmode == NM_Standalone) || (!bBeltIsMPInventory))
	//{
		// Give the player a keyring
		CreateKeyRing();
	//}

}

// ----------------------------------------------------------------------
// ResetPlayerToDefaults()
//
// Resets all travel variables to their defaults
// ----------------------------------------------------------------------

function ResetPlayerToDefaults()
{
}

// ----------------------------------------------------------------------
// RemoveAllInventory()
// ----------------------------------------------------------------------

function RemoveAllInventory()
{
	local Inventory item, nextItem, lastItem;

	if (Inventory != None)
	{
		item = Inventory;
		nextItem = item.Inventory;
		lastItem = item;

		do
		{
			if ((item != None) && item.bDisplayableInv || item.IsA('Ammo'))
			{
				// make sure everything is turned off
				if (item.IsA('HXWeapon'))
				{
					HXWeapon(item).ScopeOff();
					HXWeapon(item).LaserOff();
				}
				if (item.IsA('HXPickup'))
				{
					if (HXPickup(item).bActive)
						HXPickup(item).Activate();
				}

   			if (item.IsA('HXChargedPickup'))
					HXRemoveChargedDisplay(HXChargedPickup(item));

				DeleteInventory(item);
				item.Destroy();
				item = Inventory;
			}
			else
				item = nextItem;

			if (item != None)
				nextItem = item.Inventory;
		}
		until ((item == None) || (item == lastItem));
	}
}

// ----------------------------------------------------------------------
// PreTravel() - Called when a ClientTravel is about to happen
// ----------------------------------------------------------------------

function PreTravel()
{
	// Set a flag designating that we're traveling,
	// so MissionScript can check and not call FirstFrame() for this map.
	
	//flagBase.SetBool('PlayerTraveling', True, True, 0);

	//SaveSkillPoints();

	if (dataLinkPlay != None)
		dataLinkPlay.AbortAndSaveHistory();

	// If the player is burning (Fire! Fire!), extinguish him
	// before the map transition.  This is done to fix stuff 
	// that's fucked up.
	ExtinguishFire();
}

// ----------------------------------------------------------------------
// SaveSkillPoints()
// 
// Saves out skill points, used when starting a new game
// ----------------------------------------------------------------------

function SaveSkillPoints()
{
	//local name flagName;

	// Save/Restore must be done as atomic unit
	//if (bSavingSkillsAugs)
		//return;

	//bSavingSkillsAugs = True;

	// Save the skill points available
	//flagName = rootWindow.StringToName("SKTemp_SkillPointsAvail");
	//flagBase.SetInt(flagName, SkillPointsAvail);

	// Save the skill points available
	//flagName = rootWindow.StringToName("SKTemp_SkillPointsTotal");
	//flagBase.SetInt(flagName, SkillPointsTotal);
}

// ----------------------------------------------------------------------
// RestoreSkillPoints()
// 
// Restore skill point variables
// ----------------------------------------------------------------------

function RestoreSkillPoints()
{
	//local name flagName;

	//bSavingSkillsAugs = False;

	// Get the skill points available
	//flagName = rootWindow.StringToName("SKTemp_SkillPointsAvail");
	//if (flagBase.CheckFlag(flagName, FLAG_Int))
	//{
		//SkillPointsAvail = flagBase.GetInt(flagName);
		//flagBase.DeleteFlag(flagName, FLAG_Int);
	//}

	// Get the skill points total
	//flagName = rootWindow.StringToName("SKTemp_SkillPointsTotal");
	//if (flagBase.CheckFlag(flagName, FLAG_Int))
	//{
		//SkillPointsTotal = flagBase.GetInt(flagName);
		//flagBase.DeleteFlag(flagName, FLAG_Int);
	//}
}

// ------------------------------------------------------------------------
// GiveInitialInventory()
//
// Reroute to GameInfo.
// ------------------------------------------------------------------------

function GiveInitialInventory()
{
	local HXGameInfo Game;

	Game = HXGameInfo(Level.Game);
	if ( Game!=None )
		Game.GiveInitialInventory( Self );
}

// ----------------------------------------------------------------------
// CreateKeyRing()
// ----------------------------------------------------------------------

function CreateKeyRing()
{
	local Inventory Item;
	local class<Inventory> KeyRingClass;

	if ( HXKeyRing!=None )
		return;

	KeyRingClass = class'NanoKeyRing';
	Game.ModifyInventoryClass( KeyRingClass );
	Item = Spawn( KeyRingClass, Self );
	if ( Item==None )
		return;

	// Add to Inventory.
	// KeyRing will set itsself as HXPlayerPawn(Owner).HXKeyRing
	// And pin itsself in inventory.
	Item.Frob( Self, None );
	if ( Level.Game.ShouldRespawn(Item) )
		Item.Destroy();
}

// ----------------------------------------------------------------------
// CanBeLifted()
//
// check to see if the player can lift a certain decoration taking
// into account his muscle augs
// ----------------------------------------------------------------------

function bool CanBeLifted( Decoration Deco )
{
	local int augLevel, augMult;
	local float maxLift;

	MaxLift = 50;
	if ( AugmentationSystem!=None )
		MaxLift += 50*(AugmentationSystem.GetClassLevel(class'HXAugMuscle')+1);

	if (!deco.bPushable || (deco.Mass > maxLift) || (deco.StandingCount > 0))
	{
		if (deco.bPushable)
			ClientMessage(TooHeavyToLift);
		else
			ClientMessage(CannotLift);

		return False;
	}

	return True;
}

// ----------------------------------------------------------------------
// GrabDecoration()
//
// This overrides GrabDecoration() in Pawn.uc
// lets the strength augmentation affect how much the player can lift
// ----------------------------------------------------------------------

function GrabDecoration()
{
	// Can't grab decorations while leaning.
	if ( IsLeaning() )
		return;

	// Can't grab decorations while holding something else.
	if ( InHand!=None )
	{
		ClientMessage(HandsFull);
		return;
	}

	if ( CarriedDecoration==None )
	{
		if ( Decoration(FrobTarget)!=None && Weapon==None ) // Weapon check needed?
		{
			if ( CanBeLifted(Decoration(FrobTarget)) )
			{
				CarriedDecoration = Decoration(FrobTarget);
				PutCarriedDecorationInHand();
			}
		}
	}
}
	
// ----------------------------------------------------------------------
// PutCarriedDecorationInHand()
// ----------------------------------------------------------------------

function PutCarriedDecorationInHand()
{
	local vector LookDir, UpDir;

	if (CarriedDecoration != None)
	{
		LookDir   = Vector(Rotation);
		LookDir.Z = 0;
		LookDir   = Normal(LookDir);
		UpDir   = vect(0,0,0);
		UpDir.Z = CollisionHeight / 2.0;		// put it up near eye level

		CarriedDecoration.SetPhysics(PHYS_Falling);

		if ( CarriedDecoration.SetLocation(Location + upDir + (0.5 * CollisionRadius + CarriedDecoration.CollisionRadius) * lookDir) )
		{
			CarriedDecoration.SetPhysics(PHYS_None);
			CarriedDecoration.SetBase(self);
			CarriedDecoration.SetCollision(False, False, False);
			CarriedDecoration.bCollideWorld = False;

			// Don't make it translucent anymore if it's a HXDecoration.
			// It will get rendered translucent by DecorationRenderIterator.
			if ( !CarriedDecoration.IsA('HXDecoration') )
			{
				CarriedDecoration.Style = STY_Translucent;
				CarriedDecoration.ScaleGlow = 1.0;
				CarriedDecoration.bUnlit = True;
			}
			FrobTarget = None;
		}
		else
		{
			ClientMessage(NoRoomToLift);
			CarriedDecoration = None;
		}
	}
}

// ----------------------------------------------------------------------
// DropDecoration()
//
// This overrides DropDecoration() in Pawn.uc
// lets the player throw a decoration instead of just dropping it
// ----------------------------------------------------------------------

function DropDecoration()
{
	local Vector X, Y, Z, dropVect, origLoc, HitLocation, HitNormal, extent;
	local float velscale, size, mult;
	local bool bSuccess;
	local Actor hitActor;

	bSuccess = False;

	if (CarriedDecoration != None)
	{
		origLoc = CarriedDecoration.Location;
		GetAxes(Rotation, X, Y, Z);

		// if we are highlighting something, try to place the object on the target
		if ((FrobTarget != None) && !FrobTarget.IsA('Pawn'))
		{
			CarriedDecoration.Velocity = vect(0,0,0);

			// try to drop the object about one foot above the target
			size = FrobTarget.CollisionRadius - CarriedDecoration.CollisionRadius * 2;
			dropVect.X = size/2 - FRand() * size;
			dropVect.Y = size/2 - FRand() * size;
			dropVect.Z = FrobTarget.CollisionHeight + CarriedDecoration.CollisionHeight + 16;
			dropVect += FrobTarget.Location;
		}
		else
		{
			// throw velocity is based on augmentation
			if (AugmentationSystem != None)
			{
				mult = AugmentationSystem.GetAugLevelValue(class'HXAugMuscle');
				if (mult == -1.0)
					mult = 1.0;
			}

			if (IsLeaning())
				CarriedDecoration.Velocity = vect(0,0,0);
			else
				CarriedDecoration.Velocity = Vector(ViewRotation) * mult * 500 + vect(0,0,220) + 40 * VRand();

			// scale it based on the mass
			velscale = FClamp(CarriedDecoration.Mass / 20.0, 1.0, 40.0);

			CarriedDecoration.Velocity /= velscale;
			dropVect = Location + (CarriedDecoration.CollisionRadius + CollisionRadius + 4) * X;
			dropVect.Z += BaseEyeHeight;
		}

		// is anything blocking the drop point? (like thin doors)
		if (FastTrace(dropVect))
		{
			CarriedDecoration.SetCollision(True, True, True);
			CarriedDecoration.bCollideWorld = True;

			// check to see if there's space there
			extent.X = CarriedDecoration.CollisionRadius;
			extent.Y = CarriedDecoration.CollisionRadius;
			extent.Z = 1;
			hitActor = Trace(HitLocation, HitNormal, dropVect, CarriedDecoration.Location, True, extent);

			if ((hitActor == None) && CarriedDecoration.SetLocation(dropVect))
				bSuccess = True;
			else
			{
				CarriedDecoration.SetCollision(False, False, False);
				CarriedDecoration.bCollideWorld = False;
			}
		}

		// if we can drop it here, then drop it
		if (bSuccess)
		{
			CarriedDecoration.bWasCarried = True;
			CarriedDecoration.SetBase(None);
			CarriedDecoration.SetPhysics(PHYS_Falling);
			CarriedDecoration.Instigator = Self;

			// turn off translucency
			CarriedDecoration.Style = CarriedDecoration.Default.Style;
			CarriedDecoration.bUnlit = CarriedDecoration.Default.bUnlit;
			if ( CarriedDecoration.IsA('HXDecoration') )
				HXDecoration(CarriedDecoration).ResetScaleGlow();
			else if ( CarriedDecoration.IsA('DeusExDecoration') )
				DeusExDecoration(CarriedDecoration).ResetScaleGlow();

			CarriedDecoration = None;
		}
		else
		{
			// otherwise, don't drop it and display a message
			CarriedDecoration.SetLocation(origLoc);
			ClientMessage(CannotDropHere);
		}
	}
}

// ----------------------------------------------------------------------------
// DropItem()
//
// throws an item where you are currently looking
// or places it on your currently highlighted object
// if None is passed in, it drops what's inHand
// ----------------------------------------------------------------------------

exec function bool DropItem( optional Inventory inv, optional bool bDrop )
{
	local Inventory item;
	local Inventory previousItemInHand;
	local Vector X, Y, Z, dropVect;
	local float size, mult;
	local HXCarcass carc;
	local class<HXCarcass> carcClass;
	local bool bDropped;
	local bool bRemovedFromSlots;
	local int  itemPosX, itemPosY;

	// Yes this is needed, copied off ThrowWeapon().
	// RPC is certainly a thing to be overhauled.
	if ( Level.NetMode==NM_Client )
		return false;

	bDropped = True;

	if (inv == None)
	{
		previousItemInHand = inHand;
		item = inHand;
	}
	else
	{
		item = inv;
	}

	if (item != None)
	{
		// This nearly slipped by.
		if ( Item.bDeleteMe )
			return false;


		GetAxes(Rotation, X, Y, Z);
		dropVect = Location + (CollisionRadius + 2*item.CollisionRadius) * X;
		dropVect.Z += BaseEyeHeight;

		// check to see if we're blocked by terrain
		if (!FastTrace(dropVect))
		{
			ClientMessage( Sprintf(CannotBeDroppedLabel,Item.ItemName), 'StatusLine' );
			return false;
		}

		// See if Item can be dropped. KeyRings or active ChargedPickups will
		// reject the Drop here and sent a ClientMessage with the specific reason.
		// Weapons will do some very strange state checking, which should either be gone or 
		// extended into other classes.
		if ( !DuckCallCanBeDropped(Item,false) )
			return false;




		// Other stuff doesn't start deactivation yet, in case it may not work to drop...
		if ( Item.IsA('HXWeapon') )
		{
			HXWeapon(item).ScopeOff();
			HXWeapon(item).LaserOff();
		}


		// take it out of our hand
		if (item == inHand)
			PutInHand(None);

		// handle throwing pickups that stack
		if (item.IsA('HXPickup'))
		{
			// turn it off if it is on
			if (HXPickup(item).bActive)
				HXPickup(item).Activate();

			HXPickup(item).NumCopies--;
			//UpdateBeltText(item);	

			if (HXPickup(item).NumCopies > 0)
			{
				// put it back in our hand, but only if it was in our
				// hand originally!!!
				if (previousItemInHand == item)
					PutInHand(previousItemInHand);

				item = Spawn(item.Class, Owner);
			}
			else
			{
				// Keep track of this so we can undo it 
				// if necessary
				bRemovedFromSlots = True;
				itemPosX = item.invPosX;
				itemPosY = item.invPosY;

				// Remove it from the inventory slot grid
				RemoveItemFromSlot(item);

				// make sure we have one copy to throw!
				HXPickup(item).NumCopies = 1;
			}
		}
		else
		{
			// Keep track of this so we can undo it 
			// if necessary
			bRemovedFromSlots = True;
			itemPosX = item.invPosX;
			itemPosY = item.invPosY;

			// Remove it from the inventory slot grid
			RemoveItemFromSlot(item);
		}

		// if we are highlighting something, try to place the object on the target
		if ((FrobTarget != None) && !item.IsA('POVCorpse'))
		{
			item.Velocity = vect(0,0,0);

			// play the correct anim
			PlayPickupAnim(FrobTarget.Location);

			// try to drop the object about one foot above the target
			size = FrobTarget.CollisionRadius - item.CollisionRadius * 2;
			dropVect.X = size/2 - FRand() * size;
			dropVect.Y = size/2 - FRand() * size;
			dropVect.Z = FrobTarget.CollisionHeight + item.CollisionHeight + 16;
			if (FastTrace(dropVect))
			{
				item.DropFrom(FrobTarget.Location + dropVect);
			}
			else
			{
				ClientMessage(CannotDropHere);
				
				bDropped = False;
			}
		}
		else
		{
			// throw velocity is based on augmentation
			if (AugmentationSystem != None)
			{
				mult = AugmentationSystem.GetAugLevelValue(class'HXAugMuscle');
				if (mult == -1.0)
					mult = 1.0;
			}

			if (bDrop)
			{
				item.Velocity = VRand() * 30;

				// play the correct anim
				PlayPickupAnim(item.Location);
			}
			else
			{
				item.Velocity = Vector(ViewRotation) * mult * 300 + vect(0,0,220) + 40 * VRand();

				// play a throw anim
				PlayAnim('Attack',,0.1);
			}

			GetAxes(ViewRotation, X, Y, Z);
			dropVect = Location + 0.8 * CollisionRadius * X;
			dropVect.Z += BaseEyeHeight;

			// if we are a corpse, spawn the actual carcass
			if (item.IsA('POVCorpse'))
			{
				if (POVCorpse(item).carcClassString != "")
				{
					carcClass = class<HXCarcass>(DynamicLoadObject(POVCorpse(item).carcClassString, class'Class'));
					if (carcClass != None)
					{
						carc = Spawn(carcClass);
						if (carc != None)
						{
							carc.Mesh = carc.Mesh2;
							carc.KillerAlliance = POVCorpse(item).KillerAlliance;
							carc.KillerBindName = POVCorpse(item).KillerBindName;
							carc.Alliance = POVCorpse(item).Alliance;
							carc.bNotDead = POVCorpse(item).bNotDead;
							carc.bEmitCarcass = POVCorpse(item).bEmitCarcass;
							carc.CumulativeDamage = POVCorpse(item).CumulativeDamage;
							carc.MaxDamage = POVCorpse(item).MaxDamage;
							carc.itemName = POVCorpse(item).CorpseItemName;
							carc.CarcassName = POVCorpse(item).CarcassName;
							carc.Velocity = item.Velocity * 0.5;
							item.Velocity = vect(0,0,0);
							carc.bHidden = False;
							carc.SetPhysics(PHYS_Falling);
							carc.SetScaleGlow();
							if (carc.SetLocation(dropVect))
							{
								// must circumvent PutInHand() since it won't allow
								// things in hand when you're carrying a corpse
								SetInHandPending(None);
								item.Destroy();
								item = None;
							}
							else
								carc.bHidden = True;
						}
					}
				}
			}
			else
			{
				if (FastTrace(dropVect))
				{
					item.DropFrom(dropVect);
					item.bFixedRotationDir = True;
					item.RotationRate.Pitch = (0.5-FRand())*65536.0*4.0;
					item.RotationRate.Yaw   = (0.5-FRand())*65536.0*4.0;
				}
			}
		}

		// if we failed to drop it, put it back inHand
		if (item != None)
		{
			if (((inHand == None) || (inHandPending == None)) && (item.Physics != PHYS_Falling))
			{
				PutInHand(item);
				ClientMessage(CannotDropHere);
				bDropped = False;
			}
			else
			{
				item.Instigator = Self;
			}
		}
	}
	else if (CarriedDecoration != None)
	{
		DropDecoration();

		// play a throw anim
		PlayAnim('Attack',,0.1);
	}

	// If the drop failed and we removed the item from the inventory
	// grid, then we need to stick it back where it came from so
	// the inventory doesn't get fucked up.

	if ((bRemovedFromSlots) && (item != None) && (!bDropped))
	{
    //DEUS_EX AMSD Use the function call for this, helps multiplayer
    PlaceItemInSlot(item, itemPosX, itemPosY);
	}

	if ( item != None )
	{
		if ( bDropped )
			ClientUpdatePersonaStatusLineWindow( Sprintf(DroppedLabel, item.itemName ) );
		else
			ClientUpdatePersonaStatusLineWindow( Sprintf(CannotBeDroppedLabel, item.itemName ) );
	}

	return bDropped;
}

// ----------------------------------------------------------------------
// DropAmmo()
// 
// Drops a clip of the specified ammo class.
// ----------------------------------------------------------------------

exec function DropAmmo( Class<HXAmmo> AmmoClass, optional bool bDrop )
{
	local Vector X, Y, Z, DropVect;
	local HXAmmo Ammo, DropAmmo;
	local float Mult;

	//Log( "DropAmmo( " $ AmmoClass $ ", " $ bDrop $ " )" );

	// Find this type of ammo in inventory.
	Ammo = HXAmmo(FindInventoryType(AmmoClass));

	// Check if we have this ammo item and enough ammo.
	if ( Ammo==None || Ammo.AmmoAmount<=0 )
		return;

	GetAxes( Rotation, X, Y, Z );
	DropVect    = Location + (CollisionRadius + Ammo.CollisionRadius) * X * 1.05;
	DropVect.Z += BaseEyeHeight;

	// Check to see if we're blocked by terrain.
	if ( !FastTrace(DropVect) )
	{
		ClientMessage( CannotDropHere );
		ClientUpdatePersonaStatusLineWindow( Sprintf(CannotBeDroppedLabel,Ammo.ItemName) );
		return;
	}

	// Spawn new item.
	DropAmmo = Spawn( AmmoClass, None, '', DropVect, Rotation );

	// If spawn failed, we cannot drop.
	if ( DropAmmo==None )
	{
		ClientMessage( CannotDropHere );
		ClientUpdatePersonaStatusLineWindow( Sprintf(CannotBeDroppedLabel,Ammo.ItemName) );
		return;
	}

	// Drop clips, or if less then a clip is available the remaining ammo.
	DropAmmo.AmmoAmount = Min( Ammo.AmmoAmount, AmmoClass.Default.AmmoAmount );
	Ammo.AmmoAmount    -= DropAmmo.AmmoAmount;

	// Throw velocity is based on augmentation.
	if ( AugmentationSystem!=None )
	{
		Mult = AugmentationSystem.GetAugLevelValue( Class'HXAugMuscle' );
		if ( Mult==-1.0 )
			Mult = 1.0;
	}

	if ( bDrop )
	{
		DropAmmo.Velocity = VRand() * 30;

		// Play the correct anim.
		PlayPickupAnim( DropAmmo.Location );
	}
	else
	{
		DropAmmo.Velocity = Vector(ViewRotation) * Mult * 300 + vect(0,0,220) + 40 * VRand();

		// Play a throw anim
		PlayAnim( 'Attack', , 0.1 );
	}

	DropAmmo.DropFrom( DropAmmo.Location );
	DropAmmo.bFixedRotationDir = True;
	DropAmmo.RotationRate.Pitch = (0.5-FRand())*65536.0*4.0;
	DropAmmo.RotationRate.Yaw   = (0.5-FRand())*65536.0*4.0;

	// Update line in inventory.
	ClientUpdatePersonaStatusLineWindow( Sprintf(DroppedLabel, DropAmmo.ItemName ) );
}

// ----------------------------------------------------------------------
// UpdateBeltText() -- UNUSED IN HX
// ----------------------------------------------------------------------

function UpdateBeltText(Inventory item)
{
	Warn( "Called." );
}

// ----------------------------------------------------------------------
// UpdateAmmoBeltText() -- UNUSED IN HX
// ----------------------------------------------------------------------

function UpdateAmmoBeltText(Ammo ammo)
{
	Warn( "Called." );
}

// ----------------------------------------------------------------------
// SetInHand()
// ----------------------------------------------------------------------

function SetInHand( Inventory NewInHand )
{
	InHand = NewInHand;
}

// ----------------------------------------------------------------------
// SetInHandPending()
// ----------------------------------------------------------------------

function SetInHandPending( Inventory NewInHandPending )
{
	if ( NewInHandPending==None )
		ClientInHandPending = None;
	InHandPending = NewInHandPending;
}

// ----------------------------------------------------------------------
// UpdateInHand()
//
// Called every frame
// Checks the state of inHandPending and deals with animation and crap
// 1. Check for pending item
// 2. Play down anim (and deactivate) for inHand and wait for it to finish
// 3. Assign inHandPending to inHand (and SelectedItem)
// 4. Play up anim for inHand
// ----------------------------------------------------------------------

function UpdateInHand()
{
	local bool bSwitch;

	//sync up clientinhandpending.
	if (inHandPending != inHand)
		ClientInHandPending = inHandPending;

   //DEUS_EX AMSD  Don't let clients do this.
   if (Role < ROLE_Authority)
      return;

	if (inHand != inHandPending)
	{
		bInHandTransition = True;
		bSwitch = False;
		if (inHand != None)
		{
			// turn it off if it is on
			if (inHand.bActive)
				inHand.Activate();

			if (inHand.IsA('HXSkilledTool'))
			{
				if (inHand.IsInState('Idle'))
            {
					HXSkilledTool(inHand).PutDown();
            }
				else if (inHand.IsInState('Idle2'))
            {
					bSwitch = True;
            }
			}
			else if (inHand.IsA('HXWeapon'))
			{
				if (inHand.IsInState('Idle') || inHand.IsInState('Reload'))
					HXWeapon(inHand).PutDown();
				else if (inHand.IsInState('DownWeapon') && (Weapon == None))
					bSwitch = True;
			}
			else
			{
				bSwitch = True;
			}
		}
		else
		{
			bSwitch = True;
		}

		// OK to actually switch?
		if (bSwitch)
		{
			SetInHand(inHandPending);
			SelectedItem = inHandPending;

			if (inHand != None)
			{
				if (inHand.IsA('HXSkilledTool'))
					HXSkilledTool(inHand).BringUp();
				else if (inHand.IsA('HXWeapon'))
					SwitchWeapon(HXWeapon(inHand).InventoryGroup);
			}
		}
	}
	else
	{
		bInHandTransition = False;

		// Added this code because it's now possible to reselect an in-hand
		// item while we're putting it down, so we need to bring it back up...

		if (inHand != None)
		{
			// if we put the item away, bring it back up
			if (inHand.IsA('HXSkilledTool'))
			{
				if (inHand.IsInState('Idle2'))
					HXSkilledTool(inHand).BringUp();
			}
			else if (inHand.IsA('HXWeapon'))
			{
				if (inHand.IsInState('DownWeapon') && (Weapon == None))
					SwitchWeapon(HXWeapon(inHand).InventoryGroup);
			}
		}

	}

	UpdateCarcassEvent();
}


// ----------------------------------------------------------------------
// StartDataLinkTransmission()
// ----------------------------------------------------------------------

function Bool StartDataLinkTransmission(
	String datalinkName, 
	Optional DataLinkTrigger datalinkTrigger)
{
	//Log( Self $ ".StartDataLinkTransmission( " $ datalinkName $ ", " $ datalinkTrigger $ " ) called. REPORT THIS AS A BUG !!!" );

	return false;
}


// ----------------------------------------------------------------------
// ClientStartDataLinkTransmission()
//
// Locates and starts the DataLink passed in
// ----------------------------------------------------------------------

function bool ClientStartDataLinkTransmission(
	String datalinkName, 
	Optional HXDataLinkTrigger datalinkTrigger)
{
	local Conversation activeDataLink;
	local bool bDataLinkPlaySpawned;

	local string conbindclass;
	local int missionNumber;

	Log( Self $ ".ClientStartDataLinkTransmission( " $ datalinkName $ ", " $ datalinkTrigger $ " ) called.", 'DevDataLinkPlay' );

	// Don't allow DataLinks to start if we're in PlayersOnly mode
	if ( Level.bPlayersOnly )
		return False;

	if ( !PlayerIsClient() )
		return false;

	if ( conListItems == None )
	{
		missionNumber = DeusExLevelInfo.MissionNumber;

		if ( missionNumber >= 0 && missionNumber <= 9 )
			conbindclass = "DeusExConText.ConList_Mission0" $ missionNumber;
		else if ( missionNumber >= 10 && missionNumber <= 99 )
			conbindclass = "DeusExConText.ConList_Mission" $ missionNumber;
		else
		{
			Log( "WTF IS THIS MISSION NUMBER " $ missionNumber );

			return false;
		}

		//Log( "TODO Move BindConversationList() call (HXPlayerPawn)." );
		//Log( conbindclass );

		Class'HXActor'.Static.BindConversationList( ConBindClass, Self );
	}

	activeDataLink = GetActiveDataLink(datalinkName);

	if ( activeDataLink != None )
	{
		// Search to see if there's an active DataLinkPlay object 
		// before creating one

		if ( dataLinkPlay == None )
		{
			datalinkPlay = Spawn(class'HXClientDataLinkPlay');
			bDataLinkPlaySpawned = True;
		}

		// Call SetConversation(), which returns 
		if (datalinkPlay.SetConversation(activeDataLink))
		{
			// not needed on client
			//datalinkPlay.SetTrigger(datalinkTrigger);

			if (datalinkPlay.StartConversation(Self))
			{
				return True;
			}
			else
			{
				// Datalink must already be playing, or in queue
				if (bDataLinkPlaySpawned)
				{
					datalinkPlay.Destroy();
					datalinkPlay = None;
				}
				
				return False;
			}
		}
		else
		{
			// Datalink must already be playing, or in queue
			if (bDataLinkPlaySpawned)
			{
				datalinkPlay.Destroy();
				datalinkPlay = None;
			}
			return False;
		}
	}
	else
	{
		return False;
	}

	return false;
}

// ----------------------------------------------------------------------
// CheckFlagRefs()
//
// Loops through the flagrefs passed in and sees if the current flag
// settings in the game match this set of flags.  Returns True if so,
// otherwise False.
// ----------------------------------------------------------------------

function bool CheckFlagRefs( ConFlagRef flagRef )
{
	local ConFlagRef currentRef;

	// Loop through our list of FlagRef's, checking the value of each.
	// If we hit a bad match, then we'll stop right away since there's
	// no point of continuing.

	currentRef = flagRef;

	while( currentRef != None )
	{
		//if ( flagBase.GetBool(currentRef.flagName) != currentRef.value )
			//return False;

		if ( FlagReplicationInfo.GetBoolFlag( currentRef.flagName ) != currentRef.value )
			return False;

		currentRef = currentRef.nextFlagRef;
	}
	
	// If we made it this far, then the flags check out.
	return True;
}

// ----------------------------------------------------------------------
// GetActiveDataLink()
// 
// Loops through the conversations belonging to the player and checks
// to see if the datalink conversation passed in can be found.  Also
// checks to the "PlayedOnce" flag to prevent datalink transmissions
// from playing more than one (unless intended).
// ----------------------------------------------------------------------

function Conversation GetActiveDataLink(String datalinkName)
{
	local Name flagName;
	local ConListItem conListItem;
	local Conversation con;
	local bool bAbortDataLink;
	local bool bDatalinkFound;
	local bool bDataLinkNameFound;

	// Abort immediately if the flagbase isn't yet initialized
	//if ((flagBase == None) || (rootWindow == None))
	if ( rootWindow == None )
		return None;

	conListItem = ConListItem(conListItems);

	// In a loop, go through the conversations, checking each.
	while ( conListItem != None )
	{
		con = conListItem.con;

		if ( Caps(datalinkName) == Caps(con.conName) )
		{
			// Now check if this DataLink is only to be played
			// once 

			bDataLinkNameFound = True;
			bAbortDataLink = False;

			if ( con.bDisplayOnce )
			{
				//Log( "HXPlayerPawn.GetActiveDataLink() TODO: ADD CHECK IF ALREADY PLAYED" );
				//bAbortDataLink = False;

				flagName = StringToName(con.conName $ "_Played");		
				//bAbortDataLink = (flagBase.GetBool(flagName) == True);
				bAbortDataLink = (FlagReplicationInfo.GetBoolFlag(flagName) == True);
			}

			// Check the flags for this DataLink
			if (( !bAbortDataLink ) && ( CheckFlagRefs( con.flagRefList ) == True ))
			{
				bDatalinkFound = True;
				break;
			}
		}
		conListItem = conListItem.next;
	}

	if (bDatalinkFound)
	{
		return con;
	}
	else
	{
		// Print a warning if this DL couldn't be found based on its name
		if (bDataLinkNameFound == False)
		{
			log("WARNING! INFOLINK NOT FOUND!! Name = " $ datalinkName);
			ClientMessage("WARNING! INFOLINK NOT FOUND!! Name = " $ datalinkName);
		}
		return None;
	}
}

// ----------------------------------------------------------------------
// ClientResumeDataLinks()
// ----------------------------------------------------------------------

function ClientResumeDataLinks()
{
	if ( dataLinkPlay != None )
		dataLinkPlay.ResumeDataLinks();
}


// ----------------------------------------------------------------------
// AddNote()
//
// Adds a new note to the list of notes the player is carrying around.
// ----------------------------------------------------------------------

function DeusExNote AddNote( optional String strNote, optional Bool bUserNote, optional bool bShowInLog )
{
	local DeusExNote newNote;

	// None as Outer creates it under GObjTransientPkg.
	newNote = new(None,'',RF_Transient) Class'DeusExNote';

	newNote.text = strNote;
	newNote.SetUserNote( bUserNote );

	// Insert this new note at the top of the notes list
	if (FirstNote == None)
		LastNote  = newNote;
	else
		newNote.next = FirstNote;

	FirstNote = newNote;

	return newNote;
}

// ----------------------------------------------------------------------
// ClientAddNote()
//
// Adds a new note to the list of notes the player is carrying around.
// ----------------------------------------------------------------------

function ClientAddNote( optional String StrNote, optional bool bUserNote, optional Name TextTag )
{
	local HXRootWindow Root;
	local DeusExNote NewNote;

	if ( TextTag== '' || GetNote(TextTag)==None )
	{
		NewNote = AddNote( StrNote, bUserNote, false );
		NewNote.SetTextTag( TextTag );
	}
}

// ----------------------------------------------------------------------
// ClientDeleteAllNotes()
//
// Deletes *ALL* Notes
// ----------------------------------------------------------------------

function ClientDeleteAllNotes()
{
	local HXRootWindow Root;

	DeleteAllNotes();
}

// ----------------------------------------------------------------------
// AddGoal() -- UNUSED.
// ----------------------------------------------------------------------

function DeusExGoal AddGoal( Name GoalName, bool bPrimaryGoal )
{	
	Warn( "Called." );
	return None;
}

// ----------------------------------------------------------------------
// ClientAddGoal()
//
// Adds a new goal to the list of goals the player is carrying around.
// ----------------------------------------------------------------------

function ClientAddGoal( Name GoalName, bool bPrimaryGoal, optional String GoalText, optional bool bCompleted )
{	
	local HXRootWindow Root;
	local int i, Index;

	Log( Self $ ".ClientAddGoal( " $ GoalName $ ", " $ bPrimaryGoal $ ", \"" $ GoalText $ "\", " $ bCompleted $ " ) ", 'DevGoals' );

	if ( GoalName=='' )
		return;

	Index = -1;
	for ( i=0; i<ArrayCount(ClientGoals); i++ )
	{
		// Search for free slot.
		if ( ClientGoals[i].GoalName=='' && Index==-1 )
			Index = i;

		// Return if we already have this Goal.
		if ( ClientGoals[i].GoalName==GoalName )
			return; // Note: Maybe update?
	}

	// If we have not found an empty index, issue a warning.
	if ( Index==-1 )
	{
		Warn( "Failed to find free slot for new goal (" $ GoalName $ ")." );
		return;
	}

	// Update goal.
	ClientGoals[Index].GoalName     = GoalName;
	ClientGoals[Index].GoalText     = GoalText;
	ClientGoals[Index].bPrimaryGoal = bPrimaryGoal;
	ClientGoals[Index].bCompleted   = bCompleted;
}

// ----------------------------------------------------------------------
// ClientGoalCompleted()
//
// Looks up the goal and marks it as completed.
// ----------------------------------------------------------------------

function ClientGoalCompleted( Name GoalName )
{
	local HXRootWindow Root;
	local int i;

	Log( Self $ ".ClientGoalCompleted( " $ GoalName $ ") ", 'DevGoals' );

	if ( GoalName=='' )
		return;

	for ( i=0; i<ArrayCount(ClientGoals); i++ )
	{
		if ( ClientGoals[i].GoalName==GoalName )
		{
			ClientGoals[i].bCompleted = true;
			break;
		}
	}
}

// ----------------------------------------------------------------------
// ClientGoalCompleted()
//
// Deletes the specified goal by name. Returns True if found and deleted.
// ----------------------------------------------------------------------

function ClientDeleteGoalByName( Name GoalName )
{
	local HXRootWindow Root;
	local bool bDeleted;
	local int i;

	Log( Self $ ".ClientDeleteGoalByName( " $ GoalName $ ") ", 'DevGoals' );

	if ( GoalName=='' )
		return;

	for ( i=0; i<ArrayCount(ClientGoals); i++ )
	{
		// Compact remaining goals.
		if ( bDeleted )
		{
			ClientGoals[i].GoalName     = ClientGoals[i-1].GoalName;
			ClientGoals[i].GoalText     = ClientGoals[i-1].GoalText;
			ClientGoals[i].bPrimaryGoal = ClientGoals[i-1].bPrimaryGoal;
			ClientGoals[i].bCompleted   = ClientGoals[i-1].bCompleted;
		}
		else if ( ClientGoals[i].GoalName==GoalName )
		{
			// Clear goal.
			ClientGoals[i].GoalName     = ''; // Empty GoalName marks non existing goal.
			ClientGoals[i].GoalText     = "";
			ClientGoals[i].bPrimaryGoal = false;
			ClientGoals[i].bCompleted   = false;

			bDeleted = true;
		}
	}
}

// ----------------------------------------------------------------------
// ClientDeleteAllGoals()
//
// Deletes *ALL* Goals
// ----------------------------------------------------------------------

function ClientDeleteAllGoals()
{
	local HXRootWindow Root;
	local int i;

	for ( i=0; i<ArrayCount(ClientGoals); i++ )
	{
		// Update goal.
		ClientGoals[i].GoalName     = ''; // Empty GoalName marks non existing goal.
		ClientGoals[i].GoalText     = "";
		ClientGoals[i].bPrimaryGoal = false;
		ClientGoals[i].bCompleted   = false;
	}
}

// ----------------------------------------------------------------------
// ClientResetGoals()
// 
// Called when progressing to the next mission.  Deletes all 
// completed Primary Goals as well as *ALL* Secondary Goals 
// (regardless of status)
// ----------------------------------------------------------------------

function ClientResetGoals()
{
	local HXRootWindow Root;
	local int i;

	for ( i=0; i<ArrayCount(ClientGoals); i++ )
	{
		if ( ClientGoals[i].GoalName!='' )
		{
			// Delete:
			// 1) Completed Primary Goals
			// 2) ALL Secondary Goals
			if ( !ClientGoals[i].bPrimaryGoal || (ClientGoals[i].bPrimaryGoal && ClientGoals[i].bCompleted) )
			{
				// Update goal.
				ClientGoals[i].GoalName     = ''; // Empty GoalName marks non existing goal.
				ClientGoals[i].GoalText     = "";
				ClientGoals[i].bPrimaryGoal = false;
				ClientGoals[i].bCompleted   = false;
			}
		}
	}
}

// ----------------------------------------------------------------------
// GetClientGoalInfo()
//
// Wrapper needed because ClientGoals array is to large to be accessed
// from outside.
//
// Note: we can't return bools or a struct, thats why this int shit is
//       in here.
// ----------------------------------------------------------------------

function bool GetClientGoalInfo( int Index, out Name GoalName, out String GoalText, out int iPrimaryGoal, out int iCompleted )
{
	//Log( "GetClientGoalInfo()", 'DevGoals' );

	if ( ClientGoals[Index].GoalName=='' )
		return False;

	GoalName = ClientGoals[Index].GoalName;
	GoalText = ClientGoals[Index].GoalText;
	if ( ClientGoals[Index].bPrimaryGoal )
		iPrimaryGoal = 1;
	else
		iPrimaryGoal = 0;
	if ( ClientGoals[Index].bCompleted )
		iCompleted = 1;
	else
		iCompleted = 0;

	return True;
}

// ----------------------------------------------------------------------
// ClientAddImage()
//
// Inserts a new image in the user's list of images.  First checks to 
// make sure the player doesn't already have the image.  If not, 
// sticks the image at the top of the list.
// ----------------------------------------------------------------------

//function ClientAddImage(DataVaultImage newImage, optional bool bAnnotateImageAdded )
//{
	//local bool bImageAdded;
	//
	//bImageAdded = AddImage( newImage );
	//
	//if ( bAnnotateImageAdded && bImageAdded )
		//ClientMessage(Sprintf(class'HXInformationDevices'.default.AddedToDatavaultLabel, newImage.imageDescription));
//}


// ----------------------------------------------------------------------
// AddImage()
//
// Inserts a new image in the user's list of images.  First checks to 
// make sure the player doesn't already have the image.  If not, 
// sticks the image at the top of the list.
// ----------------------------------------------------------------------

function bool AddImage( DataVaultImage newImage )
{
	Log( "WARNING! " $ Self $ ".AddImage( " $ newImage $ " ) was called. REPORT THIS AS A BUG!" );

	return false;
}

// ----------------------------------------------------------------------
// ClientAddLog()
//
// Adds a log message to our FirstLog linked list
// ----------------------------------------------------------------------

function ClientAddLog( String LogText )
{
	AddLog( LogText );
}

// ----------------------------------------------------------------------
// HXCreateLogObject()
//
// Hope i don't miss anything
// ----------------------------------------------------------------------

function DeusExLog HXCreateLogObject()
{
	local DeusExLog newLog;

	//Log("HXGameInfo.CreateLogObject() called");

	// None as Outer creates it under GObjTransientPkg.
	newLog = new(None,'',RF_Transient) Class'DeusExLog';

	return newLog;
}

// ----------------------------------------------------------------------
// AddLog()
//
// Adds a log message to our FirstLog linked list
// ----------------------------------------------------------------------

function DeusExLog AddLog(String logText)
{
	local DeusExLog newLog;

	newLog = HXCreateLogObject();
	newLog.SetLogText(logText);

	// Add this Note to the list of player Notes
	if ( FirstLog != None )
		LastLog.next = newLog;
	else
		FirstLog = newLog;

	LastLog = newLog;

	return newLog;
}

// ----------------------------------------------------------------------
// ClientClearLog()
//
// Removes log objects
// ----------------------------------------------------------------------

function ClientClearLog()
{
	ClearLog();
}

// ----------------------------------------------------------------------
// ClearLog()
//
// Removes log objects
// ----------------------------------------------------------------------

function ClearLog()
{
	local DeusExLog log;
	local DeusExLog nextLog;

	log = FirstLog;

	while( log != None )
	{
		nextLog  = log.next;
		log.next = None; // Just to be safe.
		CriticalDelete(log);
		log = nextLog;
	}

	FirstLog = None;
	LastLog  = None;
}

// ----------------------------------------------------------------------------
// SetLogTimeout()
// ----------------------------------------------------------------------------

function SetLogTimeout( float InLogTimeout )
{
	// Variable should be set directly.
	Warn( "Called." );

	LogTimeout = InLogTimeout;
}

// ----------------------------------------------------------------------------
// GetLogTimeout()
// ----------------------------------------------------------------------------

function float GetLogTimeout()
{
	// Variable should be accessed directly.
	Warn( "Called." );

	return LogTimeout;
}

// ----------------------------------------------------------------------------
// SetMaxLogLines()
//
// MenuChoice exists, but never used ingame.
// ----------------------------------------------------------------------------

function SetMaxLogLines( byte InMaxLogLines )
{
	// Variable should be set directly.
	Warn( "Called." );

	MaxLogLines = InMaxLogLines;
}

// ----------------------------------------------------------------------------
// GetMaxLogLines()
//
// MenuChoice exists, but never used ingame.
// ----------------------------------------------------------------------------

simulated function byte GetMaxLogLines()
{
	// Variable should be accessed directly.
	Warn( "Called." );

	return MaxLogLines;
}

// ----------------------------------------------------------------------
// RefreshSystems()
// DEUS_EX AMSD For keeping multiplayer working in better shape
// ----------------------------------------------------------------------

simulated function RefreshSystems(float DeltaTime)
{
	local HXRootWindow root;

	// Check infoWindow 
	if ( rootWindow != None ) // EVIL HACK CHECK
	{
		if ( HXRootWindow(rootWindow).hud.info.IsVisible() && ( FrobTarget != CurrentInformationDevice ) )
		{
			// HX_NOTE: this should be delayed a bit, since frob target might not have been yet replicated (or maybe not an issue at all?)
			HideInformationDevicesWindow();
		}
	}

	if (Level.NetMode == NM_Standalone)
		return;

	if (Role == ROLE_Authority)
		return;
/*
	// LipSynch
	if ( bClientDoLipSynch )
	{
		// override
		bIsSpeaking = bClientIsSpeaking;
		bWasSpeaking = bClientWasSpeaking;

		ClientLipSynch(deltaTime);
	}
	else if ( bClientWasSpeaking || bWasSpeaking )
	{
		bWasSpeaking = False;
		TweenBlendAnim('MouthClosed', 0.1);
	}	

	// Looking at other actor during conversation
	if (HXConversationActor != None)
	{
		LookAtActor(HXConversationActor, true, true, true, 0, 1.0);
	}
	else
	{
		PlayTurnHead(LOOK_Forward, 1.0, 1.0);
	}
*/
	if (LastRefreshTime < 0)
		LastRefreshTime = 0;

	LastRefreshTime = LastRefreshTime + DeltaTime;

	if (LastRefreshTime < 0.25)
		return;

	if (AugmentationSystem != None)   
		AugmentationSystem.RefreshAugDisplay();

	root = HXRootWindow(rootWindow);

	if (root != None)    
		root.RefreshDisplay(LastRefreshTime);

	//RepairInventory();

	LastRefreshTime = 0;
}


// ----------------------------------------------------------------------
// ProcessInformationDevicesWindowTag()
// ----------------------------------------------------------------------

function bool ProcessInformationDevicesWindowTag(DeusExTextParser parser, out TextWindow winText, bool bSetText)
{
	local String text;
	local byte tag;
	local Name fontName;
	local String textPart;

	tag  = parser.GetTag();

	// Make sure we have a text window to operate on.
	if (winText == None)
	{
		winText = HXRootWindow(rootWindow).hud.info.AddTextWindow();
		bSetText = True;
	}

	switch(tag)
	{
		// If a winText window doesn't yet exist, create one.
		// Then add the text
		case 0:				// TT_Text:
		case 9:				// TT_PlayerName:
		case 10:			// TT_PlayerFirstName:
			text = parser.GetText();

			// Add the text
			if (bSetText)
				winText.SetText(text);
			else
				winText.AppendText(text);

			bSetText = False;
			break;

		// Create a new text window
		case 18:			// TT_NewParagraph:
			// Create a new text window
			winText = HXRootWindow(rootWindow).hud.info.AddTextWindow();
			bSetText = True;
			break;

		case 13:				// TT_LeftJustify:
			winText.SetTextAlignments(HALIGN_Left, VALIGN_Center);
			break;

		case 14:			// TT_RightJustify:
			winText.SetTextAlignments(HALIGN_Right, VALIGN_Center);
			break;

		case 12:				// TT_CenterText:
			winText.SetTextAlignments(HALIGN_Center, VALIGN_Center);
			break;

		case 15:			// TT_DefaultColor:
		case 16:			// TT_TextColor:
		case 17:			// TT_RevertColor:
			winText.SetTextColor(parser.GetColor());
			break;
	}

	return bSetText;
}

// ----------------------------------------------------------------------
// CreateInformationDevicesWindow()
// ----------------------------------------------------------------------

function CreateInformationDevicesWindow( HXInformationDevices InfoDevice )
{
	local DeusExTextParser parser;
	local DataVaultImage image;
	local TextWindow winText;				// Last text window we added
	local bool bSetText;

	// First check to see if we have a name
	if ( InfoDevice.textTag != '' )
	{
		// Create the text parser
		parser = new(None) Class'DeusExTextParser';
								    
		// Attempt to find the text object
		if (parser.OpenText(InfoDevice.textTag,InfoDevice.TextPackage))
		{
			parser.SetPlayerName(class'HXPlayerPawn'.default.TruePlayerName);

			HXRootWindow(rootWindow).hud.ShowInfoWindow();
			HXRootWindow(rootWindow).hud.info.ClearTextWindows();

			while(parser.ProcessText())
				bSetText = ProcessInformationDevicesWindowTag(parser, winText, bSetText);

			parser.CloseText();
		}
		CriticalDelete(parser);
	}

	// do we have any image data to give the player?
	//if ((imageClass != None) && (aReader != None))
	if (InfoDevice.imageClass != None)
	{
		// Display a note to the effect that there's an image here, 
		// but only if nothing else was displayed
		if (!HXRootWindow(rootWindow).hud.info.IsVisible())
		{
			// First make sure the player doesn't already have this image!!
			image = FirstImage;
			while(image != None)
			{
				if (InfoDevice.imageClass.default.imageDescription == image.imageDescription)
					return; // okay we already have this image

				image = image.NextImage;
			}

			HXRootWindow(rootWindow).hud.ShowInfoWindow();
			winText = HXRootWindow(rootWindow).hud.info.AddTextWindow();
			winText.SetText(Sprintf(InfoDevice.ImageLabel, InfoDevice.imageClass.default.imageDescription));
		}
	}
}

// ----------------------------------------------------------------------
// HideInformationDevicesWindow()
// ----------------------------------------------------------------------

function HideInformationDevicesWindow()
{
	HXRootWindow(rootWindow).hud.cross.SetCrosshair(bCrosshairVisible);
	HXRootWindow(rootWindow).hud.frobDisplay.Show();

	HXRootWindow(rootWindow).hud.info.ClearTextWindows();
	HXRootWindow(rootWindow).hud.info.Hide();

	CurrentInformationDevice = none;
}

// ----------------------------------------------------------------------
// ClientFrobInformationDevices()
// ----------------------------------------------------------------------

function ClientFrobInformationDevices( HXInformationDevices InfoDevice )
{
	if ( HXRootWindow(rootWindow).hud.info.IsVisible() )
	{
		HideInformationDevicesWindow();
	}
	else
	{
		CreateInformationDevicesWindow( InfoDevice );

		// hide the crosshairs if there's text to read, otherwise display a message
		if ( HXRootWindow(rootWindow).hud.info.IsVisible() )
		{
			HXRootWindow(rootWindow).hud.cross.SetCrosshair( False );
			HXRootWindow(rootWindow).hud.frobDisplay.Hide();

			CurrentInformationDevice = InfoDevice;
		}
		else
			ClientMessage( InfoDevice.msgNoText );
	}
}

// ----------------------------------------------------------------------------
// GetDefaultCollisionHeight()
// ----------------------------------------------------------------------------

function float GetDefaultCollisionHeight()
{
	return default.CollisionHeight;
}

// ----------------------------------------------------------------------------
// GetCrouchHeight()
// ----------------------------------------------------------------------------

simulated function float GetCrouchHeight()
{
	// SinglePlayer value.
	return 16.0;

	// DXMP value.
	//return 30.0;

	// Adjusted ScriptedPawn calculation (Results in 30.874989 for default player size).
	// This value looks correct at a quick glance ingame.
	//return default.CollisionHeight*0.718023;
}

// ----------------------------------------------------------------------------
// GetCurrentGroundSpeed()
// ----------------------------------------------------------------------------

function float GetCurrentGroundSpeed()
{
	local float augValue, speed;

	// Remove this later and find who's causing this to Access None MB
	if ( AugmentationSystem == None )
		return 0;

   augValue = AugmentationSystem.GetAugLevelValue(class'HXAugSpeed');

	if (augValue == -1.0)
		augValue = 1.0;

	//if (( Level.NetMode != NM_Standalone ) && Self.IsA('HXPlayerPawn') )
		//speed = HXPlayerPawn(Self).mpGroundSpeed * augValue;
	//else
		speed = Default.GroundSpeed * augValue;

	return speed;
}

// ----------------------------------------------------------------------------
// CreateDrone
// ----------------------------------------------------------------------------
function CreateDrone()
{
	local Vector loc;

	loc = (2.0 + class'HXSpyDrone'.Default.CollisionRadius + CollisionRadius) * Vector(ViewRotation);
	loc.Z = BaseEyeHeight;
	loc += Location;
	aHXDrone = Spawn(class'HXSpyDrone', Self,, loc, ViewRotation);
	if (aHXDrone != None)
	{
		aHXDrone.Speed = 3 * spyDroneLevelValue;
		aHXDrone.MaxSpeed = 3 * spyDroneLevelValue;
		aHXDrone.Damage = 5 * spyDroneLevelValue;
		aHXDrone.blastRadius = 8 * spyDroneLevelValue;
		// window construction now happens in Tick()
	}
}

// ----------------------------------------------------------------------------
// MoveDrone
// ----------------------------------------------------------------------------

simulated function MoveDrone( float DeltaTime, Vector loc )
{
	// if the wanted velocity is zero, apply drag so we slow down gradually
	if (VSize(loc) == 0)
   {
      aHXDrone.Velocity *= 0.9;
   }
	else
   {
      aHXDrone.Velocity += deltaTime * aHXDrone.MaxSpeed * loc;
   }

	// add slight bobbing
   // DEUS_EX AMSD Only do the bobbing in singleplayer, we want stationary drones stationary.
   /*if (Level.Netmode == NM_Standalone)*/
      aHXDrone.Velocity += deltaTime * Sin(Level.TimeSeconds * 2.0) * vect(0,0,1);
}

// ----------------------------------------------------------------------------
// DroneExplode
// ----------------------------------------------------------------------------

function DroneExplode()
{
	local HXAugDrone anAug;

	if (aHXDrone != None)
	{
		aHXDrone.Explode(aHXDrone.Location, vect(0,0,1));
      //DEUS_EX AMSD Don't blow up OTHER player drones...
      anAug = HXAugDrone(AugmentationSystem.FindAugmentation(class'HXAugDrone'));
		//foreach AllActors(class'HXAugDrone', anAug)			
      if (anAug != None)      
         anAug.Deactivate();
	}
}

// ----------------------------------------------------------------------------
// ForceDroneOff
// ----------------------------------------------------------------------------

function ForceDroneOff()
{
	local HXAugDrone anAug;

   anAug = HXAugDrone(AugmentationSystem.FindAugmentation(class'HXAugDrone'));
	//foreach AllActors(class'HXAugDrone', anAug)			
   if (anAug != None)      
      anAug.Deactivate();
}

// ----------------------------------------------------------------------------
// MultiplayerTick()
// Not the greatest name, handles single player ticks as well.  Basically
// anything tick style stuff that should be propagated to the server gets
// propagated as this one function call.
// ----------------------------------------------------------------------------
function MultiplayerTick( float DeltaTime )
{
	// Empty
	//Super(PlayerPawnExt).MultiplayerTick(DeltaTime);

	if ( PlayerIsClient() || Level.NetMode==NM_ListenServer )
	{
		if ( ShieldStatus!=SS_Off && DamageShield==None )
			DrawShield();
		if ( NintendoImmunityTimeLeft>0.0 && InvulnSph==None )
			DrawInvulnShield();

		if ( Style!=STY_Translucent )
			CreateShadow();
		else
			KillShadow();
	}

	if ( Role<ROLE_Authority )
		return;
}

// ----------------------------------------------------------------------------
// TickStuff()
// ----------------------------------------------------------------------------

simulated event TickStuff( float DeltaTime )
{
	local float AugLevel;
	local float f;
	local int BurnTime;
	local int i;

	// Nasty update function.
	if ( Role<ROLE_Authority )
	{
		bIsSpeaking = bClientIsSpeaking;
	}
	else
	{
		ClientCredits = Credits;
		bClientIsSpeaking	= bIsSpeaking;
	}

	// Update in hand.
	if ( Role>=ROLE_AutonomousProxy )
	{
		//If we've just put away items, reset this.
		if ( LastInHand!=InHand && Level.Netmode==NM_Client && InHand==None )
			ClientInHandPending = None;
		LastInHand = InHand;
		UpdateInHand();
	}

	if ( Role<ROLE_Authority )
	{
		ClientLipSynch( DeltaTime );
	}
	else if ( Role==ROLE_Authority )
	{
		// update our swimming info
		if ( IsInState('PlayerSwimming') )
		{
			DiveTimer -= deltaTime;
			DiveTimer = FMax(0, DiveTimer);
			if (DiveTimer > 0)
				PainTime = DiveTimer;
		}

		f = DiveTimer / DiveDuration * 255.0;
		//Log( "DiveTimer / DiveDuration * 255.0 = " $ f );
		i = Clamp( f, 0, 255 );
		//Log( "Clamp( f, 0, 255 ) = " $ i );
		ScaledBreathPercent = i;
		//Log( "ScaledBreathPercent = " $ ScaledBreathPercent );

		MaintainEnergy( DeltaTime );
		UpdatePoison( DeltaTime );

		if ( bOnFire )
		{
			BurnTime   = Class'HXWeaponFlamethrower'.Default.BurnTime;
			BurnTimer += DeltaTime;
			if ( BurnTimer>=BurnTime )
				ExtinguishFire();
		}

		// If we have a drone active (post-death etc) and we're not using the aug, kill it off
		AugLevel = AugmentationSystem.GetAugLevelValue( Class'HXAugDrone' );
		if ( aHXDrone!=None && AugLevel==-1.0 )
			aHXDrone.TakeDamage( 100, None, aHXDrone.Location, Vect(0,0,0), 'EMP' );

		if ( LastRefreshTime<0 )
			LastRefreshTime = 0;
		LastRefreshTime = LastRefreshTime + DeltaTime;

		if ( LastRefreshTime>0.25 )
		{
			/*if ( ShieldTimer>0 )
				ShieldTimer = ShieldTimer - LastRefreshTime;
			if (ShieldStatus==SS_Fade )
				ShieldStatus = SS_Off;
			if ( ShieldTimer<=0 && ShieldStatus==SS_Strong )
				ShieldStatus = SS_Fade;
			}*/

			if ( Level.TimeSeconds>ServerTimeLastRefresh )
			{
				SetServerTimeDiff( Level.Timeseconds );
				ServerTimeLastRefresh = Level.Timeseconds + 10.0;
			}
	
			UpdateTranslucency( LastRefreshTime );

			if ( bNintendoImmunity )
			{
				NintendoImmunityTimeLeft = NintendoImmunityTime - Level.Timeseconds;
				if ( Level.Timeseconds>NintendoImmunityTime )
					NintendoImmunityEffect( False );
			}
			LastRefreshTime = 0;
		}
	}
}

// ----------------------------------------------------------------------------
// MaintainEnergy()
// ----------------------------------------------------------------------------

function MaintainEnergy(float deltaTime)
{
	local Float energyUse;
	local Float energyRegen;

	// make sure we can't continue to go negative if we take damage
	// after we're already out of energy
	if (Energy <= 0)
	{
		Energy = 0;
		EnergyDrain = 0;
		EnergyDrainTotal = 0;
	}

	energyUse = 0;

	// Don't waste time doing this if the player is dead or paralyzed
	if ((!IsInState('Dying')) && (!IsInState('Paralyzed')))
	{
		if (Energy > 0)
		{
			// Decrement energy used for augmentations
			energyUse = AugmentationSystem.CalcEnergyUse(deltaTime);

			Energy -= EnergyUse;

			// Calculate the energy drain due to EMP attacks
			if (EnergyDrain > 0)
			{
				energyUse = EnergyDrainTotal * deltaTime;
				Energy -= EnergyUse;
				EnergyDrain -= EnergyUse;
				if (EnergyDrain <= 0)
				{
					EnergyDrain = 0;
					EnergyDrainTotal = 0;
				}
			}
		}

		//Do check if energy is 0.  
		// If the player's energy drops to zero, deactivate 
		// all augmentations
		if (Energy <= 0)
		{
			//If we were using energy, then tell the client we're out.
			//Otherwise just make sure things are off.  If energy was
			//already 0, then energy use will still be 0, so we won't
			//spam.  DEUS_EX AMSD
			if (energyUse > 0)         
				ClientMessage(EnergyDepleted);
			Energy = 0;
			EnergyDrain = 0;
			EnergyDrainTotal = 0;         
			HXAugmentationManager(AugmentationSystem).ForceDeactivateAll();
		}

		// If all augs are off, then start regenerating in multiplayer,
		// up to 25%.
		//if ((energyUse == 0) && (Energy <= MaxRegenPoint) && (Level.NetMode != NM_Standalone))
		//{
			//energyRegen = RegenRate * deltaTime;
			//Energy += energyRegen;
		//}
	}
}

// ----------------------------------------------------------------------------
// Timer()
//
// continually burn and do damage
// ----------------------------------------------------------------------------

function Timer()
{
	local int damage;

	if (!InConversation() && bOnFire)
	{
		//if ( Level.NetMode != NM_Standalone )
			//damage = Class'HXWeaponFlamethrower'.Default.mpBurnDamage;
		//else
			damage = Class'HXWeaponFlamethrower'.Default.BurnDamage;
		TakeDamage(damage, myBurner, Location, vect(0,0,0), 'Burned');

		if (HealthTorso <= 0)
		{
			TakeDamage(10, myBurner, Location, vect(0,0,0), 'Burned');
			ExtinguishFire();
		}
	}
}

// ----------------------------------------------------------------------------
// CatchFireNonRep()
// ----------------------------------------------------------------------------

function CatchFire( Pawn burner )
{
	// replication is fucked up, so get rid of it
}

// ----------------------------------------------------------------------------
// CatchFireNonRep()
// ----------------------------------------------------------------------------

function CatchFireNonRep( Pawn burner )
{
	local Fire f;
	local int i;
	local vector loc;

	//Log( Self $ ".CatchFire( " $ burner $ " ) called." );

	myBurner = burner;

	burnTimer = 0;

   if (bOnFire || Region.Zone.bWaterZone)
		return;

	bOnFire = True;
	burnTimer = 0;

	for (i=0; i<8; i++)
	{
		loc.X = 0.5*CollisionRadius * (1.0-2.0*FRand());
		loc.Y = 0.5*CollisionRadius * (1.0-2.0*FRand());
		loc.Z = 0.6*CollisionHeight * (1.0-2.0*FRand());
		loc += Location;

      // DEUS_EX AMSD reduce the number of smoke particles in multiplayer
      // by creating smokeless fire (better for server propagation).
      //if ((Level.NetMode == NM_Standalone) || (i <= 0))		
         f = Spawn(class'Fire', Self,, loc);
      //else
         //f = Spawn(class'SmokelessFire', Self,, loc);

		if (f != None)
		{
			f.DrawScale = 0.5*FRand() + 1.0;

         //DEUS_EX AMSD Reduce the penalty in multiplayer
         //if (Level.NetMode != NM_Standalone)
            //f.DrawScale = f.DrawScale * 0.5;

			// turn off the sound and lights for all but the first one
			if (i > 0)
			{
				f.AmbientSound = None;
				f.LightType = LT_None;
			}

			// turn on/off extra fire and smoke
         // MP already only generates a little.
			if (FRand() < 0.5) // if ((FRand() < 0.5) && (Level.NetMode == NM_Standalone))
				f.smokeGen.Destroy();
			if (FRand() < 0.5) // if ((FRand() < 0.5) && (Level.NetMode == NM_Standalone))
				f.AddFire();
		}
	}

	// set the burn timer
	SetTimer(1.0, True);
}

// ----------------------------------------------------------------------------
// PlayDXTakeDamageHit()
// DEUS_EX AMSD Created as a separate function to avoid extra calls to
// DXReduceDamage, which is slow in multiplayer
// ----------------------------------------------------------------------------

function PlayDXTakeDamageHit(float Damage, vector HitLocation, name damageType, vector Momentum, bool DamageReduced)
{
	local float rnd;

	PlayHit(Damage,HitLocation,damageType,Momentum);

	// if we actually took the full damage, flash the screen and play the sound
   // DEUS_EX AMSD DXReduceDamage is slow.  Pass in the result from earlier.
	if (!DamageReduced) 
	{
		if ( (damage > 0) || (ReducedDamageType == 'All') )
		{
			rnd = FClamp(Damage, 20, 100);

			switch ( DamageType )
			{
				case 'Burned':        ClientFlash(rnd * 0.002, vect(200,100,100)); ShakeView( 0.15+0.002*Damage, Damage*30, 0.3*Damage ); break;
				case 'Flamed':        ClientFlash(rnd * 0.002, vect(200,100,100)); ShakeView( 0.15+0.002*Damage, Damage*30, 0.3*Damage ); break;
				case 'Radiation':     ClientFlash(rnd * 0.002, vect(100,100,  0)); ShakeView( 0.15+0.002*Damage, Damage*30, 0.3*Damage ); break;
				case 'PoisonGas':     ClientFlash(rnd * 0.002, vect( 50,150,  0)); ShakeView( 0.15+0.002*Damage, Damage*30, 0.3*Damage ); break;
				case 'TearGas':       ClientFlash(rnd * 0.002, vect(150,150,  0)); ShakeView( 0.15+0.002*Damage, Damage*30, 0.3*Damage ); break;
				case 'Drowned':       ClientFlash(rnd * 0.002, vect(  0,100,200)); ShakeView( 0.15+0.002*Damage, Damage*30, 0.3*Damage ); break;
				case 'EMP':           ClientFlash(rnd * 0.002, vect(  0,200,200)); ShakeView( 0.15+0.002*Damage, Damage*30, 0.3*Damage ); break;
				case 'CoughingNails': ClientFlash(rnd * 0.002, vect( 25, 25, 25)); ShakeView( 0.15+0.002*Damage,         0, 0.3*Damage ); break;
				case 'Plague':        ClientFlash(rnd * 0.002, vect( 25, 25, 25)); ShakeView( 0.15+0.002*Damage,         0, 0.3*Damage ); break;
				default:              ClientFlash(rnd * 0.002, vect( 50,  0,  0)); ShakeView( 0.15+0.002*Damage, Damage*30, 0.3*Damage ); break;
			}

			
		}
	}
}

// ----------------------------------------------------------------------------
// PlayHit()
// ----------------------------------------------------------------------------

function PlayHit(float Damage, vector HitLocation, name damageType, vector Momentum)
{
	if ((Damage > 0) && (damageType == 'Shot') || (damageType == 'Exploded') || (damageType == 'AutoShot'))
		SpawnBlood(HitLocation, Damage);

	PlayTakeHitSound(Damage, damageType, 1);
}

// ----------------------------------------------------------------------------
// PlayDeathHit()
// ----------------------------------------------------------------------------

function PlayDeathHit(float Damage, vector HitLocation, name damageType, vector Momentum)
{
	PlayDying(damageType, HitLocation);
}

// ----------------------------------------------------------------------------
// UpdateClientSkillPoints()
// ----------------------------------------------------------------------------

function UpdateClientSkillPoints( int newSkillPointsAvail, int newSkillPointsTotal )
{
	if ((HXRootWindow(rootWindow) != None) &&
		  (HXRootWindow(rootWindow).hud != None) && 
		(HXRootWindow(rootWindow).hud.msgLog != None))
	{

		HXRootWindow(rootWindow).hud.msgLog.PlayLogSound(Sound'LogSkillPoints');
	}
}

// ----------------------------------------------------------------------------
// CalculateSkillHealAmount()
// ----------------------------------------------------------------------------

function int CalculateSkillHealAmount(int baseHealPoints)
{
	local float mult;
	local int adjustedHealAmount;

	// check skill use
	if (SkillSystem != None)
	{
		mult = SkillSystem.GetSkillLevelValue(class'HXSkillMedicine');

		// apply the skill
		adjustedHealAmount = baseHealPoints * mult;
	}

	return adjustedHealAmount;
}

// ----------------------------------------------------------------------------
// HealPlayer()
//
// Original second parameter was bUseMedicalSkill. This is now expected
// to be handled by external code.
// ----------------------------------------------------------------------------

function int HealPlayer( int HealPoints, optional bool bNoClientMessage )
{
	local int RemainingHealPoints, SpentHealPoints;

	if ( Level.NetMode==NM_Client )
		return 0;

	if ( HealPoints<=0 )
	{
		Warn( "Expected HealPoints>0" );
		return 0;
	}

	RemainingHealPoints = HealPoints;

	HealPart( HealthHead,     RemainingHealPoints );
	HealPart( HealthTorso,    RemainingHealPoints );
	HealPart( HealthLegRight, RemainingHealPoints );
	HealPart( HealthLegLeft,  RemainingHealPoints );
	HealPart( HealthArmRight, RemainingHealPoints );
	HealPart( HealthArmLeft,  RemainingHealPoints );

	GenerateTotalHealth();

	SpentHealPoints = HealPoints - RemainingHealPoints;

	if ( !bNoClientMessage )
	{
		if ( SpentHealPoints==1 )
			ClientMessage( MsgHealedPoint );
		else
			ClientMessage( Sprintf(MsgHealedPoints,SpentHealPoints) );
	}

	return SpentHealPoints;
}

// ----------------------------------------------------------------------------
// HealPart()
// ----------------------------------------------------------------------------

function HealPart(out int points, out int amt)
{
	local int spill;

	points += amt;
	spill = points - 100;
	if (spill > 0)
		points = 100;
	else
		spill = 0;

	amt = spill;
}

// ----------------------------------------------------------------------------
// RechargePlayer()
// ----------------------------------------------------------------------------

function int RechargePlayer( int ChargePoints, optional bool bNoClientMessage )
{
	local int SpentChargePoints;

	if ( Level.NetMode==NM_Client )
		return 0;

	if ( ChargePoints<=0.0 )
	{
		Warn( "Expected ChargePoints>0.0" );
		return 0;
	}

	// Does this round correctly?
	SpentChargePoints = Min( EnergyMax-int(Energy), ChargePoints );
	Energy += SpentChargePoints;

	if ( !bNoClientMessage )
	{
		if ( SpentChargePoints==1 )
			ClientMessage( MsgRechargedPoint, 'StatusLine' );
		else
			ClientMessage( Sprintf(MsgRechargedPoints,SpentChargePoints), 'StatusLine' );
	}

	return SpentChargePoints;
}
function int ChargePlayer( int ChargePoints )
{
	return RechargePlayer( ChargePoints, true );
}

// ----------------------------------------------------------------------------
// DrugPlayer()
// ----------------------------------------------------------------------------

function DrugPlayer( float Duration )
{
	if ( Level.NetMode==NM_Client )
		return;

	if ( Duration<0 )
	{
		Warn( "Expected positive definite Duration" );
		return;
	}

	DrugEffectTimer += Duration;
}

// ----------------------------------------------------------------------------
// Landed()
//
// copied from Engine.PlayerPawn new landing code for Deus Ex
// zero damage if falling from 15 feet or less
// scaled damage from 15 to 60 feet
// death over 60 feet
// ----------------------------------------------------------------------------

function Landed(vector HitNormal)
{
  local vector legLocation;
	local int augLevel;
	local float augReduce, dmg;

	//Note - physics changes type to PHYS_Walking by default for landed pawns
	PlayLanded(Velocity.Z);
	if (Velocity.Z < -1.4 * JumpZ)
	{
		MakeNoise(-0.5 * Velocity.Z/(FMax(JumpZ, 150.0)));
		if ((Velocity.Z < -700) && (ReducedDamageType != 'All'))
			if ( Role == ROLE_Authority )
      {
				// check our jump augmentation and reduce falling damage if we have it
				// jump augmentation doesn't exist anymore - use Speed instaed
				// reduce an absolute amount of damage instead of a relative amount
				augReduce = 0;
				if (AugmentationSystem != None)
				{
					augLevel = AugmentationSystem.GetClassLevel(class'HXAugSpeed');
					if (augLevel >= 0)
						augReduce = 15 * (augLevel+1);
				}

				dmg = Max((-0.16 * (Velocity.Z + 700)) - augReduce, 0);
				legLocation = Location + vect(-1,0,-1);			// damage left leg
				TakeDamage(dmg, None, legLocation, vect(0,0,0), 'fell');

				legLocation = Location + vect(1,0,-1);			// damage right leg
				TakeDamage(dmg, None, legLocation, vect(0,0,0), 'fell');

				dmg = Max((-0.06 * (Velocity.Z + 700)) - augReduce, 0);
				legLocation = Location + vect(0,0,1);			// damage torso
				TakeDamage(dmg, None, legLocation, vect(0,0,0), 'fell');
            }
	}
	else if ( (Level.Game != None) && (Level.Game.Difficulty > 1) && (Velocity.Z > 0.5 * JumpZ) )
		MakeNoise(0.1 * Level.Game.Difficulty);				
	bJustLanded = true;
}


// ----------------------------------------------------------------------------
// DoJump()
// 
// copied from Engine.PlayerPawn
// Modified to let you jump if you are carrying something rather light
// You can also jump if you are crouching, just at a much lower height
// ----------------------------------------------------------------------------

function DoJump( optional float F )
{
	local HXWeapon w;
	local float scaleFactor, augLevel;

	if ((CarriedDecoration != None) && (CarriedDecoration.Mass > 20))
		return;
	else if (bForceDuck || IsLeaning())
		return;

	if (Physics == PHYS_Walking)
	{
		if ( Role == ROLE_Authority )
			PlaySound(JumpSound, SLOT_None, 1.5, true, 1200, 1.0 - 0.2*FRand() );
		if ( (Level.Game != None) && (Level.Game.Difficulty > 0) )
			MakeNoise(0.1 * Level.Game.Difficulty);
		PlayInAir();

		Velocity.Z = JumpZ;

		//if ( Level.NetMode != NM_Standalone )
		//{
         //if (AugmentationSystem == None)
            //augLevel = -1.0;
         //else			
            //augLevel = AugmentationSystem.GetAugLevelValue(class'HXAugSpeed');
			//w = HXWeapon(InHand);
			//if ((augLevel != -1.0) && ( w != None ) && ( w.Mass > 30.0))
			//{
				//scaleFactor = 1.0 - FClamp( ((w.Mass - 30.0)/55.0), 0.0, 0.5 );
				//Velocity.Z *= scaleFactor;
			//}
		//}
		
		// reduce the jump velocity if you are crouching
//		if (bIsCrouching)
//			Velocity.Z *= 0.9;

		if ( Base != Level && Base != None )
			Velocity.Z += Base.Velocity.Z;
		SetPhysics(PHYS_Falling);
		if ( bCountJumps && (Role == ROLE_Authority) && (Inventory != None) )
			Inventory.OwnerJumped();
	}
}

// ----------------------------------------------------------------------------
// GetWallMaterial()
//
// gets the name of the texture group that we are facing
// ----------------------------------------------------------------------------

function name GetWallMaterial(out vector wallNormal)
{
	local vector EndTrace, HitLocation, HitNormal;
	local Actor TraceTarget;
	local int TexFlags, GrabDist;
	local name TexName, TexGroup;
	local Texture Tex;

	// if we are falling, then increase our grabbing distance
	if (Physics == PHYS_Falling)
		GrabDist = 3.0;
	else
		GrabDist = 1.5;

	// trace out in front of us
	EndTrace = Location + (Vector(Rotation) * CollisionRadius * GrabDist);

 	foreach TraceTextures(class'Actor', TraceTarget, Tex, TexName, TexGroup, TexFlags, HitLocation, HitNormal, EndTrace)
	{
		if ((target == Level) || TraceTarget.IsA('Mover'))
			break;
	}

	wallNormal = HitNormal;

	return TexGroup;
}

// ----------------------------------------------------------------------------
// GetFloorMaterial()
//
// gets the name of the texture group that we are standing on
// ----------------------------------------------------------------------------

function name GetFloorMaterial()
{
	local vector EndTrace, HitLocation, HitNormal;
	local actor TraceTarget;
	local int texFlags;
	local name texName, texGroup;
	local Texture Tex;

	// trace down to our feet
	EndTrace = Location - CollisionHeight * 2 * vect(0,0,1);

	foreach TraceTextures(class'Actor', TraceTarget, Tex, TexName, TexGroup, TexFlags, HitLocation, HitNormal, EndTrace)
	{
		if ( TraceTarget == Level )
			break;
	}

	return TexGroup;
}

exec function TT2()
{
	local vector EndTrace, HitLocation, HitNormal;
	local actor TraceTarget;
	local int texFlags;
	local name texName, texGroup;
	local Texture Tex;

	// trace down to our feet
	EndTrace = Location - CollisionHeight * 3 * vect(0,0,1);

	Log( "----[TraceTextures]-----------------------------------------------", 'TraceTextures' );

	TexName = 'GimmeDebug';

	foreach TraceTextures(class'Actor', TraceTarget, Tex, TexName, TexGroup, TexFlags, HitLocation, HitNormal, EndTrace)
	{
		Log( "Target =" @ TraceTarget @",Tex ="@ Tex @",TexName ="@ TexName @"TexGroup ="@TexGroup@"TexFlags ="@TexFlags, 'TraceTexture' );

		if ( (TraceTarget == Level) || TraceTarget.IsA('Mover') )
		{
			FloorMaterial = texGroup;
			PlayFootStep();
			Log( "======================================================================", 'TraceTextures' );
		}
		else
			Log( "----------------------------------------------------------------------", 'TraceTextures' );
	}
}

// ----------------------------------------------------------------------------
// PlayFootStep()
// ----------------------------------------------------------------------------

simulated function PlayFootStep()
{
	local Sound StepSound;
	local float SpeedFactor, MassFactor;
	local float Volume, AIVolumeMul;
	local float Pitch, Range, Radius;

	// (Might just fix it for ListenServer).
	if ( IsInState('CheatFlying') )
		return;

	StepSound = FootStepSound( Volume, AIVolumeMul );

	// Account for the somewhat lower maximum Velocity when climbing a ladder.
	if ( bOnLadder )
	{
		// FIX-ME: Figure out a way to scale it.
		SpeedFactor = 2.0;
	}
	// Base SpeedFactor on WaterSpeed instead of Velocity when Swimming.
	if ( IsInState('PlayerSwimming') || Physics==PHYS_Swimming )
	{
		SpeedFactor = WaterSpeed/180.0;
	}
	// Walking on Ground.
	else
	{
		SpeedFactor = VSize(Velocity)/180.0;
	}

	// Compute sound volume, range and pitch, based on mass and speed.
	MassFactor  = Mass/150.0;
	Radius      = 375.0;
	Volume     *= (speedFactor+0.2) * massFactor;
	Range       = radius * volume;
	Pitch       = (volume+0.5);
	Volume      = FClamp(volume, 0, 1.0) * 0.5;		// Hack to compensate for increased footstep volume.											
	Range       = FClamp(range, 0.01, radius*4);
	Pitch       = FClamp(pitch, 1.0, 1.5);

	// AugStealth decreases our footstep volume
	Volume     *= RunSilentValue;

	// HX_HAN: Slightly vary playback volume.
	PlaySound( StepSound, SLOT_Interact, Volume*(0.9+0.2*FRand()),, Range, Pitch );

	// Only do this on the server
	if ( Level.NetMode!=NM_Client )
		AISendEvent( 'LoudNoise', EAITYPE_Audio, Volume*AIVolumeMul, Range*AIVolumeMul );
}

// ----------------------------------------------------------------------------
// FootStepSound()
//
// Tries to figure out which footstep sound to use.
//
// Potential Additional Footstep Sounds:
//	* MoverSFX.StallDoorClose
//  * DeusExSounds.KarkianFootstep
//  * DeusExSounds.GreaselFootstep
//  * DeusExSounds.GrayFootstep
//
// Note:
//  * Maybe add FootSteps for Fragment.
// ----------------------------------------------------------------------------

simulated function Sound FootStepSound( out float Volume, out float AIVolumeMul )
{
	local Vector       End, HitLoc, HitNorm;
	local Actor        TraceTarget;
	local int          TexFlags;
	local Name         TexName, TexGroup;
	local Texture      Tex;
	//local Mover        Mover;
	local Decoration   Decoration;
	local Carcass      Carcass;
	local float        Rnd;

	Volume	    = 1.0;
	AIVolumeMul = 1.0;

	// Handle Ladders.
	if ( bOnLadder )
		return LadderStepSound( Volume, AIVolumeMul );
	// Handle Swimming.
	if ( IsInState('PlayerSwimming') || Physics==PHYS_Swimming )
		return SwimmingStepSound( Volume, AIVolumeMul );
	// Handle shallow Waters.
	if ( FootRegion.Zone.bWaterZone )
		return WaterStepSound( Volume, AIVolumeMul );

	// trace down to our feet
	End = Location - CollisionHeight * 2 * vect(0,0,1);

	foreach TraceTextures( Class'Actor', TraceTarget, Tex, TexName, TexGroup, TexFlags, HitLoc, HitNorm, End )
	{
		// Vanilla behaviour for Level Geometry.
		//if ( TraceTarget==Level )
		if ( TraceTarget==Level || Mover(TraceTarget)!=None )
		{
			// ZonePortals, etc.
			if ( Texture==None && TexFlags==0 )
				continue;
			return TextureGroupStepSound( Volume, AIVolumeMul, Tex, TexGroup );
		}

		// Carcass.
		Carcass = Carcass(TraceTarget);
		if ( Carcass!=None ) 
			return CarcassStepSound( Volume, AIVolumeMul, Carcass );

		// Choose Decoration FootStepSound based on FragType.
		Decoration = Decoration(TraceTarget);
		if ( Decoration!=None )
			return DecorationStepSound( Volume, AIVolumeMul, Decoration );

		// Not yet supported.
		//Mover = Mover(TraceTarget);
		//if ( Mover != None )
			//;
	}
	return FallbackStepSound( Volume, AIVolumeMul );
}

// ----------------------------------------------------------------------------
// TextureGroupStepSound()
//
// Used for Bsp based footsteps.
// ----------------------------------------------------------------------------

simulated function Sound TextureGroupStepSound( out float Volume, out float AIVolumeMul, Texture Texture, Name TextureGroup )
{
	local float Rnd;

	// Set Volume and VolumeMul first.
	switch ( TextureGroup )
	{
		case 'Metal':
		case 'Ladder':
			AIVolumeMul = 1.0;
			break;
		case 'Foliage':
		case 'Earth':
			AIVolumeMul = 0.6;
			break;
		default:
			AIVolumeMul = 0.7;
			break;
	}

	// Use Texture.FootstepSound if available.
	if ( Texture!=None  && Texture.FootstepSound!=None )
		return Texture.FootstepSound;

	Rnd = FRand();
	switch ( TextureGroup )
	{
		case 'Textile':
		case 'Paper':
			Volume *= 0.8;
		case 'Plastic':
			AIVolumeMul = 0.4;
			if (Rnd < 0.25) return Sound'CarpetStep1';
			if (Rnd < 0.5)  return Sound'CarpetStep2';
			if (Rnd < 0.75) return Sound'CarpetStep3';
			else            return Sound'CarpetStep4';
			break;

		case 'Foliage':
		case 'Earth':
			AIVolumeMul = 0.55;
			if (Rnd < 0.25) return Sound'GrassStep1';
			if (Rnd < 0.5)  return Sound'GrassStep2';
			if (Rnd < 0.75) return Sound'GrassStep3';
			else            return Sound'GrassStep4';
			break;

		case 'Metal':
		case 'Ladder':
			AIVolumeMul = 1.0;
			if (Rnd < 0.25) return Sound'MetalStep1';
			if (Rnd < 0.5)  return Sound'MetalStep2';
			if (Rnd < 0.75) return Sound'MetalStep3';
			else            return Sound'MetalStep4';
			break;

		case 'Ceramic':
		case 'Glass':
		case 'Tiles':
			AIVolumeMul = 0.7;
			if (Rnd < 0.25) return Sound'TileStep1';
			if (Rnd < 0.5)  return Sound'TileStep2';
			if (Rnd < 0.75) return Sound'TileStep3';
			else            return Sound'TileStep4';
			break;

		case 'Wood':
			AIVolumeMul = 0.7;
			if (Rnd < 0.25) return Sound'WoodStep1';
			if (Rnd < 0.5)  return Sound'WoodStep2';
			if (Rnd < 0.75) return Sound'WoodStep3';
			else            return Sound'WoodStep4';
			break;

		case 'Brick':
		case 'Concrete':
		case 'Stone':
		case 'Stucco':
		default:
			AIVolumeMul = 0.7;
			if (Rnd < 0.25) return Sound'StoneStep1';
			if (Rnd < 0.5)  return Sound'StoneStep2';
			if (Rnd < 0.75) return Sound'StoneStep3';
			else            return Sound'StoneStep4';
			break;
	}
}

// ----------------------------------------------------------------------------
// CarcassStepSound()
//
// StepSound for walking over carcass.
// ----------------------------------------------------------------------------

simulated function Sound CarcassStepSound( out float Volume, out float AIVolumeMul, Carcass Carcass )
{
	AIVolumeMul = 0.5;
	Volume      = 0.5;
	return Sound'KarkianFootstep';
}

// ----------------------------------------------------------------------------
// DecorationStepSound()
//
// StepSound for walking over carcass.
// ----------------------------------------------------------------------------

simulated function Sound DecorationStepSound( out float Volume, out float AIVolumeMul, Decoration Decoration )
{
	local DeusExDecoration DeusExDecoration;
	local HXDecoration HXDecoration;
	local Class<Fragment> FragmentClass;

	HXDecoration = HXDecoration(Decoration);
	if ( HXDecoration!=None )
	{
		FragmentClass = HXDecoration.FragType;
	}
	else
	{
		DeusExDecoration = DeusExDecoration(Decoration);
		if ( DeusExDecoration!=None )
			FragmentClass = DeusExDecoration.FragType;
	} 

	if ( FragmentClass==None )
	{
		Log( Decoration@"has empty FragType. Report this as a Bug." );
		//return Sound'TouchTone11';
		return FallbackStepSound( Volume, AIVolumeMul );
	}

	switch ( FragmentClass.Name ) 
	{
		case 'GlassFragment':		return TextureGroupStepSound( Volume, AIVolumeMul, None, 'Glass' );
		case 'MetalFragment':		return TextureGroupStepSound( Volume, AIVolumeMul, None, 'Metal' );
		case 'PaperFragment':
			AIVolumeMul = 0.3;
			Volume      = 0.8;
			return Sound'StallDoorClose';
		case 'PlasticFragment':	return TextureGroupStepSound( Volume, AIVolumeMul, None, 'Textile' );
		case 'WoodFragment':		return TextureGroupStepSound( Volume, AIVolumeMul, None, 'Wood' );
		case 'Rockchip':				return TextureGroupStepSound( Volume, AIVolumeMul, None, 'Concrete' );
		case 'FleshFragment':
			AIVolumeMul = 0.5;
			Volume      = 0.5;
			return Sound'KarkianFootstep';
		default:
			Log( "Unhandled FragmentClass="$FragmentClass$" in GetFootStepGroup() Report this as a Bug." );
			//return Sound'TouchTone5';
			return FallbackStepSound( Volume, AIVolumeMul );
	}
}

// ----------------------------------------------------------------------------
// FallbackStepSound()
// ----------------------------------------------------------------------------

simulated function Sound FallbackStepSound( out float Volume, out float AIVolumeMul )
{
	return TextureGroupStepSound( Volume, AIVolumeMul, None, 'Brick' );
}

// ----------------------------------------------------------------------------
// LadderStepSound()
// ----------------------------------------------------------------------------

simulated function Sound LadderStepSound( out float Volume, out float AIVolumeMul )
{
	local float Rnd;
	AIVolumeMul = 1.0;

	// FIX-ME: Handle climbing with foots in water.
	//if ( FootRegion.Zone.bWaterZone ) {}

	// Use LadderTexture.FootstepSound if available.
	if ( LadderTexture!=None && LadderTexture.FootstepSound!=None )
		return LadderTexture.FootstepSound;

	// Otherwise randomly select a MetalStep Sound.
	Rnd = FRand();
	if (Rnd < 0.25) return Sound'MetalStep1';
	if (Rnd < 0.5)  return Sound'MetalStep2';
	if (Rnd < 0.75) return Sound'MetalStep3';
	else            return Sound'MetalStep4';
}

// ----------------------------------------------------------------------------
// SwimmingStepSound()
// ----------------------------------------------------------------------------

simulated function Sound SwimmingStepSound( out float Volume, out float AIVolumeMul )
{
	AIVolumeMul = 0.5;
	if ( FRand()<0.5 )
		return Sound'Swimming';
	else
		return Sound'Treading';
}

// ----------------------------------------------------------------------------
// WaterStepSound()
// ----------------------------------------------------------------------------

simulated function Sound WaterStepSound( out float Volume, out float AIVolumeMul )
{
	local float Rnd;
	AIVolumeMul = 1.0;
	Rnd = FRand();
	if ( Rnd<0.33 )
		return Sound'WaterStep1';
	if ( Rnd<0.66 ) 
		return Sound'WaterStep2';
	else
		return Sound'WaterStep3';
}

// ----------------------------------------------------------------------------
// TakeDamage()
// ----------------------------------------------------------------------------

function TakeDamage( int Damage, Pawn InstigatedBy, Vector HitLocation, Vector Momentum, name DamageType )
{
	local int ActualDamage;
	local bool bAlreadyDead, bPlayAnim, bDamageGotReduced;
	local Vector Offset, Dst;
	local float HeadOffsetZ, HeadOffsetY, ArmOffset;
	local float OrigHealth, FDst;
	local DeusExLevelInfo Info;
	local HXWeapon DXW;
	local String BodyString;
	local HXGameInfo HXGame;

	if ( bNintendoImmunity )
		return;

	HXGame = HXGameInfo(Level.Game);

	BodyString = "";
	OrigHealth = Health;

	// Use the hitlocation to determine where the pawn is hit
	// transform the worldspace hitlocation into objectspace
	// in objectspace, remember X is front to back
	// Y is side to side, and Z is top to bottom
	Offset = (HitLocation-Location) << Rotation;

	// Add a HUD icon for this damage type
	if ( DamageType=='Poison' || DamageType=='PoisonEffect' || DamageType=='CoughingNails' || DamageType=='Plague' )  // hack
		AddDamageDisplay( 'PoisonGas', Offset );
	else
		AddDamageDisplay( DamageType, Offset );

	// Nanovirus damage doesn't affect us
	if ( DamageType=='NanoVirus' )
		return;

	// Handle poison
	if ( DamageType=='Poison' )
	{
		StartPoison( InstigatedBy, Damage );
	}

	// Reduce our damage correctly.
	if ( ReducedDamageType==DamageType )
		ActualDamage = float(ActualDamage) * (1.0 - ReducedDamagePct);

	// check for augs or inventory items
	bDamageGotReduced = DXReduceDamage( Damage, DamageType, HitLocation, ActualDamage, False );

	// God mode.
	if ( ReducedDamageType=='All' )
		ActualDamage = 0;

	// Friendly fire adjustment
	if ( Level.NetMode!=NM_Standalone )
		if ( InstigatedBy!=None && InstigatedBy!=Self && HXGame!=None && InstigatedBy.IsA('HXPlayerPawn') )
			ActualDamage *= HXGame.FriendlyFire;

	// EMP attacks drain BE energy.
	if ( DamageType=='EMP' )
	{
		EnergyDrain      += ActualDamage;
		EnergyDrainTotal += ActualDamage;
		PlayTakeHitSound( ActualDamage, DamageType, 1 );
		return;
	}

	// Figure out whether to play a hit animation.
	switch ( DamageType )
	{
		// If we're burning, don't play a hit anim when taking burning damage.
		// Also don't play an animation if someone uses the fire extinguisher on us.
		case 'Burned':
		case 'HalonGas':
		case 'CoughingNails':
		case 'Plague':
			bPlayAnim = false;
			break;

		default:
			bPlayAnim = true;
			break;
	}

	if ( Physics==PHYS_None )
		SetMovementPhysics();
	if ( Physics==PHYS_Walking )
		Momentum.Z = 0.4 * VSize(Momentum);
	if ( InstigatedBy==Self )
		Momentum *= 0.6;
	Momentum = Momentum/Mass;
	//	AddVelocity( Momentum ); // Doesn't do anything anyway

	// calculate our hit extents
	HeadOffsetZ = CollisionHeight * 0.78;
	HeadOffsetY = CollisionRadius * 0.35;
	ArmOffset   = CollisionRadius * 0.35;

	// Normal damage code path as used for single player.
	if ( Offset.z>HeadOffsetZ ) // Head.
	{
		// Narrow the head region
		if ( Abs(Offset.x)<HeadOffsetY || Abs(Offset.y)<HeadOffsetY )
		{
			HealthHead -= ActualDamage * 2;
			if ( bPlayAnim )
				PlayAnim( 'HitHead', , 0.1 );
		}
	}
	else if ( Offset.z<0.0 ) // Legs.
	{
		if ( Offset.y>0.0 )
		{
			HealthLegRight -= ActualDamage;
			if ( bPlayAnim )
				PlayAnim( 'HitLegRight', , 0.1 );
		}
		else
		{
			HealthLegLeft -= actualDamage;
			if ( bPlayAnim )
				PlayAnim( 'HitLegLeft', , 0.1 );
		}

 		// If this part is already dead, damage the adjacent part.
		if ( HealthLegRight<0 && HealthLegLeft>0 )
		{
			HealthLegLeft  += HealthLegRight;
			HealthLegRight  = 0;
		}
		else if ( HealthLegLeft<0 && HealthLegRight>0 )
		{
			HealthLegRight += HealthLegLeft;
			HealthLegLeft   = 0;
		}

		if ( HealthLegLeft<0 )
		{
			HealthTorso   +=HealthLegLeft;
			HealthLegLeft  = 0;
		}
		if ( HealthLegRight<0 )
		{
			HealthTorso   += HealthLegRight;
			HealthLegRight = 0;
		}
	}
	else // Arms and torso.
	{
		if ( Offset.y>ArmOffset )
		{
			HealthArmRight -= ActualDamage;
			if ( bPlayAnim )
				PlayAnim( 'HitArmRight', , 0.1 );
		}
		else if ( Offset.y<-ArmOffset )
		{
			HealthArmLeft -= ActualDamage;
			if ( bPlayAnim )
				PlayAnim( 'HitArmLeft', , 0.1 );
		}
		else
		{
			HealthTorso -= ActualDamage * 2;
			if ( bPlayAnim )
				PlayAnim( 'HitTorso', , 0.1 );
		}

		// If this part is already dead, damage the adjacent part.
		if ( HealthArmLeft<0 )
		{
			HealthTorso   += HealthArmLeft;
			HealthArmLeft  = 0;
		}
		if (HealthArmRight < 0)
		{
			HealthTorso   += HealthArmRight;
			HealthArmRight = 0;
		}
	}

	// check for a back hit and play the correct anim
	if ( Offset.x<0.0 && bPlayAnim )
	{
		if ( Offset.z>HeadOffsetZ ) // head from the back
		{
			// Narrow the head region
			if ( Abs(Offset.x)<headOffsetY || Abs(Offset.y)<HeadOffsetY )
				PlayAnim( 'HitHeadBack', , 0.1 );
		}
		else
			PlayAnim( 'HitTorsoBack', , 0.1 );
	}

	// check for a water hit
	if ( Region.Zone.bWaterZone )
	{
		if ( Offset.x<0.0 &&bPlayAnim )
			PlayAnim( 'WaterHitTorsoBack', , 0.1 );
		else
			PlayAnim( 'WaterHitTorso', , 0.1 );
	}

	GenerateTotalHealth();

	switch ( DamageType )
	{
		case 'Stunned':
		case 'TearGas':
		case 'HalonGas':
		case 'PoisonGas':
		case 'Radiation':
		case 'EMP':
		case 'NanoVirus':
		case 'Drowned': 
		case 'KnockedOut':
		case 'CoughingNails': // Reduce makenoice?
		case 'Plague':
		case 'Crack':
			break;

		// It's probably better to whitelist bleeding inflicting damage types.
		default:
			BleedRate += (OrigHealth-Health)/30.0;  // 30 points of damage = bleed profusely
			break;
	}

	if ( CarriedDecoration!=None )
		DropDecoration();

	// Death prevention. Used by training mission and mission 04 after hunt begins.
	if ( Health<=0 && HXGame!=None )
	{
		HXGame.PreventDeath( Self );
	}

	if ( Health>0 )
	{
		if ( InstigatedBy!=None )
			DamageAttitudeTo( InstigatedBy );
		PlayDXTakeDamageHit( ActualDamage, HitLocation, DamageType, Momentum, bDamageGotReduced );
		AISendEvent('Distress', EAITYPE_Visual);
	}
	else
	{
		NextState = '';
		PlayDeathHit( ActualDamage, HitLocation, DamageType, Momentum );
		if ( ActualDamage>Mass )
			Health = -1 * ActualDamage;
		Enemy = InstigatedBy;
		Died( InstigatedBy, DamageType, HitLocation );
		return;
	}
	MakeNoise(1.0); 

	//Log( "DamageType=" $ DamageType );

	if ( DamageType=='Flamed' && !bOnFire )
	{
		if ( Role == ROLE_Authority )
			CatchFireNonRep( instigatedBy );
	}

	MyProjKiller = None;
}

// ----------------------------------------------------------------------------
// ClientAddBarkDisplay
// ----------------------------------------------------------------------------

function ClientAddBarkDisplay( string text, float newDisplayTime, string speakingActorUnfamiliarName )
{
	// Can appear if net is not yet up?
	if ( GetPlayerPawn()!=Self )
		return;

	if ( bSubtitles && text != "" )
	{
		HXHudBarkDisplay(HXRootWindow(rootWindow).hud.barkDisplay).AddBark2( text, newDisplayTime, speakingActorUnfamiliarName );
	}
}

// ----------------------------------------------------------------------------
// state PlayerWalking
// ----------------------------------------------------------------------------

state PlayerWalking
{
	ignores SeePlayer, HearNoise, Bump;

	// lets us affect the player's movement
	function ProcessMove ( float DeltaTime, vector newAccel, eDodgeDir DodgeMove, rotator DeltaRot)
	{
		local int newSpeed, defSpeed;
		local name mat;
		local vector HitLocation, HitNormal, checkpoint, downcheck;
		local Actor HitActor, HitActorDown;
		local bool bCantStandUp;
		local Vector loc, traceSize;
		local float alpha, maxLeanDist;
		local float legTotal, weapSkill;
		local vector OldAccel; // PlayerPawn's ProcessMove

		// if the spy drone augmentation is active
		if (bSpyDroneActive)
		{
			if ( aHXDrone != None ) 
			{
				// put away whatever is in our hand
				if (inHand != None)
					PutInHand(None);

				// make the drone's rotation match the player's view
				aHXDrone.SetRotation(ViewRotation);

				// move the drone
				loc = Normal((aUp * vect(0,0,1) + aForward * vect(1,0,0) + aStrafe * vect(0,1,0)) >> ViewRotation);

				// opportunity for client to translate movement to server
				MoveDrone( DeltaTime, loc );

				// freeze the player
				Velocity = vect(0,0,0);
			}
			return;
		}

		defSpeed = GetCurrentGroundSpeed();

      // crouching makes you two feet tall
		if (bIsCrouching || bForceDuck)
		{
			SetBasedPawnSize( default.CollisionRadius, GetCrouchHeight() );

			// check to see if we could stand up if we wanted to
			checkpoint = Location;
			// check normal standing height
			checkpoint.Z = checkpoint.Z - CollisionHeight + 2 * GetDefaultCollisionHeight();
			traceSize.X = CollisionRadius;
			traceSize.Y = CollisionRadius;
			traceSize.Z = 1;
			HitActor = Trace(HitLocation, HitNormal, checkpoint, Location, True, traceSize);
			if (HitActor == None)
				bCantStandUp = False;
			else
				bCantStandUp = True;
		}
		else
		{
         // DEUS_EX AMSD Changed this to grab defspeed, because GetCurrentGroundSpeed takes 31k cycles to run.
			GroundSpeed = defSpeed;

			// make sure the collision height is fudged for the floor problem - CNN
			if (!IsLeaning())
			{
				ResetBasedPawnSize();
			}
		}

		if (bCantStandUp)
			bForceDuck = True;
		else
			bForceDuck = False;

		// if the player's legs are damaged, then reduce our speed accordingly
		newSpeed = defSpeed;

		//if ( Level.NetMode == NM_Standalone )
		//{
			if (HealthLegLeft < 1)
				newSpeed -= (defSpeed/2) * 0.25;
			else if (HealthLegLeft < 34)
				newSpeed -= (defSpeed/2) * 0.15;
			else if (HealthLegLeft < 67)
				newSpeed -= (defSpeed/2) * 0.10;

			if (HealthLegRight < 1)
				newSpeed -= (defSpeed/2) * 0.25;
			else if (HealthLegRight < 34)
				newSpeed -= (defSpeed/2) * 0.15;
			else if (HealthLegRight < 67)
				newSpeed -= (defSpeed/2) * 0.10;

			if (HealthTorso < 67)
				newSpeed -= (defSpeed/2) * 0.05;
		//}

		// let the player pull themselves along with their hands even if both of
		// their legs are blown off
		if ((HealthLegLeft < 1) && (HealthLegRight < 1))
		{
			newSpeed = defSpeed * 0.8;
			bIsWalking = True;
			bForceDuck = True;
		}
		// make crouch speed faster than normal
		else if (bIsCrouching || bForceDuck)
		{
//			newSpeed = defSpeed * 1.8;		// DEUS_EX CNN - uncomment to speed up crouch
			bIsWalking = True;
		}

		// CNN - Took this out because it sucks ASS!
		// if the legs are seriously damaged, increase the head bob
		// (unless the player has turned it off)
		//if (Bob > 0.0)
		//{
			//legTotal = (HealthLegLeft + HealthLegRight) / 2.0;
			//if (legTotal < 50)
				//Bob = Default.Bob * FClamp(0.05*(70 - legTotal), 1.0, 3.0);
			//else
				//Bob = Default.Bob;
		//}

		// slow the player down if he's carrying something heavy
		// Like a DEAD BODY!  AHHHHHH!!!
		if (CarriedDecoration != None)
		{
			newSpeed -= CarriedDecoration.Mass * 2;
		}
		// don't slow the player down if he's skilled at the corresponding weapon skill  
		//else if ((HXWeapon(Weapon) != None) && (Weapon.Mass > 30) && (HXWeapon(Weapon).GetWeaponSkill() > -0.25) && (Level.NetMode==NM_Standalone) )
		else if ((HXWeapon(Weapon) != None) && (Weapon.Mass > 30) && (HXWeapon(Weapon).GetWeaponSkill() > -0.25) )
		{
			// HX_MOVE: in mp slowdown code this is commented out!
			bIsWalking = True;
			newSpeed = defSpeed;
		}
		else if ((inHand != None) && inHand.IsA('POVCorpse'))
		{
			newSpeed -= inHand.Mass * 3;
		}

		// if we are moving really slow, force us to walking
		if ((newSpeed <= defSpeed / 3) && !bForceDuck)
		{
			bIsWalking = True;
			newSpeed = defSpeed;
		}

		// if we are moving backwards, we should move slower
		// DEUS_EX AMSD Turns out this wasn't working right in multiplayer, I have a fix
		// for it, but it would change all our balance.
		// HX_MOVE: put it back in
		if ((aForward < 0) && (Level.NetMode == NM_Standalone))
			newSpeed *= 0.65;

		GroundSpeed = FMax(newSpeed, 100);

		// HX_NOTE: hackfix, matches 0.3 vs 0.6 in APawn::calcVelocity()
		if ( Level.NetMode != NM_Standalone && ( bIsCrouching || bForceDuck || bIsWalking ) )
			GroundSpeed *= 0.5;

		// if we are moving or crouching, we can't lean
		// uncomment below line to disallow leaning during crouch

		if ((VSize(Velocity) < 10) && (aForward == 0))		// && !bIsCrouching && !bForceDuck)
			bCanLean = True;
		else
			bCanLean = False;

		// check leaning buttons (axis aExtra0 is used for leaning)
		maxLeanDist = 40;

		if (IsLeaning())
		{
			if ( PlayerIsClient() || (Level.NetMode == NM_Standalone) )
				ViewRotation.Roll = curLeanDist * 20;
		
			if (!bIsCrouching && !bForceDuck)
				SetBasedPawnSize(CollisionRadius, GetDefaultCollisionHeight() - Abs(curLeanDist) / 3.0);
		}
		if (bCanLean && (aExtra0 != 0))
		{
			// lean
			DropDecoration();		// drop the decoration that we are carrying
			if (AnimSequence != 'CrouchWalk')
				PlayCrawling();

			alpha = maxLeanDist * aExtra0 * 2.0 * DeltaTime;

			loc = vect(0,0,0);
			loc.Y = alpha;
			if (Abs(curLeanDist + alpha) < maxLeanDist)
			{
				// check to make sure the destination not blocked
				checkpoint = (loc >> Rotation) + Location;
				traceSize.X = CollisionRadius;
				traceSize.Y = CollisionRadius;
				traceSize.Z = CollisionHeight;
				HitActor = Trace(HitLocation, HitNormal, checkpoint, Location, True, traceSize);

				// check down as well to make sure there's a floor there
				downcheck = checkpoint - vect(0,0,1) * CollisionHeight;
				HitActorDown = Trace(HitLocation, HitNormal, downcheck, checkpoint, True, traceSize);
				if ((HitActor == None) && (HitActorDown != None))
				{
					if ( PlayerIsClient() || (Level.NetMode == NM_Standalone))
					{
						SetLocation(checkpoint);
						ServerUpdateLean( checkpoint );
						curLeanDist += alpha;
					}
				}
			}
			else
			{
				if ( PlayerIsClient() || (Level.NetMode == NM_Standalone) )
					curLeanDist = aExtra0 * maxLeanDist;
			}
		}
		else if (IsLeaning())	//if (!bCanLean && IsLeaning())	// uncomment this to not hold down lean
		{
			// un-lean
			if (AnimSequence == 'CrouchWalk')
				PlayRising();

			if ( PlayerIsClient() || (Level.NetMode == NM_Standalone))
			{
				prevLeanDist = curLeanDist;
				alpha = FClamp(7.0 * DeltaTime, 0.001, 0.9);
				curLeanDist *= 1.0 - alpha;
				if (Abs(curLeanDist) < 1.0)
					curLeanDist = 0;
			}

			loc = vect(0,0,0);
			loc.Y = -(prevLeanDist - curLeanDist);

			// check to make sure the destination not blocked
			checkpoint = (loc >> Rotation) + Location;
			traceSize.X = CollisionRadius;
			traceSize.Y = CollisionRadius;
			traceSize.Z = CollisionHeight;
			HitActor = Trace(HitLocation, HitNormal, checkpoint, Location, True, traceSize);

			// check down as well to make sure there's a floor there
			downcheck = checkpoint - vect(0,0,1) * CollisionHeight;
			HitActorDown = Trace(HitLocation, HitNormal, downcheck, checkpoint, True, traceSize);
			if ((HitActor == None) && (HitActorDown != None))
			{
				if ( PlayerIsClient() || (Level.NetMode == NM_Standalone))
				{
					SetLocation( checkpoint );
					ServerUpdateLean( checkpoint );
				}
			}
		}

		//Super(PlayerPawn).ProcessMove(DeltaTime, newAccel, DodgeMove, DeltaRot);

		//
		// PlayerPawn's ProcessMove
		//

		//local vector OldAccel;
		      
		OldAccel = Acceleration;
		Acceleration = NewAccel;
		bIsTurning = ( Abs(DeltaRot.Yaw/DeltaTime) > 5000 );
		if ( (DodgeMove == DODGE_Active) && (Physics == PHYS_Falling) )
			DodgeDir = DODGE_Active;	
		else if ( (DodgeMove != DODGE_None) && (DodgeMove < DODGE_Active) )
			Dodge(DodgeMove);

		if ( bPressedJump )
			DoJump();
		if ( (Physics == PHYS_Walking) && (GetAnimGroup(AnimSequence) != 'Dodge') )
		{
			if (!bIsCrouching)
			{
				if (bDuck != 0)
				{
					bIsCrouching = true;
					PlayDuck();
				}
			}
			else if (bDuck == 0)
			{
				OldAccel = vect(0,0,0);
				bIsCrouching = false;
				TweenToRunning(0.1);
			}

			if ( !bIsCrouching )
			{
				if ( (!bAnimTransition || (AnimFrame > 0)) && (GetAnimGroup(AnimSequence) != 'Landing') )
				{
					if ( Acceleration != vect(0,0,0) )
					{
						if ( (GetAnimGroup(AnimSequence) == 'Waiting') || (GetAnimGroup(AnimSequence) == 'Gesture') || (GetAnimGroup(AnimSequence) == 'TakeHit') )
						{
							bAnimTransition = true;
							TweenToRunning(0.1);
						}
					}
			 		else if ( (Velocity.X * Velocity.X + Velocity.Y * Velocity.Y < 1000) 
						&& (GetAnimGroup(AnimSequence) != 'Gesture') ) 
			 		{
			 			if ( GetAnimGroup(AnimSequence) == 'Waiting' )
			 			{
							if ( bIsTurning && (AnimFrame >= 0) ) 
							{
								bAnimTransition = true;
								PlayTurning();
							}
						}
			 			else if ( !bIsTurning ) 
						{
							bAnimTransition = true;
							TweenToWaiting(0.2);
						}
					}
				}
			}
			else
			{
				if ( (OldAccel == vect(0,0,0)) && (Acceleration != vect(0,0,0)) )
					PlayCrawling();
			 	else if ( !bIsTurning && (Acceleration == vect(0,0,0)) && (AnimFrame > 0.1) )
					PlayDuck();
			}
		}
	}

	function ZoneChange( ZoneInfo NewZone )
	{
		local actor HitActor;
		local vector HitLocation, HitNormal, checkpoint;

		// If we jump into water, empty our hands.
		if ( NewZone.bWaterZone )
			DropDecoration();

		// DEUS_EX CNN - make sure if we crouch in shallow water, we don't swim
		// Note that we must be standing on solid ground for this to work,
		// otherwise we should assume that we actually are swimming
		if (!HeadRegion.Zone.bWaterZone && bIsCrouching)
		{
			checkpoint = Location;
			checkpoint.Z -= (CollisionHeight + 6.0);
			HitActor = Trace(HitLocation, HitNormal, checkpoint, Location, false);
			if (HitActor != None)
				return;
		}

		if (NewZone.bWaterZone)
		{
			setPhysics(PHYS_Swimming);
			GotoState('PlayerSwimming');
		}
	}

	function PlayerTick( float DeltaTime )
	{
		//DEUS_EX AMSD Additional updates
		//Because of replication delay, aug icons end up being a step behind generally.  So refresh them
		//every freaking tick.  
		RefreshSystems(deltaTime);

		DrugEffects(deltaTime);
		Bleed(deltaTime);
		HighlightCenterObject();

		UpdateDynamicMusic( DeltaTime );
		UpdateWarrenEMPField( DeltaTime );
		// DEUS_EX AMSD Move these funcions to a multiplayer tick
		// so that only that call gets propagated to the server.
		MultiplayerTick( DeltaTime );
		// DEUS_EX AMSD For multiplayer...
		FrobTime += deltaTime;

		// save some texture info
		//FloorMaterial = GetFloorMaterial();
		//WallMaterial = GetWallMaterial(WallNormal);

		// Check if player has walked outside a first-person convo.
		//CheckActiveConversationRadius();

		// Check if all the people involved in a conversation are 
		// still within a reasonable radius.
		//CheckActorDistances();

		// handle poison
		//DEUS_EX AMSD Now handled in multiplayertick
		//UpdatePoison(deltaTime);

		// Update Flash.
		ViewFlash( DeltaTime );

		if ( bUpdatePosition )
			ClientUpdatePosition();

		PlayerMove( DeltaTime );
	}
}

// ----------------------------------------------------------------------------
// state PlayerSwimming
// ----------------------------------------------------------------------------

state PlayerSwimming
{
	ignores SeePlayer, HearNoise, Bump;

	event PlayerTick(float deltaTime)
	{
		local vector loc;

		//DEUS_EX AMSD Additional updates
		//Because of replication delay, aug icons end up being a step behind generally.  So refresh them
		//every freaking tick.  
		RefreshSystems(deltaTime);

		DrugEffects(deltaTime);
		HighlightCenterObject();
		UpdateDynamicMusic(deltaTime);
    // DEUS_EX AMSD For multiplayer...
    MultiplayerTick(deltaTime);
		FrobTime += deltaTime;

		if (bOnFire)
			ExtinguishFire();

		// save some texture info
		//FloorMaterial = GetFloorMaterial();
		//WallMaterial = GetWallMaterial(WallNormal);

		// don't let the player run if swimming
		bIsWalking = True;

		/*if ( Role==ROLE_Authority )
		{
			// update our swimming info
			DiveTimer -= deltaTime;
			DiveTimer = FMax(0, DiveTimer);

			if (DiveTimer > 0)
				PainTime = DiveTimer;
		}*/

		// Check if player has walked outside a first-person convo.
		//CheckActiveConversationRadius();

		// Check if all the people involved in a conversation are 
		// still within a reasonable radius.
		//CheckActorDistances();

		// Randomly spawn an air bubble every 0.2 seconds
		// Place them in front of the player's eyes
		swimBubbleTimer += deltaTime;
		if (swimBubbleTimer >= 0.2)
		{
			swimBubbleTimer = 0;
			if (FRand() < 0.4)
			{
				loc = Location + VRand() * 4;
				loc += Vector(ViewRotation) * CollisionRadius * 2;
				loc.Z += CollisionHeight * 0.9;
				Spawn(class'AirBubble', Self,, loc);
			}
		}

		// handle poison
      //DEUS_EX AMSD Now handled in multiplayertick
		//UpdatePoison(deltaTime);

		// Update Flash.
		ViewFlash( DeltaTime );

		if ( bUpdatePosition )
			ClientUpdatePosition();

		PlayerMove( DeltaTime );
	}

	function BeginState()
	{
		local float mult, augLevel;

		// set us to be two feet high
		SetBasedPawnSize(Default.CollisionRadius, 16);

		// get our skill info
		// HX_NOTE: fix spawning in water:
		if ( SkillSystem != None )
			mult = SkillSystem.GetSkillLevelValue(class'HXSkillSwimming');
		else
			mult = 1.0; // default value

		DiveDuration = UnderWaterTime * mult;
		DiveTimer = DiveDuration;
		swimBubbleTimer = 0;

		// 0.5 is a heuristic value measured with a stopwatch.
		if ( Level.NetMode==NM_Standalone )
			WaterSpeed = Default.WaterSpeed * mult;
		else
			WaterSpeed = Default.WaterSpeed * mult * 0.5;

		// PlayerPawn's BeginState()
		Disable('Timer');
		if ( !IsAnimating() )
			TweenToWaiting(0.3);
		//log("player swimming");
	}
}

// ----------------------------------------------------------------------------
// state Dying
//
// make sure the death animation finishes
// ----------------------------------------------------------------------------

state Dying
{
	ignores all;

	function int HealPlayer( int HealPoints, optional Bool bUseMedicineSkill );
	function     DrugPlayer( float Duration );

	exec function ActivateBelt( int Position );
	exec function ParseLeftClick();
	exec function ParseRightClick();

	exec function Suicide();
	exec function SwitchAmmo();
	exec function bool DropItem( optional Inventory Item, optional bool bDrop );
	exec function DropAmmo( Class<HXAmmo> AmmoClass, optional bool bDrop );
	exec function _ActivateAugmentation( int AugKey );
	exec function ActivateAugmentation( int AugKey );
	exec function DeactivateAugmentation( int AugKey );
	exec function ToggleAugmentation( int AugKey );

	exec function PutInHand( optional Inventory Item )
	{
		// Still allow putting away items.
		if ( Item==None )
			Global.PutInHand( None );
	}

	event PlayerTick(float deltaTime)
	{
    if (PlayerIsClient())      
      ClientDeath();
		UpdateDynamicMusic(deltaTime);

		Super(PlayerPawnExt).PlayerTick(deltaTime);
	}

	exec function Fire(optional float F)
	{
		if ( Level.NetMode != NM_Standalone && bHidden )
      Super.Fire();
	}

	exec function ShowMainMenu()
	{
		// reduce the white glow when the menu is up
		if (InstantFog != vect(0,0,0))
		{
			InstantFog   = vect(0.1,0.1,0.1);
			InstantFlash = 0.01;

			// force an update
			ViewFlash(1.0);
		}

		Global.ShowMainMenu();
	}

	function BeginState()
	{
		FrobTime = Level.TimeSeconds;
		ShowHud(False);
    ClientDeath();
	}

  function TakeDamage(int Damage, Pawn instigatedBy, Vector hitlocation, Vector momentum, name damageType)
	{
	}

	function PlayerCalcView(out actor ViewActor, out vector CameraLocation, out rotator CameraRotation)
	{
		local vector ViewVect, HitLocation, HitNormal, whiteVec;
		local float ViewDist;
		local actor HitActor;
		local float time;

		ViewActor = Self;
		if (bHidden)
		{
			// spiral up and around carcass and fade to white in five seconds
			time = Level.TimeSeconds - FrobTime;

			/*if ( ((myKiller != None) && (killProfile != None) && (!killProfile.bKilledSelf)) || 
				  ((killProfile != None) && killProfile.bValid && (!killProfile.bKilledSelf)))
			{
				if ( killProfile.bValid && killProfile.bTurretKilled )
					ViewVect = killProfile.killerLoc - Location;
				else if ( killProfile.bValid && killProfile.bProximityKilled )
					ViewVect = killProfile.killerLoc - Location;
				else if (( !killProfile.bKilledSelf ) && ( myKiller != None ))
					ViewVect = myKiller.Location - Location;
				CameraLocation = Location;
				CameraRotation = Rotator(ViewVect);
			}
			else*/ if (time < 8.0)
			{
				whiteVec.X = time / 16.0;
				whiteVec.Y = time / 16.0;
				whiteVec.Z = time / 16.0;
				CameraRotation.Pitch = -16384;
				CameraRotation.Yaw = (time * 8192.0) % 65536;
				ViewDist = 32 + time * 32;
				InstantFog = whiteVec;
				InstantFlash = 0.5;
				ViewFlash(1.0);
				// make sure we don't go through the ceiling
				ViewVect = vect(0,0,1);
				HitActor = Trace(HitLocation, HitNormal, Location + ViewDist * ViewVect, Location);
				if ( HitActor != None )
					CameraLocation = HitLocation;
				else
					CameraLocation = Location + ViewDist * ViewVect;
			}
			else
			{
				/*if  ( Level.NetMode != NM_Standalone )
				{
					// Don't fade to black in multiplayer
				}
				else
				{*/
					// then, fade out to black in four seconds and bring up
					// the main menu automatically
					whiteVec.X = FMax(0.5 - (time-8.0) / 8.0, -1.0);
					whiteVec.Y = FMax(0.5 - (time-8.0) / 8.0, -1.0);
					whiteVec.Z = FMax(0.5 - (time-8.0) / 8.0, -1.0);
					CameraRotation.Pitch = -16384;
					CameraRotation.Yaw = (time * 8192.0) % 65536;
					 ViewDist = 32 + 8.0 * 32;
					InstantFog = whiteVec;
					InstantFlash = whiteVec.X;
					ViewFlash(1.0);

					// start the splash screen after a bit
					// only if we don't have a menu open
					// DEUS_EX AMSD Don't do this in multiplayer!!!!
					/*if (Level.NetMode == NM_Standalone)
					{
						if (whiteVec == vect(-1.0,-1.0,-1.0))
							if ((MenuUIWindow(HXRootWindow(rootWindow).GetTopWindow()) == None) &&
								(ToolWindow(HXRootWindow(rootWindow).GetTopWindow()) == None))
								ConsoleCommand("OPEN DXONLY");
					}*/
				/*}*/
				// make sure we don't go through the ceiling
				ViewVect = vect(0,0,1);
				HitActor = Trace(HitLocation, HitNormal, Location + ViewDist * ViewVect, Location);
				if ( HitActor != None )
					CameraLocation = HitLocation;
				else
					CameraLocation = Location + ViewDist * ViewVect;
			}
		}
		else
		{
			// use FrobTime as the cool DeathCam timer
			FrobTime = Level.TimeSeconds;

			// make sure we don't go through the wall
		    ViewDist = 190;
			ViewVect = vect(1,0,0) >> Rotation;
			HitActor = Trace( HitLocation, HitNormal, 
					Location - ViewDist * vector(CameraRotation), Location, false, vect(12,12,2));
			if ( HitActor != None )
				CameraLocation = HitLocation;
			else
				CameraLocation = Location - ViewDist * ViewVect;
		}

		// don't fog view if we are "paused"
		/*if (HXRootWindow(rootWindow).bUIPaused)
		{
			InstantFog   = vect(0,0,0);
			InstantFlash = 0;
			ViewFlash(1.0);
		}*/
	}

Begin:
	// Dead players comes back to life with scope view, so this is here to prevent that
	if ( HXWeapon(inHand) != None )
	{
		HXWeapon(inHand).bZoomed = False;
		HXWeapon(inHand).RefreshScopeDisplay(Self, True, False);
	}

	if ( HXRootWindow(rootWindow).hud.augDisplay != None )
	{
		HXRootWindow(rootWindow).hud.augDisplay.bVisionActive = False;
		HXRootWindow(rootWindow).hud.augDisplay.activeCount = 0;
	}

	// Don't come back to life drugged or posioned
	poisonCounter		= 0; 
	poisonTimer			= 0;    
	drugEffectTimer	= 0;

	// Don't come back to life crouched
	bCrouchOn			= False;
	bWasCrouchOn		= False;
	bIsCrouching		= False;
	bForceDuck			= False;
	lastbDuck			= 0;
	bDuck					= 0;

	FrobTime = Level.TimeSeconds;
	bBehindView = True;
	Velocity = vect(0,0,0);
	Acceleration = vect(0,0,0);
	DesiredFOV = Default.DesiredFOV;
	FinishAnim();
	KillShadow();

  FlashTimer = 0;

	// hide us and spawn the carcass
	bHidden = True;
	SpawnCarcass();
	//DEUS_EX AMSD Players should not leave physical versions of themselves around :)
	if (Level.NetMode != NM_Standalone)
		HidePlayer();
}

// ----------------------------------------------------------------------------
// state CheatFlying.
// ----------------------------------------------------------------------------

state CheatFlying
{
	ignores SeePlayer, HearNoise, Bump, TakeDamage;

	function PlayFootStep();
		
	function AnimEnd()
	{
		PlaySwimming();
	}
	
	function ProcessMove(float DeltaTime, vector NewAccel, eDodgeDir DodgeMove, rotator DeltaRot)	
	{
		Acceleration = Normal(NewAccel);
		Velocity = Normal(NewAccel) * 300;
		AutonomousPhysics(DeltaTime);
	}

	event PlayerTick( float DeltaTime )
	{
		if ( bUpdatePosition )
			ClientUpdatePosition();

		PlayerMove( DeltaTime );

		// Update Flash.
		ViewFlash( DeltaTime );

		// Reset FrobTarget so we don't fly around with
		// something remaining highlighted.
		FrobTarget = None;
	}

	function PlayerMove(float DeltaTime)
	{
		local rotator newRotation;
		local vector X,Y,Z;

		GetAxes(ViewRotation,X,Y,Z);

		aForward *= 0.1;
		aStrafe  *= 0.1;
		aLookup  *= 0.24;
		aTurn    *= 0.24;
		aUp		 *= 0.1;
	
		Acceleration = aForward*X + aStrafe*Y + aUp*vect(0,0,1);  

		UpdateRotation(DeltaTime, 1);

		if ( Role < ROLE_Authority ) // then save this move and replicate it
			ReplicateMove(DeltaTime, Acceleration, DODGE_None, rot(0,0,0));
		else
			ProcessMove(DeltaTime, Acceleration, DODGE_None, rot(0,0,0));
	}

	function BeginState()
	{
		EyeHeight = BaseEyeHeight;
		SetPhysics(PHYS_Flying);
		if  ( !IsAnimating() )
			PlaySwimming();
		// log("cheat flying");
	}
}

// ----------------------------------------------------------------------------
// state CheatGhosting.
// ----------------------------------------------------------------------------

state CheatGhosting extends CheatFlying
{
}

// ----------------------------------------------------------------------------
// ActivateItemFromInventoryScreen
// ----------------------------------------------------------------------------

function ActivateItemFromInventoryScreen( Inventory inv )
{
	if ( inHandPending == inv )
		SetInHandPending(None);

	// If this is a binoculars, then it needs to be equipped
	// before it can be activated
	if ( inv.IsA('HXBinoculars') ) 
		PutInHand( inv );

	inv.Activate();
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// Cheats.
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
// GiveNanoKey()
// ----------------------------------------------------------------------------

exec function GiveNanoKey( name KeyID, string KeyDescription )
{
	ServerGiveNanoKey( string(KeyID), KeyDescription );
}
function ServerGiveNanoKey( string KeyID, string KeyDescription )
{
	if ( !HXGameInfo(Level.Game).bCheatsEnabled )
		return;

	HXGameInfo(Level.Game).GiveKey( StringToName(KeyID), KeyDescription );
}

// ----------------------------------------------------------------------------
// RemoveNanoKey()
// ----------------------------------------------------------------------------

exec function RemoveNanoKey( name KeyID )
{
	ServerRemoveNanoKey( string(KeyID) );
}
function ServerRemoveNanoKey( string KeyID )
{
	if ( !HXGameInfo(Level.Game).bCheatsEnabled )
		return;

	HXGameInfo(Level.Game).RemoveKey( StringToName(KeyID) );
}

// ----------------------------------------------------------------------------
// SetFlag()
// ----------------------------------------------------------------------------

exec function SetFlag( name FlagName, bool FlagValue )
{
	ServerSetFlag( string(FlagName), FlagValue );
}
function ServerSetFlag( string FlagString, bool FlagValue )
{
	local name FlagName;

	if ( !HXGameInfo(Level.Game).bCheatsEnabled )
		return;

	FlagName = StringToName( FlagString );
	if ( FlagName=='' )
		return;

	HXGameInfo(Level.Game).FlagReplicationInfo.SetBoolFlag( FlagName, FlagValue );
	HXGameInfo(Level.Game).Steve.FlagBase.SetBool( FlagName, FlagValue );
}

// ----------------------------------------------------------------------------
// Tantalus()
//
// Instantly kills/destroys the object directly in front of the player
// (just like the Tantalus Field in Star Trek)
// ----------------------------------------------------------------------------

exec function Tantalus()
{
	ServerTantalus();
}
exec function ServerTantalus()
{
	local Actor            hitActor;
	local Vector           hitLocation, hitNormal;
	local Vector           position, line;
	local HXScriptedPawn   hitPawn;
	local HXMover          hitMover;
	local HXDecoration     hitDecoration;
	local bool             bTakeDamage;
	local int              damage;

	if (!HXGameInfo(Level.Game).bCheatsEnabled)
		return;

	bTakeDamage = false;
	damage      = 1;
	position    = Location;
	position.Z += BaseEyeHeight;
	line        = Vector(ViewRotation) * 4000;

	hitActor = Trace(hitLocation, hitNormal, position+line, position, true);
	if (hitActor != None)
	{
		hitMover = HXMover(hitActor);
		hitPawn = HXScriptedPawn(hitActor);
		hitDecoration = HXDecoration(hitActor);
		if (hitMover != None)
		{
			if (hitMover.bBreakable)
			{
				hitMover.doorStrength = 0;
				bTakeDamage = true;
			}
		}
		else if (hitPawn != None)
		{
			if (!hitPawn.bInvincible)
			{
				hitPawn.HealthHead     = 0;
				hitPawn.HealthTorso    = 0;
				hitPawn.HealthLegLeft  = 0;
				hitPawn.HealthLegRight = 0;
				hitPawn.HealthArmLeft  = 0;
				hitPawn.HealthArmRight = 0;
				hitPawn.Health         = 0;
				bTakeDamage = true;
			}
		}
		else if (hitDecoration != None)
		{
			if (!hitDecoration.bInvincible)
			{
				hitDecoration.HitPoints = 0;
				bTakeDamage = true;
			}
		}
		else if (hitActor != Level)
		{
			damage = 5000;
			bTakeDamage = true;
		}
	}

	if (bTakeDamage)
		hitActor.TakeDamage(damage, self, hitLocation, line, 'Tantalus');
}

// ----------------------------------------------------------------------
// OpenSesame()
//
// Opens any door immediately in front of you, locked or not
// ----------------------------------------------------------------------

exec function OpenSesame()
{
	ServerOpenSesame();
}
exec function ServerOpenSesame()
{
	local Actor       hitActor;
	local Vector      hitLocation, hitNormal;
	local Vector      position, line;
	local HXMover hitMover;
	local HXMover triggerMover;
	local DeusExMover dxhitMover;
	local DeusExMover dxtriggerMover;
	local HXHackableDevices device;

	if (!HXGameInfo(Level.Game).bCheatsEnabled)
		return;

	position    = Location;
	position.Z += BaseEyeHeight;
	line        = Vector(ViewRotation) * 4000;

	hitActor = Trace(hitLocation, hitNormal, position+line, position, true);
	hitMover = HXMover(hitActor);

	dxhitMover = DeusExMover(hitActor);

	device   = HXHackableDevices(hitActor);

	if (hitMover != None)
	{
		if ((hitMover.Tag != '') && (hitMover.Tag != 'DeusExMover'))
		{
			foreach AllActors(class'HXMover', triggerMover, hitMover.Tag)
			{
				triggerMover.bLocked = false;
				triggerMover.Trigger(self, self);
			}
		}
		else
		{
			hitMover.bLocked = false;
			hitMover.Trigger(self, self);
		}
	}
	else if (dxhitMover != None)
	{
		if ((dxhitMover.Tag != '') && (dxhitMover.Tag != 'DeusExMover'))
		{
			foreach AllActors(class'DeusExMover', dxtriggerMover, dxhitMover.Tag)
			{
				dxtriggerMover.bLocked = false;
				dxtriggerMover.Trigger(self, self);
			}
		}
		else
		{
			dxhitMover.bLocked = false;
			dxhitMover.Trigger(self, self);
		}
	}
	else if (device != None)
	{
		if (device.bHackable)
		{
			if (device.hackStrength > 0)
			{
				device.hackStrength = 0;
				device.HackAction(self, true);
			}
		}
	}
}

// ----------------------------------------------------------------------
// Legend()
//
// Displays the "Behind The Curtain" menu
// ----------------------------------------------------------------------

exec function Legend()
{
	/*if ( !bCheatsEnabled )
		return;*/

	InvokeUIScreen( Class'BehindTheCurtain' );
}

// ----------------------------------------------------------------------
// AllHealth()
// ----------------------------------------------------------------------

exec function AllHealth()
{
	ServerAllHealth();
}
function ServerAllHealth()
{
	if (!HXGameInfo(Level.Game).bCheatsEnabled)
		return;

	RestoreAllHealth();
}

// ----------------------------------------------------------------------
// DamagePart()
// ----------------------------------------------------------------------

exec function DamagePart( int partIndex, optional int amount )
{
	ServerDamagePart( partIndex, amount);
}
function ServerDamagePart( int partIndex, optional int amount )
{
	if (!HXGameInfo(Level.Game).bCheatsEnabled)
		return;

	if (amount == 0)
		amount = 1000;

	switch(partIndex)
	{
		case 0:		// head
			HealthHead -= Min(HealthHead, amount);
			break;

		case 1:		// torso
			HealthTorso -= Min(HealthTorso, amount);
			break;

		case 2:		// left arm
			HealthArmLeft -= Min(HealthArmLeft, amount);
			break;

		case 3:		// right arm
			HealthArmRight -= Min(HealthArmRight, amount);
			break;

		case 4:		// left leg
			HealthLegLeft -= Min(HealthLegLeft, amount);
			break;

		case 5:		// right leg
			HealthLegRight -= Min(HealthLegRight, amount);
			break;
	}
}

// ----------------------------------------------------------------------
// DamageAll()
// ----------------------------------------------------------------------

exec function DamageAll(optional int amount)
{
	ServerDamageAll( amount );
}
function ServerDamageAll(optional int amount)
{
	if (!HXGameInfo(Level.Game).bCheatsEnabled)
		return;

	if (amount == 0)
		amount = 1000;

	HealthHead     -= Min(HealthHead, amount);
	HealthTorso    -= Min(HealthTorso, amount);
	HealthArmLeft  -= Min(HealthArmLeft, amount);
	HealthArmRight -= Min(HealthArmRight, amount);
	HealthLegLeft  -= Min(HealthLegLeft, amount);
	HealthLegRight -= Min(HealthLegRight, amount);
}

// ----------------------------------------------------------------------
// AllEnergy()
// ----------------------------------------------------------------------

exec function AllEnergy()
{
	ServerAllEnergy();
}
exec function ServerAllEnergy()
{
	if ( !HXGameInfo(Level.Game).bCheatsEnabled )
		return;

	Energy = default.Energy;
}

// ----------------------------------------------------------------------
// AllCredits()
// ----------------------------------------------------------------------

exec function AllCredits()
{
	ServerAllCredits();
}
function ServerAllCredits()
{
	if ( !HXGameInfo(Level.Game).bCheatsEnabled )
		return;

	Credits += 100000;

	UpdateClientCredits( Credits );
}

// ----------------------------------------------------------------------
// AddCredits()
// ----------------------------------------------------------------------

exec function AddCredits( optional int NumCredits )
{
	ServerAddCredits( NumCredits );
}
function ServerAddCredits( int NumCredits )
{
	if ( !HXGameInfo(Level.Game).bCheatsEnabled )
		return;

	// If no parameter is given, NumCredits will be 0, so use this as a
	// marker for adding the default Credit pickup amount.
	if ( NumCredits==0 )
		NumCredits = 100;

	// Ignore negative amount of credits.
	if ( NumCredits<0 )
		return;

	Credits += NumCredits;

	UpdateClientCredits( Credits );
}

// ---------------------------------------------------------------------
// AllSkills()
// ----------------------------------------------------------------------

exec function AllSkills()
{
	ServerAllSkills();
}
function ServerAllSkills()
{
	local HXGameInfo HXGame;

	HXGame = HXGameInfo(Level.Game);
	if ( HXGame==None || !HXGame.bCheatsEnabled )
		return;

	HXGame.SkillPointsAdd( 115900, Sprintf(AllSkillsAwardMessage,PlayerReplicationInfo.PlayerName) );

	SkillSystem.AddAllSkills();
}

// ----------------------------------------------------------------------
// AllSkillPoints()
// ----------------------------------------------------------------------

exec function AllSkillPoints()
{
	ServerAllSkillPoints();
}
exec function ServerAllSkillPoints()
{
	local HXGameInfo HXGame;

	HXGame = HXGameInfo(Level.Game);
	if ( HXGame==None || !HXGame.bCheatsEnabled )
		return;

	HXGame.SkillPointsAdd( 115900, Sprintf(AllSkillPointsAwardMessage,PlayerReplicationInfo.PlayerName) );
}

// ----------------------------------------------------------------------
// AddSkillPoints()
// ----------------------------------------------------------------------

exec function AddSkillPoints( optional int NumSkillPoints )
{
	ServerAddSkillPoints( NumSkillPoints );
}
exec function ServerAddSkillPoints( int NumSkillPoints )
{
	local HXGameInfo HXGame;

	HXGame = HXGameInfo(Level.Game);
	if ( HXGame==None || !HXGame.bCheatsEnabled )
		return;

	// If no parameter is given, NumSkillPoints will be 0, so use this as a
	// marker for adding some? amount.
	if ( NumSkillPoints==0 )
		NumSkillPoints = 675;

	// Ignore negative amount of credits.
	if ( NumSkillPoints<0 )
		return;

	HXGame.SkillPointsAdd( NumSkillPoints, Sprintf(AddSkillPointsAwardMessage,PlayerReplicationInfo.PlayerName) );
}

// ----------------------------------------------------------------------------
// AllAugs()
// ----------------------------------------------------------------------------

exec function AllAugs()
{
	ServerAllAugs();
}
function ServerAllAugs()
{
	if ( !HXGameInfo(Level.Game).bCheatsEnabled )
		return;

	if ( AugmentationSystem!=None )
	{
		AugmentationSystem.AddAllAugs();
		AugmentationSystem.SetAllAugsToMaxLevel();
	}
}

// ----------------------------------------------------------------------------
// AugAdd()
//
// Augmentation system functions
// exec functions for command line for demo
// ----------------------------------------------------------------------------

exec function AugAdd( class<Augmentation> AugClass )
{
	local class<Actor> ActorClass;
	local Augmentation Aug;

	if ( !HXGameInfo(Level.Game).bCheatsEnabled )
		return;

	if ( AugmentationSystem==None || AugClass==None )
		return;

	ActorClass = AugClass;
	HXGameInfo(Level.Game).ModifyActorClass( ActorClass );
	AugClass = class<Augmentation>(ActorClass);
	if ( AugClass==None )
		return;

	Aug = AugmentationSystem.GivePlayerAugmentation(AugClass);
	if ( Aug==None )
		ClientMessage(GetItemName(String(AugClass)) $ " is not a valid augmentation!");
}

// ----------------------------------------------------------------------------
// AugReset()
// ----------------------------------------------------------------------------

exec function AugReset()
{
	if ( !HXGameInfo(Level.Game).bCheatsEnabled )
		return;

	if ( AugmentationSystem!=None )
	{
		AugmentationSystem.ResetAugmentations();
		AugmentationSystem.CreateAugmentations( Self );

		ClearAugmentationDisplay();
	}
}

// ----------------------------------------------------------------------------
// AugAddDefault()
// ----------------------------------------------------------------------------

exec function AugAddDefault()
{
	if ( !HXGameInfo(Level.Game).bCheatsEnabled )
		return;

	if ( AugmentationSystem!=None )
	{
		AugmentationSystem.AddDefaultAugmentations();
		AugmentationSystem.RefreshAugDisplay();
	}
}



// ----------------------------------------------------------------------------
// AllImages()
// ----------------------------------------------------------------------------

exec function AllImages()
{
	ServerAllImages();
}
function ServerAllImages()
{
	local Vector loc;
	local Inventory item;
	local HXGameInfo HXGame;

	if (!HXGameInfo(Level.Game).bCheatsEnabled)
		return;

	HXGame = HXGameInfo(Level.Game);

	HXGame.AddImage(class'Image01_GunFireSensor');
	HXGame.AddImage(class'Image01_LibertyIsland');
	HXGame.AddImage(class'Image01_TerroristCommander');
	HXGame.AddImage(class'Image02_Ambrosia_Flyer');
	HXGame.AddImage(class'Image02_NYC_Warehouse');
	HXGame.AddImage(class'Image02_BobPage_ManOfYear');
	HXGame.AddImage(class'Image03_747Diagram');
	HXGame.AddImage(class'Image03_NYC_Airfield');
	HXGame.AddImage(class'Image03_WaltonSimons');
	HXGame.AddImage(class'Image04_NSFHeadquarters');
	HXGame.AddImage(class'Image04_UNATCONotice');
	HXGame.AddImage(class'Image05_GreaselDisection');
	HXGame.AddImage(class'Image05_NYC_MJ12Lab');
	HXGame.AddImage(class'Image06_HK_Market');
	HXGame.AddImage(class'Image06_HK_MJ12Helipad');
	HXGame.AddImage(class'Image06_HK_MJ12Lab');
	HXGame.AddImage(class'Image06_HK_Versalife');
	HXGame.AddImage(class'Image06_HK_WanChai');
	HXGame.AddImage(class'Image08_JoeGreenMIBMJ12');
	HXGame.AddImage(class'Image09_NYC_Ship_Bottom');
	HXGame.AddImage(class'Image09_NYC_Ship_Top');
	HXGame.AddImage(class'Image10_Paris_Catacombs');
	HXGame.AddImage(class'Image10_Paris_CatacombsTunnels');
	HXGame.AddImage(class'Image10_Paris_Metro');
	HXGame.AddImage(class'Image11_Paris_Cathedral');
	HXGame.AddImage(class'Image11_Paris_CathedralEntrance');
	HXGame.AddImage(class'Image12_Vandenberg_Command');
	HXGame.AddImage(class'Image12_Vandenberg_Sub');
	HXGame.AddImage(class'Image12_Tiffany_HostagePic');
	HXGame.AddImage(class'Image14_OceanLab');
	HXGame.AddImage(class'Image14_Schematic');
	HXGame.AddImage(class'Image15_Area51Bunker');
	HXGame.AddImage(class'Image15_GrayDisection');
	HXGame.AddImage(class'Image15_BlueFusionDevice');
	HXGame.AddImage(class'Image15_Area51_Sector3');
	HXGame.AddImage(class'Image15_Area51_Sector4');
}

// ----------------------------------------------------------------------
// Trig()
// ----------------------------------------------------------------------

exec function Trig( name EventName )
{
	ServerTrig( string(EventName) );
}
function ServerTrig( string EventString )
{
	local name EventName;
	local Actor A;

	if ( !HXGameInfo(Level.Game).bCheatsEnabled )
		return;

	EventName = StringToName( EventString );

	if ( EventName!='' )
		foreach AllActors( class'Actor', A, EventName )
			A.Trigger( Self, Self );
}

// ----------------------------------------------------------------------
// UnTrig()
// ----------------------------------------------------------------------

exec function UnTrig( name EventName )
{
	ServerUnTrig( string(EventName) );
}
function ServerUnTrig( string EventString )
{
	local name EventName;
	local Actor A;

	if ( !HXGameInfo(Level.Game).bCheatsEnabled )
		return;

	EventName = StringToName( EventString );

	if ( EventName!='' )
		foreach AllActors( class'Actor', A, EventName )
			A.UnTrigger( Self, Self );
}

// ----------------------------------------------------------------------
// IAmWarren()
// ----------------------------------------------------------------------

exec function IAmWarren()
{
	ServerIAmWarren();
}
function ServerIAmWarren()
{
	if ( !HXGameInfo(Level.Game).bCheatsEnabled )
		return;

	if (!bWarrenEMPField)
	{
		bWarrenEMPField = true;
		WarrenTimer = 0;
		WarrenSlot  = 0;
		ClientMessage("Warren's EMP Field activated");  // worry about localization?
	}
	else
	{
		bWarrenEMPField = false;
		ClientMessage("Warren's EMP Field deactivated");  // worry about localization?
	}
}

// ----------------------------------------------------------------------
// UpdateWarrenEMPField()
// 
// Update Warren's EMP field
// ----------------------------------------------------------------------

function UpdateWarrenEMPField(float deltaTime)
{
	local float          empRadius;
	local HXRobot          curRobot;
	local HXAlarmUnit      curAlarm;
	local HXAutoTurret     curTurret;
	local HXLaserTrigger   curLaser;
	local HXBeamTrigger    curBeam;
	local HXSecurityCamera curCamera;
	local int            option;

	if (bWarrenEMPField)
	{
		WarrenTimer -= deltaTime;
		if (WarrenTimer <= 0)
		{
			WarrenTimer = 0.15;

			empRadius = 600;
			if (WarrenSlot == 0)
			{
				foreach RadiusActors(Class'HXRobot', curRobot, empRadius)
				{
					if ((curRobot.LastRendered() < 2.0) && (curRobot.CrazedTimer <= 0) &&
					    (curRobot.EMPHitPoints > 0))
					{
						if (curRobot.GetPawnAllianceType(self) == ALLIANCE_Hostile)
							option = Rand(2);
						else
							option = 0;
						if (option == 0)
							curRobot.TakeDamage(curRobot.EMPHitPoints*2, self, curRobot.Location, vect(0,0,0), 'EMP');
						else
							curRobot.TakeDamage(100, self, curRobot.Location, vect(0,0,0), 'NanoVirus');
						SpawnEMPSparks(curRobot, Rotator(Location-curRobot.Location));
					}
				}
			}
			else if (WarrenSlot == 1)
			{
				foreach RadiusActors(Class'HXAlarmUnit', curAlarm, empRadius)
				{
					if ((curAlarm.LastRendered() < 2.0) && !curAlarm.bConfused)
					{
						curAlarm.TakeDamage(100, self, curAlarm.Location, vect(0,0,0), 'EMP');
						SpawnEMPSparks(curAlarm, curAlarm.Rotation);
					}
				}
			}
			else if (WarrenSlot == 2)
			{
				foreach RadiusActors(Class'HXAutoTurret', curTurret, empRadius)
				{
					if ((curTurret.LastRendered() < 2.0) && !curTurret.bConfused)
					{
						curTurret.TakeDamage(100, self, curTurret.Location, vect(0,0,0), 'EMP');
						SpawnEMPSparks(curTurret, Rotator(Location-curTurret.Location));
					}
				}
			}
			else if (WarrenSlot == 3)
			{
				foreach RadiusActors(Class'HXLaserTrigger', curLaser, empRadius)
				{
					if ((curLaser.LastRendered() < 2.0) && !curLaser.bConfused)
					{
						curLaser.TakeDamage(100, self, curLaser.Location, vect(0,0,0), 'EMP');
						SpawnEMPSparks(curLaser, curLaser.Rotation);
					}
				}
			}
			else if (WarrenSlot == 4)
			{
				foreach RadiusActors(Class'HXBeamTrigger', curBeam, empRadius)
				{
					if ((curBeam.LastRendered() < 2.0) && !curBeam.bConfused)
					{
						curBeam.TakeDamage(100, self, curBeam.Location, vect(0,0,0), 'EMP');
						SpawnEMPSparks(curBeam, curBeam.Rotation);
					}
				}
			}
			else if (WarrenSlot == 5)
			{
				foreach RadiusActors(Class'HXSecurityCamera', curCamera, empRadius)
				{
					if ((curCamera.LastRendered() < 2.0) && !curCamera.bConfused)
					{
						curCamera.TakeDamage(100, self, curCamera.Location, vect(0,0,0), 'EMP');
						SpawnEMPSparks(curCamera, Rotator(Location-curCamera.Location));
					}
				}
			}

			WarrenSlot++;
			if (WarrenSlot >= 6)
				WarrenSlot = 0;
		}
	}
}


// ----------------------------------------------------------------------------
// SetState()
// ----------------------------------------------------------------------------

exec function SetState( name StateName )
{
	ServerSetState( string(StateName) );
}
function ServerSetState( string StateString )
{
	local ScriptedPawn P;
	local Actor hitActor;
	local vector loc, line, HitLocation, hitNormal;
	local name StateName;

	if ( !HXGameInfo(Level.Game).bCheatsEnabled )
		return;

	StateName = StringToName( StateString );

	loc = Location;
	loc.Z += BaseEyeHeight;
	line = Vector(ViewRotation) * 2000;

	hitActor = Trace(hitLocation, hitNormal, loc+line, loc, true);
	P = ScriptedPawn(hitActor);
	if (P != None)
	{
		P.GotoState(StateName);
		ClientMessage("Setting "$P.BindName$" to the "$StateName$" state");
	}
}
exec function SetLocalState( name StateName ) // !!! Turn this into a server ack thing. !!
{
	local ScriptedPawn P;
	local Actor hitActor;
	local vector loc, line, HitLocation, hitNormal;

	//if (!HXGameInfo(Level.Game).bCheatsEnabled)
		//return;

	loc = Location;
	loc.Z += BaseEyeHeight;
	line = Vector(ViewRotation) * 2000;

	hitActor = Trace(hitLocation, hitNormal, loc+line, loc, true);
	P = ScriptedPawn(hitActor);
	if (P != None)
	{
		P.GotoState(StateName);
		ClientMessage("Setting "$P.BindName$" to the local "$StateName$" state");
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// MapChange commands.
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

// Moves the server over to URL while ditching progress.
exec function SwitchLevel( string URL )
{
	if ( Game==None || !Game.AllowCommand(Self,'SwitchLevel',CMDTYPE_MapChange,0,,URL) )
		return;

	// Make sure there is at least a dummy portal, otherwise 
	// ServerTravel will append the current portal.
	if ( InStr(URL,"#")==INDEX_NONE )
		URL = URL $ "#";

	Level.ServerTravel( URL, false );
}

// Moves the server over to URL while keeping progress.
exec function SwitchCoopLevel( string URL )
{
	if ( Game==None || !Game.AllowCommand(Self,'SwitchCoopLevel',CMDTYPE_MapChange,1,,URL) )
		return;

	// Make sure there is at least a dummy portal, otherwise 
	// ServerTravel will append the current portal.
	if ( InStr(URL,"#")==INDEX_NONE )
		URL = URL $ "#";

	Level.ServerTravel( URL, true );
}

// Travels to the current map keeping progress.
exec function Switcheroo()
{
	local string URL;

	if ( Game==None )
		return;

	//URL = GetURLMap()$"#"; // Has the filepath in.
	URL = string(Outer.Name);
	//Log( "URL ="@URL, 'Switcheroo' );
	if ( Game.Steve!=None && Game.Steve.Portal!="" )
		URL = URL $ Game.Steve.Portal;

	if ( !Game.AllowCommand(Self,'Switcheroo',CMDTYPE_MapChange,1,,URL) )
		return;

	Level.ServerTravel( URL, true );
}


// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// DebugInfo commands.
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

// Prints state of the actor in front.
exec function GetState()
{
	local vector HitLocation, HitNormal, TraceStart, TraceEnd;
	local Actor Target;

	if ( Game==None || !Game.AllowCommand(Self,'GetState',CMDTYPE_CheatDebugInfo) )
		return;

	TraceStart    = Location;
	TraceStart.Z += BaseEyeHeight;
	TraceEnd      = TraceStart+Vector(ViewRotation)*2000.0;

	Target = Trace( HitLocation, HitNormal, TraceEnd, TraceStart, true );
	if ( Target==None )
	{
		ClientMessage( "Nothing found..." );
		return;
	}

	GetLocalState( Target );
	if ( !PlayerIsListenClient() )
		ClientMessage( Target.Name $ "'s remote state is" @ Target.GetStateName() );
}
function GetLocalState( Actor Target )
{
	ClientMessage( Target.Name $ "'s local state is" @ Target.GetStateName() );
}

// Prints physics of the actor in front.
exec function GetPhysics()
{
	local vector HitLocation, HitNormal, TraceStart, TraceEnd;
	local Actor Target;

	if ( Game==None || !Game.AllowCommand(Self,'GetPhysics',CMDTYPE_CheatDebugInfo) )
		return;

	TraceStart    = Location;
	TraceStart.Z += BaseEyeHeight;
	TraceEnd      = TraceStart+Vector(ViewRotation)*2000.0;

	Target = Trace( HitLocation, HitNormal, TraceEnd, TraceStart, true );
	if ( Target==None )
	{
		ClientMessage( "Nothing found..." );
		return;
	}

	GetLocalPhysics( Target );
	if ( !PlayerIsListenClient() )
		ClientMessage( Target.Name $ "'s remote physics are" @ GetEnum(Enum'EPhysics',Target.Physics) );
}
function GetLocalPhysics( Actor Target )
{
	ClientMessage( Target.Name $ "'s local physics are" @ GetEnum(Enum'EPhysics',Target.Physics) );
}

// Prints state of my very own PlayerPawn.
exec function GetMyState()
{
	if ( Game==None || !Game.AllowCommand(Self,'GetMyState',CMDTYPE_CheatDebugInfo) )
		return;

	GetMyLocalState();
	if ( !PlayerIsListenClient() )
		ClientMessage( "My remote state is" @ GetStateName() );
}
function GetMyLocalState()
{
	ClientMessage( "My local state is" @ GetStateName() );
}

// Prints physics of my very own PlayerPawn.
exec function GetMyPhysics()
{
	if ( Game==None || !Game.AllowCommand(Self,'GetMyPhysics',CMDTYPE_CheatDebugInfo) )
		return;

	GetMyLocalPhysics();
	if ( !PlayerIsListenClient() )
		ClientMessage( "My remote physics are" @ GetEnum(Enum'EPhysics',Physics) );
}
function GetMyLocalPhysics()
{
	ClientMessage( "My local physics are" @ GetEnum(Enum'EPhysics',Physics) );
}


// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// CheatSummon commands.
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

// Tries to find the class by string for Summon/SpawnMass and afterwards modifies it into the appropreciate class.
final function class<Actor> LoadSummonClass( string SummonClassName )
{
	local HXGameInfo Game;
	local class<Inventory> InventoryClass;
	local class<Actor> SummonClass;
	local Object Object;

	if ( SummonClassName=="" )
		return None;

	// Barf.
	if ( InStr(SummonClassName,".")!=-1 )
	{
		// Fully qualified name.
		SummonClass = class<Actor>( DynamicLoadObject(SummonClassName,class'Class',true) );
	}
	else
	{
		// We have only a single string here. So try inside Engine, DeusEx and HX package.
		SummonClass = class<Actor>( DynamicLoadObject("Engine."$SummonClassName,class'Class',true) );
		if ( SummonClass==None )
			SummonClass = class<Actor>( DynamicLoadObject("DeusEx."$SummonClassName,class'Class',true) );
		if ( SummonClass==None )
			SummonClass = class<Actor>( DynamicLoadObject("HX."$SummonClassName,class'Class',true) );

		// Search all loaded objects to try finding this class.
		foreach AllObjects( class'Object', Object )
		{
			if ( string(Object.Name)~=SummonClassName )
			{
				SummonClass = class<Actor>(Object);
				break;
			}
		}

		// As a last resort try with HX package and HX class prefix added.
		if ( SummonClass==None )
			SummonClass = class<Actor>( DynamicLoadObject("HX.HX"$SummonClassName,class'Class',true) );
	}

	// At least we tried.
	if ( SummonClass==None )
		return None;

	Game = HXGameInfo(Level.Game);
	if ( Game!=None )
	{
		// MissionScripts are omnited here, because they won't fully work when spawned
		// this way, etc.
		InventoryClass = class<Inventory>(SummonClass);
		if ( InventoryClass!=None )
		{
			Game.ModifyInventoryClass( InventoryClass );
			
			SummonClass = InventoryClass;
		}
		else
		{
			Game.ModifyActorClass( SummonClass );
		}
	}
	return SummonClass;
}

// Summons an Actor.
exec function Summon( string SummonClassName )
{
	local class<Actor> SpawnClass;

	if ( Game==None || !Game.AllowCommand(Self,'Summon',CMDTYPE_CheatSummon,1) )
		return;

	SpawnClass = LoadSummonClass( SummonClassName );
	if ( SpawnClass!=None )
	{
		Log( "Summon "$SpawnClass.Name$" ("$SummonClassName$")" );
		Spawn( SpawnClass,,,Location + (CollisionRadius+SpawnClass.Default.CollisionRadius+30) * Vector(Rotation) + vect(0,0,1) * 15 );
	}
	else
	{
		Log( "Summon failed ("$SummonClassName$")" );
	}
}

// Spawns a bunch of actors around the player.
exec function SpawnMass( Name SummonClassName, optional int TotalCount )
{
	ClientMessage( Sprintf("SummonClass: %s",SummonClassName) );
	ServerSpawnMass( string(SummonClassName), TotalCount );
}
function ServerSpawnMass( string SummonClassName, optional int TotalCount )
{
	local actor        spawnee;
	local vector       spawnPos;
	local vector       center;
	local rotator      direction;
	local int          maxTries;
	local int          count;
	local int          numTries;
	local float        maxRange;
	local float        range;
	local float        angle;
	local class<Actor> spawnClass;
	local string		ClassString;

	// Sadly, uc does not have the nice C++ default value stuff for unrealscript functions.
	if ( TotalCount==0 )
		TotalCount = 10;

	TotalCount = Clamp( TotalCount, 1, 250 );
	TotalCount = Min(TotalCount,250);

	if ( Game==None || !Game.AllowCommand(Self,'SpawnMass',CMDTYPE_CheatSummon,TotalCount) )
		return;

	SpawnClass = LoadSummonClass( SummonClassName );
	if ( SpawnClass==None )
	{
		ClientMessage("Illegal actor name "$GetItemName(SummonClassName));
		return;
	}

	maxTries = totalCount*2;
	count = 0;
	numTries = 0;
	maxRange = sqrt(totalCount/3.1416)*4*SpawnClass.Default.CollisionRadius;

	direction = ViewRotation;
	direction.pitch = 0;
	direction.roll  = 0;
	center = Location + Vector(direction)*(maxRange+SpawnClass.Default.CollisionRadius+CollisionRadius+20);
	while ((count < totalCount) && (numTries < maxTries))
	{
		angle = FRand()*3.14159265359*2;
		range = sqrt(FRand())*maxRange;
		spawnPos.X = sin(angle)*range;
		spawnPos.Y = cos(angle)*range;
		spawnPos.Z = 0;
		spawnee = spawn(SpawnClass,,,center+spawnPos, Rotation);
		if (spawnee != None)
			count++;
		numTries++;
	}

	ClientMessage( Sprintf("%i %s(s) spawned",Count,SpawnClass.Name) );
}


// Helper for AllXYZ spawning cheats.
final function class<Inventory> InventoryReplacementClass( class<Inventory> InClass )
{
	local HXGameInfo Game;
	Game = HXGameInfo(Level.Game);
	if ( Game!=None )
		Game.ModifyInventoryClass( InClass );
	return InClass;
}
final static function Vector RandomCheatSpawnPoint( Vector Location, float Radius )
{
	return Location+class'HXActor'.static.VDiskRand2D(Radius);
}


// Spawns all weapons in front of the player.
exec function AllWeapons()
{
	ServerAllWeapons();
}
function ServerAllWeapons()
{
	local Rotator ViewRotation2D;
	local Vector  SpawnDiskCenter;
	local float   SpawnDiskRadius;

	if ( Game==None || !Game.AllowCommand(Self,'AllWeapons',CMDTYPE_CheatSummon,24) )
		return;

	ViewRotation2D.Yaw = ViewRotation.Yaw;
	SpawnDiskCenter    = Location+(5.0*CollisionRadius)*Vector(ViewRotation2D);
	SpawnDiskRadius    = 3.0*CollisionRadius;

	Spawn( InventoryReplacementClass(class'WeaponAssaultGun'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'WeaponAssaultShotgun'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'WeaponBaton'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'WeaponCombatKnife'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'WeaponCrowbar'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'WeaponEMPGrenade'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'WeaponFlamethrower'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'WeaponGasGrenade'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'WeaponGEPGun'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'WeaponHideAGun'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'WeaponLAM'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'WeaponLAW'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'WeaponMiniCrossbow'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'WeaponNanoSword'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'WeaponNanoVirusGrenade'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'WeaponPepperGun'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'WeaponPistol'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'WeaponPlasmaRifle'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'WeaponProd'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'WeaponRifle'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'WeaponSawedOffShotgun'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'WeaponShuriken'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'WeaponStealthPistol'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'WeaponSword'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
}

// Spawns ammo of all types in front of the player.
exec function AllAmmo()
{
	ServerAllAmmo();
}
exec function ServerAllAmmo()
{
	local Rotator ViewRotation2D;
	local Vector  SpawnDiskCenter;
	local float   SpawnDiskRadius;

	if ( Game==None || !Game.AllowCommand(Self,'AllAmmo',CMDTYPE_CheatSummon,15) )
		return;

	ViewRotation2D.Yaw = ViewRotation.Yaw;
	SpawnDiskCenter    = Location+(4.0*CollisionRadius)*Vector(ViewRotation2D);
	SpawnDiskRadius    = 2.0*CollisionRadius;

	Spawn( InventoryReplacementClass(class'Ammo10mm'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'Ammo20mm'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'Ammo3006'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'Ammo762mm'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'AmmoBattery'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'AmmoDart'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'AmmoDartFlare'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'AmmoDartPoison'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'AmmoNapalm'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'AmmoPepper'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'AmmoPlasma'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'AmmoRocket'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'AmmoRocketWP'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'AmmoSabot'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'AmmoShell'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
}


// Spawns all pickups in front of the player.
exec function AllPickups()
{
	local HXAugmentationCannister AugmentationCannister;
	local Inventory NanoKey;
	local Rotator ViewRotation2D;
	local Vector  SpawnDiskCenter;
	local float   SpawnDiskRadius;
	local int     KeyLevel;
	local string  KeyColor;

	if ( Game==None || !Game.AllowCommand(Self,'AllPickups',CMDTYPE_CheatSummon,34) )
		return;

	ViewRotation2D.Yaw = ViewRotation.Yaw;
	SpawnDiskCenter    = Location+(4.0*CollisionRadius)*Vector(ViewRotation2D);
	SpawnDiskRadius    = 2.0*CollisionRadius;

	// Special Case for augmentation cannister.
	AugmentationCannister = HXAugmentationCannister(Spawn( InventoryReplacementClass(class'AugmentationCannister'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) ));
	if ( AugmentationCannister!=None )
	{
		switch ( Rand(9) )
		{
			case 0:
				AugmentationCannister.AddAugs[0] = 'HXAugMuscle';
				AugmentationCannister.AddAugs[1] = 'HXAugCombat';
				break;
			case 1:
				AugmentationCannister.AddAugs[0] = 'HXAugSpeed';
				AugmentationCannister.AddAugs[1] = 'HXAugStealth';
				break;
			case 2:
				AugmentationCannister.AddAugs[0] = 'HXAugDefense';
				AugmentationCannister.AddAugs[1] = 'HXAugDrone';
				break;
			case 3:
				AugmentationCannister.AddAugs[0] = 'HXAugVision';
				AugmentationCannister.AddAugs[1] = 'HXAugTarget';
				break;
			case 4:
				AugmentationCannister.AddAugs[0] = 'HXAugCloak';
				AugmentationCannister.AddAugs[1] = 'HXAugRadarTrans';
				break;
			case 5:
				AugmentationCannister.AddAugs[0] = 'HXAugBallistic';
				AugmentationCannister.AddAugs[1] = 'HXAugEMP';
				break;
			case 6:
				AugmentationCannister.AddAugs[0] = 'HXAugEnviro';
				AugmentationCannister.AddAugs[1] = 'HXAugAqualung';
				break;
			case 7:
				AugmentationCannister.AddAugs[0] = 'HXAugHealing';
				AugmentationCannister.AddAugs[1] = 'HXAugShield';
				break;
			case 8:
				AugmentationCannister.AddAugs[0] = 'HXAugPower';
				AugmentationCannister.AddAugs[1] = 'HXAugHeartLung';
				break;
		}
	}

	Spawn( InventoryReplacementClass(class'AugmentationUpgradeCannister'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'Binoculars'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'BioelectricCell'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'Credits'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'FireExtinguisher'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'Flare'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'MedKit'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );

	// Special case for NanoKey.
	NanoKey = Spawn( InventoryReplacementClass(class'NanoKey'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	if ( NanoKey!=None )
	{
		KeyLevel = Rand(4);

		switch ( KeyLevel )
		{
			case 0: KeyColor = "Blue";   break;
			case 1: KeyColor = "Green";  break;
			case 2: KeyColor = "Yellow"; break;
			case 3: KeyColor = "Red";    break;
		}

		NanoKey.SetPropertyText( "KeyID",       KeyColor$"Key"     );
		NanoKey.SetPropertyText( "Description", KeyColor@"Key"     );
		NanoKey.SetPropertyText( "SkinColor",  "SC_Level"$KeyLevel );
	}

	// Snacks.
	Spawn( InventoryReplacementClass(class'Candybar'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'SoyFood'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );

	// Beverages.
	Spawn( InventoryReplacementClass(class'Liquor40oz'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'LiquorBottle'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'Sodacan'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'WineBottle'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );

	// Drugs.
	Spawn( InventoryReplacementClass(class'VialCrack'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'HXVialVirus'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'VialAmbrosia'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'Cigarettes'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );

	// SkilledTool.
	Spawn( InventoryReplacementClass(class'Lockpick'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'Multitool'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );

	// ChargedPickup.
	Spawn( InventoryReplacementClass(class'AdaptiveArmor'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'BallisticArmor'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'HazMatSuit'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'Rebreather'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'TechGoggles'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );

	// WeaponMod.
	Spawn( InventoryReplacementClass(class'WeaponModAccuracy'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'WeaponModClip'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'WeaponModLaser'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'WeaponModRange'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'WeaponModRecoil'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'WeaponModReload'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'WeaponModScope'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'WeaponModSilencer'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
}

// Spawns all charged pickups in front of the player.
exec function AllChargedPickups()
{
	local Rotator ViewRotation2D;
	local Vector  SpawnDiskCenter;
	local float   SpawnDiskRadius;

	if ( Game==None || !Game.AllowCommand(Self,'AllChargedPickups',CMDTYPE_CheatSummon,5) )
		return;

	ViewRotation2D.Yaw = ViewRotation.Yaw;
	SpawnDiskCenter    = Location+(4.0*CollisionRadius)*Vector(ViewRotation2D);
	SpawnDiskRadius    = 1.5*CollisionRadius;

	// ChargedPickups.
	Spawn( InventoryReplacementClass(class'AdaptiveArmor'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'BallisticArmor'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'HazMatSuit'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'Rebreather'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'TechGoggles'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
}

// Spawns a lockpick and a multitool front of the player.
exec function AllSkilledTools()
{
	local Rotator ViewRotation2D;
	local Vector  SpawnDiskCenter;
	local float   SpawnDiskRadius;

	if ( Game==None || !Game.AllowCommand(Self,'AllSkilledTools',CMDTYPE_CheatSummon,2) )
		return;

	ViewRotation2D.Yaw = ViewRotation.Yaw;
	SpawnDiskCenter    = Location+(4.0*CollisionRadius)*Vector(ViewRotation2D);
	SpawnDiskRadius    = 1.0*CollisionRadius;

	// AllSkilledTools.
	Spawn( InventoryReplacementClass(class'Lockpick'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'Multitool'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
}

// Spawns all drug items in front of the player.
exec function AllDrugs()
{
	local Rotator ViewRotation2D;
	local Vector  SpawnDiskCenter;
	local float   SpawnDiskRadius;

	if ( Game==None || !Game.AllowCommand(Self,'AllDrugs',CMDTYPE_CheatSummon,4) )
		return;

	ViewRotation2D.Yaw = ViewRotation.Yaw;
	SpawnDiskCenter    = Location+(4.0*CollisionRadius)*Vector(ViewRotation2D);
	SpawnDiskRadius    = 1.0*CollisionRadius;

	// Drugs.
	Spawn( InventoryReplacementClass(class'Cigarettes'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'VialAmbrosia'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'VialCrack'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'HXVialVirus'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
}

// Spawns all food items in front of the player.
exec function AllFoods()
{
	local Rotator ViewRotation2D;
	local Vector  SpawnDiskCenter;
	local float   SpawnDiskRadius;

	if ( Game==None || !Game.AllowCommand(Self,'AllFoods',CMDTYPE_CheatSummon,6) )
		return;

	ViewRotation2D.Yaw = ViewRotation.Yaw;
	SpawnDiskCenter    = Location+(4.0*CollisionRadius)*Vector(ViewRotation2D);
	SpawnDiskRadius    = 1.5*CollisionRadius;

	// Snacks.
	Spawn( InventoryReplacementClass(class'Candybar'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'SoyFood'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );

	// Beverages.
	Spawn( InventoryReplacementClass(class'Liquor40oz'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'LiquorBottle'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'Sodacan'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'WineBottle'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
}

// Spawns a candybar and soyfood in front of the player.
exec function AllSnacks()
{
	local Rotator ViewRotation2D;
	local Vector  SpawnDiskCenter;
	local float   SpawnDiskRadius;

	if ( Game==None || !Game.AllowCommand(Self,'AllSnacks',CMDTYPE_CheatSummon,2) )
		return;

	ViewRotation2D.Yaw = ViewRotation.Yaw;
	SpawnDiskCenter    = Location+(4.0*CollisionRadius)*Vector(ViewRotation2D);
	SpawnDiskRadius    = 1.0*CollisionRadius;

	// Snacks.
	Spawn( InventoryReplacementClass(class'Candybar'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'SoyFood'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
}

// Spawns all beverages in front of the player.
exec function AllBeverages()
{
	local Rotator ViewRotation2D;
	local Vector  SpawnDiskCenter;
	local float   SpawnDiskRadius;

	if ( Game==None || !Game.AllowCommand(Self,'AllBeverages',CMDTYPE_CheatSummon,4) )
		return;

	ViewRotation2D.Yaw = ViewRotation.Yaw;
	SpawnDiskCenter    = Location+(4.0*CollisionRadius)*Vector(ViewRotation2D);
	SpawnDiskRadius    = 1.0*CollisionRadius;

	// Beverages.
	Spawn( InventoryReplacementClass(class'Liquor40oz'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'LiquorBottle'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'Sodacan'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'WineBottle'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
}

// Spawns all weapon mods in front of the player.
exec function AllWeaponMods()
{
	local Rotator ViewRotation2D;
	local Vector  SpawnDiskCenter;
	local float   SpawnDiskRadius;

	if ( Game==None || !Game.AllowCommand(Self,'AllWeaponMods',CMDTYPE_CheatSummon,8) )
		return;

	ViewRotation2D.Yaw = ViewRotation.Yaw;
	SpawnDiskCenter    = Location+(4.0*CollisionRadius)*Vector(ViewRotation2D);
	SpawnDiskRadius    = 1.5*CollisionRadius;

	// AllWeaponMods.
	Spawn( InventoryReplacementClass(class'WeaponModAccuracy'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'WeaponModClip'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'WeaponModLaser'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'WeaponModRange'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'WeaponModRecoil'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'WeaponModReload'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'WeaponModScope'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
	Spawn( InventoryReplacementClass(class'WeaponModSilencer'),,, RandomCheatSpawnPoint(SpawnDiskCenter,SpawnDiskRadius) );
}

// ----------------------------------------------------------------------------
// Walk()
// ----------------------------------------------------------------------------

exec function Walk()
{
	if (RestrictInput())
		return;

	if (!HXGameInfo(Level.Game).bCheatsEnabled)
		return;

	//if ( !bAdmin && (Level.Netmode != NM_Standalone) )
		//return;

	StartWalk();

	// Basically what client does in ClientReStart().
	Velocity = vect(0,0,0);
	Acceleration = vect(0,0,0);
	BaseEyeHeight = Default.BaseEyeHeight;
	EyeHeight = BaseEyeHeight;
	PlayWaiting();

	if ( Region.Zone.bWaterZone && PlayerRestartState=='PlayerWalking' )
	{
		if ( HeadRegion.Zone.bWaterZone )
			PainTime = UnderWaterTime;
		SetPhysics( PHYS_Swimming );
		GotoState( 'PlayerSwimming' );
	}
	else
		GotoState( PlayerReStartState );
}

function StartWalk()
{
	UnderWaterTime = Default.UnderWaterTime;	
	SetCollision( True, True, True );
	SetPhysics( PHYS_Walking );
	bCollideWorld = True;
	ClientReStart();	
}

exec function Fly()
{
	if (RestrictInput())
		return;

	if (!HXGameInfo(Level.Game).bCheatsEnabled)
		return;

	//if ( !bAdmin && (Level.Netmode != NM_Standalone) )
		//return;
		
	UnderWaterTime = Default.UnderWaterTime;	
	ClientMessage("You feel much lighter");
	SetCollision(true, true , true);
	bCollideWorld = true;

	GotoState('CheatFlying');
}

exec function Ghost()
{
	if (RestrictInput())
		return;

	if (!HXGameInfo(Level.Game).bCheatsEnabled)
		return;

	//if ( !bAdmin && (Level.Netmode != NM_Standalone) )
		//return;
	
	UnderWaterTime = -1.0;	
	ClientMessage("You feel ethereal");
	SetCollision(false, false, false);
	bCollideWorld = false;
	GotoState('CheatGhosting');
}

// ----------------------------------------------------------------------
// DXDumpInfo()
//
// Dumps the following player information to the log file
// - inventory (with item counts)
// - health (as %)
// - energy (as %)
// - credits
// - skill points (avail and max)
// - skills
// - augmentations
// ----------------------------------------------------------------------

exec function DXDumpInfo()
{
	ServerDXDumpInfo();
}

function ServerDXDumpInfo()
{
	local DumpLocation dumploc;
	local DeusExLevelInfo info;
	local string userName, mapName, strCopies;
	local Inventory item, nextItem;
	local DeusExWeapon W;
	local Skill skill;
	local Augmentation aug;
	local bool bHasAugs;

	if (!HXGameInfo(Level.Game).bCheatsEnabled)
		return;

	dumploc = CreateDumpLocationObject();
	if (dumploc != None)
	{
		userName = dumploc.GetCurrentUser();
		CriticalDelete(dumploc);
	}

	if (userName == "")
		userName = "NO USERNAME";

	mapName = "NO MAPNAME";
	foreach AllActors(class'DeusExLevelInfo', info)
		mapName = info.MapName;

	log("");
	log("**** DXDumpInfo - User: "$userName$" - Map: "$mapName$" ****");
	log("");
	log("  Inventory:");

	if (Inventory != None)
	{
		item = Inventory;
		do
		{
			nextItem = item.Inventory;

			if (item.bDisplayableInv || item.IsA('Ammo'))
			{
				W = DeusExWeapon(item);
				if ((W != None) && W.bHandToHand && (W.ProjectileClass != None))
					strCopies = " ("$W.AmmoType.AmmoAmount$" rds)";
				else if (item.IsA('Ammo') /* && (Ammo(item).PickupViewMesh != Mesh'TestBox')*/ )
					strCopies = " ("$Ammo(item).AmmoAmount$" rds)";
				else if (item.IsA('Pickup') && (Pickup(item).NumCopies > 1))
					strCopies = " ("$Pickup(item).NumCopies$")";
				else
					strCopies = "";

				log("    "$item.GetItemName(String(item.Class))$strCopies);
			}
			item = nextItem;
		}
		until (item == None);
	}
	else
		log("    Empty");

	GenerateTotalHealth();
	log("");
	log("  Health:");
	log("    Overall   - "$Health$"%");
	log("    Head      - "$HealthHead$"%");
	log("    Torso     - "$HealthTorso$"%");
	log("    Left arm  - "$HealthArmLeft$"%");
	log("    Right arm - "$HealthArmRight$"%");
	log("    Left leg  - "$HealthLegLeft$"%");
	log("    Right leg - "$HealthLegRight$"%");

	log("");
	log("  BioElectric Energy:");
	log("    "$Int(Energy)$"%");

	log("");
	log("  Credits:");
	log("    "$Credits);

	log("");
	log("  Skill Points:");
	log("    Available    - "$SkillPointsAvail);
	log("    Total Earned - "$SkillPointsTotal);

	log("");
	log("  Skills:");
	if (SkillSystem != None)
	{
		skill = SkillSystem.FirstSkill;
		while (skill != None)
		{
			if (skill.SkillName != "")
				log("    "$skill.SkillName$" - "$skill.skillLevelStrings[skill.CurrentLevel]);

			skill = skill.next;
		}
	}

	bHasAugs = False;
	log("");
	log("  Augmentations:");
	if (AugmentationSystem != None)
	{
		aug = AugmentationSystem.FirstAug;
		while (aug != None)
		{
			if (aug.bHasIt && (aug.AugmentationLocation != LOC_Default) && (aug.AugmentationName != ""))
			{
				bHasAugs = True;
				log("    "$aug.AugmentationName$" - Location: "$aug.AugLocsText[aug.AugmentationLocation]$" - Level: "$aug.CurrentLevel+1);
			}

			aug = aug.next;
		}
	}

	if (!bHasAugs)
		log("    None");

	log("");
	log("**** DXDumpInfo - END ****");
	log("");

	ClientMessage("Info dumped for user "$userName);
}

// ----------------------------------------------------------------------
// WinStats()
// ----------------------------------------------------------------------

exec function WinStats( bool bStatsOn )
{
	if ( RootWindow!=None )
		RootWindow.ShowStats( bStatsOn );
}

// ----------------------------------------------------------------------
// ToggleWinStats()
// ----------------------------------------------------------------------

exec function ToggleWinStats()
{
	//if ( !bCheatsEnabled )
		//return;
	if ( RootWindow!=None )
		RootWindow.ShowStats( !RootWindow.bShowStats );
}

// ----------------------------------------------------------------------
// WinFrames()
// ----------------------------------------------------------------------

exec function WinFrames( bool bFramesOn )
{
	//if ( !bCheatsEnabled )
		//return;
	if ( RootWindow!=None )
		RootWindow.ShowFrames( bFramesOn );
}

// ----------------------------------------------------------------------
// ToggleWinFrames()
// ----------------------------------------------------------------------

exec function ToggleWinFrames()
{
	//if ( !bCheatsEnabled )
		//return;
	if ( RootWindow!=None )
		RootWindow.ShowFrames( !RootWindow.bShowFrames );
}

// ----------------------------------------------------------------------
// Show*() Functions for ActorDisplay. Now forwarded to RootWindow.
// ----------------------------------------------------------------------

exec function ShowClass( Class<Actor> ViewClass )
{
	local HXRootWindow Root;
	//if ( !bCheatsEnabled )
		//return;
	Root = HXRootWindow(RootWindow);
	if ( Root!=None )
		Root.ShowClass( ViewClass );
}
exec function ShowEyes( bool bShow )
{
	local HXRootWindow Root;
	//if ( !bCheatsEnabled )
		//return;
	Root = HXRootWindow(RootWindow);
	if ( Root!=None )
		Root.ShowEyes( bShow );
}
exec function ShowArea( bool bShow )
{
	local HXRootWindow Root;
	//if ( !bCheatsEnabled )
		//return;
	Root = HXRootWindow(RootWindow);
	if ( Root!=None )
		Root.ShowArea( bShow );
}
exec function ShowCylinder( bool bShow )
{
	local HXRootWindow Root;
	//if ( !bCheatsEnabled )
		//return;
	Root = HXRootWindow(RootWindow);
	if ( Root!=None )
		Root.ShowCylinder( bShow );
}
exec function ShowMesh( bool bShow )
{
	local HXRootWindow Root;
	//if ( !bCheatsEnabled )
		//return;
	Root = HXRootWindow(RootWindow);
	if ( Root!=None )
		Root.ShowMesh( bShow );
}
exec function ShowZone( bool bShow )
{
	local HXRootWindow Root;
	//if ( !bCheatsEnabled )
		//return;
	Root = HXRootWindow(RootWindow);
	if ( Root!=None )
		Root.ShowZone( bShow );
}
exec function ShowLOS( bool bShow )
{
	local HXRootWindow Root;
	//if ( !bCheatsEnabled )
		//return;
	Root = HXRootWindow(RootWindow);
	if ( Root!=None )
		Root.ShowLOS( bShow );
}
exec function ShowVisibility( bool bShow )
{
	local HXRootWindow Root;
	//if ( !bCheatsEnabled )
		//return;
	Root = HXRootWindow(RootWindow);
	if ( Root!=None )
		Root.ShowVisibility( bShow );
}
exec function ShowData( bool bShow )
{
	local HXRootWindow Root;
	//if ( !bCheatsEnabled )
		//return;
	Root = HXRootWindow(RootWindow);
	if ( Root!=None )
		Root.ShowData( bShow );
}
exec function ShowEnemyResponse( bool bShow )
{
	local HXRootWindow Root;
	//if ( !bCheatsEnabled )
		//return;
	Root = HXRootWindow(RootWindow);
	if ( Root!=None )
		Root.ShowEnemyResponse( bShow );
}
exec function ShowState( bool bShow )
{
	local HXRootWindow Root;
	//if ( !bCheatsEnabled )
		//return;
	Root = HXRootWindow(RootWindow);
	if ( Root!=None )
		Root.ShowState( bShow );
}
exec function ShowEnemy( bool bShow )
{
	local HXRootWindow Root;
	//if ( !bCheatsEnabled )
		//return;
	Root = HXRootWindow(RootWindow);
	if ( Root!=None )
		Root.ShowEnemy( bShow );
}
exec function ShowInstigator( bool bShow )
{
	local HXRootWindow Root;
	//if ( !bCheatsEnabled )
		//return;
	Root = HXRootWindow(RootWindow);
	if ( Root!=None )
		Root.ShowInstigator( bShow );
}
exec function ShowBase( bool bShow )
{
	local HXRootWindow Root;
	//if ( !bCheatsEnabled )
		//return;
	Root = HXRootWindow(RootWindow);
	if ( Root!=None )
		Root.ShowBase( bShow );
}
exec function ShowLight( bool bShow )
{
	local HXRootWindow Root;
	//if ( !bCheatsEnabled )
		//return;
	Root = HXRootWindow(RootWindow);
	if ( Root!=None )
		Root.ShowLight( bShow );
}
exec function ShowDist( bool bShow )
{
	local HXRootWindow Root;
	//if ( !bCheatsEnabled )
		//return;
	Root = HXRootWindow(RootWindow);
	if ( Root!=None )
		Root.ShowDist( bShow );
}
exec function ShowBindName( bool bShow )
{
	local HXRootWindow Root;
	//if ( !bCheatsEnabled )
		//return;
	Root = HXRootWindow(RootWindow);
	if ( Root!=None )
		Root.ShowBindName( bShow );
}
exec function ShowPos( bool bShow )
{
	local HXRootWindow Root;
	//if ( !bCheatsEnabled )
		//return;
	Root = HXRootWindow(RootWindow);
	if ( Root!=None )
		Root.ShowPos( bShow );
}
exec function ShowHealth( bool bShow )
{
	local HXRootWindow Root;
	//if ( !bCheatsEnabled )
		//return;
	Root = HXRootWindow(RootWindow);
	if ( Root!=None )
		Root.ShowHealth( bShow );
}
exec function ShowPhysics( bool bShow )
{
	local HXRootWindow Root;
	//if ( !bCheatsEnabled )
		//return;
	Root = HXRootWindow(RootWindow);
	if ( Root!=None )
		Root.ShowPhysics( bShow );
}
exec function ShowMass( bool bShow )
{
	local HXRootWindow Root;
	//if ( !bCheatsEnabled )
		//return;
	Root = HXRootWindow(RootWindow);
	if ( Root!=None )
		Root.ShowMass( bShow );
}
exec function ShowVelocity( bool bShow )
{
	local HXRootWindow Root;
	//if ( !bCheatsEnabled )
		//return;
	Root = HXRootWindow(RootWindow);
	if ( Root!=None )
		Root.ShowVelocity( bShow );
}
exec function ShowAcceleration( bool bShow )
{
	local HXRootWindow Root;
	//if ( !bCheatsEnabled )
		//return;
	Root = HXRootWindow(RootWindow);
	if ( Root!=None )
		Root.ShowAcceleration( bShow );
}

// ----------------------------------------------------------------------
// ClientSpawnHits
// ----------------------------------------------------------------------

simulated function ClientSpawnHits( bool bPenetrating, bool bHandToHand, Vector HitLocation, Vector HitNormal, Actor Other, float Damage)
{
   local HXTraceHitSpawner hitspawner;

   if (bPenetrating)
   {
      if (bHandToHand)
      {
         hitspawner = Spawn(class'HXTraceHitHandSpawner',Other,,HitLocation,Rotator(HitNormal));
      }
      else
      {
         hitspawner = Spawn(class'HXTraceHitSpawner',Other,,HitLocation,Rotator(HitNormal));
			hitspawner.HitDamage = Damage;
      }
   }
   else
   {
      if (bHandToHand)
      {
         hitspawner = Spawn(class'HXTraceHitHandNonPenSpawner',Other,,HitLocation,Rotator(HitNormal));
      }
      else
      {
         hitspawner = Spawn(class'HXTraceHitNonPenSpawner',Other,,HitLocation,Rotator(HitNormal));
      }
   }
   if (hitSpawner != None)
      hitspawner.HitDamage = Damage;
}


/* Adjust hit location - adjusts the hit location in for pawns, and returns
true if it was really a hit, and false if not (for ducking, etc.)
*/
simulated function bool AdjustHitLocation(out vector HitLocation, vector TraceDir)
{
	local float adjZ, maxZ, scale;
	local Vector adjTraceDir;

/*
	if ( Level.NetMode != NM_Standalone )
	{
		TraceDir = Normal(TraceDir);
		AdjTraceDir = TraceDir;
		AdjTraceDir.Z = 0.0;
		AdjTraceDir = Normal(AdjTraceDir);
		scale = TraceDir dot AdjTraceDir;
		HitLocation = HitLocation + ( CollisionRadius * 0.60 * TraceDir ) / scale;
		if ( BaseEyeHeight == Default.BaseEyeHeight )
			return true;

		maxZ = Location.Z + EyeHeight + 0.25 * CollisionHeight;
		if ( HitLocation.Z > maxZ )
		{
			if ( TraceDir.Z >= 0 )
				return false;
			adjZ = (maxZ - HitLocation.Z)/TraceDir.Z;
			HitLocation.Z = maxZ;
			HitLocation.X = HitLocation.X + TraceDir.X * adjZ;
			HitLocation.Y = HitLocation.Y + TraceDir.Y * adjZ;
			if ( VSize(HitLocation - Location) > CollisionRadius )	
				return false;
		}
	}
*/
//	else
//	{
		TraceDir = Normal(TraceDir);
		HitLocation = HitLocation + 0.5 * CollisionRadius * TraceDir;
		if ( BaseEyeHeight == Default.BaseEyeHeight )
			return true;
		maxZ = Location.Z + EyeHeight + 0.25 * CollisionHeight;
		if ( HitLocation.Z > maxZ )
		{
			if ( TraceDir.Z >= 0 )
				return false;
			adjZ = (maxZ - HitLocation.Z)/TraceDir.Z;
			HitLocation.Z = maxZ;
			HitLocation.X = HitLocation.X + TraceDir.X * adjZ;
			HitLocation.Y = HitLocation.Y + TraceDir.Y * adjZ;
			if ( VSize(HitLocation - Location) > CollisionRadius )	
				return false;
		}
//	}
	return true;
}

// ----------------------------------------------------------------------
// ClientPlayActorSpeech()
// ----------------------------------------------------------------------

function ClientPlayActorSpeech( int serverSoundID, string speechclassstr, Actor Speaker, float Radius )
{
	local Sound speech;

	//Log( "ClientPlayActorSpeech( " $ serverSoundID $ ", " $ speech $ ", " $ Speaker $ ", " $ Radius $ " ) called." );

	speech = Sound( DynamicLoadObject( speechclassstr, class'Sound' ) );

	//Log( speech );
	//speech = None;

	if ( Speaker != None && speech != None )
		ClientSoundIDMapping[ serverSoundID % 16 ] = Speaker.PlaySound( speech, SLOT_Talk, , , Radius );
		//Speaker.PlayOwnedSound( speech, SLOT_Talk, , , Radius );
}

// ----------------------------------------------------------------------
// ClientPlayActorCinematicSpeech()
// ----------------------------------------------------------------------

simulated function ClientPlayActorCinematicSpeech( int serverSoundID, string speechclassstr, Actor Speaker, float Radius )
{
	local Sound speech;

	//Log( "ClientPlayActorCinematicSpeech( " $ serverSoundID $ ", " $ speech $ ", " $ Speaker $ ", " $ Radius $ " ) called." );

	speech = Sound( DynamicLoadObject( speechclassstr, class'Sound' ) );

	//Log( speech );
	//speech = None;

	if ( speech != None )
	{
		// Check how close the player is to this actor.  If the player is 
		// close enough to the speaker, play through the speaker.
		if ((speaker == None) || (VSize( Location - speaker.Location ) > 400))
		{
			ClientSoundIDMapping[serverSoundID % 16 ] = PlaySound( speech, SLOT_Talk, , , Radius );
		}
		else
		{
			ClientSoundIDMapping[serverSoundID % 16 ] = Speaker.PlaySound( speech, SLOT_Talk, , , Radius );
		}
	}
}

// ----------------------------------------------------------------------
// ClientStopActorSpeech()
// ----------------------------------------------------------------------

function ClientStopActorSpeech( int serverSoundID )
{
	//Log( "ClientStopActorSpeech( " $ serverSoundID $ " ) called." );

	if ( ClientSoundIDMapping[ serverSoundID % 16 ] != 0 )
		StopSound( ClientSoundIDMapping[ serverSoundID % 16 ] );
}

// ----------------------------------------------------------------------
// CheckConversationHeightDifference()
//
// Checks to make sure the player and the invokeActor are fairly close
// to each other on the Z Plane.  Returns True if they are an 
// acceptable distance, otherwise returns False.
// ----------------------------------------------------------------------

function bool CheckConversationHeightDifference(Actor invokeActor, int heightOffset)
{
	local Int dist;

	// HX_NOTE added another abs
	dist = Abs( Abs(Location.Z - invokeActor.Location.Z) - Abs(Default.CollisionHeight - CollisionHeight) );

	if (dist > (Abs(CollisionHeight - invokeActor.CollisionHeight) + heightOffset))
		return False;
	else
		return True;
}

// ----------------------------------------------------------------------
// ClientEnterConversation
// ----------------------------------------------------------------------

function ClientEnterConversation()
{
	//Log( "ClientEnterConversation()" );

	GotoState('Conversation');
}

// ----------------------------------------------------------------------
// ClientLeaveConversation
// ----------------------------------------------------------------------

function ClientLeaveConversation()
{
	//Log( "ClientLeaveConversation() => NextState = " $ NextState );

	if ((Health > 0) && ((IsInState('Conversation')) || (NextState == 'Interpolating')))
	{
		if (NextState == '')
			GotoState('PlayerWalking');
		else
			GotoState(NextState);
	}

}

// ----------------------------------------------------------------------
// state Conversation
// ----------------------------------------------------------------------

state Conversation
{
	ignores SeePlayer, HearNoise, Bump;

	// Do not accept any client belt modification requests.
	function RemoveObjectFromBelt( Inventory Item )
	{
		ClientMessage( "Nope: Conversation: RemoveObjectFromBelt", 'StatusLine' );
	}
	function ClearPosition( int Position );
	function ClearBelt();
	function AddObjectToBelt( Inventory Item, int Position, bool bUnused )
	{
		ClientMessage( "Nope: Conversation: AddObjectToBelt", 'StatusLine' );
	}

	// !! Reject Inventory transaction rejects as well. !!

	// Maybe...
	//function int HealPlayer( int HealPoints, optional Bool bUseMedicineSkill );
	//function     DrugPlayer( float Duration );

	exec function ActivateBelt( int Position );
	exec function ParseLeftClick();
	exec function ParseRightClick();

	exec function Suicide();
	exec function SwitchAmmo();
	exec function bool DropItem( optional Inventory Item, optional bool bDrop );
	exec function DropAmmo( Class<HXAmmo> AmmoClass, optional bool bDrop );
	exec function _ActivateAugmentation( int AugKey );
	exec function ActivateAugmentation( int AugKey );
	exec function DeactivateAugmentation( int AugKey );
	exec function ToggleAugmentation( int AugKey );

	exec function PutInHand( optional Inventory Item )
	{
		// Still allow putting away items.
		if ( Item==None )
			Global.PutInHand( None );
	}

	function ServerMove
	(
		float TimeStamp, 
		vector Accel, 
		vector ClientLoc,
		bool NewbRun,
		bool NewbDuck,
		bool NewbJumpStatus,
		bool bFired,
		bool bAltFired,
		bool bForceFire,
		bool bForceAltFire,
		eDodgeDir DodgeMove, 
		byte ClientRoll, 
		int View,
		optional byte OldTimeDelta,
		optional int OldAccel
	)
	{
		Global.ServerMove(
					TimeStamp,
					vect(0,0,0), 
					ClientLoc,
					false,
					false,
					false, 
					false,
					false,
					false,
					false,
					DODGE_None, 
					0, //ClientRoll, 
					View);
	}

	function PlayerMove(Float DeltaTime)
	{
		//if ( ViewRotation.Pitch < 0 )
			//ViewRotation.Pitch = 0;

		// Make sure we're stopped
		Velocity.X = 0;
		Velocity.Y = 0;
		Velocity.Z = 0;

		Acceleration = Velocity;

		if ( Role < ROLE_Authority ) // then save this move and replicate it
			ReplicateMove(DeltaTime, vect(0,0,0), DODGE_None, rot(0,0,0));
		else
			ProcessMove(DeltaTime, vect(0,0,0), DODGE_None, rot(0,0,0));
	}

	event TickStuff( float DeltaTime )
	{
		local rotator tempRot;
		local float   yawDelta;

		Global.TickStuff( DeltaTime );

		// Keep turning towards the person we're speaking to
		if ( ConversationActor != None )
		{
			LookAtActor(ConversationActor, true, true, true, 0, 0.5);

			// Hacky way to force the player to turn...
			tempRot = rot(0,0,0);
			tempRot.Yaw = (DesiredRotation.Yaw - Rotation.Yaw) & 65535;
			if (tempRot.Yaw > 32767)
				tempRot.Yaw -= 65536;
			yawDelta = RotationRate.Yaw * deltaTime;
			if (tempRot.Yaw > yawDelta)
				tempRot.Yaw = yawDelta;
			else if (tempRot.Yaw < -yawDelta)
				tempRot.Yaw = -yawDelta;
			SetRotation(Rotation + tempRot);
		}

		if ( Role == ROLE_Authority )
		{
			// Check if all the people involved in a conversation are 
			// still within a reasonable radius.
			HXGameInfo(Level.Game).CheckActorDistances( Self );

			LipSynch(deltaTime);
		}
	}

	event PlayerTick(float deltaTime)
	{
		local rotator tempRot;
		local float   yawDelta;

		UpdateInHand();
		UpdateDynamicMusic(deltaTime);

		DrugEffects(deltaTime);
		Bleed(deltaTime);

		// must update viewflash manually incase a flash happens during a convo
		ViewFlash(deltaTime);

		Super(PlayerPawnExt).PlayerTick(deltaTime);
	}

	function LoopHeadConvoAnim()
	{
	}


	function BeginState()
	{
		// Downgrade RemoteRole, so we can conversation stream animations.
		//RemoteRole = ROLE_SimulatedProxy;
	}

	function EndState()
	{
		// Restore RemoteRole.
		//RemoteRole = ROLE_AutonomousProxy;

		// Maybe not that great idea.
		HXGameInfo(Level.Game).conPlay = None;

		// Re-enable the PC's detectability
		//MakePlayerIgnored(false);

		MoveTarget = None;
		bBehindView = false;
		StopBlendAnims();
		ConversationActor = None;

		bInThirdPersonCameraOverride = false;

		if ( Role < ROLE_Authority )
		{
			//PlayTurnHead(LOOK_Forward, 1.0, 1.0);
			//bWasSpeaking = False;
			//TweenBlendAnim('MouthClosed', 0.1);
		}
		//Log( Self $ ".Conversation.EndState() called." );

		if ( RemoteRole == ROLE_AutonomousProxy )
			ClientLeaveConversation();
	}

Begin:
	// Make sure we're stopped
	Velocity.X = 0;
	Velocity.Y = 0;
	Velocity.Z = 0;

	Acceleration = Velocity;

	PlayRising();

	// Make sure the player isn't on fire!
	if (bOnFire)
		ExtinguishFire();

	// Make sure the PC can't be attacked while in conversation
	//MakePlayerIgnored(true);

	if ( Role == ROLE_Authority )
		LookAtActor(conPlay.startActor, true, false, true, 0, 0.5);

	DesiredRotation.Pitch = 0.0;
	SetRotation(DesiredRotation);

	PlayTurning();
//	TurnToward(conPlay.startActor);
//	TweenToWaiting(0.1);
//	FinishAnim();

	if (!HXGameInfo(Level.Game).ConPlay.StartCoopConversation(Self))
	{
		HXGameInfo(Level.Game).AbortConversation(True);
	}
	else
	{
		// Put away whatever the PC may be holding
		HXGameInfo(Level.Game).conPlay.SetInHand(InHand);
		PutInHand(None);
		UpdateInHand();

		// don't set bInThirdPersonCameraOverride yet, since we have not yet a valid shot

		if ( HXGameInfo(Level.Game).conPlay.GetDisplayMode() == DM_ThirdPerson )
			bBehindView = true;	

		if ( RemoteRole == ROLE_AutonomousProxy )
			ClientEnterConversation();
	}
}

// ----------------------------------------------------------------------
// ClientCreateConWinThird()
// ----------------------------------------------------------------------

function ClientCreateConWinThird( bool bForcePlay )
{
	HXRootWindow(rootWindow).ClearWindowStack();

	// Hide the hud display if this is a third-person convo
	HXRootWindow(rootWindow).hud.Hide();
	HXRootWindow(rootWindow).ShowCursor( False );

	if ( conWinThird == None )
		conWinThird = HXConWindowActive(rootWindow.NewChild(Class'HXConWindowActive', False));

	conWinThird.SetForcePlay(bForcePlay);

	// Align the conversation window
	conWinThird.SetWindowAlignments(HALIGN_Full, VALIGN_Full);
	conWinThird.Clear();
	conWinThird.Show();
	conWinThird.RestrictInput( False );
}

// ----------------------------------------------------------------------
// ClientDisplayConWinThirdLine()
// ----------------------------------------------------------------------

function ClientDisplayConWinThirdLine( string speakerName, string speakerText, Actor speakingActor )
{
	// speakingActor is only checked if it's a DeusExPlayer
	if ( conWinThird != None )
	{
		// Clear the window
		conWinThird.Clear();

		conWinThird.DisplayName( speakerName );
		conWinThird.DisplayText( speakerText, speakingActor );

		conWinThird.RestrictInput( False );
	}
}

// ----------------------------------------------------------------------
// ClientAddConWinThirdLine()
// ----------------------------------------------------------------------

function ClientAddConWinThirdLine( string speech )
{
	// speakingActor is only checked if it's a DeusExPlayer

	if ( conWinThird != None )
	{
		conWinThird.AppendText( speech );

		conWinThird.RestrictInput( False );
	}
}

// ----------------------------------------------------------------------
// ClientDisplayConWinThirdChoice()
// ----------------------------------------------------------------------

function ClientDisplayConWinThirdChoice( coerce string choiceName, int choiceMask )
{
	local ConEventChoice choiceEvent;
	local ConChoice choice;
	local int choiceCount;

	if ( conWinThird != None )
	{
		conWinThird.RestrictInput( True );

		choiceEvent = ConEventChoice( DynamicLoadObject( choiceName, class'ConEventChoice' ) );

		//Log( choiceEvent );
		//Log( choiceEvent.ChoiceList );
		//Log( choiceMask );

		if ( choiceEvent.bClearScreen )
			conWinThird.Clear();

		choice = choiceEvent.ChoiceList;
		choiceCount = 0;

		while( choice != None )
		{	
			if ( (choiceMask & ( 1 << choiceCount ) ) != 0 )
			{
				if ( choice.skillNeeded != None )
				{
					conWinThird.DisplaySkillChoice( choice );
				}
				else
				{
					conWinThird.DisplayChoice( choice );
				}
			}

			choiceCount++;
			choice = choice.nextChoice;
		}		

		conWinThird.RestrictInput( False );
	}
}

// ----------------------------------------------------------------------
// ClientDestroyConWinThird()
// ----------------------------------------------------------------------

function ClientDestroyConWinThird()
{
	if ( conWinThird != None )
		//conWinThird.Destroy();
		conWinThird.Close();

	// Show the hud display if this was a third-person convo
	//HXRootWindow(rootWindow).hud.Show();
}

// ----------------------------------------------------------------------
// ServerPlayNextConPlayEvent()
// ----------------------------------------------------------------------

function ServerPlayNextConPlayEvent()
{
	if ( HXGameInfo(Level.Game)!=None )
		if ( HXGameInfo(Level.Game).ConPlay!=None )
			HXGameInfo(Level.Game).ConPlay.SkipCurrent();
}

// ----------------------------------------------------------------------
// ServerPlayConPlayChoice()
// ----------------------------------------------------------------------

function ServerPlayConPlayChoice( int index )
{
	if ( HXGameInfo(Level.Game)!=None )
		if ( HXGameInfo(Level.Game).ConPlay!=None )
			HXGameInfo(Level.Game).ConPlay.PlayChoiceByIndex( index );
}

// ----------------------------------------------------------------------
// EndConversation()
//
// Called by ConPlay when a conversation has finished.
// ----------------------------------------------------------------------

function EndConversation()
{
	local DeusExLevelInfo info;

	Super(PlayerPawnExt).EndConversation();

	// If we're in a bForcePlay (cinematic) conversation,
	// force the CinematicWindow to be displayd
	//if ((conPlay != None) && (conPlay.GetForcePlay()))
	//{
		//if (HXRootWindow(rootWindow) != None)
			//HXRootWindow(rootWindow).NewChild(class'CinematicWindow');
	//}

	//conPlay = None;

	// Check to see if we need to resume any DataLinks that may have
	// been aborted when we started this conversation
	ClientResumeDataLinks();

	StopBlendAnims();

	// We might already be dead at this point (someone drop a LAM before
	// entering the conversation?) so we want to make sure the player
	// doesn't suddenly jump into a non-DEATH state.
	//
	// Also make sure the player is actually in the Conversation state
	// before attempting to kick him out of it.

	//Log( "NextState = " $ NextState );


	if ((Health > 0) && ((IsInState('Conversation')) || (IsInState('FirstPersonConversation')) || (NextState == 'Interpolating')))
	{
		//Log( "BLUB" );
		if (NextState == '')
			GotoState('PlayerWalking');
		else
			GotoState(NextState);
	}
}


// ----------------------------------------------------------------------
// PlayerCalcView()
// ----------------------------------------------------------------------

simulated function PlayerCalcView( out actor ViewActor, out vector CameraLocation, out rotator CameraRotation )
{
	//Log( "(PCV)" $ bInThirdPersonCameraOverride );

	// if a ConCamera object calculated a view for us. (maybe use components for loc and rot)
	if ( bInThirdPersonCameraOverride )
	{
		CameraLocation	= ThirdPersonCameraLocation;
		CameraRotation	= ThirdPersonCameraRotation;
		//ViewActor				= ThirdPersonCameraViewActor;
		ViewActor = Self;
		//return;
	}

	// check for spy drone and freeze player's view
	else if ( bSpyDroneActive )
	{
		if ( aDrone != None )
		{
			// First-person view.
			CameraLocation = Location;
			CameraLocation.Z += EyeHeight;
			CameraLocation += WalkBob;
			//return;
		}
	}

	// Check if we're in first-person view or third-person.  If we're in first-person then
	// we'll just render the normal camera view.  Otherwise we want to place the camera
	// as directed by the conPlay.cameraInfo object.

	//if ( bBehindView && (!InConversation()) )
	else if ( bBehindView )
	{
		Super(PlayerPawnExt).PlayerCalcView(ViewActor, CameraLocation, CameraRotation);
		//return;
	}

	//if ( (!InConversation()) || ( conPlay.GetDisplayMode() == DM_FirstPerson ) )
	else
	{
		// First-person view.
		ViewActor = Self;
		CameraRotation = ViewRotation;
		CameraLocation = Location;
		CameraLocation.Z += EyeHeight;
		CameraLocation += WalkBob;
		//return;
	}

	// Allow the ConCamera object to calculate the camera position and 
	// rotation for us (in other words, take this sloppy routine and 
	// hide it elsewhere).

	//if (conPlay.cameraInfo.CalculateCameraPosition(ViewActor, CameraLocation, CameraRotation) == False)
		//Super.PlayerCalcView(ViewActor, CameraLocation, CameraRotation);
}

// ----------------------------------------------------------------------
// RemoveItemDuringConversation()
// ----------------------------------------------------------------------

function RemoveItemDuringConversation(Inventory item)
{
	if (item != None)
	{
		// take it out of our hand
		if (item == inHand)
			PutInHand(None);

		// Make sure it's removed from the inventory grid
		RemoveItemFromSlot(item);

		// Make sure the item is deactivated!
		if (item.IsA('HXWeapon'))
		{
			HXWeapon(item).ScopeOff();
			HXWeapon(item).LaserOff();
		}
		else if (item.IsA('HXPickup'))
		{
			// turn it off if it is on
			if (HXPickup(item).bActive)
				HXPickup(item).Activate();
		}
		
		if (HXGameInfo(Level.Game).conPlay != None)
			HXGameInfo(Level.Game).conPlay.SetInHand(None);
	}
}

// ----------------------------------------------------------------------
// ActivateSpecialComputerOption()
// ----------------------------------------------------------------------

function ActivateSpecialComputerOption( HXComputers comp, int specialIndex )
{
	if ( comp != none )
		comp.ActivateSpecialOption( specialIndex );
}

// ----------------------------------------------------------------------
// ComputerToggleDoorLock()
// ----------------------------------------------------------------------

function ComputerToggleDoorLock( name doorTag )
{
	local Mover M;

	foreach AllActors( class'Mover', M, doorTag )
	{
		if ( M.isA('HXMover'))
			HXMover(M).bLocked = !HXMover(M).bLocked;
		else if ( M.isA('DeusExMover') )
			DeusExMover(M).bLocked = !DeusExMover(M).bLocked;
	}
}

// ----------------------------------------------------------------------
// ComputerTriggerDoor()
// ----------------------------------------------------------------------

function ComputerTriggerDoor( HXElectronicDevices comp, name doorTag )
{
	local Mover M;

	// be sure to trigger all matching tagged doors
	foreach AllActors( class'Mover', M, doorTag )
		if ( M.isA('HXMover') || M.isA('DeusExMover') )
			M.Trigger( comp, Self );

}

// ----------------------------------------------------------------------
// FailRootWindowCheck()
// ----------------------------------------------------------------------

function FailRootWindowCheck()
{
	if (Level.Game.IsA('HXGameInfo'))
		HXGameInfo(Level.Game).FailRootWindowCheck(Self);
}

// ----------------------------------------------------------------------
// FailConsoleCheck()
// ----------------------------------------------------------------------

function FailConsoleCheck()
{
	if (Level.Game.IsA('HXGameInfo'))
		HXGameInfo(Level.Game).FailConsoleCheck(Self);
}

// ----------------------------------------------------------------------
// SendActorOnPath()
//
// Notifies a client of the start of an interpolation event
// ----------------------------------------------------------------------

function SendActorOnPath( Name InterpolationEvent )
{
	local InterpolationPoint I;
	local Actor A;

	Log( Self $ ".SendActorOnPath( " $ InterpolationEvent $ " )" );

	if ( Role == ROLE_Authority )
		return;

	// find the target actors to start on the path
	foreach AllActors (class'Actor', A, InterpolationEvent)
	{
		if ((A != None) && !A.IsA('InterpolationPoint'))
		{
			//Log( "Dumping IP Info for " $ A.Event );

			//foreach AllActors (class'InterpolationPoint', I, A.Event)
			//{
				//Log( "-------------------------------");

				//if ( I.IsA('HXInterpolationPoint') )
					//HXInterpolationPoint(I).PrintInfo();
				//else
					//Log( "Found non HX IP:" @ I );

				//Log( "Interpolation point" @ I.Tag @ I.Position $ ":" );
				//if( I.Prev != None )
					//Log( "   Prev # " $ I.Prev.Position );
				//if( I.Next != None )
					//Log( "   Next # " $ I.Next.Position );
			//}

			//Log( "-------------------------------");

			foreach AllActors (class'InterpolationPoint', I, A.Event)
			{
				if (I.Position == 1)		// start at 1 instead of 0 - put 0 at the object's initial position
				{
					A.SetCollision(False, False, False);
					A.bCollideWorld = False;
					A.Target = I;
					A.SetPhysics(PHYS_Interpolating);
					A.PhysRate = 1.0;
					A.PhysAlpha = 0.0;
					A.bInterpolating = True;
					A.bStasis = False;
					A.GotoState('Interpolating');

					//Log( "Stuff called." );
					break;
				}
			}
		}
	}
}


// ----------------------------------------------------------------------
// state Interpolating
// ----------------------------------------------------------------------

state Interpolating
{
	//ignores all;

	function     TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, Vector momentum, name damageType );
	function int HealPlayer( int HealPoints, optional Bool bUseMedicineSkill );
	function     DrugPlayer( float Duration );

	exec function ActivateBelt( int Position );
	exec function ParseLeftClick();
	exec function ParseRightClick();

	exec function Suicide();
	exec function SwitchAmmo();
	exec function bool DropItem( optional Inventory Item, optional bool bDrop );
	exec function DropAmmo( Class<HXAmmo> AmmoClass, optional bool bDrop );
	exec function _ActivateAugmentation( int AugKey );
	exec function ActivateAugmentation( int AugKey );
	exec function DeactivateAugmentation( int AugKey );
	exec function ToggleAugmentation( int AugKey );

	exec function PutInHand( optional Inventory Item )
	{
		// Still allow putting away items.
		if ( Item==None )
			Global.PutInHand( None );
	}

	

	function ProcessMove( float DeltaTime, vector NewAccel, eDodgeDir DodgeMove, rotator DeltaRot )	
	{
		//Acceleration = Normal(NewAccel);
		//Velocity = Normal(NewAccel) * 300;
		//AutonomousPhysics(DeltaTime);
	}

	function PlayerMove( float DeltaTime )
	{
	}

	function UpdateRotation( float DeltaTime, float maxPitch )
	{
	}

	simulated function PlayerCalcView( out actor ViewActor, out vector CameraLocation, out rotator CameraRotation )
	{
		// First-person view.
		if ( ClientInterpolationDummy!=None )
		{
			ViewActor = Self;
			CameraRotation = ClientInterpolationDummy.Rotation;
			CameraLocation = ClientInterpolationDummy.Location;
			CameraLocation.Z += EyeHeight; // Yes/No?
		}
		else
		{
			ViewActor = Self;
			CameraRotation = ViewRotation;
			CameraLocation = Location;
			CameraLocation.Z += EyeHeight; // Yes/No?
		}
	}

	exec function Fire(optional float F)
	{
		local DeusExLevelInfo DeusExLevelInfo;

		// Only bring up the menu if we're not in a mission outro.
		DeusExLevelInfo = GetLevelInfo();
		if ( Level.NetMode==NM_StandAlone && DeusExLevelInfo!=None && DeusExLevelInfo.MissionNumber<0 )
			ShowMainMenu();
	}
/*
	event PlayerTick(float deltaTime)
	{
		UpdateInHand();
		UpdateDynamicMusic(deltaTime);
		ShowHud(False);
	}
*/
Begin:
	// Hide
	bHidden = True;

	KillShadow();

	if (bOnFire)
		ExtinguishFire();

	bDetectable = False;

	// put away your weapon
	if (Weapon != None)
	{
		Weapon.bHideWeapon = True;
		Weapon = None;
		PutInHand(None);
	}

	// can't carry decorations across levels
	if (CarriedDecoration != None)
	{
		CarriedDecoration.Destroy();
		CarriedDecoration = None;
	}

	SetCollision(false, false, false);
	PlayAnim('Still');
	SetPhysics(PHYS_Interpolating);
}


// check to see if we are done interpolating, if so, then travel to the next map
simulated event InterpolateEnd(Actor Other)
{
	//Log( Self@"InterpolateEnd()" );

	if (InterpolationPoint(Other).bEndOfPath)
		if (NextMap != "")
		{
			// DEUS_EX_DEMO
			//
			// If this is the demo, show the demo splash screen, which
			// will exit the game after the player presses a key/mouseclick
//				if (NextMap == "02_NYC_BatteryPark")
//					ShowDemoSplash();
//				else
				//Level.Game.SendPlayer(Self, NextMap);
		}
}

function BroadcastInterpolationOptions( Name cameraPathTag, float InPhysRate, float InPhysAlpha, bool bInInterpolating )
{
	local InterpolationPoint I;
	local HXRootWindow Root;

	if ( ClientInterpolationDummy!=None )
	{
		ClientInterpolationDummy.Destroy();
		ClientInterpolationDummy = None;
	}

	ClientInterpolationDummy = Spawn( Class'HXClientInterpolationDummy' );

	foreach AllActors( Class 'InterpolationPoint', I, cameraPathTag)
	{
		if ( I.Position==1 )
		{
			ClientInterpolationDummy.SetCollision(False, False, False);
			ClientInterpolationDummy.bCollideWorld = False;
			ClientInterpolationDummy.Target = I;
			ClientInterpolationDummy.SetPhysics(PHYS_Interpolating);
			ClientInterpolationDummy.PhysRate = 1.0;
			ClientInterpolationDummy.PhysAlpha = 0.0;
			ClientInterpolationDummy.bInterpolating = True;
			ClientInterpolationDummy.bStasis = False;

			Root = HXRootWindow(RootWindow);
			if ( Root!=None )
				Root.ClearWindowStack();

			ShowHud(False);
			PutInHand(None);

			// if we're in a conversation, set the NextState
			// otherwise, goto the correct state
			//if (Player.conPlay != None)
				//Player.NextState = 'Interpolating';
			//else
			GotoState('Interpolating');
			break;
		}
	}
}

// ----------------------------------------------------------------------
// ClientLipSynch()
//
// lip synching support - DEUS_EX CNN
// ----------------------------------------------------------------------

simulated function ClientLipSynch(float deltaTime)
{
	local name animseq;
	local float rnd;
	local float tweentime;

	//Log( "ClientLipSynch()" );

	// update the animation timers that we are using
	animTimer[0] += deltaTime;
	animTimer[1] += deltaTime;
	animTimer[2] += deltaTime;

	if ( bIsSpeaking )
	{
		// Make sure we close our mouth.
		bWasSpeaking = True;

		// if our framerate is high enough (>20fps), tween the lips smoothly
		if (Level.TimeSeconds - animTimer[3]  < 0.05)
			tweentime = 0.1;
		else
			tweentime = 0.0;

		// the last animTimer slot is used to check framerate
		animTimer[3] = Level.TimeSeconds;

		//Log( Self $ ".nextPhoneme = " $ nextPhoneme );
		//if( Player != None && Player.Console != None &&Console.IsA('HXConsole') )
			//HXConsole(Player.Console).PhonemeNotify( Self, nextPhoneme );
		if ( GetPlayerPawn() != None && GetPlayerPawn().Player != None && GetPlayerPawn().Player.Console != None && GetPlayerPawn().Player.Console.IsA('HXConsole') )
			HXConsole(GetPlayerPawn().Player.Console).PhonemeNotify( Self, nextPhoneme );

		if (nextPhoneme == "A")
			animseq = 'MouthA';
		else if (nextPhoneme == "E")
			animseq = 'MouthE';
		else if (nextPhoneme == "F")
			animseq = 'MouthF';
		else if (nextPhoneme == "M")
			animseq = 'MouthM';
		else if (nextPhoneme == "O")
			animseq = 'MouthO';
		else if (nextPhoneme == "T")
			animseq = 'MouthT';
		else if (nextPhoneme == "U")
			animseq = 'MouthU';
		else if (nextPhoneme == "X")
			animseq = 'MouthClosed';

		if (animseq != '')
		{
			if (lastPhoneme != nextPhoneme)
			{
				lastPhoneme = nextPhoneme;
				TweenBlendAnim(animseq, tweentime);
			}
		}
	}
	else if ( bWasSpeaking )
	{
		bWasSpeaking = False;
		TweenBlendAnim('MouthClosed', tweentime);
	}

	// blink randomly
	if (animTimer[0] > 2.0)
	{
		animTimer[0] = 0;
		if (FRand() < 0.4)
			PlayBlendAnim('Blink', 1.0, 0.1, 1);
	}
}

//
// lip synching support - DEUS_EX CNN
//
function LipSynch(float deltaTime)
{
	local name animseq;
	local float rnd;
	local float tweentime;

	// update the animation timers that we are using
	animTimer[0] += deltaTime;
	animTimer[1] += deltaTime;
	animTimer[2] += deltaTime;

	if (bIsSpeaking)
	{
		// if our framerate is high enough (>20fps), tween the lips smoothly
		if (Level.TimeSeconds - animTimer[3]  < 0.05)
			tweentime = 0.1;
		else
			tweentime = 0.0;

		// the last animTimer slot is used to check framerate
		animTimer[3] = Level.TimeSeconds;

		//if( Player != None && Player.Console != None &&Console.IsA('HXConsole') )
			//HXConsole(Player.Console).PhonemeNotify( Self, nextPhoneme );
		if ( GetPlayerPawn() != None && GetPlayerPawn().Player != None && GetPlayerPawn().Player.Console != None && GetPlayerPawn().Player.Console.IsA('HXConsole') )
			HXConsole(GetPlayerPawn().Player.Console).PhonemeNotify( Self, nextPhoneme );

		if (nextPhoneme == "A")
			animseq = 'MouthA';
		else if (nextPhoneme == "E")
			animseq = 'MouthE';
		else if (nextPhoneme == "F")
			animseq = 'MouthF';
		else if (nextPhoneme == "M")
			animseq = 'MouthM';
		else if (nextPhoneme == "O")
			animseq = 'MouthO';
		else if (nextPhoneme == "T")
			animseq = 'MouthT';
		else if (nextPhoneme == "U")
			animseq = 'MouthU';
		else if (nextPhoneme == "X")
			animseq = 'MouthClosed';

		if (animseq != '')
		{
			if (lastPhoneme != nextPhoneme)
			{
				lastPhoneme = nextPhoneme;
				TweenBlendAnim(animseq, tweentime);
			}
		}
	}
	else if (bWasSpeaking)
	{
		bWasSpeaking = False;
		TweenBlendAnim('MouthClosed', tweentime);
	}

	// blink randomly
	if (animTimer[0] > 2.0)
	{
		animTimer[0] = 0;
		if (FRand() < 0.4)
			PlayBlendAnim('Blink', 1.0, 0.1, 1);
	}

	LoopHeadConvoAnim();
	LoopBaseConvoAnim();
}

/*
// ----------------------------------------------------------------------
// ClientLoopBaseConvoAnim()
// ----------------------------------------------------------------------

simulated function ClientLoopBaseConvoAnim()
{
	local float rnd;

	rnd = FRand();

	// move arms randomly
	if (bClientIsSpeaking)
	{
		if (animTimer[2] > 2.5)
		{
			animTimer[2] = 0;
			if (rnd < 0.1)
				PlayAnim('GestureLeft', 0.35, 0.4);
			else if (rnd < 0.2)
				PlayAnim('GestureRight', 0.35, 0.4);
			else if (rnd < 0.3)
				PlayAnim('GestureBoth', 0.35, 0.4);
		}
	}

	// if we're not playing an animation, loop the breathe
	if (!IsAnimating())
		LoopAnim('BreatheLight',, 0.4);
}


//
// LookAtActor - DEUS_EX STM
//

simulated function LookAtActor(Actor targ, bool bRotate,
                     bool bLookHorizontal, bool bLookVertical,
                     optional float DelayTime, optional float rate,
                     optional float LockAngle, optional float AngleOffset)
{
	local vector lookTo;

	// If we're looking at a pawn, look at the head;
	// otherwise, look at the center point

	if ( targ != None )
	{
		lookTo = targ.Location;
		if (Pawn(targ) != None)
			lookTo += (vect(0,0,1)*Pawn(targ).BaseEyeHeight);
		else if (Decoration(targ) != None)
			lookTo += (vect(0,0,1)*Decoration(targ).BaseEyeHeight);
		else
			lookTo += (vect(0,0,1)*targ.CollisionHeight*0.75);

		LookAtVector(lookTo, bRotate, bLookHorizontal, bLookVertical,
								 DelayTime, rate, LockAngle, AngleOffset);
	}
}

//
// LookAtVector - DEUS_EX STM
//

simulated function LookAtVector(vector lookTo, bool bRotate,
                      bool bLookHorizontal, bool bLookVertical,
                      optional float DelayTime, optional float rate,
                      optional float LockAngle, optional float AngleOffset)
{
	local vector         lookFrom;
	local rotator        lookAngle;
	local int            hPos, vPos;
	local int            hAngle, vAngle;
	local int            hAbs, vAbs;
	local int            hRot;
	local ELookDirection lookDir;

	if (rate <= 0)
		rate = 1.0;

	// Head movement angles
	hAngle = 5461;  // 30 degrees horizontally
	vAngle = 2731;  // 15 degrees vertically

	// Determine our angle to the target
	lookFrom  = Location + (vect(0,0,1)*CollisionHeight*0.9);
	lookAngle = Rotator(lookTo-lookFrom);
	lookAngle.Yaw = (lookAngle.Yaw - Rotation.Yaw) & 65535;
	if (lookAngle.Yaw > 32767)
		lookAngle.Yaw -= 65536;
	if (lookAngle.Pitch > 32767)
		lookAngle.Pitch -= 65536;

	// hPos and vPos determine which way the pawn needs to look
	// horizontally and vertically

	hPos = 0;
	vPos = 0;

	// Do we need to look up or down?
	if (bLookVertical)
	{
		if (lookAngle.Pitch > vAngle*0.9)
			vPos = 1;
		else if (lookAngle.Pitch < -vAngle*0.75)
			vPos = -1;
	}

	// Do we need to look left or right?
	if (bLookHorizontal)
	{
		if (lookAngle.Yaw > hAngle*0.5)
			hPos = 1;
		else if (lookAngle.Yaw < -hAngle*0.5)
			hPos = -1;
	}

	hAbs = Abs(lookAngle.Yaw);
	vAbs = Abs(lookAngle.Pitch);

	if (bRotate)
	{
		hRot = lookAngle.Yaw;

		// Hack -- NPCs that look horizontally or vertically, AND rotate, will use inexact rotations
		if (bLookHorizontal && (vPos == 0))
		{
			if (hRot > hAngle*1.2)
				hRot -= hAngle*1.2;
			else if (hRot < -hAngle*1.2)
				hRot += hAngle*1.2;
			else
				hRot = 0;
		}
		else if (bLookVertical && (hPos == 0))
		{
			if (hRot > hAngle*0.35)
				hRot -= hAngle*0.35;
			else if (hRot < -hAngle*0.35)
				hRot += hAngle*0.35;
			else
				hRot = 0;
		}

		// Clamp the rotation angle, based on the angles passed in
		if (AngleOffset > 0)
		{
			hRot = (hRot + (Rotation.Yaw-LockAngle) + 65536*4) & 65535;
			if (hRot > 32767)
				hRot -= 65536;
			if      (hRot < -AngleOffset)
				hRot = -AngleOffset;
			else if (hRot > AngleOffset)
				hRot = AngleOffset;
			hRot = (hRot + (LockAngle-Rotation.Yaw) + 65536*4) & 65535;
			if (hRot > 32767)
				hRot -= 65536;
		}

		// Compute actual rotation, based on new angle
		hAbs = (65536 + lookAngle.Yaw - hRot) & 65535;
		if (hAbs > 32767)
			hAbs = 65536-hAbs;
	}

	// No rotation
	else
		hRot = 0;

	// We can't look vertically AND horizontally at the same time
	// (we need a skeletal animation system!!!)

	if ((hPos != 0) && (vPos != 0))
	{
		if (hAbs > vAbs)
			vPos = 0;
		else
			hPos = 0;
	}

	// Play head turning animation
	if (hPos > 0)
		lookDir = LOOK_Right;
	else if (hPos < 0)
		lookDir = LOOK_Left;
	else if (vPos > 0)
		lookDir = LOOK_Up;
	else if (vPos < 0)
		lookDir = LOOK_Down;
	else
		lookDir = LOOK_Forward;
	if ((bLookHorizontal || bLookVertical) && (animTimer[1] >= DelayTime))
		PlayTurnHead(lookDir, 1.0, rate);

	// Turn as necessary
	if (bRotate && ROLE == ROLE_Authority )
		DesiredRotation = Rotation + rot(0,1,0)*hRot;
}
*/
// ----------------------------------------------------------------------
// GetDisplayName()
//
// Returns a name that can be displayed in the conversation.  
//
// The first time we speak to someone we'll use the Unfamiliar name.
// For subsequent conversations, use the Familiar name.  As a fallback,
// the BindName will be used if both of the other two fields
// are blank.
//
// If this is a DeusExDecoration and the Familiar/Unfamiliar names
// are blank, then use the decoration's ItemName instead.  This is 
// for use in the FrobDisplayWindow.
// ----------------------------------------------------------------------

function String GetDisplayName(Actor actor, optional Bool bUseFamiliar)
{
	// Sanity check
	if ((actor == None) || (player == None) || (rootWindow == None))
		return "";

	// Use player names
	if ( actor.IsA('PlayerPawn')
		&& PlayerPawn(actor).PlayerReplicationInfo != None
		&& PlayerPawn(actor).PlayerReplicationInfo.PlayerName != "" )
		return PlayerPawn(actor).PlayerReplicationInfo.PlayerName;

	// If we've spoken to this person already, use the Familiar Name
	// HX_NOTE:	use the Client(Un)FamiliarName/ClientLastConEndTime for HXScriptedPawns
	//					they are the same on ListenServers anyway
	if ( actor.IsA('HXScriptedPawn') )
	{
		if ((HXScriptedPawn(actor).ClientFamiliarName != "") && ((HXScriptedPawn(actor).ClientLastConEndTime > 0) || (bUseFamiliar)))
			return HXScriptedPawn(actor).ClientFamiliarName;
		else if (HXScriptedPawn(actor).ClientUnfamiliarName != "")
			return HXScriptedPawn(actor).ClientUnfamiliarName;

		// fallback (maybe for in map placed HXScriptedPawns?)
		else if ((actor.FamiliarName != "") && ((HXScriptedPawn(actor).ClientLastConEndTime > 0) || (bUseFamiliar)))
			return actor.FamiliarName;
		else if (actor.UnfamiliarName != "")
			return actor.UnfamiliarName;
	}
	else
	{
		if ((actor.FamiliarName != "") && ((actor.LastConEndTime > 0) || (bUseFamiliar)))
			return actor.FamiliarName;
		else if (actor.UnfamiliarName != "")
			return actor.UnfamiliarName;	
	}

	if (actor.IsA('DeusExDecoration'))
		return DeusExDecoration(actor).itemName;
	else
		return actor.BindName;
}

// ----------------------------------------------------------------------
// Frob()
// ----------------------------------------------------------------------

function Frob(Actor Frobber, Inventory frobWith)
{
	if ( Frobber.IsA('HXPlayerPawn') )
		PlaySound(Sound'MaleUnconscious', SLOT_Pain,,,, (1.1 - 0.2*FRand()));
}

// ----------------------------------------------------------------------
// AckInventoryTransaction()
//
// Acknowledges an inventory transaction, used to speed up inventory updates.
// ----------------------------------------------------------------------

function AckInventoryTransaction( Inventory Item, int NewX, int NewY, optional bool bNewItem )
{
	local HXRootWindow Root;

	if ( Item==None )
		return;

	if ( Item.bDisplayableInv )
	{
		// Inventory part
		Item.InvPosX = NewX;
		Item.InvPosY = NewY;
	}

	// Signal inventory screen refresh.
	Root = HXRootWindow(RootWindow);
	if ( Root!=None )
		Root.SignalInventoryRefresh();
}

// ----------------------------------------------------------------------
// RequestInventoryTransaction()
//
// Requests an inventory transaction
// ----------------------------------------------------------------------

function RequestInventoryTransaction( Inventory Item, int NewX, int NewY )
{
	local int i, j;

	// sanity checks
	if ( Item == None )
		return;
	
	if ( NewX < 0 || NewY < 0 )
		return;

	if ( (NewX + Item.invSlotsX) > ArrayCount(InventoryGrid) )
		return;

	if ( (NewY + Item.invSlotsY) > ArrayCount(InventoryGrid[0].Content) )
		return;

	// finally check if the space is available
	if ( !IsEmptySpace( NewX, NewY, Item.invSlotsX, Item.invSlotsY, Item ) )
		return;

	if ( Item.invPosX < 0
		|| Item.invPosY < 0
		|| (NewX + Item.invSlotsX) > ArrayCount(InventoryGrid)
		||	(NewY + Item.invSlotsY) > ArrayCount(InventoryGrid[0].Content) )
	{
		Log( "RequestInventoryTransaction() for"@Item@"bad old inventory position");
	}
	else
	{
		// clear old space
		MarkSpace( Item.invPosX, Item.invPosY, Item.invSlotsX, Item.invSlotsY, None );

		//for ( i = Item.invPosX; i < (Item.invPosX + Item.invSlotsX); i++ )
			//for ( j = Item.invPosY; j < (Item.invPosY + Item.invSlotsY); j++ )
				//InventoryGrid[i].Content[j] = None;
	}

	// mark new spot as occupied
	MarkSpace( NewX, NewY, Item.invSlotsX, Item.invSlotsY, Item );

	//for ( i = NewX; i < (NewX + Item.invSlotsX); i++ )
		//for ( j = NewY; j < (NewY + Item.invSlotsY); j++ )
			//InventoryGrid[i].Content[j] = Item;

	// update item
	Item.invPosX = NewX;
	Item.invPosY = NewY;

	// send ack
	AckInventoryTransaction( Item, NewX, NewY, False );
}

// ----------------------------------------------------------------------
// GrabInventory()
// 
// Grabs the inventory
// ----------------------------------------------------------------------

function GrabInventory( Inventory GrabTarget, Inventory frobWith )
{
	local HXRootWindow root;
	local Ammo ammo;
	local Inventory item;
	local Actor A;

	// Since we pickup a copy, this will prevent doublefrobbing.
	if ( GrabTarget.bDeleteMe )
		return;

	// make sure nothing is based on us if we're an inventory
	foreach GrabTarget.BasedActors(class'Actor', A)
		A.SetBase(None);

	GrabTarget.Frob(Self, frobWith);

	// if the object destroyed itself, get out
	if ( GrabTarget==None || GrabTarget.bDeleteMe )
		return;

	// if the inventory item aborted it's own pickup, get out
	//if (/*GrabTarget.IsA('Inventory') &&*/ GrabTarget.Owner!=Self )
		//return;

	// alert NPCs that I'm messing with stuff
	if ( GrabTarget.bOwned )
		AISendEvent('Futz', EAITYPE_Visual);

	// play an animation
	PlayPickupAnim( GrabTarget.Location );

	if ( Level.Game.ShouldRespawn(GrabTarget) )
	{
		GrabTarget.Destroy();
		return;
	}

	// set the base so the inventory follows us around correctly
	GrabTarget.SetBase(Self);
}

// ----------------------------------------------------------------------
// IsEmptySpace()
//
// Checks if there is room in the inventory
// ----------------------------------------------------------------------

function bool IsEmptySpace( int X, int Y, int W, int H, optional Inventory Ignore )
{
	local int i, j;

	for ( i = X; i < (X + W); i++ )
		for ( j = Y; j < (Y + H); j++ )
			if ( InventoryGrid[i].Content[j] != None && InventoryGrid[i].Content[j] != Ignore )
				return false;

	return true;
}

// ----------------------------------------------------------------------
// MarkSpace()
//
// Checks if there is room in the inventory
// ----------------------------------------------------------------------

function MarkSpace( int X, int Y, int W, int H, Inventory NewInGrid )
{
	local int i, j;

	if ( X < 0 && Y < 0 )
		return;

	if ( X < 0
		|| Y < 0
		|| (X + W) > ArrayCount(InventoryGrid)
		||	(X + H) > ArrayCount(InventoryGrid[0].Content) )
	{
		Log( "Warning"@Self$".MarkSpace("@X$","@Y$","@W$","@H$","@NewInGrid@") Exceeding bounds");
		return;
	}

	for ( i = X; i < (X + W); i++ )
		for ( j = Y; j < (Y + H); j++ )
			InventoryGrid[i].Content[j] = NewInGrid;
}

// ----------------------------------------------------------------------
// FindInventorySpace()
// ----------------------------------------------------------------------

function bool FindInventorySpace( int ItemWidth, int ItemHeight, out int X, out int Y )
{
	local int i, j, m, n;

	X = -1;
	Y = -1;

	// This item takes no space, so return true. (might get awkward)
	if ( ItemWidth == 0 && ItemHeight == 0 )
	{
		return true;
	}

	if ( ItemWidth <= 0 || ItemHeight <= 0 )
	{
		Log( Self @ ".CheckInventorySpace("@ItemWidth$","@ItemHeight@") WARNING Unexpected item size!" );
		return false;
	}

	// loop through all candidates
	for ( j = 0; j < ArrayCount(InventoryGrid[i].Content) - (ItemHeight - 1); j++ )
	{
		for ( i = 0; i < ArrayCount(InventoryGrid) - (ItemWidth - 1); i++ )
		{
			// find an empty spot
			if ( InventoryGrid[i].Content[j] == None && IsEmptySpace( i, j, ItemWidth, ItemHeight ))
			{
				// found an empty spot
				X = i;
				Y = j;

				return true;
			}
		}
	}

	return false;
}

// ----------------------------------------------------------------------
// HandleItemPickup()
//
// THIS WHOLE HANDLING NEEDS TO BE REVISED.
// ----------------------------------------------------------------------

function bool HandleItemPickup( Actor ActorPickupTarget, optional bool bSearchOnly )
{
	local bool bCanPickup;
	local bool bSlotSearchNeeded;
	local Inventory foundItem;

	local HXWeapon	FoundWeapon;
	local HXAmmo		FoundAmmo;
	local HXPickup  FoundPickup;

	local Inventory PickupTarget, Inv;

	local int X, Y;

	PickupTarget = Inventory(ActorPickupTarget);

	if ( PickupTarget==None || PickupTarget.bDeleteMe )
		return False;

	// HX_INV: check if item already in inventory
	for ( Inv = Inventory; Inv != None; Inv = Inv.Inventory )
	{
		if ( PickupTarget==Inv )
		{
			Log( Self @ ".HandleItemPickup() PickupTarget == Inv ==" @ PickupTarget );
			return False;		
		}
	}

	// Ammunition
	if ( PickupTarget.IsA('HXAmmo') )
	{
		FoundAmmo = HXAmmo(FindInventoryType( PickupTarget.Class ));

		if ( FoundAmmo!=None )
		{
			// Check if ammo is at max
			if ( FoundAmmo.AmmoAmount>=FoundAmmo.MaxAmmo )
			{
				ClientMessage(TooMuchAmmo);
				return False;
			}
			// Ammo not at max, so pick it up
			else
			{
				GrabInventory( PickupTarget, inHand );
				return True;
			}
		}
		// No ammo at all of this type
		else
		{
			GrabInventory( PickupTarget, inHand );
			return True;		
		}
	}
	else if ( PickupTarget.IsA('DataVaultImage') )	
	{
		// HX_INV: ADD STUFF HERE (Actually no point in doing that).
		ClientMessage( "[DataVaultImage] This should never happen (TM)." );
		return False;
	}
	// Pickups
	else if ( PickupTarget.IsA('HXPickup') )
	{
		// NanoKey or Credits
		if ( PickupTarget.IsA('HXNanoKey') || PickupTarget.IsA('HXCredits') )
		{
			GrabInventory( PickupTarget, inHand );
			return True;
		}

		FoundPickup = HXPickup(FindInventoryType(PickupTarget.Class));

		// Special case for Stackable Pickups.
		if ( HXPickup(PickupTarget).bCanHaveMultipleCopies && FoundPickup!=None )
		{
			// MaxCopies==0 is stated as unlimited copies, but I'm not sure if that is right.
			if ( FoundPickup.NumCopies<FoundPickup.MaxCopies || FoundPickup.MaxCopies==0 )
			{
				GrabInventory( PickupTarget, inHand );
				return True;
			}
			// Can't carry any more copies.
			else
			{
				ClientMessage( HXPickup(PickupTarget).MsgTooMany );
				return False;
			}
		}
		else
		{
			// Check if we have enough inventory space
			if ( FindInventorySpace(PickupTarget.InvSlotsX,PickupTarget.InvSlotsY,X,Y) )
			{
				GrabInventory( PickupTarget, inHand );
				return True;
			}
			// Nope no room
			else
			{
				ClientMessage( Sprintf(InventoryFull,PickupTarget.ItemName ) );
				return False;
			}
		}
	}
	// Weapons
	else if ( PickupTarget.IsA('HXWeapon') )
	{
		FoundWeapon = HXWeapon(FindInventoryType(PickupTarget.Class));

		if ( FoundWeapon != None )
		{
			//bCanPickup = ! ( FoundWeapon.ReloadCount == 0 && 
			//	               FoundWeapon.PickupAmmoCount == 0 && 
			//	               FoundWeapon.AmmoName != None );

			// Otherwise, if this is a single-use weapon, prevent the player from picking up
			//if (!bCanPickup)
			if ( FoundWeapon.ReloadCount==0 )
			{
				ClientMessage( Sprintf(CanCarryOnlyOne,PickupTarget.ItemName) );
				return False;
			}
			// Non single use weapon
			else
			{
				// Grenades.
				if ( HXWeapon(PickupTarget).bIsGrenade )
				{
					// Check if this grenade type is a max
					if ( FoundWeapon.AmmoType.AmmoAmount>=FoundWeapon.AmmoType.MaxAmmo)
					{
						ClientMessage( TooMuchAmmo );
						return False;
					}
					// Pick grenades up and add it to the inventory
					else
					{
						GrabInventory( PickupTarget, InHand );
						return True;
					}
				}
				// Dumb DX behavior, always pick up the weapon, even if ammo is full or weapon mods are not better
				// but i will leave it that way
				else
				{
					GrabInventory( PickupTarget, InHand );
					return True;				
				}
			}
		}
		else
		{
			// Check if we have enough inventory space.
			if ( FindInventorySpace(PickupTarget.InvSlotsX,PickupTarget.InvSlotsY,X,Y) )
			{
				GrabInventory( PickupTarget, inHand );
				return True;
			}
			// No room.
			else
			{
				ClientMessage( Sprintf(InventoryFull,PickupTarget.ItemName) );
				return False;
			}
		}
	}
	else
	{
		//Log( "Trying to pick up" @ PickupTarget );

		GrabInventory( PickupTarget, inHand );
		return true;
	}
}

// ----------------------------------------------------------------------
// AddInventory()
// ----------------------------------------------------------------------

function Inventory FindInventory( Inventory Item )
{
	local Inventory Inv;

	for( Inv=Inventory; Inv!=None; Inv=Inv.Inventory )   
		if ( Inv == Item )
			return Inv;

	return None;
}

// ----------------------------------------------------------------------
// AddInventory()
// ----------------------------------------------------------------------

function bool AddInventory( Inventory NewItem )
{
	local Inventory Inv;
	local bool bAddAtFront;

	if ( Level.NetMode==NM_Client )
	{
		Warn( "Called on Client");
		return false;
	}
	
	// The item should not have been destroyed if we get here.
	if (NewItem ==None )
	{
		Log("Tried to add None Inventory to "$self$".");
		return false;
	}

	// Skip if already in the inventory. this might break stuff!
	for( Inv=Inventory; Inv!=None; Inv=Inv.Inventory )
	{
		if( Inv == NewItem )
		{
			//Log( "Tried to add"@NewItem@"to"@self@" already carrying." );
			NewItem.SetOwner(Self);
			NewItem.RemoteRole = ROLE_SimulatedProxy;
			return true;
		}
	}

	// DEUS_EX AJY
	// Update the previous owner's inventory chain
	// HX_INV do not remove my own proposed inventory!
	if (NewItem.Owner != None && NewItem.Owner != Self)
		Pawn(NewItem.Owner).DeleteInventory(NewItem);

	NewItem.SetOwner(Self);
	NewItem.RemoteRole = ROLE_SimulatedProxy;

	bAddAtFront = True;

	if ( Inventory == None || bAddAtFront )
	{
		// Add to front of inventory chain.
		// HX_INV: just add the first item on front

		NewItem.Inventory = Inventory;
		Inventory = NewItem;
	}
	else
	{
		// HX_INV: add at end
		for( Inv=Inventory; Inv.Inventory !=None; Inv=Inv.Inventory )
			;

		Inv.Inventory = NewItem;
		NewItem.Inventory = None;
	}

//	Super(PlayerPawnExt).AddInventory( NewItem );

	if ( NewItem.bDisplayableInv )
	{
		// HX_INV: now put it in my inventory
		// The last two variable are declared out, so position will be set!
		if ( !FindInventorySpace( NewItem.invSlotsX, NewItem.invSlotsY, NewItem.invPosX, NewItem.invPosY ) )
		{
			Log("WARNING: Failed to find inventory slot for"@NewItem@" placing at (4,5)");

			NewItem.invPosX = 4;
			NewItem.invPosY = 5;

			MarkSpace( 4, 5, 1, 1, NewItem );

			AckInventoryTransaction( NewItem, 4, 5, True );
		}
		else
		{
			MarkSpace( NewItem.invPosX, NewItem.invPosY, NewItem.invSlotsX, NewItem.invSlotsY, NewItem );

			AckInventoryTransaction( NewItem, NewItem.invPosX, NewItem.invPosY, True );
		}

		//Log( "Placing"@ NewItem @"at("$NewItem.invPosX$", "$NewItem.invPosY$")." );
		_AddObjectToBelt( NewItem, -1, false );
	}
	else
	{
		// Just trigger gui stuff
		AckInventoryTransaction( NewItem, -1, -1, True );
	}

	return true;
}

// ----------------------------------------------------------------------
// DeleteInventory()
// ----------------------------------------------------------------------

function bool DeleteInventory( Inventory Item )
{
	local bool retval;
	//local HXRootWindow root;
	//local HXPersonaScreenInventory winInv;

	if ( Level.NetMode==NM_Client )
		return false;

	// Ideally this shouldn't happen, but?
	if ( bDeleteMe )
		Warn( "Item already destroyed" );

	// For now unpin it here as well, might not be that ideal, as there
	// may be reason to preserve pinning for the particular inventory slot.
	UnPinInBelt( Item );
	_RemoveObjectFromBelt( Item, true );

	// Make sure the item is removed from the inventory grid.
	MarkSpace( Item.InvPosX, Item.InvPosY, Item.InvSlotsX, Item.InvSlotsY, None );

	// If the item was inHand, clear the inHand
	if ( InHand==Item )
	{
		SetInHand( None );
		SetInHandPending( None );
	}

	if ( InHandPending==Item )
		Item = None;

	// For NM_ListenServer?
	if ( ClientInHandPending==Item )
		ClientInHandPending = None;

	// TODO: add some clientside notification
	//root = HXRootWindow(rootWindow);
	//if ( root!=None )
	//{
	//	winInv = HXPersonaScreenInventory(root.GetTopWindow());
	//	if (winInv != None)
	//		winInv.InventoryDeleted(item);
	//}

	if ( Item.IsA('HXWeapon') )
	{
		HXWeapon(Item).ScopeOff();
		HXWeapon(Item).LaserOff();
	}
	else if ( Item.IsA('HXPickup') )
	{
		if ( HXPickup(Item).bActive )
			HXPickup(Item).Activate();

		if ( Item.IsA('HXChargedPickup') )
			HXRemoveChargedDisplay( HXChargedPickup(Item) );
	}

	Super(Pawn).DeleteInventory( Item );
	return true;
}

// ----------------------------------------------------------------------
// RepairInventory()
//
// Get rid of this shit.
// ----------------------------------------------------------------------

function RepairInventory()
{
}


// ----------------------------------------------------------------------
// PlaceItemInSlot()
//
// Client can call it, bad!
// ----------------------------------------------------------------------

function PlaceItemInSlot( Inventory anItem, int col, int row )
{
}

// ----------------------------------------------------------------------
// RemoveItemFromSlot()
//
// Client can call it, bad!
// ----------------------------------------------------------------------

function RemoveItemFromSlot(Inventory anItem)
{
}


// ----------------------------------------------------------------------
// FindInventorySlot()
//
// Searches through the inventory slot grid and attempts to find a 
// valid location for the item passed in.  Returns True if the item
// is placed, otherwise returns False.
// ----------------------------------------------------------------------

function Bool FindInventorySlot(Inventory anItem, optional Bool bSearchOnly)
{
	Log( "FIXME: remove call to FindInventorySlot()" );
	return false;
}

// ----------------------------------------------------------------------
// Possess() -- This pawn was possessed by a player.
// ----------------------------------------------------------------------

event Possess()
{
	Super(PlayerPawn).Possess();

	if ( Level.Netmode!=NM_DedicatedServer && Level==GetEntryLevel() )
	{
		//Log( "Skipping InitRootWindow() for Entry", 'DevRootWindow' );
	}
	else if ( Self!=GetPlayerPawn() )
	{
		//Log( "Skipping InitRootWindow() for Self!=GetPlayerPawn()", 'DevRootWindow' );
	}
	else
	{
		InitRootWindow();
	}

	if ( Level.Netmode==NM_Client )
		ClientPossessed();
}

// ----------------------------------------------------------------------
// ClientPossessed()
// ----------------------------------------------------------------------

function ClientPossessed()
{
	if ( Level.Game.IsA('HXGameInfo') )
		HXGameInfo(Level.Game).ClientPlayerPossessed( Self );
}

// ----------------------------------------------------------------------
// ClientStartCinematicCamera()
// ----------------------------------------------------------------------

function ClientStartCinematicCamera( float TimeOffset, Vector StartLocation, Rotator StartViewRotation )
{
	local HXClientCameraPoint Zero, Bingo;
	local CameraPoint Point;
	local Vector InitialLocation;

	Log( Self $ ".ClientStartCinematicCamera( " $ TimeOffset $ " )", 'CameraPoint' );

	// Skip this stuff on listen server
	if ( Level.NetMode == NM_DedicatedServer )
		return;

	foreach AllActors( class'CameraPoint', Point )
	{
		Bingo = SpawnClientCameraPoint( Point );
		Bingo.Player = Self;
		Bingo.GotoState( 'Idle', 'Wait' );

		if ( Bingo.sequenceNum == 0 )
			Zero = Bingo;
	}

	GotoState('Paralyzed', 'Letterbox');

	if ( Shadow != None )
	{
		Shadow.Destroy();
		Shadow = None;
	}

	SetLocation( StartLocation );
	ViewRotation = StartViewRotation;

	bHidden = True;
	bCollideWorld = False;
	SetCollision(False, False, False);
	BaseEyeHeight = 0.0;

	if ( TimeOffset == 0.0 )
	{
		Zero.GotoState( 'Idle', 'Begin' );
		return;
	}
	else
	{
		Zero.FastForward( TimeOffset );
		return;
	}
}


// ----------------------------------------------------------------------
// SpawnClientCameraPoint()
// ----------------------------------------------------------------------

function HXClientCameraPoint SpawnClientCameraPoint( CameraPoint Other )
{
	local HXClientCameraPoint A;

	A = Spawn( class'HXClientCameraPoint', , Other.Tag, Other.Location, Other.Rotation );

	if ( A == none )
		Log( "Failed to client camera point for" @ Other, 'ReplaceFailed' );
	else
		Log( "Spawned client camera point for" @ Other, 'Replace' );

	A.Event = Other.Event;
	A.Group = Other.Group;
	A.Tag		= Other.Tag;

	//Other.Event = '';
	//Other.Group = '';

	// CameraPoint
	A.SetPropertyText("cmd", Other.GetPropertyText("cmd"));

	A.value					= Other.value;
	A.eventName			= Other.eventName;
	A.timeSmooth		= Other.timeSmooth;
	A.timeWaitPost	= Other.timeWaitPost;
	A.bParallel			= Other.bParallel;
	A.bRandom				= Other.bRandom;
	A.randomCount		= Other.randomCount;
	A.postRandomNum	= Other.postRandomNum;
	A.sequenceNum		= Other.sequenceNum;

	return A;
}

// ----------------------------------------------------------------------
// state Paralyzed
// ----------------------------------------------------------------------

state Paralyzed
{
	ignores all;

	function     TakeDamage(int Damage, Pawn instigatedBy, Vector hitlocation, Vector momentum, name damageType);
	function int HealPlayer( int HealPoints, optional Bool bUseMedicineSkill );
	function     DrugPlayer( float Duration );

	exec function ActivateBelt( int Position );
	exec function ParseLeftClick();
	exec function ParseRightClick();

	exec function Suicide();
	exec function SwitchAmmo();
	exec function bool DropItem( optional Inventory Item, optional bool bDrop );
	exec function DropAmmo( Class<HXAmmo> AmmoClass, optional bool bDrop );
	exec function _ActivateAugmentation( int AugKey );
	exec function ActivateAugmentation( int AugKey );
	exec function DeactivateAugmentation( int AugKey );
	exec function ToggleAugmentation( int AugKey );

	exec function PutInHand( optional Inventory Item )
	{
		// Still allow putting away items.
		if ( Item==None )
			Global.PutInHand( None );
	}


	exec function Fire(optional float F)
	{
		ShowMainMenu();
	}

	event PlayerTick(float deltaTime)
	{
		//UpdateInHand();
		ShowHud(False);
		ViewFlash(deltaTime);
	}

	// Kill all movement sync stuff
	function PlayerMove( float DeltaTime )
	{
	}

	function UpdateRotation(float DeltaTime, float maxPitch)
	{
	}

	function ServerMove( float TimeStamp, vector InAccel, vector ClientLoc,	bool NewbRun,	bool NewbDuck, bool NewbJumpStatus,
											 bool bFired, bool bAltFired, bool bForceFire, bool bForceAltFire, eDodgeDir DodgeMove, byte ClientRoll, 
											 int View, optional byte OldTimeDelta, optional int OldAccel )
	{
	}

	function ProcessMove ( float DeltaTime, vector newAccel, eDodgeDir DodgeMove, rotator DeltaRot)
	{
	}

	function ClientAdjustPosition( float TimeStamp, name newState, EPhysics newPhysics,
																 float NewLocX, float NewLocY, float NewLocZ, 
																 float NewVelX, float NewVelY, float NewVelZ,	Actor NewBase )
	{
	}

	function ClientUpdatePosition()
	{
	}

	function ReplicateMove(	float DeltaTime, vector NewAccel, eDodgeDir DodgeMove, rotator DeltaRot )
	{
	}

Begin:
	Log( "Paralyzed.Begin:" );
	if (bOnFire)
		ExtinguishFire();

	bDetectable = False;

	// put away your weapon
	if (Weapon != None)
	{
		Weapon.bHideWeapon = True;
		Weapon = None;
		PutInHand(None);
	}

	// can't carry decorations across levels
	if (CarriedDecoration != None)
	{
		CarriedDecoration.Destroy();
		CarriedDecoration = None;
	}

	SetPhysics(PHYS_None);
	PlayAnim('Still');
	Stop;

Letterbox:
	ShowHud(False);

	Log( "Paralyzed.Letterbox:" );
	if (bOnFire)
		ExtinguishFire();

	bDetectable = False;

	// put away your weapon
	if (Weapon != None)
	{
		Weapon.bHideWeapon = True;
		Weapon = None;
		PutInHand(None);
	}

	// can't carry decorations across levels
	if (CarriedDecoration != None)
	{
		CarriedDecoration.Destroy();
		CarriedDecoration = None;
	}

	SetPhysics(PHYS_None);
	PlayAnim('Still');
	if (rootWindow != None)
		rootWindow.NewChild(class'HXCinematicWindow');
}

// ----------------------------------------------------------------------
// VerifyGameEngine()
// ----------------------------------------------------------------------

final function VerifyGameEngine( string EngineClassName )
{
	if ( !CompareGameEngine( class<GameEngine>(DynamicLoadObject( EngineClassName, class'Class' )) ) )
	{
		Log( "GameEngine check failed. You need to use HX.HXGameEngine." );
		FailGameEngineCheck();
	}
}

// ----------------------------------------------------------------------
// FailGameEngineCheck()
// ----------------------------------------------------------------------

function FailGameEngineCheck()
{
	if (Level.Game.IsA('HXGameInfo'))
		HXGameInfo(Level.Game).FailGameEngineCheck(Self);
}

// ----------------------------------------------------------------------
// GetLevelInfo()
// ----------------------------------------------------------------------

simulated function DeusExLevelInfo GetLevelInfo()
{
	local DeusExLevelInfo info;

	foreach AllActors(class'DeusExLevelInfo', info)
		break;

	return info;
}


// ----------------------------------------------------------------------
// UpdateDynamicMusic()
//
// Pattern definitions:
//   0 - Ambient 1
//   1 - Dying
//   2 - Ambient 2 (optional)
//   3 - Combat
//   4 - Conversation
//   5 - Outro
// ----------------------------------------------------------------------

function UpdateDynamicMusic( float deltaTime )
{
	local bool bCombat;
	local ScriptedPawn npc;
	local Pawn CurPawn;
	local DeusExLevelInfo info;

	if ( Level.Song == None )
		return;

	// HX_NOTE: Now the server decides which music should be played.
	if ( Role < ROLE_Authority )
		return;

	// DEUS_EX AMSD In singleplayer, do the old thing.
	// In multiplayer, we can come out of dying.

	//if (!PlayerIsClient())
	//{
		//if ((musicMode == MUS_Dying) || (musicMode == MUS_Outro))
			//return;
	//}
	//else
	//{
	//if (musicMode == MUS_Outro)
		//return;
	//}

	if (musicMode == MUS_Outro)
		return;

	musicCheckTimer += deltaTime;
	musicChangeTimer += deltaTime;

	if (IsInState('Interpolating'))
	{
		// don't mess with the music on any of the intro maps
		info = GetLevelInfo();

		if ((info != None) && (info.MissionNumber < 0))
		{
			musicMode = MUS_Outro;
			return;
		}

		if (musicMode != MUS_Outro)
		{
			ClientSetMusic(Level.Song, 5, 255, MTRAN_FastFade);
			musicMode = MUS_Outro;
		}
	}
	else if (IsInState('Conversation'))
	{
		if (musicMode != MUS_Conversation)
		{
			// save our place in the ambient track
			if (musicMode == MUS_Ambient)
				savedSection = SongSection;
			else
				savedSection = 255;

			ClientSetMusic(Level.Song, 4, 255, MTRAN_Fade);
			musicMode = MUS_Conversation;
		}
	}
	else if (IsInState('Dying'))
	{
		if (musicMode != MUS_Dying)
		{
			ClientSetMusic(Level.Song, 1, 255, MTRAN_Fade);
			musicMode = MUS_Dying;
		}
	}
	else
	{
		// only check for combat music every second
		if (musicCheckTimer >= 1.0)
		{
			musicCheckTimer = 0.0;
			bCombat = False;

			// check a 100 foot radius around me for combat
			// XXXDEUS_EX AMSD Slow Pawn Iterator
			//foreach RadiusActors(class'ScriptedPawn', npc, 1600)
			for (CurPawn = Level.PawnList; CurPawn != None; CurPawn = CurPawn.NextPawn)
			{
				npc = ScriptedPawn(CurPawn);

				if ((npc != None) && (VSize(npc.Location - Location) < (1600 + npc.CollisionRadius)))
				{
					if ((npc.GetStateName() == 'Attacking') && (npc.Enemy == Self))
					//if ( npc.GetStateName() == 'Attacking' && npc.Enemy != None && npc.Enemy.bIsPlayer )
					{
						bCombat = True;
						break;
					}
				}
			}

			if (bCombat)
			{
				musicChangeTimer = 0.0;

				if (musicMode != MUS_Combat)
				{
					// save our place in the ambient track
					if (musicMode == MUS_Ambient)
						savedSection = SongSection;
					else
						savedSection = 255;

					Log( "Setting Combat Music" );
					ClientSetMusic(Level.Song, 3, 255, MTRAN_FastFade);
					musicMode = MUS_Combat;
				}
			}

			else if (musicMode != MUS_Ambient)
			{
				// wait until we've been out of combat for 5 seconds before switching music
				if (musicChangeTimer >= 5.0)
				{
					// use the default ambient section for this map
					if (savedSection == 255)
						savedSection = Level.SongSection;

					// fade slower for combat transitions
					if (musicMode == MUS_Combat)
						ClientSetMusic(Level.Song, savedSection, 255, MTRAN_SlowFade);
					else
						ClientSetMusic(Level.Song, savedSection, 255, MTRAN_Fade);

					savedSection = 255;
					musicMode = MUS_Ambient;
					musicChangeTimer = 0.0;
				}
			}
		}
	}
}

// ----------------------------------------------------------------------
// GetItemName()
//
// Returns the string representation of the name of an object without the package
// prefixes.
// ----------------------------------------------------------------------

simulated function String GetItemName( string FullName )
{
	local int pos;

	pos = InStr(FullName, ".");
	While ( pos != -1 )
	{
		FullName = Right(FullName, Len(FullName) - pos - 1);
		pos = InStr(FullName, ".");
	}

	// HX_HAN: strip HX too.
	//if ( Left(FullName,2) ~= "HX" )
		//FullName = Right(FullName, Len(FullName) - 2);

	return FullName;
}

// ----------------------------------------------------------------------
// SwitchAmmo()
// ----------------------------------------------------------------------

exec function SwitchAmmo()
{
	local HXWeapon InHandWeapon;

	InHandWeapon = HXWeapon(InHand);
	if ( InHandWeapon!=None )
		InHandWeapon.CycleAmmo();	
}

// ----------------------------------------------------------------------
// ClientSpawnProjectile
// ----------------------------------------------------------------------

simulated function ClientSpawnProjectile( class<projectile> ProjClass, Actor owner, Vector Start, Rotator AdjustedAim )
{
	local Projectile proj;

	proj = Spawn(ProjClass, Owner,, Start, AdjustedAim);
	if ( proj != None )
	{
		proj.RemoteRole = ROLE_None;
		proj.Damage = 0;
	}
}

// ----------------------------------------------------------------------------
// Low level inventory belt handling routines dealing with direct
// array access.
//
// This could be reimplemented by mod authors for differently
// sized object belts.
// ----------------------------------------------------------------------------

function int InventoryBeltSize()
{
	return ArrayCount(InventoryBelt);
}

// Technically this is a higher level routine, but lower level functions
// depend on it. So it remains in the low level category.
function bool ValidateInventoryBeltPosition( int Position )
{
	return Position>=0 && Position<InventoryBeltSize();
}

function Inventory GetInventoryFromBeltPosition( int Position )
{
	if ( !ValidateInventoryBeltPosition(Position) )
		return None;
	return InventoryBelt[Position];
	//return InventoryBelt[Position].Item;
}

function SetInventoryByBeltPosition( int Position, Inventory Item )
{
	if ( !ValidateInventoryBeltPosition(Position) )
		return;
	InventoryBelt[Position] = Item;
	//InventoryBelt[Position].Item = Item;
}

function PinBeltPosition( int Position )
{
	if ( !ValidateInventoryBeltPosition(Position) )
		return;
	InventoryBeltPinned[Position] = 1;
	//InventoryBelt[Position].bPinned = 1;
}

function UnPinBeltPosition( int Position )
{
	if ( !ValidateInventoryBeltPosition(Position) )
		return;
	InventoryBeltPinned[Position] = 0;
	//InventoryBelt[Position].bPinned = 0;
}

function bool BeltPositionPinned( int Position )
{
	if ( !ValidateInventoryBeltPosition(Position) )
		return false;
	return InventoryBeltPinned[Position]==1;
	//return InventoryBelt[Position].bPinned==1;
}

// ----------------------------------------------------------------------------
// Higher level inventory belt routines.
//
// These are abstracted from the lower level InventoryBeltSize
// GetInventoryFromBeltPosition, SetInventoryByBeltPosition and
// ValidateInventoryBeltPosition implementation and won't have to be replaced
// for a different sized belt.
// ----------------------------------------------------------------------------

// Pins belt slot the item is positioned in.
function PinInBelt( Inventory Item )
{
	PinBeltPosition( FindInBelt(Item) );
}

// Pins the belt slot the item is positioned in.
function UnPinInBelt( Inventory Item )
{
	UnPinBeltPosition( FindInBelt(Item) );
}

// Whether the item is pinned in it's belt position.
function bool PinnedInBelt( Inventory Item )
{
	BeltPositionPinned( FindInBelt(Item) );
}

function int FindInBelt( Inventory Item )
{
	local int Index;

	// Client is allowed to search his belt.
	//if ( Level.NetMode==NM_Client )
		//return;

	if ( Item==None )
		return INDEX_NONE;

	for ( Index=0; Index<InventoryBeltSize(); Index++ )
		if ( Item==GetInventoryFromBeltPosition(Index) )
			return Index;

	return INDEX_NONE;
}

// RPC'd to server. Not allowed to remove pinned items.
function RemoveObjectFromBelt( Inventory Item )
{
	_RemoveObjectFromBelt( Item );
}

// Not replicated.
function _RemoveObjectFromBelt( Inventory Item, optional bool bIgnorePinningStatus )
{
	local int Position;

	if ( Level.NetMode==NM_Client )
		return;

	Position = FindInBelt( Item );
	if ( Position==INDEX_NONE )
		return;

	if ( !bIgnorePinningStatus && BeltPositionPinned(Position) )
		return;

	SetInventoryByBeltPosition( Position, None );
}

// RPC'd to server.
function ClearPosition( int Position )
{
	_ClearPosition( Position );
}

// Not replicated.
function _ClearPosition( int Position, optional bool bIgnorePinningStatus )
{
	if ( Level.NetMode==NM_Client )
		return;

	if ( ValidateInventoryBeltPosition(Position) )
		if ( bIgnorePinningStatus || !BeltPositionPinned(Position) )
			SetInventoryByBeltPosition( Position, None );
}

// RPC'd to server.
function ClearBelt()
{
	_ClearBelt();
}

// Not replicated.
function _ClearBelt( optional bool bIgnorePinningStatus )
{
	local int Position;

	if ( Level.NetMode==NM_Client )
		return;

	for ( Position=0; Position<InventoryBeltSize(); Position++ )
		if ( bIgnorePinningStatus || !BeltPositionPinned(Position) )
			SetInventoryByBeltPosition( Position, None );
}

// RPC'd to server. Position==INDEX_NONE tries to place Item into a free spot.
function AddObjectToBelt( Inventory Item, int Position, bool bUnused )
{
	_AddObjectToBelt( Item, Position );
}

// Not replicated. Position==INDEX_NONE tries to place Item into a free spot.bForce ignores pinning status and bDisplayableInv checks.
function _AddObjectToBelt( Inventory Item, int Position, optional bool bForce )
{
	local int i;

	if ( Level.NetMode==NM_Client )
		return;

	// This doesn't have to be cheating, will happen through delay as well.
	if ( Item==None || Item.bDeleteMe || Item.Owner!=Self )
		return;

	// Can this be added to the belt?
	if ( Item.Icon==None ) // Yuk.
		Warn( Sprintf("Yuk (Item=%s,Position=%i)",Item.Name,Position) );
		//return;

	// bDisplayableInv means that this item can be on the inventory grid. However, this excludes the NanoKeyRing.
	// But NanoKeyRing will be force into slot either way.
	if ( !Item.bDisplayableInv && !bForce )
		return;

	// Handle forced placement.
	if ( bForce )
	{
		if ( !ValidateInventoryBeltPosition(Position) )
		{
			Warn( Sprintf("Tried to force item into invalid belt position (Item=%s,Position=%i)",Item.Name,Position) );
			return;
		}
		_RemoveObjectFromBelt( Item, true );
		SetInventoryByBeltPosition( Position, Item );
		return;
	}

	// Place into specified position unless it's pinned.
	if ( ValidateInventoryBeltPosition(Position) )
	{
		if ( BeltPositionPinned(Position) )
			return;

		_RemoveObjectFromBelt( Item, true );
		SetInventoryByBeltPosition( Position, Item );
		return;
	}

	// Invalid belt position.
	if ( Position!=INDEX_NONE )
	{
		Warn( Sprintf("Tried to place item into invalid belt position (Item=%s,Position=%i)",Item.Name,Position) );
		return;
	}

	// Search for a free spot to place the item into.
	for ( Position=0; Position<InventoryBeltSize(); Position++ )
	{
		if ( GetInventoryFromBeltPosition(Position)==None )
		{
			RemoveObjectFromBelt( Item );
			SetInventoryByBeltPosition( Position, Item );
			return;
		}
	}

	// No free spot found.
	Log( Sprintf("_AddObjectToBelt: Couldn't find a free belt position for automatic placement (Item=%s)",Item.Name,Position), 'DevInventory' );
}

// ----------------------------------------------------------------------
// ActivateBelt() / NextBeltItem() / PrevBeltItem()
//
// Direct belt item access.
// ----------------------------------------------------------------------

// Replicated to Server.
exec function ActivateBelt( int Position )
{
	if ( Level.NetMode==NM_Client )
		return;

	if ( CarriedDecoration!=None )
		return;

	if ( !ValidateInventoryBeltPosition(Position) )
		return;

	// !! Unlike Next/PrevBeltItem this will not affect ClientInHandPending !! It should act in the same way !!
	PutInHand( GetInventoryFromBeltPosition(Position) );
}

// Not replicated.
exec function NextBeltItem()
{
	local int Position, StartPosition;

	// !! This is just a clientside check, we can have a decoration on the serverside the server will drop !!
	if ( CarriedDecoration!=None )
		return;

	Position = 0;

	if ( ClientInHandPending!=None )
		Position = Max(0,FindInBelt(ClientInHandPending));
	else if ( InHandPending!=None )
		Position = Max(0,FindInBelt(InHandPending));
	else if ( InHand!=None )
		Position = Max(0,FindInBelt(inHand));

	StartPosition = Position;

	do
	{
		if ( ++Position>=InventoryBeltSize() )
			Position = 0;

		if ( GetInventoryFromBeltPosition(Position)!=None )
		{
			PutInHand( GetInventoryFromBeltPosition(Position) );
			break;
		}
	}
	until ( StartPosition==Position );

	ClientInHandPending = GetInventoryFromBeltPosition(Position);
}

// Not replicated.
exec function PrevBeltItem()
{
	local int Position, StartPosition;

	// !! This is just a clientside check, we can have a decoration on the serverside the server will drop !!
	if ( CarriedDecoration!=None )
		return;

	Position = 0;

	if ( ClientInHandPending!=None )
		Position = Max(0,FindInBelt(ClientInHandPending));
	else if ( InHandPending!=None )
		Position = Max(0,FindInBelt(InHandPending));
	else if ( InHand!=None )
		Position = Max(0,FindInBelt(inHand));

	StartPosition = Position;
	do
	{
		if ( --Position<=-1 )
			Position = InventoryBeltSize()-1;

		if ( GetInventoryFromBeltPosition(Position)!=None )
		{
			PutInHand( GetInventoryFromBeltPosition(Position) );
			break;
		}
	}
	until ( StartPosition==Position );

	ClientInHandPending = GetInventoryFromBeltPosition(Position);
}

// ----------------------------------------------------------------------
// UpdateAnimRate()
// ----------------------------------------------------------------------

function UpdateAnimRate( float augValue )
{
	// Implemented in HXHuman.
}

// ----------------------------------------------------------------------
// Say()
// ----------------------------------------------------------------------

exec function Say( String Msg )
{
	local Pawn Pawn;
	local String Str;

	// Ignore empty messages.
	if ( Msg=="" )
		return;

	Str = PlayerReplicationInfo.PlayerName $ ": " $ Msg;

	if ( Role==ROLE_Authority )
		Log( "Say>" $ Str );

	for ( Pawn=Level.PawnList; Pawn!=None; Pawn=Pawn.NextPawn )
		if( Pawn.bIsPlayer )
			Pawn.ClientMessage( Str, 'Say', True );

	return;
}

// ----------------------------------------------------------------------
// CreateThemeManager()
// ----------------------------------------------------------------------

function CreateColorThemeManager()
{
	local ColorTheme ColorTheme;

	Super.CreateColorThemeManager();

	// Safeguard.
	if ( ThemeManager==None )
		return;

	// Now set bTravel=False for this ColorTheme shit.
	ThemeManager.bTravel = False;
	for ( ColorTheme=ThemeManager.FirstColorTheme; ColorTheme!=None; ColorTheme=ColorTheme.Next )
		ColorTheme.bTravel = False;
}

// ----------------------------------------------------------------------
// LipSynchTimer()
// ----------------------------------------------------------------------

simulated event LipSynchTimer();

// ----------------------------------------------------------------------
// StartNewGame()
//
// Starts a new game given the map passed in
// HX_HAN: Hijacked this to start a new listen game.
// ----------------------------------------------------------------------

exec function StartNewGame( /*optional*/ String StartMap )
{
	local HXRootWindow Root;
	local string GameType;

	Root = HXRootWindow(RootWindow);
	if ( Root!=None )
		Root.ClearWindowStack();

	if ( StartMap=="" )
		StartMap = "01_NYC_UNATCOIsland";

	// Read DefaultServerGame out of ini.
	GameType = GetConfig( "Engine.Engine", "DefaultServerGame" );
	if ( GameType=="" )
		GameType = "HX.HXGameInfo";

	// Send the player to the specified map!
	ConsoleCommand( "Start" @ StartMap $ "?Listen?Game="$GameType );
}

// ----------------------------------------------------------------------
// StartNewDedicatedGame()
//
// Dedicated server variant of StartNewGame().
// ----------------------------------------------------------------------

exec function StartNewDedicatedGame( optional String StartMap )
{
	local HXRootWindow Root;
	local string GameType;

	Root = HXRootWindow(RootWindow);
	if ( Root!=None )
		Root.ClearWindowStack();

	if ( StartMap=="" )
		StartMap = "01_NYC_UNATCOIsland";

	// Read DefaultServerGame out of ini.
	GameType = GetConfig( "Engine.Engine", "DefaultServerGame" );
	if ( GameType=="" )
		GameType = "HX.HXGameInfo";

	// Send the player to the specified map!
	ConsoleCommand( "Relaunch" @ StartMap $ "?Game="$GameType$"?-Server?Log=HXServer.log" );
}

// ----------------------------------------------------------------------
// Bleed()
// 
// Let the blood flow
// ----------------------------------------------------------------------

function Bleed(float deltaTime)
{
	local float  dropPeriod;
	local float  adjustedRate;
	local vector bloodVector;

   if ( HXGameInfo(Level.Game)!=None && !HXGameInfo(Level.Game).bSpawnEffects )
   {
      bleedrate = 0;
      dropCounter = 0;
      return;
   }

	// Copied from ScriptedPawn::Tick()
	bleedRate = FClamp(bleedRate, 0.0, 1.0);
	if (bleedRate > 0)
	{
		adjustedRate = (1.0-bleedRate)*1.0+0.1;  // max 10 drops per second
		dropPeriod = adjustedRate / FClamp(VSize(Velocity)/512.0, 0.05, 1.0);
		dropCounter += deltaTime;
		while (dropCounter >= dropPeriod)
		{
			bloodVector = vect(0,0,1)*CollisionHeight*0.5;  // so folks don't bleed from the crotch
			spawn(Class'BloodDrop',,,bloodVector+Location);
			dropCounter -= dropPeriod;
		}
		bleedRate -= deltaTime/clotPeriod;
	}
	if (bleedRate <= 0)
	{
		dropCounter = 0;
		bleedRate   = 0;
	}
}

// ----------------------------------------------------------------------
// SpawnBlood()
// ----------------------------------------------------------------------

function SpawnBlood(Vector HitLocation, float Damage)
{
	local int i;

	if ( HXGameInfo(Level.Game)!=None && !HXGameInfo(Level.Game).bSpawnEffects )
		return;

	spawn(class'BloodSpurt',,,HitLocation);
	spawn(class'BloodDrop',,,HitLocation);
	for (i=0; i<int(Damage); i+=10)
		spawn(class'BloodDrop',,,HitLocation);
}

// ----------------------------------------------------------------------
// CreatePlayerTracker() -- Test if we need this.
// ----------------------------------------------------------------------

simulated function CreatePlayerTracker()
{
	/*local MPPlayerTrack PlayerTracker;

	PlayerTracker = Spawn(class'MPPlayerTrack');  
	PlayerTracker.AttachedPlayer = Self;*/
}

// ----------------------------------------------------------------------
// VRand2D() creates random normalized 2D Vector.
// ----------------------------------------------------------------------

static final function Vector VRand2D()
{
	local Rotator RandRot;
	RandRot.Yaw = FRand() * 65535.0;
	return Vector(RandRot);
}

// ----------------------------------------------------------------------
// ViewFlash()
// ----------------------------------------------------------------------

function ViewFlash( float DeltaTime )
{
	local float Delta, Goalscale, ReductionFactor;
	local Vector GoalFog;

	ReductionFactor = 2;

	if ( FlashTimer>0 )
	{
		if ( FlashTimer<Deltatime )
		{
			FlashTimer = 0;
		}
		else
		{
			ReductionFactor = 0;
			FlashTimer -= Deltatime;
		}
	}

	if ( bNoFlash )
	{
		InstantFlash = 0;
		InstantFog = vect(0,0,0);
	}

	Delta              = FMin(0.1, DeltaTime);
	GoalScale          = 1 + DesiredFlashScale + ConstantGlowScale + HeadRegion.Zone.ViewFlash.X; 
	GoalFog            = DesiredFlashFog + ConstantGlowFog + HeadRegion.Zone.ViewFog;
	DesiredFlashScale -= DesiredFlashScale * ReductionFactor * Delta;  
	DesiredFlashFog   -= DesiredFlashFog * ReductionFactor * Delta;
	FlashScale.X      += (GoalScale - FlashScale.X + InstantFlash) * 10 * Delta;
	//FlashFog          += (GoalFog - FlashFog + InstantFog) * 10 * Delta;
	CurrentFlashFog   += (goalFog - CurrentFlashFog + InstantFog) * 10 * delta;

	// Reset instant.
	InstantFlash = 0;
	InstantFog   = vect(0,0,0);

	if ( FlashScale.X > 0.981 )
		FlashScale.X = 1;
	FlashScale = FlashScale.X * vect(1,1,1);

	FlashFog = CurrentFlashFog;
	if ( FlashFog.X < 0.019 )
		FlashFog.X = 0;
	if ( FlashFog.Y < 0.019 )
		FlashFog.Y = 0;
	if ( FlashFog.Z < 0.019 )
		FlashFog.Z = 0;
}

// ----------------------------------------------------------------------
// UpdateRotation()
// ----------------------------------------------------------------------

function UpdateRotation(float DeltaTime, float maxPitch)
{
	local rotator newRotation;
	
	DesiredRotation = ViewRotation; //save old rotation
	ViewRotation.Pitch += 32.0 * DeltaTime * aLookUp;
	ViewRotation.Pitch = ViewRotation.Pitch & 65535;
	If ((ViewRotation.Pitch > 18000) && (ViewRotation.Pitch < 49152))
	{
		If (aLookUp > 0) 
			ViewRotation.Pitch = 18000;
		else
			ViewRotation.Pitch = 49152;
	}
	ViewRotation.Yaw += 32.0 * DeltaTime * aTurn;
	ViewShake(deltaTime);

	// HX_HAN: Took this out.
	//ViewFlash(deltaTime);
		
	newRotation = Rotation;
	newRotation.Yaw = ViewRotation.Yaw;
	newRotation.Pitch = ViewRotation.Pitch;
	If ( (newRotation.Pitch > maxPitch * RotationRate.Pitch) && (newRotation.Pitch < 65536 - maxPitch * RotationRate.Pitch) )
	{
		If (ViewRotation.Pitch < 32768) 
			newRotation.Pitch = maxPitch * RotationRate.Pitch;
		else
			newRotation.Pitch = 65536 - maxPitch * RotationRate.Pitch;
	}
    // added to keep the player's model from pitching or rolling - DEUS_EX CNN
	newRotation.Pitch = 0;
	newRotation.Roll = 0;

	SetRotation(newRotation);
}

//
// Send movement to the server.
// Passes acceleration in components so it doesn't get rounded.
//
function ServerMove
(
	float TimeStamp, 
	vector InAccel, 
	vector ClientLoc,
	bool NewbRun,
	bool NewbDuck,
	bool NewbJumpStatus, 
	bool bFired,
	bool bAltFired,
	bool bForceFire,
	bool bForceAltFire,
	eDodgeDir DodgeMove, 
	byte ClientRoll, 
	int View,
	optional byte OldTimeDelta,
	optional int OldAccel
)
{
	local float DeltaTime, clientErr, OldTimeStamp;
	local rotator DeltaRot, Rot;
	local vector Accel, LocDiff;
	local int maxPitch, ViewPitch, ViewYaw;
	local actor OldBase;
	local bool NewbPressedJump, OldbRun, OldbDuck;
	local eDodgeDir OldDodgeMove;

	// If this move is outdated, discard it.
	if ( CurrentTimeStamp >= TimeStamp )
		return;

	// if OldTimeDelta corresponds to a lost packet, process it first
	if (  OldTimeDelta != 0 )
	{
		OldTimeStamp = TimeStamp - float(OldTimeDelta)/500 - 0.001;
		if ( CurrentTimeStamp < OldTimeStamp - 0.001 )
		{
			// split out components of lost move (approx)
			Accel.X = OldAccel >>> 23;
			if ( Accel.X > 127 )
				Accel.X = -1 * (Accel.X - 128);
			Accel.Y = (OldAccel >>> 15) & 255;
			if ( Accel.Y > 127 )
				Accel.Y = -1 * (Accel.Y - 128);
			Accel.Z = (OldAccel >>> 7) & 255;
			if ( Accel.Z > 127 )
				Accel.Z = -1 * (Accel.Z - 128);
			Accel *= 20;
			
			OldbRun = ( (OldAccel & 64) != 0 );
			OldbDuck = ( (OldAccel & 32) != 0 );
			NewbPressedJump = ( (OldAccel & 16) != 0 );
			if ( NewbPressedJump )
				bJumpStatus = NewbJumpStatus;

			switch (OldAccel & 7)
			{
				case 0:
					OldDodgeMove = DODGE_None;
					break;
				case 1:
					OldDodgeMove = DODGE_Left;
					break;
				case 2:
					OldDodgeMove = DODGE_Right;
					break;
				case 3:
					OldDodgeMove = DODGE_Forward;
					break;
				case 4:
					OldDodgeMove = DODGE_Back;
					break;
			}
			//log("Recovered move from "$OldTimeStamp$" acceleration "$Accel$" from "$OldAccel);
			MoveAutonomous(OldTimeStamp - CurrentTimeStamp, OldbRun, OldbDuck, NewbPressedJump, OldDodgeMove, Accel, rot(0,0,0));
			CurrentTimeStamp = OldTimeStamp;
		}
	}		

	// View components
	ViewPitch = View/32768;
	ViewYaw = 2 * (View - 32768 * ViewPitch);
	ViewPitch *= 2;
	// Make acceleration.
	Accel = InAccel/10;

	NewbPressedJump = (bJumpStatus != NewbJumpStatus);
	bJumpStatus = NewbJumpStatus;

	// handle firing and alt-firing
	if ( bFired )
	{
		if ( bForceFire && (Weapon != None) )
			Weapon.ForceFire();
		else if ( bFire == 0 )
			Fire(0);
		bFire = 1;
	}
	else
		bFire = 0;


	if ( bAltFired )
	{
		if ( bForceAltFire && (Weapon != None) )
			Weapon.ForceAltFire();
		else if ( bAltFire == 0 )
			AltFire(0);
		bAltFire = 1;
	}
	else
		bAltFire = 0;

	// Save move parameters.
	DeltaTime = TimeStamp - CurrentTimeStamp;
	if ( ServerTimeStamp > 0 )
	{
		// allow 1% error
		TimeMargin += DeltaTime - 1.01 * (Level.TimeSeconds - ServerTimeStamp);
		if ( TimeMargin > MaxTimeMargin )
		{
			// player is too far ahead
			TimeMargin -= DeltaTime;
			if ( TimeMargin < 0.5 )
				MaxTimeMargin = Default.MaxTimeMargin;
			else
				MaxTimeMargin = 0.5;
			DeltaTime = 0;
		}
	}

	CurrentTimeStamp = TimeStamp;
	ServerTimeStamp = Level.TimeSeconds;
	Rot.Roll = 256 * ClientRoll;
	Rot.Yaw = ViewYaw;
	if ( (Physics == PHYS_Swimming) || (Physics == PHYS_Flying) )
		maxPitch = 2;
	else
		maxPitch = 1;
	If ( (ViewPitch > maxPitch * RotationRate.Pitch) && (ViewPitch < 65536 - maxPitch * RotationRate.Pitch) )
	{
		If (ViewPitch < 32768) 
			Rot.Pitch = maxPitch * RotationRate.Pitch;
		else
			Rot.Pitch = 65536 - maxPitch * RotationRate.Pitch;
	}
	else
		Rot.Pitch = ViewPitch;

	// From what I gather, this should have been the case in single player as well since
	// pitch is zeroed out in UpdateRotation.  Oh well, now it doesn't look goofy in mp
	// MBCODE
	if ( Level.NetMode != NM_Standalone )
		Rot.Pitch = 0;

	DeltaRot = (Rotation - Rot);
	ViewRotation.Pitch = ViewPitch;
	ViewRotation.Yaw = ViewYaw;
	ViewRotation.Roll = 0;
	SetRotation(Rot);

	OldBase = Base;

	// Perform actual movement.
	if ( (Level.Pauser == "") && (DeltaTime > 0) )
		MoveAutonomous(DeltaTime, NewbRun, NewbDuck, NewbPressedJump, DodgeMove, Accel, DeltaRot);

	// Accumulate movement error.
	// HX_HAN: Restore this as it caused problems with dropped decorations.
	//if ( Level.TimeSeconds - LastUpdateTime > 500.0/Player.CurrentNetSpeed )
	if ( Level.TimeSeconds - LastUpdateTime > 2000.0/Player.CurrentNetSpeed )
	{
		ClientErr = 10000;     
	}
	//Update every 2 seconds or so, regardless of anything else.
	//if ( Level.TimeSeconds - LastUpdateTime > 2 )
		//ClientErr = 10000;
	else if ( Level.TimeSeconds - LastUpdateTime > 180.0/Player.CurrentNetSpeed )
	{
		LocDiff = Location - ClientLoc;
		ClientErr = LocDiff Dot LocDiff;
	}

	// If client has accumulated a noticeable positional error, correct him.
	if ( ClientErr > 3 )
	{
		if ( Mover(Base) != None )
			ClientLoc = Location - Base.Location;
		else
			ClientLoc = Location;
	   //log("Client Error at "$TimeStamp$" is "$ClientErr$" with acceleration "$Accel$" LocDiff "$LocDiff$" Physics "$Physics);
      LastUpdateTime = Level.TimeSeconds;
		ClientAdjustPosition
		(
			TimeStamp, 
			GetStateName(), 
			Physics, 
			ClientLoc.X, 
			ClientLoc.Y, 
			ClientLoc.Z, 
			Velocity.X, 
			Velocity.Y, 
			Velocity.Z,
			Base
		);
	}
   // DEUS_EX AMSD Do any ticking which needs to be done.
   MultiplayerTick(DeltaTime);
	//log("Server "$Role$" moved "$self$" stamp "$TimeStamp$" location "$Location$" Acceleration "$Acceleration$" Velocity "$Velocity);
}	

// ----------------------------------------------------------------------------
// IncreaseNanoVirusInfection()
//
// Starts infection if not already infected.
// ----------------------------------------------------------------------------

function IncreaseNanoVirusInfection()
{
	local float OldNanoVirusDelay;

	if ( Game.IsAugmentedPlayerClass(Class) )
		return;

	if ( !bNanoVirusInfected )
	{
		bNanoVirusInfected = true;
		NanoVirusDelay     = default.NanoVirusDelay;
		NanoVirusTime      = NanoVirusDelay*class'HXActor'.static.TPDFShape( FRand(), 0.75, 1.00, 1.25 );
		return;
	}

	OldNanoVirusDelay = NanoVirusDelay;

	// Can be below zero when called by NanoVirusTimer.
	if ( OldNanoVirusDelay<0.0001 )
		OldNanoVirusDelay = 0.0002;

	// Don't dip below one second.
	NanoVirusDelay  = FMax( NanoVirusDelay*class'HXActor'.static.TPDFShape(FRand(),0.8,0.9,1.0), 1.0 );

	// Lower timer.
	NanoVirusTime -= (OldNanoVirusDelay-NanoVirusDelay)*(NanoVirusTime/OldNanoVirusDelay);
	if ( NanoVirusTime<0.0001 ) // Just because I'm unsure about my math here. --han
		NanoVirusTime = 0.0002;
}

// ----------------------------------------------------------------------------
// DecreaseNanoVirusInfection()
// ----------------------------------------------------------------------------

function DecreaseNanoVirusInfection()
{
	local float OldNanoVirusDelay;

	// Can't reset, becaues we are not infected.
	if ( !bNanoVirusInfected )
		return;

	OldNanoVirusDelay = NanoVirusDelay;

	// Don't go above infection start delay.
	NanoVirusDelay = FMin( NanoVirusDelay*class'HXActor'.static.TPDFShape(FRand(),1.5,2.0,2.5), default.NanoVirusDelay );

	// Delay timer.
	NanoVirusTime += (NanoVirusDelay-OldNanoVirusDelay)*(NanoVirusTime/OldNanoVirusDelay);
}

// ----------------------------------------------------------------------------
// StopNanoVirusInfection(()
// ----------------------------------------------------------------------------

function StopNanoVirusInfection()
{
	bNanoVirusInfected = false;
	NanoVirusTime      = 0;
}

// ----------------------------------------------------------------------------
// NanoVirusTimer()
// ----------------------------------------------------------------------------

event NanoVirusTimer()
{
	local Vector DamageOffset;
	local int    DamageAmount;

	if ( !bNanoVirusInfected )
		return;

	switch ( Rand(6) )
	{
		// Head.
		case 0:
			DamageOffset.X = 0.0;
			DamageOffset.Y = 0.0;
			DamageOffset.Z = CollisionHeight;
			DamageAmount   = NanoVirusDamage/2;
			break;

		// Right leg.
		case 1:
			DamageOffset.X = 0.0;
			DamageOffset.Y = 1.0;
			DamageOffset.Z =-1.0;
			DamageAmount   = NanoVirusDamage;
			break;

		// Left leg.
		case 2:
			DamageOffset.X = 0.0;
			DamageOffset.Y =-1.0;
			DamageOffset.Z =-1.0;
			DamageAmount   = NanoVirusDamage;
			break;

		// Right arm.
		case 3:
			DamageOffset.X = 0.0;
			DamageOffset.Y = CollisionRadius;
			DamageOffset.Z = 0.0;
			DamageAmount   = NanoVirusDamage;
			break;

		// Left arm.
		case 4:
			DamageOffset.X = 0.0;
			DamageOffset.Y =-CollisionRadius;
			DamageOffset.Z = 0.0;
			DamageAmount   = NanoVirusDamage;
			break;

		// Torso.
		case 5:
			DamageOffset.X = 0.0;
			DamageOffset.Y = 0.0;
			DamageOffset.Z = 0.0;
			DamageAmount   = NanoVirusDamage/2;
			break;

	}

	// Damage us.
	TakeDamage( DamageAmount, Self, Location+(DamageOffset>>Rotation), vect(0,0,0), 'Plague' );

	IncreaseNanoVirusInfection();

	// Reset timer.
	NanoVirusTime = NanoVirusDelay;
}

// ----------------------------------------------------------------------------
// WalkTexture()
//
// Engine calls this event and it is the only way to tell whether we the
// player is attached to a ladder, so save away the Ladder related data.
// ----------------------------------------------------------------------------

simulated event WalkTexture( Texture InTexture, vector InStepLocation, vector InStepNormal )
{
	if ( Texture.Outer!=None && Texture.Outer.Name=='Ladder' )
	{
		LadderTexture      = InTexture;
		LadderStepLocation = InStepLocation;
		LadderStepNormal   = InStepNormal;
		bOnLadder          = True;
	}
	else
	{
		bOnLadder = False;
	}
}

// ----------------------------------------------------------------------------
// Suicide()
// ----------------------------------------------------------------------------

exec function Suicide()
{
	// Reset Instigator.
	Instigator = None;

	KilledBy( None );
}

// ----------------------------------------------------------------------------
// ShowProgress()
//
// DeusExPlayer.ShowProgress() messes with the windows. We don't want that.
// ----------------------------------------------------------------------------

//function ShowProgress()
//{
//}

// ----------------------------------------------------------------------------
// PruneCurrent()
//
// Called before current map progress is saved just before switching level.
// Out parameter can be used to flag or unflag actor as transient.
//
// Be aware that this can break linked lists such as Level.PawnList.
// ----------------------------------------------------------------------------

simulated event PruneCurrent( out byte bTransient )
{
	local Augmentation Aug, NextAug;
	local Skill        Skill, NextSkill;
	local ColorTheme   Theme, NextTheme;

	//Log( Self, 'PruneCurrent' );

	// Reference to this Pawn would be simple set to None, thus breaking Level.PawnList linkage.
	RemovePawn();

	// Destroy any associated actors.
	if ( PlayerReplicationInfo!=None )
	{
		PlayerReplicationInfo.Destroy();
		PlayerReplicationInfo = None;
	}
	if ( AugmentationSystem!=None )
	{
		Aug = AugmentationSystem.FirstAug;
		while ( Aug!=None )
		{
			NextAug	= Aug.Next;
			Aug.Destroy();
			Aug = NextAug;
		}
		AugmentationSystem.Destroy();
		AugmentationSystem = None;
	}
	if ( SkillSystem!=None )
	{
		Skill = SkillSystem.FirstSkill;
		while ( Skill!=None  )
		{
			NextSkill	= Skill.Next;
			Skill.Destroy();
			Skill = NextSkill;
		}				
		SkillSystem.Destroy();
		SkillSystem = None;
	}
	if ( ThemeManager!=None )
	{
		Theme = ThemeManager.FirstColorTheme;
		while ( Theme!=None  )
		{
			NextTheme	= Theme.Next;
			Theme.Destroy();
			Theme = NextTheme;
		}				
		ThemeManager.Destroy();
		ThemeManager = None;
	}
	if ( CarriedDecoration!=None )
	{
		if ( HXDecoration(CarriedDecoration)!=None )
			HXDecoration(CarriedDecoration).Vanish();
		else
			CarriedDecoration.Destroy();
		CarriedDecoration = None;
	}
	if ( Shadow!=None )
	{
		Shadow.Destroy();
		Shadow = None;
	}
	// SpyDrone? Light from aug?

	// Flag player as transient so he will not get saved along the map.
	// I could probably destroy any non local players here.
	bTransient = 1;
}

// ----------------------------------------------------------------------------
// ClientMessage()
// ----------------------------------------------------------------------------

function ClientMessage( coerce string S, optional Name Type, optional bool bBeep )
{
	local bool bConsoleHistoryOnly;

	if ( Type=='' )
		Type = 'Event';

	// Forward to RootWindow.
	if ( RootWindow!=None )
		if ( RootWindow.ClientMessage(S,Type,bBeep) )
			bConsoleHistoryOnly = true;

	if ( Player==None )
		return;

	if ( Player.Console!=None )
	{
		if ( bConsoleHistoryOnly )
		{
			if ( HXConsole(Player.Console)!=None )
				HXConsole(Player.Console).MessageHistory( None/*PlayerReplicationInfo*/, S, 'Event'/*Type*/ );
		}
		else
			Player.Console.Message( None/*PlayerReplicationInfo*/, S, 'Event'/*Type*/ );
	}

	if ( bBeep && bMessageBeep )
		PlayBeepSound();
	if ( myHUD!=None )
		myHUD.Message( PlayerReplicationInfo, S, Type );
}

// ----------------------------------------------------------------------------
// ActivateAugmentation()
//
// Ideally, any activation should be piped through here, so I can add
// filtering by using stub in states, instead of RestrictInput().
//
// This function was used to toggle before.
// ----------------------------------------------------------------------------

exec function _ActivateAugmentation( int AugKey )
{
	local HXAugmentationManager _AugmentationSystem;

	_AugmentationSystem = HXAugmentationManager(AugmentationSystem);
	if ( _AugmentationSystem!=None )
		_AugmentationSystem.ActivateAugmentationByKey( AugKey );
}

// !! This was clientside.
exec function ActivateAugmentation( int AugKey )
{
	_ActivateAugmentation( AugKey );
}

// ----------------------------------------------------------------------------
// DeactivateAugmentation()
// ----------------------------------------------------------------------------

exec function DeactivateAugmentation( int AugKey )
{
	local HXAugmentationManager _AugmentationSystem;

	_AugmentationSystem = HXAugmentationManager(AugmentationSystem);
	if ( _AugmentationSystem!=None )
		_AugmentationSystem.DeactivateAugmentationByKey( AugKey );
}

// ----------------------------------------------------------------------------
// ToggleAugmentation()
// ----------------------------------------------------------------------------

exec function ToggleAugmentation( int AugKey )
{
	local HXAugmentationManager _AugmentationSystem;

	_AugmentationSystem = HXAugmentationManager(AugmentationSystem);
	if ( _AugmentationSystem!=None )
		_AugmentationSystem.ToggleAugmentationByKey( AugKey );
}

// ----------------------------------------------------------------------------
// DualmapXY()
//
// If player chose to dual map the F keys.
// ----------------------------------------------------------------------------

exec function DualmapF3()  { ToggleAugmentation(0); }
exec function DualmapF4()  { ToggleAugmentation(1); }
exec function DualmapF5()  { ToggleAugmentation(2); }
exec function DualmapF6()  { ToggleAugmentation(3); }
exec function DualmapF7()  { ToggleAugmentation(4); }
exec function DualmapF8()  { ToggleAugmentation(5); }
exec function DualmapF9()  { ToggleAugmentation(6); }
exec function DualmapF10() { ToggleAugmentation(7); }
exec function DualmapF11() { ToggleAugmentation(8); }
exec function DualmapF12() { ToggleAugmentation(9); }

// ----------------------------------------------------------------------
// Died()
//
// Checks to see if a conversation is playing when the PC dies.
// If so, nukes it.
// ----------------------------------------------------------------------

function Died(pawn Killer, name damageType, vector HitLocation)
{
	if (conPlay != None)
		conPlay.TerminateConversation();

	if (bOnFire)
		ExtinguishFire();

	if (AugmentationSystem != None)
		HXAugmentationManager(AugmentationSystem).ForceDeactivateAll();

   if ((Level.NetMode == NM_DedicatedServer) || (Level.NetMode == NM_ListenServer))
      ClientDeath();

	Super(PlayerPawnExt).Died(Killer, damageType, HitLocation);
}

// ----------------------------------------------------------------------------
// CustomCommand()
//
// Interface for PlayerPawn independent exec commands to passed from clients
// directly to the GameInfo and Mutator chain.
// ----------------------------------------------------------------------------

exec function CustomCommand( string Command )
{
	if ( Level.NetMode==NM_Client )
		return;

	Game.CustomCommand( Self, Command );
}

// ----------------------------------------------------------------------------
// Stubbed out.
// ----------------------------------------------------------------------------

function GetSkillInfoFromProj( DeusExPlayer killer, Actor proj );
function MultiplayerNotifyMsg( int code, optional int param, optional string str );
function ServerConditionalNotifyMsg( int code, optional int param, optional string str );
function CreateKillerProfile( Pawn killer, int damage, name damageType, String bodyPart );
function GetWeaponName( DeusExWeapon w, out String name );

// ----------------------------------------------------------------------------
// Disabled exec functions.
// ----------------------------------------------------------------------------

// PlayerPawn.
exec function ActivateInventoryItem( class InvItem );
exec function ActivateTranslator();
exec function ActivateHint();
exec function ChangeHud();
exec function ChangeCrosshair();
exec function FunctionKey( byte Num );
//exec function SwitchWeapon (byte F );
exec function GetWeapon( class<Weapon> NewWeaponClass );
exec function PrevItem();
exec function ActivateItem();
//exec function Fire( optional float F );
exec function AltFire( optional float F );
//exec function DoJump( optional float F );
//exec function Suicide()
// [...]

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	NetPriority=3.0
	AugMuscleClassLevel=-1
	bBeltIsMPInventory=False
	RegenRate=0.0
	bInThirdPersonCameraOverride=False
	bPostLoginRun=False
	AugPrefs(0)=HXAugVision
	AugPrefs(1)=HXAugDrone
	AugPrefs(2)=HXAugMuscle
	AugPrefs(3)=HXAugCloak
	AugPrefs(4)=HXAugRadarTrans
	AugPrefs(5)=HXAugHealing
	AugPrefs(6)=HXAugAqualung
	AugPrefs(7)=HXAugPower
	AugPrefs(8)=HXAugSpeed
	AugUpPrefs(0)=0
	AugUpPrefs(1)=0
	AugUpPrefs(2)=0
	AugUpPrefs(3)=0
	AugUpPrefs(4)=0
	AugUpPrefs(5)=0
	AugUpPrefs(6)=0
	AugUpPrefs(7)=0
	AugUpPrefs(8)=0
	AugCannisterAppearance(0)=(MuscleCombat=0,SpeedStealth=0,DefenseDrone=0,VisionTarget=0,CloakRadarTrans=0,BallisticEMP=0,EnviroAqualung=0,HealingShield=0,PowerHeartLung=0)
	AugCannisterAppearance(1)=(MuscleCombat=1,SpeedStealth=0,DefenseDrone=0,VisionTarget=0,CloakRadarTrans=0,BallisticEMP=0,EnviroAqualung=0,HealingShield=0,PowerHeartLung=0)
	AugCannisterAppearance(2)=(MuscleCombat=0,SpeedStealth=1,DefenseDrone=0,VisionTarget=0,CloakRadarTrans=0,BallisticEMP=0,EnviroAqualung=1,HealingShield=0,PowerHeartLung=0)
	AugCannisterAppearance(3)=(MuscleCombat=0,SpeedStealth=0,DefenseDrone=0,VisionTarget=0,CloakRadarTrans=0,BallisticEMP=1,EnviroAqualung=0,HealingShield=0,PowerHeartLung=0)
	AugCannisterAppearance(4)=(MuscleCombat=0,SpeedStealth=1,DefenseDrone=0,VisionTarget=0,CloakRadarTrans=0,BallisticEMP=0,EnviroAqualung=0,HealingShield=0,PowerHeartLung=0)
	AugCannisterAppearance(5)=(MuscleCombat=0,SpeedStealth=0,DefenseDrone=1,VisionTarget=0,CloakRadarTrans=0,BallisticEMP=0,EnviroAqualung=0,HealingShield=1,PowerHeartLung=0)
	AugCannisterAppearance(6)=(MuscleCombat=0,SpeedStealth=1,DefenseDrone=1,VisionTarget=1,CloakRadarTrans=1,BallisticEMP=0,EnviroAqualung=1,HealingShield=0,PowerHeartLung=1)
	AugCannisterAppearance(7)=(MuscleCombat=0,SpeedStealth=0,DefenseDrone=0,VisionTarget=0,CloakRadarTrans=0,BallisticEMP=0,EnviroAqualung=0,HealingShield=0,PowerHeartLung=0)
	AugCannisterAppearance(8)=(MuscleCombat=0,SpeedStealth=0,DefenseDrone=0,VisionTarget=0,CloakRadarTrans=1,BallisticEMP=0,EnviroAqualung=1,HealingShield=0,PowerHeartLung=0)
	AugCannisterAppearance(9)=(MuscleCombat=0,SpeedStealth=0,DefenseDrone=1,VisionTarget=0,CloakRadarTrans=0,BallisticEMP=0,EnviroAqualung=0,HealingShield=0,PowerHeartLung=0)
	AugCannisterAppearance(10)=(MuscleCombat=0,SpeedStealth=0,DefenseDrone=0,VisionTarget=1,CloakRadarTrans=0,BallisticEMP=1,EnviroAqualung=0,HealingShield=0,PowerHeartLung=0)
	AugCannisterAppearance(11)=(MuscleCombat=0,SpeedStealth=0,DefenseDrone=0,VisionTarget=0,CloakRadarTrans=1,BallisticEMP=0,EnviroAqualung=0,HealingShield=0,PowerHeartLung=0)
	AugCannisterAppearance(12)=(MuscleCombat=0,SpeedStealth=0,DefenseDrone=0,VisionTarget=0,CloakRadarTrans=0,BallisticEMP=0,EnviroAqualung=0,HealingShield=0,PowerHeartLung=0)
	AugCannisterAppearance(13)=(MuscleCombat=0,SpeedStealth=0,DefenseDrone=0,VisionTarget=0,CloakRadarTrans=0,BallisticEMP=0,EnviroAqualung=0,HealingShield=1,PowerHeartLung=0)
	AugCannisterAppearance(14)=(MuscleCombat=0,SpeedStealth=0,DefenseDrone=0,VisionTarget=0,CloakRadarTrans=0,BallisticEMP=0,EnviroAqualung=0,HealingShield=0,PowerHeartLung=1)
	WindowScale=1
	DroppedLabel="%s dropped"
	CannotBeDroppedLabel="%s cannot be dropped here"
	ATMLessCreditsAvailable="ATM Account had a lower amount of credits left"
	ATMAccountEmpty="ATM Account is empty"
	ScaledBreathPercent=255
	bIsMultiSkinned=True
	AllSkillsAwardMessage="%s used AllSkills cheat"
	AllSkillPointsAwardMessage="%s used AllSkillPoints cheat"
	AddSkillPointsAwardMessage="%s used AddSkillPoints cheat"
	MsgHealedPoint="Healed 1 point"
	MsgHealedPoints="Healed %d points"
	MsgRechargedPoint="Recharged 1 point"
	MsgRechargedPoints="Recharged %d points"
	ChatTimeout=6.0
	NanoVirusDelay=120
	NanoVirusDamage=5
}
