//=============================================================================
// HXProjectile.
//=============================================================================
class HXProjectile extends Projectile
	abstract;

var transient HXGameInfo Game;
var Name PrecessorName;
var bool bSpawning;

var bool bHighlight; // Highlight for frobbing.
var bool bExplodes;				// does this projectile explode?
var bool bBlood;				// does this projectile cause blood?
var bool bDebris;				// does this projectile cause debris?
var bool bStickToWall;			// does this projectile stick to walls?
var bool bStuck;				// is this projectile stuck to the wall?
var bool bIsThrownProjectile; // Is this a thrown projectile?
var vector InitDir;				// initial direction of travel
var float BlastRadius;			// radius to explode
var Actor Damagee;				// who is being damaged
var name DamageType;			// type of damage that this projectile does
var int AccurateRange;			// maximum accurate range in world units (feet * 16)
var int MaxRange;				// maximum range in world units (feet * 16)
var vector InitLoc;				// initial location for range tracking
var bool bTracking;				// should this projectile track a target?
var Actor Target;				// what target we are tracking
var float Time;					// misc. Timer
var float MinDrawScale;
var float MaxDrawScale;

var vector LastSeenLoc;    // Last known location of target
var vector NetworkTargetLoc; // For network propagation (non relevant targets)
var bool bHasNetworkTarget;
var bool bHadLocalTarget;

var int GradualHurtSteps;		// how many separate explosions for the staggered HurtRadius
var int GradualHurtCounter;		// which one are we currently doing

var bool bEmitDanger;
var class<Weapon> SpawnWeaponClass; // Weapon to give the player if this projectile is disarmed and frobbed.
var class<Ammo>   SpawnAmmoClass;   // Ammo to give the player if this projectile is disarmed and frobbed.

var bool bIgnoresNanoDefense; //True if the aggressive defense aug does not blow this up.

var bool bAggressiveExploded; //True if exploded by Aggressive Defense 

var localized string ItemName;		// human readable name
var localized string ItemArticle;	// article much like those for weapons

var bool bPlayerPlaced;

// ----------------------------------------------------------------------------
// Network replication.
// ----------------------------------------------------------------------------

replication 
{
	// Server to client.
	reliable if ( Role==ROLE_Authority )
		bTracking, Target, bAggressiveExploded, bHasNetworkTarget, NetworkTargetLoc, bPlayerPlaced,
		bHighlight, ItemName, bIgnoresNanoDefense;
}

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	// Save Precessors name aside for debugging purposes.
	PrecessorName        = Other.Name;

	// Advanced.
//bStatic              = Other.bStatic;             // Nope. Defined by defaultproperties.
	bHidden              = Other.bHidden;
//bNoDelete            = Other.bNoDelete;           // Nope. Defined by defaultproperties.
//bCanTeleport         = Other.bCanTeleport;        // Do I want this?
//bIsSecretGoal        = Other.bIsSecretGoal;
//bIsKillGoal          = Other.bIsKillGoal;
//bIsItemGoal          = Other.bIsItemGoal;
//bCollideWhenPlacing  = Other.bCollideWhenPlacing; // Still used by FarMove.
//bTravel              = Other.bTravel;             // Do not mess with this.
//bMovable             = Other.bMovable;            // Do not mess with this.
//bHighDetail          = Other.bHighDetail;         // Nah, do not mess with this.
//bStasis              = Other.bStasis;             // Rather not-ish.
//bForceStasis         = Other.bForceStasis;        // Rather not-ish.
//NetTemporary         = Other.NetTemporary;        // Certainly not.
//bNetOptional         = Other.bNetOptional;        // Certainly not.
//bBlockSight          = Other.bBlockSight;
//bDetectable          = Other.bDetectable;
//bTransient           = Other.bTransient;          // Rather not-ish.
//LifeSpan             = Other.LifeSpan;
//bHiddenEd            = Other.bHiddenEd;           // Editing flag.
//bDirectional         = Other.bDirectional;        // Editing flag.
//bEdShouldSnap        = Other.bEdShouldSnap;       // Editing flag.
//bOwnerNoSee          = Other.bOwnerNoSee;         // Rather not-ish.
//bOnlyOwnerSee        = Other.bOnlyOwnerSee;       // Rather not-ish.
//bAlwaysRelevant      = Other.bAlwaysRelevant;     // Certainly not-ish.
//bGameRelevant        = Other.bGameRelevant;       // Rather uncertain-ish.
	bOwned               = Other.bOwned;

	// Collision.
	SetCollisionSize( Other.CollisionRadius, Other.CollisionHeight );
	SetCollision( Other.bCollideActors, Other.bBlockActors, Other.bBlockPlayers );
	bCollideWorld	       = Other.bCollideWorld;
	bProjTarget          = Other.bProjTarget;

	// Conversation.
//BindName             = Other.BindName;         // !! Shadowed for ConversationTrigger.
//BarkBindName         = Other.BarkBindName;
//FamiliarName         = Other.FamiliarName;
//UnfamiliarName       = Other.UnfamiliarName;
//ConStartInterval     = Other.ConStartInterval;

	// Display.
//DrawType             = Other.DrawType;
//Style                = Other.Style;
//Sprite               = Other.Sprite;
//Texture              = Other.Texture;
//Skin                 = Other.Skin;
//MultiSkins[0]        = Other.MultiSkins[0];
//MultiSkins[1]        = Other.MultiSkins[1];
//MultiSkins[2]        = Other.MultiSkins[2];
//MultiSkins[3]        = Other.MultiSkins[3];
//MultiSkins[4]        = Other.MultiSkins[4];
//MultiSkins[5]        = Other.MultiSkins[5];
//MultiSkins[6]        = Other.MultiSkins[6];
//MultiSkins[7]        = Other.MultiSkins[7];
//Mesh                 = Other.Mesh;
//DrawScale            = Other.DrawScale;
//ScaleGlow            = Other.ScaleGlow;
//AmbientGlow          = Other.AmbientGlow;
//Fatness              = Other.Fatness;
//bUnlit               = Other.bUnlit;
//bNoSmooth            = Other.bNoSmooth;           // Not replicated.
//bParticles           = Other.bParticles;          // Not replicated.
//bRandomFrame         = Other.bRandomFrame;        // Not replicated.
//bMeshEnviroMap       = Other.bMeshEnviroMap;
//bMeshCurvy           = Other.bMeshCurvy;          // Not replicated.
//VisibilityRadius     = Other.VisibilityRadius;    // Not replicated.
//VisibilityHeight     = Other.VisibilityHeight;    // Not replicated.
//bShadowCast          = Other.bShadowCast;         // Not replicated.
////AnimSequence         = Other.AnimSequence;        // Preset?
//AnimFrame            = Other.AnimFrame;           // Preset? Implicit replicated?
//AnimRate             = Other.AnimRate;            // Preset? Implicit replicated?
//LODBias              = Other.LODBias;             // Not replicated.
//RenderIteratorClass  = Other.RenderIteratorClass; // Not replicated.

	// Events. 
	Event                = Other.Event;
//Tag                  = Other.Tag;   // Set by Spawn.

	// Filter.
//bDifficulty0         = Other.bDifficulty0;
//bDifficulty1         = Other.bDifficulty1;
//bDifficulty2         = Other.bDifficulty2;
//bDifficulty3         = Other.bDifficulty3;
//bSinglePlayer        = Other.bSinglePlayer;
//bNet                 = Other.bNet;
//bNetSpecial          = Other.bNetSpecial;
//OddsOfAppearing      = Other.OddsOfAppearing;

	// LightColor.
//LightBrightness      = Other.LightBrightness;
//LightHue             = Other.LightHue;
//LightSaturation      = Other.LightSaturation;

	// Lighting.
//LightType            = Other.LightType;
//LightEffect          = Other.LightEffect;
//LightRadius          = Other.LightRadius;
//LightPeriod          = Other.LightPeriod;
//LightPhase           = Other.LightPhase;
//LightCone            = Other.LightCone;        // Not replicated.
//VolumeBrightness     = Other.VolumeBrightness;
//VolumeRadius         = Other.VolumeRadius;
//VolumeFog            = Other.VolumeFog;        // Not replicated.
//bSpecialLit          = Other.bSpecialLit;
//bActorShadows        = Other.bActorShadows;    // Not replicated.
//bCorona              = Other.bCorona;          // Not replicated.
//bLensFlare           = Other.bLensFlare;       // Not replicated.

	// Movement.
//Location            = Other.Location; // Set by Spawn.
//Rotation            = Other.Rotation; // Set by Spawn.
//Velocity            = Other.Velocity; // Nah.
//SetPhysics( Other.Physics );          // Tricky-ish, hopefully irrelevant for Triggers.
//AttachTag           = Other.AttachTag;
//bBounce             = Other.bBounce;
//bFixedRotationDir   = Other.bFixedRotationDir;
//bRotateToDesired    = Other.bRotateToDesired;
//Mass                = Other.Mass;
//Buoyancy            = Other.Buoyancy;
//RotationRate        = Other.RotationRate;
//DesiredRotation     = Other.DesiredRotation;

	// Networking.
//RemoteRole           = Other.RemoteRole;         // I certainly
//NetPriority          = Other.NetPriority;        // won't use
//NetUpdateFrequency   = Other.NetUpdateFrequency; // these
//RelevantRadius       = Other.RelevantRadius;     // values. --han

	// Object.
	InitialState         = Other.InitialState; // Does this even work out of the box?
	Group                = Other.Group;

	// Smell.
//SmellClass           = Other.SmellClass;

	// Sound.
//SoundRadius          = Other.SoundRadius;
//SoundVolume          = Other.SoundVolume;
//SoundPitch           = Other.SoundPitch;
//AmbientSound         = Other.AmbientSound;
//TransientSoundVolume = Other.TransientSoundVolume; // Not replicated.
//TransientSoundRadius = Other.TransientSoundRadius; // Not replicated.

	// Make sure old Actor has Tag, Event, Group, BindName and BarkBindName removed.
	Other.Tag            = '';
	Other.Event          = '';
	Other.Group          = '';
//Other.BindName       = "";
//Other.BarkBindName   = "";

	// !! Projectile ??

	// DeusExProjectile contains no editable properties.
}

// ----------------------------------------------------------------------------
// IsInRelevant()
// 
// Whether code is currently running during a spawn inside a mutator in which
// case the properties are not yet properly set.
// ----------------------------------------------------------------------------

simulated function bool IsInRelevant()
{
	if ( Level.Game==None ) // Will happen on client too.
		return false;
	return Level.Game.IsInState( 'InIsRelevant' );
}

// ----------------------------------------------------------------------------
// Spawned()
// ----------------------------------------------------------------------------

simulated event Spawned()
{
	Super.Spawned();

	if ( Level.bStartup )
		bGameRelevant = true;

	Game = HXGameInfo(Level.Game);
}

// ----------------------------------------------------------------------------
// PreBeginPlay()
// ----------------------------------------------------------------------------

function PreBeginPlay()
{
	if ( bDeleteMe || IsInRelevant() )
		return;

	// Handle autodestruction if desired. Moved this here because the
	// config properties won't have their correct value set when spawned inside
	// the mutator, so you can't replace them at first pass there.
	if ( !bGameRelevant && Level.NetMode!=NM_Client && !Level.Game.IsRelevant(Self) )
	{
		Destroy();
		return;
	}
}

// ----------------------------------------------------------------------------
// PostBeginPlay()
// ----------------------------------------------------------------------------

function PostBeginPlay()
{
	if ( bDeleteMe || IsInRelevant() )
		return;

	if ( bEmitDanger )
		AIStartEvent( 'Projectile', EAITYPE_Visual );
}

// ----------------------------------------------------------------------------
// SetInitialState()
//
// Called after PostBeginPlay.
// ----------------------------------------------------------------------------

simulated event SetInitialState()
{
	if ( bDeleteMe || IsInRelevant() )
		return;

	if ( InitialState!='' )
		GotoState( InitialState );
	else
		GotoState( 'Auto' );

	bSpawning = false;
}

// ----------------------------------------------------------------------------
// PostPostBeginPlay()
// ----------------------------------------------------------------------------

event PostPostBeginPlay()
{
	// This may need to be reset, as a new GameInfo is spawned each time.
	Game = HXGameInfo(Level.Game);
}

// ----------------------------------------------------------------------------
// FellOutOfWorld()
// ----------------------------------------------------------------------------

event FellOutOfWorld()
{
	if ( PrecessorName!='' )
	{
		Log( Sprintf("Precessor of falling out of world %s was %s.",Name,PrecessorName), 'FellOutOfWorld' );
	}

	SetPhysics( PHYS_None );
	Destroy();
}

//
// Let the player pick up stuck projectiles
//
function Frob(Actor Frobber, Inventory frobWith)
{
	Super.Frob(Frobber, frobWith);

	// if the player frobs it and it's stuck, the player can grab it
	if (bStuck)
		GrabProjectile(HXPlayerPawn(Frobber));
}

function GrabProjectile(HXPlayerPawn player)
{
	local Inventory item;

	if (player != None)
	{
		if (spawnWeaponClass != None)		// spawn the weapon
		{
			item = Spawn(spawnWeaponClass);
			if (item != None)
				Weapon(item).PickupAmmoCount = 1;
		}
		else if (spawnAmmoClass != None)	// or spawn the ammo
		{
			item = Spawn(spawnAmmoClass);
				Ammo(item).AmmoAmount = 1;
		}
		if (item != None)
		{
			player.FrobTarget = item;

			// check to see if we can pick up the new weapon/ammo
			if (player.HandleItemPickup(item))
			{
				Destroy();				// destroy the projectile on the wall
			}
			else
				item.Destroy();			// destroy the weapon/ammo if it can't be picked up

			player.FrobTarget = None;
		}
	}
}

//
// update our flight path based on our ranges and tracking info
//
simulated function Tick(float deltaTime)
{
	local float dist, size;
	local Rotator dir;
	local vector TargetLocation; 
	local vector vel;
	local vector NormalHeading;
	local vector NormalDesiredHeading;
	local float HeadingDiffDot;
	local vector zerovec;

	if (bStuck)
		return;

	Super.Tick(deltaTime);

	if (VSize(LastSeenLoc) < 1)
	{
		LastSeenLoc = Location + Normal(Vector(Rotation)) * 10000;
	}

	if (Role == ROLE_Authority)
	{
		bHasNetworkTarget = (Target != None);
	}
	else
	{
		bHadLocalTarget = (bHadLocalTarget || (Target != None));
	}

	if (bTracking && ((Target != None) || ((Level.NetMode != NM_Standalone) && (bHasNetworkTarget)) || ((Level.Netmode != NM_Standalone) && (bHadLocalTarget))))
	{
		// check it's range
		dist = Abs(VSize(Target.Location - Location));
		if (dist > MaxRange)
		{
			// if we're out of range, lose the lock and quit tracking
			bTracking = False;
			Target = None;
			return;
		}
		else
		{
			// get the direction to the target
			if (Level.NetMode == NM_Standalone)
				TargetLocation = Target.Location;
			else
				TargetLocation = AcquireMPTargetLocation();
			if (Role == ROLE_Authority)
				NetworkTargetLoc = TargetLocation;
			LastSeenLoc = TargetLocation;
			dir = Rotator(TargetLocation - Location);
			dir.Roll = 0;

			if (Level.Netmode != NM_Standalone)
			{
				NormalHeading = Normal(Vector(Rotation));
				NormalDesiredHeading = Normal(TargetLocation - Location);
				HeadingDiffDot = NormalHeading Dot NormalDesiredHeading;
			}

			// set our new rotation
			bRotateToDesired = True;
			DesiredRotation = dir;

			// move us in the new direction that we are facing
			size = VSize(Velocity);
			vel = Normal(Vector(Rotation));

			if (Level.NetMode != NM_Standalone)
			{
				size = FMax(HeadingDiffDot,0.4) * Speed;
			}
			Velocity = vel * size;
		}
	}
	else
	{
		// make the rotation match the velocity direction
		SetRotation(Rotator(Velocity));
	}

	dist = Abs(VSize(InitLoc - Location));

	if (dist > AccurateRange)		// start descent due to "gravity"
		Acceleration = Region.Zone.ZoneGravity / 2;

	if ((Role < ROLE_Authority) && (bAggressiveExploded))
		Explode(Location, vect(0,0,1));
}

function Timer()
{
	if (bStuck)
		Destroy();
}

simulated function vector AcquireMPTargetLocation()
{   	
	local vector StartTrace, EndTrace, HitLocation, HitNormal;
	local Actor hit, retval;

	if (Target == None)
	{
		if (bHasNetworkTarget)
			return NetworkTargetLoc;
		else
			return LastSeenLoc;
	}

	StartTrace = Location;
	EndTrace = Target.Location;

	if (!Target.IsA('Pawn'))
		return Target.Location;

	foreach TraceActors(class'Actor', hit, HitLocation, HitNormal, EndTrace, StartTrace)
	{
		if (hit == Target)
			return Target.Location;
	}

	// adjust for eye height
	EndTrace.Z += Pawn(Target).BaseEyeHeight;

	foreach TraceActors(class'Actor', hit, HitLocation, HitNormal, EndTrace, StartTrace)
	{
		if (hit == Target)
			return EndTrace;
	}

	return LastSeenLoc;
}

function SpawnBlood(Vector HitLocation, Vector HitNormal)
{
	local int i;

	if ((HXGameInfo(Level.Game) != None) && (!HXGameInfo(Level.Game).bSpawnEffects))
		return;

	spawn(class'BloodSpurt',,,HitLocation+HitNormal);
	for (i=0; i<Damage/7; i++)
	{
		if (FRand() < 0.5)
		spawn(class'BloodDrop',,,HitLocation+HitNormal*4);
	}
}

simulated function SpawnEffects(Vector HitLocation, Vector HitNormal, Actor Other)
{
	local int i;
	local DeusExDecal mark;
	local Rockchip chip;

   // don't draw damage art on destroyed movers
	if (DeusExMover(Other) != None)
		if (DeusExMover(Other).bDestroyed)
			ExplosionDecal = None;

	// draw the explosion decal here, not in Engine.Projectile
	if (ExplosionDecal != None)
	{
		mark = DeusExDecal(Spawn(ExplosionDecal, Self,, HitLocation, Rotator(HitNormal)));
		if (mark != None)
		{
			mark.DrawScale = FClamp(damage/30, 0.5, 3.0);
			mark.ReattachDecal();
		}

		ExplosionDecal = None;
	}

	//DEUS_EX AMSD Don't spawn these on the server.
	if ((Level.NetMode == NM_DedicatedServer) && (Role == ROLE_Authority))
		return;

	if (bDebris)
	{
		for (i=0; i<Damage/5; i++)
			if (FRand() < 0.8)
			{
				chip = spawn(class'Rockchip',,,HitLocation+HitNormal);
				//DEUS_EX AMSD In multiplayer, don't propagate these to 
				//other players (or from the listen server to clients).
				if (chip != None)            
					chip.RemoteRole = ROLE_None;
			}
	}
}

simulated function DrawExplosionEffects(vector HitLocation, vector HitNormal)
{
	local ShockRing ring;
	//local SphereEffect sphere;
	local ExplosionLight light;
	local AnimatedSprite expeffect;

	// draw a pretty explosion
	light = Spawn(class'ExplosionLight',,, HitLocation);
	if (light != None)
		light.RemoteRole = ROLE_None;

	if (BlastRadius < 128)
	{
		expeffect = Spawn(class'ExplosionSmall',,, HitLocation);
		light.size = 2;
	}
	else if (BlastRadius < 256)
	{
		expeffect = Spawn(class'ExplosionMedium',,, HitLocation);
		light.size = 4;
	}
	else
	{
		expeffect = Spawn(class'ExplosionLarge',,, HitLocation);
		light.size = 8;
	}

	if (expeffect != None)
		expeffect.RemoteRole = ROLE_None;

	// draw a pretty shock ring
	// For nano defense we are doing something else.
	//if ((!bAggressiveExploded) || (Level.NetMode == NM_Standalone))
	//{
		ring = Spawn(class'ShockRing',,, HitLocation, rot(16384,0,0));
		if (ring != None)
		{
			ring.RemoteRole = ROLE_None;
			ring.size = BlastRadius / 32.0;
		}
			ring = Spawn(class'ShockRing',,, HitLocation, rot(0,0,0));
		if (ring != None)
		{
			ring.RemoteRole = ROLE_None;
			ring.size = BlastRadius / 32.0;
		}
			ring = Spawn(class'ShockRing',,, HitLocation, rot(0,16384,0));
		if (ring != None)
		{
			ring.RemoteRole = ROLE_None;
			ring.size = BlastRadius / 32.0;
		}
	//}
/*
	else
	{
		sphere = Spawn(class'SphereEffect',,, HitLocation, rot(16384,0,0));
		if (sphere != None)
		{
			sphere.RemoteRole = ROLE_None;
			sphere.size = BlastRadius / 32.0;
		}
			sphere = Spawn(class'SphereEffect',,, HitLocation, rot(0,0,0));
		if (sphere != None)
		{
			sphere.RemoteRole = ROLE_None;
			sphere.size = BlastRadius / 32.0;
		}
		sphere = Spawn(class'SphereEffect',,, HitLocation, rot(0,16384,0));
		if (sphere != None)
		{
			sphere.RemoteRole = ROLE_None;
			sphere.size = BlastRadius / 32.0;
		}
	}
*/
}

//
// Exploding state
//
state Exploding
{
	ignores ProcessTouch, HitWall, Explode;

	function DamageRing()
	{
		local Pawn apawn;
		local float damageRadius;
		local Vector dist;

		/*if ( Level.NetMode != NM_Standalone )
		{
			damageRadius = (BlastRadius / GradualHurtSteps) * GradualHurtCounter;

			for ( apawn = Level.PawnList; apawn != None; apawn = apawn.nextPawn )
			{
				if ( apawn.IsA('HXPlayerPawn') )
				{
					dist = apawn.Location - Location;
					if ( VSize(dist) < damageRadius )
					{
						if ( GradualHurtCounter <= 2 )
						{
							if ( apawn.FastTrace( apawn.Location, Location ))
								HXPlayerPawn(apawn).myProjKiller = Self;
						}
						else
							HXPlayerPawn(apawn).myProjKiller = Self;
					}
				}
			}
		}*/

		//DEUS_EX AMSD Ignore Line of Sight on the lowest radius check, only in multiplayer
		HurtRadius
		(
			(2 * Damage) / GradualHurtSteps,
			(BlastRadius / GradualHurtSteps) * GradualHurtCounter,
			DamageType,
			MomentumTransfer / GradualHurtSteps,
			Location,
			//((GradualHurtCounter <= 2) && (Level.NetMode != NM_Standalone))
			false
		);
	}

	function Timer()
	{
		// GOTY:
		//GradualHurtCounter++;
		//DamageRing();

		// RTM:
		DamageRing();
		GradualHurtCounter++;

		if ( GradualHurtCounter>=GradualHurtSteps )
			Destroy();
	}

Begin:
	// stagger the HurtRadius outward using Timer()
	// do five separate blast rings increasing in size
	GradualHurtCounter = 1;
	GradualHurtSteps = 5;
	Velocity = vect(0,0,0);
	bHidden = True;
	LightType = LT_None;
	SetCollision(False, False, False);

	// RTM:
	SetTimer(0.5/float(GradualHurtSteps), True);

	// GOTY:
	//DamageRing();
	//SetTimer(0.25/float(GradualHurtSteps), True);
}

/*
RTM:

	gradualHurtCounter = 1;
	Sleep(0.5/float(gradualHurtSteps));
	DamageRing();
	gradualHurtCounter = 2;
	Sleep(0.5/float(gradualHurtSteps));
	DamageRing();
	gradualHurtCounter = 3;
	Sleep(0.5/float(gradualHurtSteps));
	DamageRing();
	gradualHurtCounter = 4;
	Sleep(0.5/float(gradualHurtSteps));
	DamageRing();
	gradualHurtCounter = 5;
	Destroy();

GOTY:

	gradualHurtCounter = 1;
	DamageRing();
	Sleep(0.25/float(gradualHurtSteps));
	gradualHurtCounter = 2;
  DamageRing();
	Sleep(0.25/float(gradualHurtSteps));
	gradualHurtCounter = 3;
  DamageRing();
	Sleep(0.25/float(gradualHurtSteps));
	gradualHurtCounter = 4;
  DamageRing();
	Sleep(0.25/float(gradualHurtSteps));
	gradualHurtCounter = 5;
  DamageRing();
	Destroy();

*/

function PlayImpactSound()
{
	local float rad;

	if ((Level.NetMode == NM_Standalone) || (Level.NetMode == NM_ListenServer) || (Level.NetMode == NM_DedicatedServer))
	{
		rad = Max(BlastRadius*4, 1024);
		PlaySound(ImpactSound, SLOT_None, 2.0,, rad);
	}
}

auto simulated state Flying
{
	simulated function ProcessTouch (Actor Other, Vector HitLocation)
	{
		if (bStuck)
			return;

		if ((Other != instigator) && (HXProjectile(Other) == None) && (Other != Owner))
		{
			Damagee = Other;
			Explode(HitLocation, Normal(HitLocation-Damagee.Location));

       // DEUS_EX AMSD Spawn blood server side only
      if (Role == ROLE_Authority)
			{
				if ( Damagee.bIsPawn && !(Damagee.IsA('HXScriptedPawn') && HXScriptedPawn(Damagee).bIsRobot) && bBlood )
					SpawnBlood(HitLocation, Normal(HitLocation-Damagee.Location));
			}
		}
	}
	simulated function HitWall(vector HitNormal, actor Wall)
	{
		//Log("HXProjectile.Flying.HitWall() called.");

		if (bStickToWall)
		{
			Velocity = vect(0,0,0);
			Acceleration = vect(0,0,0);
			SetPhysics(PHYS_None);
			bStuck = true; // Does the client care?

			// MBCODE: Do this only on server side
			if ( Role == ROLE_Authority )
			{
				bHighlight = true;

        //if (Level.NetMode != NM_Standalone)
           //SetTimer(5.0,False);

				if (Wall.IsA('Mover'))
				{
					SetBase(Wall);
					Wall.TakeDamage(Damage, Pawn(Owner), Wall.Location, MomentumTransfer*Normal(Velocity), DamageType);
				}
			}
		}

		if (Wall.IsA('HXBreakableGlass') || Wall.IsA('BreakableGlass'))
			bDebris = False;

		SpawnEffects(Location, HitNormal, Wall);

		Super.HitWall(HitNormal, Wall);
	}
	simulated function Explode(vector HitLocation, vector HitNormal)
	{
		local bool bDestroy;
		local float rad;

		// Reduce damage on nano exploded projectiles
		//if ((bAggressiveExploded) && (Level.NetMode != NM_Standalone))
			 //Damage = Damage/6;

		bDestroy = false;

		if (bExplodes)
		{
         //DEUS_EX AMSD Don't draw effects on dedicated server
         if ((Level.NetMode != NM_DedicatedServer) || (Role < ROLE_Authority))			
            DrawExplosionEffects(HitLocation, HitNormal);

			GotoState('Exploding');
		}
		else
		{
			// Server side only
			if ( Role == ROLE_Authority )
			{
				if ((Damagee != None) && (HXTracer(Self) == None)) // Don't even attempt damage with a tracer
				{
					if ( Level.NetMode != NM_Standalone )
					{
						if ( Damagee.IsA('HXPlayerPawn') )
							HXPlayerPawn(Damagee).myProjKiller = Self;
					}
					Damagee.TakeDamage(Damage, Pawn(Owner), HitLocation, MomentumTransfer*Normal(Velocity), DamageType);
				}
			}
			if (!bStuck)
				bDestroy = true;
		}

		rad = Max(BlastRadius*24, 1024);

		// This needs to be outside the simulated call chain
		PlayImpactSound();

    //DEUS_EX AMSD Only do these server side
    if (Role == ROLE_Authority)
    {
       if (ImpactSound != None)
       {
          AISendEvent('LoudNoise', EAITYPE_Audio, 2.0, BlastRadius*24);
          if (bExplodes)
             AISendEvent('WeaponFire', EAITYPE_Audio, 2.0, BlastRadius*5);
       }
    }
		if (bDestroy)
			Destroy();
	}
	simulated function BeginState()
	{
		/*local HXWeapon W;*/

		InitLoc = Location;
		InitDir = vector(Rotation);	
		Velocity = speed*InitDir;
		PlaySound(SpawnSound, SLOT_None);
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	bSpawning=True
	AccurateRange=800
	MaxRange=1600
	MinDrawScale=0.05
	MaxDrawScale=2.5
	bEmitDanger=True
	ItemName="DEFAULT PROJECTILE NAME - REPORT THIS AS A BUG"
	ItemArticle="Error"
	RemoteRole=ROLE_SimulatedProxy
	LifeSpan=60.0
	RotationRate=(Pitch=65536,Yaw=65536)
}
