//=============================================================================
// HXRepairBot.
//=============================================================================
class HXRepairBot extends HXRobot;

var int chargeAmount;
var int chargeRefreshTime;
var Float lastchargeTime;

//var HXHUDRechargeWindow RechargeWindow;

// ----------------------------------------------------------------------------
// Network replication
// ----------------------------------------------------------------------------
//replication
//{
	//reliable if ( Role == ROLE_Authority )
		//lastchargeTime, chargeRefreshTime;
//}

// ----------------------------------------------------------------------------
// PostBeginPlay()
// ----------------------------------------------------------------------------

function PostBeginPlay()
{
	Super.PostBeginPlay();

	curFrobber = None;
	lastChargeTime = -chargeRefreshTime;
}

// ----------------------------------------------------------------------------
// Frob()
// ----------------------------------------------------------------------------

function Frob(Actor Frobber, Inventory frobWith)
{
	local HXPlayerPawn player;
	local float elapsed, delay;

	// Don't allow someone else to use the repairbot when already in use.
	if (curFrobber != None)
	{
		if (HXPlayerPawn(Frobber) != None)
			HXPlayerPawn(Frobber).ClientMessage(Sprintf(PawnInUseMsg,curFrobber.PlayerReplicationInfo.PlayerName));
		return;
	}

	Super.Frob(Frobber, frobWith);

	// DEUS_EX AMSD get player from frobber, not from getplayerpawn
	player = HXPlayerPawn(Frobber);

	if (player != None)
	{
		if (!bAnimating)
		{
			curFrobber = player;
			GotoState('On');
		}
	}
}

// ----------------------------------------------------------------------------
// state On
// ----------------------------------------------------------------------------

state On
{
	function Tick(float deltaTime)
	{
		Global.Tick(deltaTime);

		if (bOn)
		{
			//if ((RechargeWindow == None) && (Level.NetMode == NM_Standalone))
			//{
				//GotoState('Off');
			//}            
			if (curFrobber == None)
			{
				GotoState('Off');
			}
			else if (VSize(curFrobber.Location - Location) > 1500)
			{
				Log("Disabling repairbot "$Self$" because user "$curFrobber$" was too far away");
				//Probably should be "GotoState('Off')" instead, but no good way to test, so I'll leave it alone.
				curFrobber = None;
			}
		}
	}

Begin:
	if (!bOn)
	{
		bAnimating = True;
		Acceleration=Vect(0, 0, 0);
		DesiredRotation=Rotation;
		PlaySound(sound'RepairBotRaiseArm', SLOT_None);
		PlayAnim('Start');
		FinishAnim();
		bOn = True;
		bAnimating = False;
    TryInvoke();
	}
}

// ----------------------------------------------------------------------------
// state Off
// ----------------------------------------------------------------------------

state Off
{
Begin:
	if (bOn)
	{
		bAnimating = True;

		PlaySound(sound'RepairBotLowerArm', SLOT_None);
		PlayAnim('Stop');
		FinishAnim();

		bOn = False;
		bAnimating = False;
    curFrobber = None;

		FollowOrders();
	}
}

// ----------------------------------------------------------------------------
// TryInvoke()
// ----------------------------------------------------------------------------

function TryInvoke()
{
	if (IsInState('Off'))
		return;

	if (!Invoke())
	{
		GotoState('Off');
	}

	return;
}

// ----------------------------------------------------------------------------
// Invoke()
// ----------------------------------------------------------------------------

function bool Invoke()
{
	local HXPlayerPawn player;

	//if (RechargeWindow != None)
		//return False;

	player = curFrobber;

	if (player != None)
	{
		player.InvokeRepairBot(self, lastChargeTime, Level.TimeSeconds);
		SetOwner(Player);
	}

	return True;
}

// ----------------------------------------------------------------------------
// CloseOut()
// ----------------------------------------------------------------------------

function CloseOut()
{
	if (curFrobber != None)
		GotoState('Off');
}

// ----------------------------------------------------------------------------
// ChargePlayer()
// DEUS_EX AMSD Moved back over here 
// ----------------------------------------------------------------------------
function int ChargePlayer(DeusExPlayer PlayerToCharge)
{
	local int chargedPoints;

	if ( CanCharge() )
	{
		chargedPoints = PlayerToCharge.ChargePlayer( chargeAmount );
		lastChargeTime = Level.TimeSeconds;
		HXPlayerPawn(PlayerToCharge).SetRepairBotChargeTime(self, lastChargeTime, Level.TimeSeconds);
	}
  return chargedPoints;
}

// ----------------------------------------------------------------------------
// CanCharge()
// 
// Returns whether or not the bot can charge the player
// ----------------------------------------------------------------------------

simulated function bool CanCharge()
{	
	return ( (Level.TimeSeconds - int(lastChargeTime)) > chargeRefreshTime);
}

// ----------------------------------------------------------------------------
// GetRefreshTimeRemaining()
// ----------------------------------------------------------------------------

simulated function Float GetRefreshTimeRemaining()
{
	return chargeRefreshTime - (Level.TimeSeconds - lastChargeTime);
}

// ----------------------------------------------------------------------------
// GetAvailableCharge()
// ----------------------------------------------------------------------------

simulated function Int GetAvailableCharge()
{
	if (CanCharge())
		return chargeAmount; 
	else
		return 0;
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	PawnInUseMsg="The Repairbot is already in use by %s."
	bAlwaysRelevant=True
	ChargeAmount=75
	ChargeRefreshTime=60
	GroundSpeed=100.0
	WaterSpeed=50.0
	AirSpeed=144.0
	AccelRate=100.0
	UnderWaterTime=20.0
	AttitudeToPlayer=ATTITUDE_Ignore
	DrawType=DT_Mesh
	Mesh=RepairBot
	SoundRadius=16
	SoundVolume=128
	AmbientSound=RepairBotMove
	CollisionRadius=34.00
	//CollisionHeight=47.47
	CollisionHeight=42.97
	Mass=150.0
	Buoyancy=97.0
	BindName="RepairBot"
	FamiliarName="Repair Bot"
	UnfamiliarName="Repair Bot"
}
