//=============================================================================
// HXRetinalScanner.
//=============================================================================
class HXRetinalScanner extends HXHackableDevices;

var() localized String MsgUsed;

// ----------------------------------------------------------------------------
// HackAction().
// ----------------------------------------------------------------------------

function HackAction( Actor Hacker, bool bHacked )
{
	local Actor  A;
	local Pawn   P;
	local string PlayerName;

	Super.HackAction( Hacker, bHacked );

	if ( bHacked )
	{
		if ( Event!='' )
		{
			P = Pawn(Hacker);
			if ( P!=None )
			{
				if ( P.PlayerReplicationInfo!=None )
					PlayerName = P.PlayerReplicationInfo.PlayerName;

				P.ClientMessage( Sprintf(MsgUsed,PlayerName) );
			}

			foreach AllActors( class'Actor', A, Event )
				A.Trigger( Self, Pawn(Hacker) );
		}
	}
}

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local RetinalScanner OtherRetinalScanner;

	// Call Super.
	Super.Succeeds( Other );

	// Special RetinalScanner Init.
	OtherRetinalScanner = RetinalScanner(Other);
	if ( OtherRetinalScanner!=None )
	{
		MsgUsed = OtherRetinalScanner.MsgUsed;
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	MsgUsed="Clearance granted"
	ItemName="Retinal Scanner"
	Mesh=RetinalScanner
	SoundRadius=8
	SoundVolume=255
	SoundPitch=96
	AmbientSound=SecurityL
	CollisionRadius=10.00
	//CollisionHeight=11.43
	CollisionHeight=10.68
	Mass=30.0
	Buoyancy=40.0
}
