//=============================================================================
// HXRootWindow
//=============================================================================
class HXRootWindow extends DeusExRootWindow;

// Customizable HUD.
var class<HXHUD> HUDClass;

// Customizable classes for DataVaultFunctions,
var class<HXPersonaScreenBaseWindow> ShowInventoryWindowClass;
var class<HXPersonaScreenBaseWindow> ShowHealthWindowClass;
var class<HXPersonaScreenBaseWindow> ShowAugmentationsWindowClass;
var class<HXPersonaScreenBaseWindow> ShowSkillsWindowClass;
var class<HXPersonaScreenBaseWindow> ShowGoalsWindowClass;
var class<HXPersonaScreenBaseWindow> ShowConversationsWindowClass;
var class<HXPersonaScreenBaseWindow> ShowImagesWindowClass;
var class<HXPersonaScreenBaseWindow> ShowLogsWindowClass;
var class<HXPersonaScreenBaseWindow> ShowAugmentationAddWindowClass;

// ----------------------------------------------------------------------------
// InitWindow()
//
// Called when this window is initialized.
// ----------------------------------------------------------------------------

event InitWindow()
{
	local HXConsole Console;
	local String Message;
	local Name MessageType;

	Super(ModalWindow).InitWindow();

	SetFont( Font'TechMedium' );

	SetDefaultCursor( Texture'DefaultCursor' );
	SetDefaultEditCursor( Texture'DefaultTextCursor');
	SetDefaultMovementCursors( Texture'DefaultMoveCursor', Texture'DefaultHMoveCursor', Texture'DefaultVMoveCursor', Texture'DefaultTLMoveCursor', Texture'DefaultTRMoveCursor' );

	// Initialize variables
	WinCount = 0;

	ActorDisplay = ActorDisplayWindow(NewChild(Class'ActorDisplayWindow'));
	ActorDisplay.SetWindowAlignments(HALIGN_Full, VALIGN_Full);

	// Init HUD.
	if ( HUDClass!=None )
	{
		HUD = HXHUD(NewChild(HUDClass));
		if ( HUD!=None )
		{
			HUD.UpdateSettings(HXPlayerPawn(parentPawn));
			HUD.SetWindowAlignments(HALIGN_Full, VALIGN_Full, 0, 0);
		}
	}

	ScopeView = HXScopeView(NewChild(Class'HXScopeView', False));
	ScopeView.SetWindowAlignments(HALIGN_Full, VALIGN_Full, 0, 0);

	SetDefaultCursor( Texture'DeusExCursor1', Texture'DeusExCursor1_Shadow' );

	ScopeView.Lower();

	// Copy over desired class to DataVaultFunctions.
	DataVaultFunctions[0].WinClass = ShowInventoryWindowClass;
	DataVaultFunctions[1].WinClass = ShowHealthWindowClass;
	DataVaultFunctions[2].WinClass = ShowAugmentationsWindowClass;
	DataVaultFunctions[3].WinClass = ShowSkillsWindowClass;
	DataVaultFunctions[4].WinClass = ShowGoalsWindowClass;
	DataVaultFunctions[5].WinClass = ShowConversationsWindowClass;
	DataVaultFunctions[6].WinClass = ShowImagesWindowClass;
	DataVaultFunctions[7].WinClass = ShowLogsWindowClass;

	//Log( Self $ ".InitWindow()" );

	// Snag/clear visible Console log.
	Console = HXConsole(ParentPawn.Player.Console);
	if ( Console!=None )
	{
		if ( HUD!=None && HUD.MsgLog!=None )
		{
			// Add to HUD MsgLog.
			while ( Console.SnagMessage(Message,MessageType) )
				ClientMessage( Message, MessageType, false );
		}
		else
		{
			// Just clear.
			Console.ArchiveMessages();
		}
	}
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------
// ConfigurationChanged() : Called when the parent changes this window's
//                          size

//event ConfigurationChanged()
//{
	//Super.ConfigurationChanged();

	//Log( "ConfigurationChanged()", Name );
//}

// ----------------------------------------------------------------------------
// ClientMessage()
// ----------------------------------------------------------------------------

function bool ClientMessage( coerce string Message, optional Name Type, optional bool bBeep )
{
	local Color linecol;
	local Sound MessageSound;
	local float MessageSoundVolume;
	local HXPersonaScreenBaseWindow PersonaTopWindow;
	local HXHUD _HUD;

	// If a PersonaBaseWindow is visible, send the log message that way as well.
	// This was done before in HUDLogDisplay.
	PersonaTopWindow = HXPersonaScreenBaseWindow(GetTopWindow());
	if ( PersonaTopWindow!=None )
		if ( PersonaTopWindow.ClientMessage(Message,Type,bBeep) )
			return true;

	// Add this to the player's list of log objects
	HXPlayerPawn(parentPawn).AddLog( Message ); // !! YUK YUK YUK YUK !!

	// Let HUD deal with it.
	_HUD = HXHUD(HUD);
	if ( _HUD!=None )
		if ( _HUD.ClientMessage(Message,Type,bBeep) )
			return true;

	return false;
}

// ----------------------------------------------------------------------------
// RefreshDisplay()
// DEUS_EX AMSD Used to keep displays up to date with replication from
// the server.  Calls current topwindow refreshwindow.
// ----------------------------------------------------------------------------

function RefreshDisplay( float DeltaTime )
{
	if ( GetTopWindow()!=None )
		GetTopWindow().RefreshWindow(DeltaTime);
	//if (hud != None)
		//hud.belt.RefreshHUDDisplay(DeltaTime);
}

// ----------------------------------------------------------------------------
// ActivateObjectInBelt() -- UNUSED IN HX
// ----------------------------------------------------------------------------

function bool ActivateObjectInBelt( int Pos )
{
	return False;
}

// ----------------------------------------------------------------------------
// AddInventory() -- UNUSED IN HX
// ----------------------------------------------------------------------------

function AddInventory( Inventory Item )
{
}

// ----------------------------------------------------------------------------
// DeleteInventory() -- UNUSED IN HX
// ----------------------------------------------------------------------------

function DeleteInventory( Inventory Item )
{
}

// ----------------------------------------------------------------------------
// UIPauseGame()
//
// Pauses the game, but checks to see if the Mission is -1 or -2, which means
// we're on the title screen and we don't want to pause the game here.
// ----------------------------------------------------------------------------

function UIPauseGame()
{
	// Only do this once 
	if (!bUIPaused)
	{
		bUIPaused = True;

		// HX
		//parentPawn.bShowMenu = True;

		if (!AtIntroMap())
		{
			ShowSnapshot();
			parentPawn.ShowMenu();
		}
		else
		{
			MaskBackground(True);
		}
	}
}

// ----------------------------------------------------------------------
// MessageBox()
//
// Displays a Message box
// ----------------------------------------------------------------------

function MenuUIMessageBoxWindow MessageBox( String MsgTitle, String MsgText, int MsgBoxMode, bool HideCurrentScreen, Window WinParent )	
{
	local MenuUIMessageBoxWindow MsgBox;

	MsgBox = MenuUIMessageBoxWindow(PushWindow(Class'MenuUIMessageBoxWindow',hideCurrentScreen));
	MsgBox.SetTitle( MsgTitle );
	MsgBox.SetMessageText( MsgText );
	MsgBox.SetMode( MsgBoxMode );
	MsgBox.SetNotifyWindow( WinParent );

	return MsgBox; // We can safely return None here, as only ConfirmQuickLoad has ever used the return value.
}

// ----------------------------------------------------------------------
// ConfirmQuickLoad()
// ----------------------------------------------------------------------

function ConfirmQuickLoad()
{
}

// ----------------------------------------------------------------------
// InvokeMenuScreen()
//
// Invokes a DeusExBaseWindow.
// ----------------------------------------------------------------------

function DeusExBaseWindow InvokeMenuScreen( Class<DeusExBaseWindow> ScreenClass, optional bool bNoPause )
{
	local DeusExBaseWindow TopWindow, NewWindow;
	local bool bHideCurrentWindow;

	// Check to see if a menu is visible. If so, hide it.
	TopWindow = GetTopWindow();
	bHideCurrentWindow = TopWindow.IsA('MenuUIScreenWindow') || TopWindow.IsA('HXMenuUIScreenWindow') || TopWindow.IsA('HXMenuUIMenuWindow');

	// Push.
	NewWindow = PushWindow( ScreenClass, bHideCurrentWindow, bNoPause );

	// Pause the game.
	if ( !bNoPause )
		UIPauseGame();

	return NewWindow;
}

// ----------------------------------------------------------------------------
// UnPauseGame()
// ----------------------------------------------------------------------------

function UnPauseGame()
{
	bUIPaused = False;

	SetBackgroundStyle(DSTY_None);

	HideSnapshot();
	ShowHud(True);

	ParentPawn.bShowMenu = False;
	ParentPawn.Player.Console.GotoState( '' );
	ParentPawn.SetPause( False );
}

// ----------------------------------------------------------------------------
// AtIntroMap()
// ----------------------------------------------------------------------------

function bool AtIntroMap()
{
	local DeusExLevelInfo dxInfo;

	foreach parentPawn.AllActors(class'DeusExLevelInfo', dxInfo)
		break;

	if ((dxInfo == None) || ((dxInfo != None) && (dxInfo.missionNumber >= 0)))
		return False;
	else
		return True;
}

// ----------------------------------------------------------------------------
// InvokeLoadScreen() -- UNUSED IN HX
// ----------------------------------------------------------------------------

function InvokeLoadScreen()
{
}

// ----------------------------------------------------------------------------
// InvokeSaveScreen() -- UNUSED IN HX
// ----------------------------------------------------------------------------

function InvokeSaveScreen()
{
}

// ----------------------------------------------------------------------------
// ClearWindowStackNoUnPauseGame()
//
// Version of ClearWindowStack() without UnPauseGame();
// ----------------------------------------------------------------------------

function ClearWindowStackNoUnPauseGame()
{
	while(winCount > 0)
	{
		if ( winStack[winCount-1] != None )
		{
			winStack[winCount-1].Destroy();
			winStack[winCount-1] = None;
			winCount--;
		}
	}

	// HX_HAN: Took this out because it caused a crashed when disconnecting
	//         from a server (Regression caused by fix for crash when in
	//         inventory screen and closing game window).
	//UnPauseGame();
}

// ----------------------------------------------------------------------------
// Show*Window()
//
// Wrapper for DataVault functions. So one just needs to alter the default
// properties of a custom RootWindow class and has it in one place.
// ----------------------------------------------------------------------------

function ShowInventoryWindow()       { ShowDataVaultWindow( ShowInventoryWindowClass       ); }
function ShowHealthWindow()          { ShowDataVaultWindow( ShowHealthWindowClass          ); }
function ShowAugmentationsWindow()   { ShowDataVaultWindow( ShowAugmentationsWindowClass   ); }
function ShowSkillsWindow()          { ShowDataVaultWindow( ShowSkillsWindowClass          ); }
function ShowGoalsWindow()           { ShowDataVaultWindow( ShowGoalsWindowClass           ); }
function ShowConversationsWindow()   { ShowDataVaultWindow( ShowConversationsWindowClass   ); }
function ShowImagesWindow()          { ShowDataVaultWindow( ShowImagesWindowClass          ); }
function ShowLogsWindow()            { ShowDataVaultWindow( ShowLogsWindowClass            ); }
function ShowAugmentationAddWindow() { ShowDataVaultWindow( ShowAugmentationAddWindowClass ); }

// Based on HXPlayerPawn.InvokeUIScreen()
function ShowDataVaultWindow( Class<HXPersonaScreenBaseWindow> WindowClass )
{
	if ( IsKeyDown(IK_Alt) || IsKeyDown(IK_Shift) || IsKeyDown(IK_Ctrl) )
		return;

	InvokeUIScreen( WindowClass );
}

// ----------------------------------------------------------------------
// AddDamageDisplay()
//
// Turn on the correct damage type icon on the HUD
// Note that these icons naturally fade out after a few seconds,
// so there is no need to turn them off
// ----------------------------------------------------------------------

function AddDamageDisplay( Name DamageType, Vector HitOffset )
{
	HUD.DamageDisplay.AddIcon( DamageType, HitOffset );
}

// ----------------------------------------------------------------------
// SetDamagePercent()
//
// Set the percentage amount of damage that's being absorbed
// ----------------------------------------------------------------------

function SetDamagePercent( float Percent )
{
	HUD.DamageDisplay.SetPercent( Percent );
}

// ----------------------------------------------------------------------
// Show*() functions for ActorDisplay.
// ----------------------------------------------------------------------

function ShowClass( Class<Actor> ViewClass )
{
	if ( ActorDisplay!=None )
		ActorDisplay.SetViewClass( ViewClass );
}
function ShowEyes( bool bShow )
{
	if ( ActorDisplay!=None )
		ActorDisplay.ShowEyes( bShow );
}
function ShowArea( bool bShow )
{
	if ( ActorDisplay!=None )
		ActorDisplay.ShowArea( bShow );
}
function ShowCylinder( bool bShow )
{
	if ( ActorDisplay!=None )
		ActorDisplay.ShowCylinder( bShow );
}
function ShowMesh( bool bShow )
{
	if ( ActorDisplay!=None )
		ActorDisplay.ShowMesh( bShow );
}
function ShowZone( bool bShow )
{
	if ( ActorDisplay!=None )
		ActorDisplay.ShowZone( bShow );
}
function ShowLOS( bool bShow )
{
	if ( ActorDisplay!=None )
		ActorDisplay.ShowLOS( bShow );
}
function ShowVisibility( bool bShow )
{
	if ( ActorDisplay!=None )
		ActorDisplay.ShowVisibility( bShow );
}
function ShowData( bool bShow )
{
	if ( ActorDisplay!=None )
		ActorDisplay.ShowData( bShow );
}
function ShowEnemyResponse( bool bShow )
{
	if ( ActorDisplay!=None )
		ActorDisplay.ShowEnemyResponse( bShow );
}
function ShowState( bool bShow )
{
	if ( ActorDisplay!=None )
		ActorDisplay.ShowState( bShow );
}
function ShowEnemy( bool bShow )
{
	if ( ActorDisplay!=None )
		ActorDisplay.ShowEnemy( bShow );
}
function ShowInstigator( bool bShow )
{
	if ( ActorDisplay!=None )
		ActorDisplay.ShowInstigator( bShow );
}
function ShowBase( bool bShow )
{
	if ( ActorDisplay!=None )
		ActorDisplay.ShowBase( bShow );
}
function ShowLight( bool bShow )
{
	if ( ActorDisplay!=None )
		ActorDisplay.ShowLight( bShow );
}
function ShowDist( bool bShow )
{
	if ( ActorDisplay!=None )
		ActorDisplay.ShowDist( bShow );
}
function ShowBindName( bool bShow )
{
	if ( ActorDisplay!=None )
		ActorDisplay.ShowBindName( bShow );
}
function ShowPos( bool bShow )
{
	if ( ActorDisplay!=None )
		ActorDisplay.ShowPos( bShow );
}
function ShowHealth( bool bShow )
{
	if ( ActorDisplay!=None )
		ActorDisplay.ShowHealth( bShow );
}
function ShowPhysics( bool bShow )
{
	if ( ActorDisplay!=None )
		ActorDisplay.ShowPhysics( bShow );
}
function ShowMass( bool bShow )
{
	if ( ActorDisplay!=None )
		ActorDisplay.ShowMass(bShow);
}
function ShowVelocity( bool bShow )
{
	if ( ActorDisplay!=None )
		ActorDisplay.ShowVelocity( bShow );
}
function ShowAcceleration( bool bShow )
{
	if ( ActorDisplay!=None )
		ActorDisplay.ShowAcceleration( bShow );
}

// ----------------------------------------------------------------------------
// SignalInventoryRefresh()
//
// Called when inventory item position was updated.
// ----------------------------------------------------------------------------

function SignalInventoryRefresh()
{
	local HXPersonaScreenInventory WinInv;

	WinInv = HXPersonaScreenInventory(GetTopWindow());
	if ( WinInv!=None )
		WinInv.SignalRefresh();
}

// ----------------------------------------------------------------------------
// AddAugmentationDisplay()
// ----------------------------------------------------------------------------

function AddAugmentationDisplay( Augmentation Aug )
{
	HUD.ActiveItems.AddIcon(aug.SmallIcon, aug);
}

// ----------------------------------------------------------------------------
// RemoveAugmentationDisplay()
// ----------------------------------------------------------------------------

function RemoveAugmentationDisplay( Augmentation Aug )
{
	HUD.ActiveItems.RemoveIcon( Aug );
}

// ----------------------------------------------------------------------------
// ClearAugmentationDisplay()
// ----------------------------------------------------------------------------

function ClearAugmentationDisplay()
{
	HUD.ActiveItems.ClearAugmentationDisplay();
}

// ----------------------------------------------------------------------------
// UpdateAugmentationDisplayStatus()
// ----------------------------------------------------------------------------

function UpdateAugmentationDisplayStatus( Augmentation Aug )
{
	HUD.ActiveItems.UpdateAugIconStatus( Aug );
}

// ----------------------------------------------------------------------------
// AddChargedDisplay()
// ----------------------------------------------------------------------------

function AddChargedDisplay( HXChargedPickup Item )
{
	HUD.ActiveItems.AddIcon( Item.ChargedIcon, Item );
}

// ----------------------------------------------------------------------------
// RemoveChargedDisplay()
// ----------------------------------------------------------------------------

function RemoveChargedDisplay( HXChargedPickup Item )
{
	HUD.ActiveItems.RemoveIcon( Item );
}

// ----------------------------------------------------------------------------
// PlayLogSound()
// ----------------------------------------------------------------------------

function PlayLogSound( Sound NewLogSound )
{
	HUD.MsgLog.PlayLogSound( NewLogSound );
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	HUDClass=HXDeusExCoopHUD
	//HUDClass=HXDeusExHUD
	//HUDClass=HXDXMPHUD
	MaxWinStack=6
	ColSnapshot=(R=128,G=128,B=128)
	SnapshotWidth=256.0
	SnapshotHeight=192.0
	DataVaultFunctions(0)=(Function="ShowInventoryWindow",WinClass=Class'HX.HXPersonaScreenInventory')
	DataVaultFunctions(1)=(Function="ShowHealthWindow",WinClass=Class'HX.HXPersonaScreenHealth')
	DataVaultFunctions(2)=(Function="ShowAugmentationsWindow",WinClass=Class'HX.HXPersonaScreenAugmentations')
	DataVaultFunctions(3)=(Function="ShowSkillsWindow",WinClass=Class'HX.HXPersonaScreenSkills')
	DataVaultFunctions(4)=(Function="ShowGoalsWindow",WinClass=Class'HX.HXPersonaScreenGoals')
	DataVaultFunctions(5)=(Function="ShowConversationsWindow",WinClass=Class'HX.HXPersonaScreenConversations')
	DataVaultFunctions(6)=(Function="ShowImagesWindow",WinClass=Class'HX.HXPersonaScreenImages')
	DataVaultFunctions(7)=(Function="ShowLogsWindow",WinClass=Class'HX.HXPersonaScreenLogs')
	ShowInventoryWindowClass=Class'HX.HXPersonaScreenInventory'
	ShowHealthWindowClass=Class'HX.HXPersonaScreenHealth'
	ShowAugmentationsWindowClass=Class'HX.HXPersonaScreenAugmentations'
	ShowSkillsWindowClass=Class'HX.HXPersonaScreenSkills'
	ShowGoalsWindowClass=Class'HX.HXPersonaScreenGoals'
	ShowConversationsWindowClass=Class'HX.HXPersonaScreenConversations'
	ShowImagesWindowClass=Class'HX.HXPersonaScreenImages'
	ShowLogsWindowClass=Class'HX.HXPersonaScreenLogs'
	ShowAugmentationAddWindowClass=Class'HX.HXPersonaScreenAugmentationsMedBot'
	QuickLoadTitle="Quick Load?"
	QuickLoadMessage="You will lose your current game in progress, are you sure you wish to Quick Load?"
}
