//=============================================================================
// HXSatelliteDish.
//=============================================================================
class HXSatelliteDish extends HXOutdoorThings;

#exec OBJ LOAD FILE=MoverSFX

var() bool bRandomRotation;
var float time;
var Rotator origRot;

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local SatelliteDish OtherSatelliteDish;

	// Call Super.
	Super.Succeeds( Other );

	// Special SatelliteDish Init.
	OtherSatelliteDish = SatelliteDish(Other);
	if ( OtherSatelliteDish!=None )
	{
		bRandomRotation = OtherSatelliteDish.bRandomRotation;
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

function Tick(float deltaTime)
{
	local int newYaw;

	time += deltaTime;

	// if we're done rotating, stop the ambient sound
	if (Rotation.Yaw ~= DesiredRotation.Yaw)
		AmbientSound = None;
	else
		AmbientSound = sound'LargeElevMove';

	// check for rotation every 10 seconds
	if (bRandomRotation)
	{
		if (time > 10.0)
		{
			if (FRand() < 0.15)
			{
				// how far should we turn?
				newYaw = 4096 - Rand(8192);
				DesiredRotation.Yaw = origRot.Yaw + newYaw;
				if (DesiredRotation.Yaw < 0)
					DesiredRotation.Yaw += 65536;
				DesiredRotation.Yaw = DesiredRotation.Yaw % 65536;

				// play a cool startup sound
				PlaySound(sound'LargeElevStart', SLOT_Misc,,, 1024);
			}
			time = 0;
		}
	}

	Super.Tick(deltaTime);
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

function BeginPlay()
{
	Super.BeginPlay();

	origRot = Rotation;
	DesiredRotation = Rotation;

	//if (Level.Netmode != NM_Standalone)
		//bRandomRotation=False;
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	bSpecialDesired=True
	RemoteRole=ROLE_SimulatedProxy
	ItemName="Satellite Dish"
	bRandomRotation=True
	Physics=PHYS_Rotating
	Mesh=SatelliteDish
	SoundRadius=16
	SoundVolume=192
	CollisionRadius=84.00
	//CollisionHeight=102.20
	CollisionHeight=101.45
	bRotateToDesired=True
	Mass=5000.0
	Buoyancy=5.0
	RotationRate=(Yaw=1024)
}
