//=============================================================================
// HXScopeView.
//=============================================================================
class HXScopeView expands DeusExScopeView;

//#exec TEXTURE IMPORT FILE="Textures\HUD\HXHUDScopeView.pcx"			NAME="HXHUDScopeView"				GROUP="UserInterface" MIPS=Off
//#exec TEXTURE IMPORT FILE="Textures\HUD\HXHUDScopeViewBars.pcx"			NAME="HXHUDScopeViewBars"				GROUP="UserInterface" MIPS=Off

/*
var bool bActive;		// is this view actually active?
var DeusExPlayer player;
var Color colLines;
var Bool  bBinocs;
var Bool  bViewVisible;
var int   desiredFOV;
*/

const ReferenceHeight = 300;

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window
// ----------------------------------------------------------------------

event InitWindow()
{
	Super(Window).InitWindow();
	
	// Get a pointer to the player
	player = DeusExPlayer(GetRootWindow().parentPawn);

	bTickEnabled = true;

	StyleChanged();
}

// ----------------------------------------------------------------------
// Tick()
// ----------------------------------------------------------------------

event Tick(float deltaSeconds)
{
	local Crosshair        cross;
	local HXRootWindow dxRoot;

	dxRoot = HXRootWindow(GetRootWindow());
	if ( dxRoot != None )
	{
		cross = dxRoot.hud.cross;

		if (bActive)
			cross.SetCrosshair( False );
		else
			cross.SetCrosshair( player.bCrosshairVisible );
	}
}

// ----------------------------------------------------------------------
// ActivateView()
// ----------------------------------------------------------------------

function ActivateView(int newFOV, bool bNewBinocs, bool bInstant)
{
	desiredFOV = newFOV;

	bBinocs = bNewBinocs;

	if ( player != None )
	{
		if ( bInstant )
			player.SetFOVAngle(desiredFOV);
		else
			player.desiredFOV = desiredFOV;

		bViewVisible = True;
		Show();
	}
}

// ----------------------------------------------------------------------
// DeactivateView()
// ----------------------------------------------------------------------

function DeactivateView()
{
	if (player != None)
	{
		Player.DesiredFOV = Player.Default.DefaultFOV;
		bViewVisible = False;
		Hide();
	}
}

// ----------------------------------------------------------------------
// HideView()
// ----------------------------------------------------------------------

function HideView()
{
	if (bViewVisible)
	{
		Hide();
		Player.SetFOVAngle(Player.Default.DefaultFOV);
	}
}

// ----------------------------------------------------------------------
// ShowView()
// ----------------------------------------------------------------------

function ShowView()
{
	if (bViewVisible)
	{
		Player.SetFOVAngle(desiredFOV);
		Show();
	}
}

// ----------------------------------------------------------------------
// DrawWindow()
// ----------------------------------------------------------------------

event DrawWindow(GC gc)
{
	local float FromX, ToX;
	local float FromY, ToY;
	local float ScopeWidth, ScopeHeight;
	local float ScopeScale;
	local float ScaledFromX, ScaledToX;
	local float ScaledFromY, ScaledToY;
	local float ScaledScopeWidth, ScaledScopeHeight;
	local Texture TempTexture;

	Super(Window).DrawWindow(gc);

	if ( GetRootWindow().parentPawn != None && player.IsInState('Dying') )
		return;

	// Figure out where to put everything
	if ( bBinocs )
		ScopeWidth  = 512;
	else
		ScopeWidth  = 256;

	ScopeHeight = 256;

	// HX_HAN
	// Figure out scale ( Use ReferenceHeight as base height ),
	// but don't draw it smaller on lower res.
	ScopeScale = Height / ReferenceHeight;
	if ( ScopeScale < 1.0 )
		ScopeScale = 1.0;
	else if ( Width < ScopeScale*ScopeWidth || Height < ScopeScale*ScopeHeight )
 		ScopeScale = Min( ScopeScale, Min( Width/ScopeWidth, Height/ScopeHeight ) );

	ScaledScopeWidth  = ScopeScale*(ScopeWidth +0.75);
	ScaledScopeHeight = ScopeScale*(ScopeHeight+0.75);

	ScaledFromX = (Width-ScaledScopeWidth)/2;
	ScaledFromY = (Height-ScaledScopeHeight)/2;
	ScaledToX   = ScaledFromX + ScaledScopeWidth;
	ScaledToY   = ScaledFromY + ScaledScopeHeight;

	FromX = (Width-ScopeWidth)/2;
	FromY = (Height-ScopeHeight)/2;
	ToX   = FromX + ScopeWidth;
	ToY   = FromY + ScopeHeight;

	// Draw the black borders
	gc.SetTileColorRGB( 0, 0, 0 );
	gc.SetStyle( DSTY_Normal );
	//if ( Player.Level.NetMode == NM_Standalone )	// Only block out screen real estate in single player
	//{
		// fix strange lines
		gc.DrawPattern(0,           0,             Width+16*ScopeScale,       ScaledFromY+2,                  0, 0, Texture'Solid');
		gc.DrawPattern(0,           ScaledToY  -2, Width+16*ScopeScale,       ScaledFromY+8*ScopeScale,       0, 0, Texture'Solid');
		gc.DrawPattern(0,           ScaledFromY+2, ScaledFromX+4,            ScaledScopeHeight+4,            0, 0, Texture'Solid');
		gc.DrawPattern(ScaledToX-2, ScaledFromY-2, ScaledFromX+8*ScopeScale, ScaledScopeHeight+8*ScopeScale, 0, 0, Texture'Solid');
	//}
	// Draw the center scope bitmap
	// Use the Header Text color 

	gc.SetTileColorRGB( 0, 0, 0 );
	gc.SetStyle( DSTY_Normal );

	if ( bBinocs )
	{
		gc.SetStyle( DSTY_Modulated );
		TempTexture = Texture'HUDBinocularView_1';
		gc.DrawStretchedTexture( ScaledFromX,                    ScaledFromY, ScaledScopeWidth/2, ScaledScopeHeight, 0, 0, TempTexture.USize, TempTexture.VSize, TempTexture );
		TempTexture = Texture'HUDBinocularView_2';
		gc.DrawStretchedTexture( ScaledFromX+ScaledScopeWidth/2, ScaledFromY, ScaledScopeWidth/2, ScaledScopeHeight, 0, 0, TempTexture.USize, TempTexture.VSize, TempTexture );

		gc.SetTileColor( colLines );
		gc.SetStyle( DSTY_Masked );
		TempTexture = Texture'HUDBinocularCrosshair_1';
		gc.DrawStretchedTexture( ScaledFromX,                    ScaledFromY, ScaledScopeWidth/2, ScaledScopeHeight, 0, 0, TempTexture.USize, TempTexture.VSize, TempTexture );
		TempTexture = Texture'HUDBinocularCrosshair_2';
		gc.DrawStretchedTexture( ScaledFromX+ScaledScopeWidth/2, ScaledFromY, ScaledScopeWidth/2, ScaledScopeHeight, 0, 0, TempTexture.USize, TempTexture.VSize, TempTexture );
	}
	else
	{
		// Crosshairs - Use new scope in multiplayer, keep the old in single player
//		if ( Player.Level.NetMode == NM_Standalone )
//		{
			gc.SetStyle( DSTY_Modulated );
			TempTexture = Texture'HUDScopeView';
			gc.DrawStretchedTexture( ScaledFromX, ScaledFromY, ScaledScopeWidth, ScaledScopeHeight, 0, 0, TempTexture.USize, TempTexture.VSize, TempTexture );
			gc.SetTileColor( colLines );
			gc.SetStyle( DSTY_Masked );
			//gc.DrawTexture( FromX, FromY, ScopeWidth, ScopeHeight, 0, 0, Texture'HUDScopeCrosshair' );
			TempTexture = Texture'HUDScopeCrosshair';
			gc.DrawStretchedTexture( FromX, FromY, ScopeWidth, ScopeHeight, 0, 0, TempTexture.USize, TempTexture.VSize, TempTexture );
//		}
//		else
//		{
//			if ( WeaponRifle(Player.inHand) != None )
//			{
//				gc.SetStyle(DSTY_Modulated);
//				gc.DrawTexture( FromX, FromY, ScopeWidth, ScopeHeight, 0, 0, Texture'HUDScopeView3' );
//			}
//			else
//			{
//				gc.SetStyle(DSTY_Modulated);
//				gc.DrawTexture( FromX, FromY, ScopeWidth, ScopeHeight, 0, 0, Texture'HUDScopeView2' );
//			}
//		}
	}
}

// ----------------------------------------------------------------------
// StyleChanged()
// ----------------------------------------------------------------------

event StyleChanged()
{
	local ColorTheme theme;
	theme = player.ThemeManager.GetCurrentHUDColorTheme();
	colLines = theme.GetColorFromName( 'HUDColor_HeaderText' );
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
}
