//=============================================================================
// HXScubaDiver.
//=============================================================================
class HXScubaDiver extends HXHumanCivilian;

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local ScubaDiver OtherScubaDiver;

	// Call Super.
	Super.Succeeds( Other );

	// Special ScubaDiver Init.
	OtherScubaDiver = ScubaDiver(Other);
	if ( OtherScubaDiver!=None )
	{
		// Quirk for ScubeDiver not having the RebreatherLoop AmbientSound.
		if ( OtherScubaDiver.AmbientSound==None )
		{
			AmbientSound = Default.AmbientSound;
			SoundRadius  = Default.SoundRadius;
			SoundVolume  = Default.SoundVolume;		
		}
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	AmbientSound=RebreatherLoop
	SoundRadius=32
	SoundVolume=160
	CarcassType=ScubaDiverCarcass
	WalkingSpeed=0.296
	WalkAnimMult=0.78
	GroundSpeed=200.0
	UnderWaterTime=-1.0
	Texture=ScubasuitTex1
	Mesh=GM_Scubasuit
	MultiSkins(0)=ScubasuitTex0
	MultiSkins(1)=ScubasuitTex0
	MultiSkins(2)=ScubasuitTex1
	CollisionRadius=20.0
	//CollisionHeight=47.5
	CollisionHeight=43.0
	BindName="ScubaDiver"
	FamiliarName="Scuba Diver"
	UnfamiliarName="Scuba Diver"
	NameArticle="a "
}
