//=============================================================================
// HXSeat -- Seat class to allow NPCs to sit down.
//
// This class is not needed for Seats anymore, just set bIsSeat on for your
// Decoration. You still need to copy over the code.
//=============================================================================
class HXSeat extends HXDecoration
	abstract;

// Moved to HXDecoration.
//var() Vector SitPoint[4];
//var Actor SittingActor[4];
//var int NumSitPoints;
//var vector InitialPosition;

// ----------------------------------------------------------------------------
// BeginPlay()
// ----------------------------------------------------------------------------

simulated function BeginPlay()
{
	local int iSitPoint;

	Super.BeginPlay();

	if ( Role==ROLE_Authority && !IsInRelevant() )
	{
		// Count how many sitpoints are valid.
		NumSitPoints = 0;
		for( iSitPoint=0; iSitPoint<ArrayCount(SitPoint); iSitPoint++ )
		{
			if ( SitPoint[iSitPoint]!=Vect(-1000,-1000,-1000) )
				NumSitPoints++;
			else
				break;
		}

		InitialPosition = Location;
	}
}

// ----------------------------------------------------------------------------
// Bump()
// ----------------------------------------------------------------------------

function Bump( Actor Other )
{
	local HXScriptedPawn Sitter;
	local bool bInUse;
	local int i;

	bInUse = false;
	for ( i=0; i<ArrayCount(SittingActor); i++ )
	{
		if ( SittingActor[i]!=None )
		{
			if ( SittingActor[i]==Other || (HXScriptedPawn(SittingActor[i])!=None && HXScriptedPawn(SittingActor[i]).bSitting) )
			{
				bInUse = true;
				break;
			}
		}
	}

	// If we're in use, ignore bump (no pushing).
	if ( !bInUse )
		Super.Bump( Other );
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	bIsSeat=True
	FragType=WoodFragment
	SitPoint(0)=(X=-1000.0,Y=-1000.0,Z=-1000.0)
	SitPoint(1)=(X=-1000.0,Y=-1000.0,Z=-1000.0)
	SitPoint(2)=(X=-1000.0,Y=-1000.0,Z=-1000.0)
	SitPoint(3)=(X=-1000.0,Y=-1000.0,Z=-1000.0)
	bCanBeBase=True
	bFlammable=True
}
