//=============================================================================
// HXSecurityBot2.
//=============================================================================
class HXSecurityBot2 extends HXRobot;

var localized String PerforatedBy;

enum ESkinColor
{
	SC_UNATCO,
	SC_Chinese
};

var() ESkinColor SkinColor;

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local SecurityBot2 OtherSecurityBot2;

	// Call Super.
	Super.Succeeds( Other );

	// Special SecurityBot2 Init.
	OtherSecurityBot2 = SecurityBot2(Other);
	if ( OtherSecurityBot2!=None )
	{
		SetPropertyText( "SkinColor", OtherSecurityBot2.GetPropertyText("SkinColor") );
	}
}

// ----------------------------------------------------------------------------
// BeginPlay()
// ----------------------------------------------------------------------------

simulated function BeginPlay()
{
	Super.BeginPlay();

	if ( Role==ROLE_Authority && !IsInRelevant() )
	{
		switch ( SkinColor )
		{
			case SC_UNATCO:  MultiSkins[1] = Texture'SecurityBot2Tex1'; break;
			case SC_Chinese: MultiSkins[1] = Texture'SecurityBot2Tex2'; break;
		}
	}
}

// ----------------------------------------------------------------------------
// PlayDisabled()
// ----------------------------------------------------------------------------

function PlayDisabled()
{
	switch ( Rand(3) )
	{
		case 0:  TweenAnimPivot( 'Disabled1', 0.2 ); break;
		case 1:  TweenAnimPivot( 'Disabled2', 0.2 ); break;
		default: TweenAnimPivot( 'Still',     0.2 ); break;
	}
}

// ----------------------------------------------------------------------------
// KillMessage()
// ----------------------------------------------------------------------------

function string KillMessage( Name DamageType, Pawn Other )
{
	return PerforatedBy $ NameArticle $ UnfamiliarName $ ".";
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	PerforatedBy=" was perforated by "
	SearchingSound=SecurityBot2Searching
	SpeechTargetAcquired=SecurityBot2TargetAcquired
	SpeechTargetLost=SecurityBot2TargetLost
	SpeechOutOfAmmo=SecurityBot2OutOfAmmo
	SpeechCriticalDamage=SecurityBot2CriticalDamage
	SpeechScanning=SecurityBot2Scanning
	EMPHitPoints=100
	ExplosionSound=SecurityBot2Explode
	WalkingSpeed=1.000000
	bEmitDistress=True
	InitialInventory(0)=(Inventory=Class'WeaponRobotMachinegun')
	InitialInventory(1)=(Inventory=Class'Ammo762mm',Count=50)
	WalkSound=SecurityBot2Walk'
	GroundSpeed=95.0
	WaterSpeed=50.0
	AirSpeed=144.0
	AccelRate=500.0
	Health=250
	UnderWaterTime=20.0
	AttitudeToPlayer=ATTITUDE_Ignore
	DrawType=DT_Mesh
	Mesh=SecurityBot2
	MultiSkins(1)=SecurityBot2Tex1
	CollisionRadius=62.00
	//CollisionHeight=58.28
	CollisionHeight=53.78
	Mass=800.0
	Buoyancy=100.0
	BindName="SecurityBot2"
	FamiliarName="Security Bot"
	UnfamiliarName="Security Bot"
}
