//=============================================================================
// HXSecurityBot3.
//=============================================================================
class HXSecurityBot3 extends HXRobot;

var localized String PerforatedBy;

enum ESkinColor
{
	SC_UNATCO,
	SC_Chinese
};

var() ESkinColor SkinColor;

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local SecurityBot3 OtherSecurityBot3;

	// Call Super.
	Super.Succeeds( Other );

	// Special SecurityBot3 Init.
	OtherSecurityBot3 = SecurityBot3(Other);
	if ( OtherSecurityBot3!=None )
	{
		SetPropertyText( "SkinColor", OtherSecurityBot3.GetPropertyText("SkinColor") );
	}
}

// ----------------------------------------------------------------------------
// BeginPlay()
// ----------------------------------------------------------------------------

simulated function BeginPlay()
{
	Super.BeginPlay();

	if ( Role==ROLE_Authority && !IsInRelevant() )
	{
		switch ( SkinColor )
		{
			case SC_UNATCO:  Skin = Texture'SecurityBot3Tex1'; break;
			case SC_Chinese: Skin = Texture'SecurityBot3Tex2'; break;
		}
	}
}

// ----------------------------------------------------------------------------
// KillMessage()
// ----------------------------------------------------------------------------

function string KillMessage( Name DamageType, Pawn Other )
{
	return PerforatedBy $ NameArticle $ UnfamiliarName $ ".";
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	PerforatedBy=" was perforated by "
	SpeechTargetAcquired=SecurityBot3TargetAcquired
	SpeechTargetLost=SecurityBot3TargetLost
	SpeechOutOfAmmo=SecurityBot3OutOfAmmo
	SpeechCriticalDamage=SecurityBot3CriticalDamage
	SpeechScanning=SecurityBot3Scanning
	EMPHitPoints=40
	WalkingSpeed=1.0
	bEmitDistress=True
	InitialInventory(0)=(Inventory=Class'WeaponRobotMachinegun')
	InitialInventory(1)=(Inventory=Class'Ammo762mm',Count=50)
	GroundSpeed=95.0
	WaterSpeed=50.0
	AirSpeed=144.0
	AccelRate=500.0
	Health=150
	UnderWaterTime=20.0
	AttitudeToPlayer=ATTITUDE_Ignore
	DrawType=DT_Mesh
	Mesh=SecurityBot3
	Skin=SecurityBot3Tex1
	SoundRadius=16
	SoundVolume=128
	AmbientSound=SecurityBot3Move
	CollisionRadius=25.35
	//CollisionHeight=28.50
	CollisionHeight=24.00
	Mass=1000.0
	Buoyancy=100.0
	BindName="SecurityBot3"
	FamiliarName="Security Bot"
	UnfamiliarName="Security Bot"
}
