//=============================================================================
// HXSenseTrigger.
//=============================================================================
class HXSenseTrigger extends HXTrigger;

var() Class<Inventory> KeyNeeded;
var() Name FailedEvent;

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local SenseTrigger OtherSenseTrigger;

	// Call Super.
	Super.Succeeds( Other );

	// Special SenseTrigger Init.
	OtherSenseTrigger = SenseTrigger(Other);
	if ( OtherSenseTrigger!=None )
	{
		KeyNeeded   = OtherSenseTrigger.KeyNeeded;
		FailedEvent = OtherSenseTrigger.FailedEvent;

		// Can't remember why I started logged this. --han
		//Log( Self $ ".KeyNeeded is " $ KeyNeeded );
	}
}

// ----------------------------------------------------------------------------
// Touch()
// ----------------------------------------------------------------------------

singular function Touch( Actor Other )
{
	local bool bDoIt;
	local Pawn P;
	local Inventory inv;
	local Actor A;

	// Should we even pay attention to this actor?
	if ( !IsRelevant(Other) )
		return;

	P = Pawn(Other);
	if ( P==None )
		return;

	bDoIt = false;
	for ( Inv=P.Inventory; Inv!=None; Inv=Inv.Inventory )
		if ( KeyNeeded==Inv.Class )
			bDoIt = true;

	if ( bDoIt )
	{
		Super.Touch( Other );
	}
	else if ( FailedEvent!='' )
	{
		foreach AllActors( class'Actor', A, FailedEvent )
			A.Trigger( Other, Other.Instigator );
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	ReTriggerDelay=1.0
}
