//=============================================================================
// HXSequenceTrigger
//
// Triggers a MultiMover to go to a certain set of keyframes.
// Also can trigger an ElevatorMover to go to a certain keyframe.
// Defaults to being triggered (zero radius).
// Set a radius and bCollideActors to make it touchable.
//=============================================================================
class HXSequenceTrigger extends HXTrigger;

var() int SeqNum;

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local SequenceTrigger OtherSequenceTrigger;

	// Call Super.
	Super.Succeeds( Other );

	// Special SequenceTrigger Init.
	OtherSequenceTrigger = SequenceTrigger(Other);
	if ( OtherSequenceTrigger!=None )
	{
		SeqNum = OtherSequenceTrigger.SeqNum;
	}
}

// ----------------------------------------------------------------------------
// Trigger()
// ----------------------------------------------------------------------------

function Trigger( Actor Other, Pawn Instigator )
{
	CheckMovers();

	Super.Trigger( Other, Instigator );
}

// ----------------------------------------------------------------------------
// Touch()
// ----------------------------------------------------------------------------

function Touch( Actor Other )
{
	CheckMovers();

	Super.Touch( Other );
}

// ----------------------------------------------------------------------------
// CheckMovers()
// ----------------------------------------------------------------------------

function CheckMovers()
{
	local Mover M;

	if ( Event=='' )
		return;

	foreach AllActors( class'Mover', M, Event )
	{
		if ( M.IsA('MultiMover') )
			MultiMover(M).SetSeq( SeqNum );
		else if ( M.IsA('ElevatorMover') )
			ElevatorMover(M).SetSeq( SeqNum );
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	CollisionRadius=0.0
	bCollideActors=False
}
