//=============================================================================
// HXServerList
//		Stores a server entry in a DeusEx Server List
//=============================================================================
class HXServerList extends UWindowList;

// Valid for sentinel only
var	HXMenuScreenJoinGame	Owner;
var int					TotalServers;
var int					TotalPlayers;
var int					TotalMaxPlayers;
var bool				bNeedUpdateCount;

// Config
var config int			MaxSimultaneousPing;

// Master server variables
var string				IP;
var int					QueryPort;
var string				Category;		// Master server categorization
var string				GameName;		// Unreal, Unreal Tournament

// State of the ping
var HXServerPing	ServerPing;
var bool				bPinging;
var bool				bPingFailed;
var bool				bPinged;
var bool				bNoInitalPing;
var bool				bOldServer;

// Rules and Lists
var UBrowserRulesList	RulesList;
var UBrowserPlayerList  PlayerList;
var bool				bKeepDescription;	// don't overwrite HostName
var int					PlayerListSortColumn;

// Unreal server variables
var bool				bLocalServer;
var float				Ping;
var string				HostName;
var int					GamePort;
var string				MapName;
var string				MapTitle;
var string				MapDisplayName;
var string				GameType;
var string				GameMode;
var int					NumPlayers;
var int					MaxPlayers;
var int					GameVer;
var int					MinNetVer;

function DestroyListItem() 
{
	Owner = None;

	if(ServerPing != None)
	{
		ServerPing.Destroy();
		ServerPing = None;
	}
	Super.DestroyListItem();
}

function QueryFinished(UBrowserServerListFactory Fact, bool bSuccess, optional string ErrorMsg)
{
   //DEUS_EX AMSD Call to owner for callback 
	Owner.ListQueryFinished(Fact, bSuccess, ErrorMsg); //*******
}

// Functions for server list entries only.
function PingServer(bool bInitial, bool bJustThisServer, bool bNoSort)
{
	// Create the UdpLink to ping the server
	ServerPing = GetPlayerOwner().GetEntryLevel().Spawn(class'HXServerPing');
	ServerPing.Server = Self;
	ServerPing.StartQuery('GetInfo', 2);
	ServerPing.bInitial = bInitial;
	ServerPing.bJustThisServer = bJustThisServer;
	ServerPing.bNoSort = bNoSort;
	bPinging = True;
}

function ServerStatus()
{
	// Create the UdpLink to ping the server
	ServerPing = GetPlayerOwner().GetEntryLevel().Spawn(class'HXServerPing');
	ServerPing.Server = Self;
	ServerPing.StartQuery('GetStatus', 2);
	bPinging = True;
}

function StatusDone(bool bSuccess)
{
	// Destroy the UdpLink
	ServerPing.Destroy();
	ServerPing = None;

	bPinging = False;

	RulesList.Sort();
	PlayerList.Sort();
   HXServerList(Sentinel).Owner.PingStatusDone(Self);
}

function CancelPing()
{
	if(bPinging && ServerPing != None && ServerPing.bJustThisServer)
		PingDone(False, True, False, True);
}

function PingDone(bool bInitial, bool bJustThisServer, bool bSuccess, bool bNoSort)
{
	local HXMenuScreenJoinGame W;
	local HXServerList OldSentinel;

	// Destroy the UdpLink
	if(ServerPing != None)
		ServerPing.Destroy();
	
	ServerPing = None;

	bPinging = False;
	bPingFailed = !bSuccess;
	bPinged = True;

	OldSentinel = HXServerList(Sentinel);
	if(!bNoSort)
	{
		Remove();

		// Move to the ping list
		if(!bPingFailed || (OldSentinel != None && OldSentinel.Owner != None && OldSentinel.Owner.bShowFailedServers))
		{
			if(OldSentinel.Owner.PingedList != None)
				OldSentinel.Owner.PingedList.AppendItem(Self);
		}
	}
	else
	{
		if(OldSentinel != None && OldSentinel.Owner != None && OldSentinel != OldSentinel.Owner.PingedList)
			Log("Unsorted PingDone lost as it's not in ping list!");
	}

	if(Sentinel != None)
	{
		HXServerList(Sentinel).bNeedUpdateCount = True;

//		if(bInitial)
			//ConsiderForSubsets();
	}

	if(!bJustThisServer)
		if(OldSentinel != None)
		{
			W = OldSentinel.Owner;

			if(W.bPingSuspend)
			{
				W.bPingResume = True;
				W.bPingResumeInitial = bInitial;
			}
			else
				OldSentinel.PingNext(bInitial, bNoSort);
		}

   OldSentinel.Owner.ListPingDone(self);
}

//***************

// Functions for sentinel only

function InvalidatePings()
{
	local HXServerList l;

	for(l = HXServerList(Next);l != None;l = HXServerList(l.Next)) 
		l.Ping = 9999;
}

function PingServers(bool bInitial, bool bNoSort)
{
	local HXServerList l;
	
	bPinging = False;

	for(l = HXServerList(Next);l != None;l = HXServerList(l.Next)) 
	{
		l.bPinging = False;
		l.bPingFailed = False;
		l.bPinged = False;
	}

	PingNext(bInitial, bNoSort);
}

function PingNext(bool bInitial, bool bNoSort)
{
	local int TotalPinging;
	local HXServerList l;
	local bool bDone;
	
	TotalPinging = 0;
	
	bDone = True;
	for(l = HXServerList(Next);l != None;l = HXServerList(l.Next)) 
	{
		if(!l.bPinged)
			bDone = False;
		if(l.bPinging)
			TotalPinging ++;
	}
	
	if(bDone && Owner != None)
	{
		bPinging = False;
		Owner.PingFinished();
	}
	else
	if(TotalPinging < MaxSimultaneousPing)
	{
		for(l = HXServerList(Next);l != None;l = HXServerList(l.Next))
		{
			if(		!l.bPinging 
				&&	!l.bPinged 
				&&	(!bInitial || !l.bNoInitalPing)
				&&	TotalPinging < MaxSimultaneousPing
			)
			{
				TotalPinging ++;		
				l.PingServer(bInitial, False, bNoSort);
			}

			if(TotalPinging >= MaxSimultaneousPing)
				break;
		}
	}
}

function HXServerList FindExistingServer(string FindIP, int FindQueryPort)
{
	local UWindowList l;

	for(l = Next;l != None;l = l.Next)
	{
		if(HXServerList(l).IP == FindIP && HXServerList(l).QueryPort == FindQueryPort)
			return HXServerList(l);
	}
	return None;
}

function PlayerPawn GetPlayerOwner()
{
	return HXServerList(Sentinel).Owner.GetPlayerPawn();
}

function UWindowList CopyExistingListItem(Class<UWindowList> ItemClass, UWindowList SourceItem)
{
	local HXServerList L;

	L = HXServerList(Super.CopyExistingListItem(ItemClass, SourceItem));

	L.bLocalServer	= HXServerList(SourceItem).bLocalServer;
	L.IP			= HXServerList(SourceItem).IP;
	L.QueryPort		= HXServerList(SourceItem).QueryPort;
	L.Ping			= HXServerList(SourceItem).Ping;
	L.HostName		= HXServerList(SourceItem).HostName;
	L.GamePort		= HXServerList(SourceItem).GamePort;
	L.MapName		= HXServerList(SourceItem).MapName;
	L.MapTitle		= HXServerList(SourceItem).MapTitle;
	L.MapDisplayName= HXServerList(SourceItem).MapDisplayName;
	L.MapName		= HXServerList(SourceItem).MapName;
	L.GameType		= HXServerList(SourceItem).GameType;
	L.GameMode		= HXServerList(SourceItem).GameMode;
	L.NumPlayers	= HXServerList(SourceItem).NumPlayers;
	L.MaxPlayers	= HXServerList(SourceItem).MaxPlayers;
	L.GameVer		= HXServerList(SourceItem).GameVer;
	L.MinNetVer		= HXServerList(SourceItem).MinNetVer;
	L.bKeepDescription = HXServerList(SourceItem).bKeepDescription;

	return L;
}

function int Compare(UWindowList T, UWindowList B)
{
   return 0; 
	//CompareCount++; //*********
	//return HXServerList(Sentinel).Owner.Grid.Compare(HXServerList(T), HXServerList(B));
}

function AppendItem(UWindowList L)
{
	Super.AppendItem(L);
	HXServerList(Sentinel).bNeedUpdateCount = True;
}

function Remove()
{
	local HXServerList S;

	S = HXServerList(Sentinel);
	Super.Remove();

	if(S != None)
		S.bNeedUpdateCount = True;
}

// Sentinel only
// FIXME: slow when lots of servers!!
function UpdateServerCount()
{
	local HXServerList l;

	TotalServers = 0;
	TotalPlayers = 0;
	TotalMaxPlayers = 0;

	for(l = HXServerList(Next);l != None;l = HXServerList(l.Next))
	{
		TotalServers++;
		TotalPlayers += l.NumPlayers;
		TotalMaxPlayers += l.MaxPlayers;
	}
}

function bool DecodeServerProperties(string Data)
{
	return True;
}

defaultproperties
{
	MaxSimultaneousPing=10
	PlayerListSortColumn=1
}
