//=============================================================================
// HXShakeTrigger.
//
// Shakes the screen when touched or triggered.
// Set bCollideActors to False to make it triggered.
//
// NOTES:
//  !! Should be revised for multiple players !!
//=============================================================================
class HXShakeTrigger extends HXTrigger;

var() float ShakeTime;
var() float ShakeRollMagnitude;
var() float ShakeVertMagnitude;

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local ShakeTrigger OtherShakeTrigger;

	// Call Super.
	Super.Succeeds( Other );

	// Special ShakeTrigger Init.
	OtherShakeTrigger = ShakeTrigger(Other);
	if ( OtherShakeTrigger!=None )
	{
		ShakeTime          = OtherShakeTrigger.ShakeTime;
		ShakeRollMagnitude = OtherShakeTrigger.ShakeRollMagnitude;
		ShakeVertMagnitude = OtherShakeTrigger.ShakeVertMagnitude;
	}
}

// ----------------------------------------------------------------------------
// Trigger()
// ----------------------------------------------------------------------------

function Trigger( Actor Other, Pawn Instigator )
{
	Instigator.ShakeView( ShakeTime, ShakeRollMagnitude, ShakeVertMagnitude );

	Super.Trigger( Other, Instigator );
}

// ----------------------------------------------------------------------------
// Touch()
// ----------------------------------------------------------------------------

function Touch( Actor Other )
{
	local HXPlayerPawn Player;

	if ( IsRelevant(Other) )
	{
		Player = HXPlayerPawn(Other);
		if ( Player!=None )
			Player.ShakeView( ShakeTime, ShakeRollMagnitude, ShakeVertMagnitude );

		Super.Touch( Other );
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	Shaketime=1.0
	ShakeRollMagnitude=1024.0
	ShakeVertMagnitude=16.0
}
