//=============================================================================
// HXShowerFaucet.
//
// TODO:
//  * Make it extinguish fire on players/other deco if they are under it.
//=============================================================================
class HXShowerFaucet extends HXDecoration;

var() bool				bOpen;
var bool					bHeadValid;
var ParticleGenerator	WaterGen[4];
var Vector				SprayOffsets[4];

var float	HeadLocX, HeadLocY, HeadLocZ;
var int		HeadPitch, HeadYaw, HeadRoll;
var float HeadColRadius, HeadColHeight;

// ----------------------------------------------------------------------------
// Network replication.
// ----------------------------------------------------------------------------

replication
{
  // Server to client.
  reliable if (Role == ROLE_Authority)
		HeadLocX, HeadLocY, HeadLocZ, HeadPitch, HeadYaw, HeadRoll,
		HeadColRadius, HeadColHeight, bOpen, bHeadValid;
}

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local ShowerFaucet OtherShowerFaucet;

	// Call Super.
	Super.Succeeds( Other );

	// Special ShowerFaucet Init.
	OtherShowerFaucet = ShowerFaucet(Other);
	if ( OtherShowerFaucet!=None )
	{
		bOpen = OtherShowerFaucet.bOpen;
	}
}

// ----------------------------------------------------------------------------
// Destroyed()
// ----------------------------------------------------------------------------

simulated function Destroyed()
{
	local int i;

	for ( i=0; i<4; i++ )
		if ( WaterGen[i] != None)
			WaterGen[i].DelayedDestroy();

	Super.Destroyed();
}

// ----------------------------------------------------------------------------
// Tick()
// ----------------------------------------------------------------------------

simulated function Tick( float DeltaTime )
{
	local int i;

	Super.Tick( DeltaTime );

	for ( i=0; i<4; i++ )
		if ( WaterGen[i]!=None && bOpen!=WaterGen[i].bSpewing )
			WaterGen[i].Trigger( None, None );
}

// ----------------------------------------------------------------------------
// Frob()
// ----------------------------------------------------------------------------

function Frob( Actor Frobber, Inventory FrobWith )
{
	local int i;

	Super.Frob( Frobber, FrobWith );

	bOpen = !bOpen;

	if ( bOpen )
	{
		PlaySound( Sound'ValveOpen',,,, 256, 2.0 );
		PlayAnim( 'On' );

		// Extinguish the player if he frobbed this.
		if ( HXPlayerPawn(Frobber)!=None && HXPlayerPawn(Frobber).bOnFire )
			HXPlayerPawn(Frobber).ExtinguishFire();
	}
	else
	{
		PlaySound( Sound'ValveClose',,,, 256, 2.0 );
		PlayAnim( 'Off' );
	}

	// Alert AI.
	Instigator = Pawn(Frobber);
	AISendEvent( 'LoudNoise', EAITYPE_Audio,, 384 );
}

// ----------------------------------------------------------------------------
// PostBeginPlay()
// ----------------------------------------------------------------------------

simulated function PostBeginPlay()
{
	local HXShowerHead Head;

	Super.PostBeginPlay();

	if ( Role==ROLE_Authority )
	{
		// Find the matching shower head
		if ( Tag!='' )
		{
			foreach AllActors( class'HXShowerHead', Head, Tag )
			{
				// We can't assume that the Head is value, but we also
				// want to have the Location and especially Rotation
				// in a higher resolution for a better matching effect
				// in network.
				HeadLocX			= Head.Location.X;
				HeadLocY			= Head.Location.Y;
				HeadLocZ			= Head.Location.Z;
				HeadPitch			= Head.Rotation.Pitch;
				HeadYaw				= Head.Rotation.Yaw;
				HeadRoll			= Head.Rotation.Roll;		
				HeadColRadius	= Head.CollisionRadius;
				HeadColHeight	= Head.CollisionHeight;
				bHeadValid		= True;
				SpawnGenerator();
				break;
			}
		}

		// Play the correct startup animation.
		if ( bOpen )
		{
			PlayAnim( 'On', 10.0, 0.001 );
		}
		else
		{
			PlayAnim( 'Off', 10.0, 0.001 );
		}
	}
}

// ----------------------------------------------------------------------------
// PostNetBeginPlay()
// ----------------------------------------------------------------------------

simulated function PostNetBeginPlay()
{
	local Vector Loc;

	Super.PostNetBeginPlay();

	if ( bHeadValid )
		SpawnGenerator();
	else
		Log( Self @ ".bHeadValid = False" );
}

// ----------------------------------------------------------------------------
// SpawnGenerator()
// ----------------------------------------------------------------------------

simulated function SpawnGenerator()
{
	local Vector Loc;
	local int i;
	local Vector HeadLocation;
	local Rotator HeadRotation;

	HeadLocation.X = HeadLocX;
	HeadLocation.Y = HeadLocY;
	HeadLocation.Z = HeadLocZ;

	HeadRotation.Pitch	= HeadPitch;
	HeadRotation.Yaw		= HeadYaw;
	HeadRotation.Roll		= HeadRoll;

	// Spawn a particle generator.
	for ( i=0; i<4; i++ )
	{
		if ( WaterGen[i]==None )
		{
			// rotate the spray offsets into object coordinate space
			Loc    = SprayOffsets[i];
			Loc.X += HeadColRadius * 0.7;
			Loc.Z -= HeadColHeight * 0.85;
			Loc    = Loc >> HeadRotation;
			Loc   += HeadLocation;

			WaterGen[i] = Spawn( Class'ParticleGenerator', Self,, Loc, HeadRotation-rot(8192,0,0) );
			if ( WaterGen[i]!=None )
			{
				WaterGen[i].ParticleDrawScale = 0.05;
				WaterGen[i].CheckTime = 0.05;
				WaterGen[i].Frequency = 1.0;
				WaterGen[i].bGravity = True;
				WaterGen[i].bScale = False;
				WaterGen[i].bFade = True;
				WaterGen[i].EjectSpeed = 100.0;
				WaterGen[i].ParticleLifeSpan = 1.5;
				WaterGen[i].NumPerSpawn = 3;
				WaterGen[i].bRandomEject = True;
				WaterGen[i].ParticleTexture = Texture'Effects.Generated.WtrDrpSmall';
				WaterGen[i].bTriggered = True;
				WaterGen[i].bInitiallyOn = bOpen;
				WaterGen[i].SetBase(Self);

				// only have sound on one of them
				if (i == 0)
				{
					WaterGen[i].bAmbientSound = True;
					WaterGen[i].AmbientSound = Sound'Shower';
					WaterGen[i].SoundRadius = 16;
				}

				// Let this not bother networking
				WaterGen[i].RemoteRole = ROLE_None;
			}
		}
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	RemoteRole=ROLE_SimulatedProxy
	SprayOffsets(0)=(X=2.0,Z=2.0)
	SprayOffsets(1)=(Y=-2.0)
	SprayOffsets(2)=(X=-2.0,Z=-2.0)
	SprayOffsets(3)=(Y=2.0)
	bInvincible=True
	ItemName="Shower Faucet"
	bPushable=False
	Physics=PHYS_None
	Mesh=ShowerFaucet
	CollisionRadius=6.80
	//CollisionHeight=6.41
	CollisionHeight=5.66
	Mass=20.0
	Buoyancy=10.0
}
