//=============================================================================
// HXSkill.
//=============================================================================
class HXSkill extends Skill;

/*

var() localized string		SkillName;
var() localized string		Description;
var   Texture               SkillIcon;
var() bool					bAutomatic;
var() bool					bConversationBased;
var() int					Cost[3];
var() float					LevelValues[4];
var travel int				CurrentLevel;		// 0 is unskilled, 3 is master
*/

var const class<HXSkilledTool> hxItemNeeded;

/*
// which player am I attached to?
var DeusExPlayer Player;

// Pointer to next skill
var travel Skill next;		

// Printable skill level strings
var Localized string skillLevelStrings[4];
var localized string SkillAtMaximum;
*/

// ----------------------------------------------------------------------------
// network replication
// ----------------------------------------------------------------------------

replication
{
/*
    //variables server to client
    reliable if ((Role == ROLE_Authority) && (bNetOwner))
        CurrentLevel, next;

    //functions client to server
    reliable if (Role < ROLE_Authority)
        IncLevel, Use, DecLevel;
*/
}

// ----------------------------------------------------------------------------
// PreBeginPlay()
// ----------------------------------------------------------------------------

function PreBeginPlay();

// ----------------------------------------------------------------------------
// Use()
// ----------------------------------------------------------------------------

function bool Use()
{
	local bool bDoIt;

	bDoIt = True;

	if (hxItemNeeded != None)
	{
		bDoIt = False;

		if ((Player.inHand != None) && (Player.inHand.Class == hxItemNeeded))
		{
			HXSkilledTool(Player.inHand).PlayUseAnim();

			// alert NPCs that I'm messing with stuff
			if ( Player.FrobTarget != None )
			{
				if ( Player.FrobTarget.bOwned )
				{
					if ( Player.FrobTarget.IsA('HXMover') )
					{
						//HXMover(Player.FrobTarget).hackInstigator = Player;
					}
					else if ( Player.FrobTarget.IsA('HXHackableDevices') )
					{
						HXHackableDevices(Player.FrobTarget).hackInstigator = Player;
					}

					Player.FrobTarget.AISendEvent('MegaFutz', EAITYPE_Visual);
				}
			}

			bDoIt = True;
		}
	}

	return bDoIt;
}

// ----------------------------------------------------------------------------
// IncLevel()
// ----------------------------------------------------------------------------

function bool IncLevel(optional DeusExPlayer usePlayer)
{
	local DeusExPlayer localPlayer;

	// First make sure we're not maxed out
	if (CurrentLevel < 3)
	{
		// If "usePlayer" is passed in, then we want to use this 
		// as the basis for making our calculations, temporarily
		// overriding whatever this skill's player is set to.

		if (usePlayer != None)
			localPlayer = usePlayer;
		else
			localPlayer = Player;

		// Now, if a player is defined, then check to see if there enough
		// skill points available.  If no player is defined, just do it.
		if (localPlayer != None) 
		{
			if ((localPlayer.SkillPointsAvail >= Cost[CurrentLevel]))
			{
				// decrement the cost and increment the current skill level
				localPlayer.SkillPointsAvail -= GetCost();
				CurrentLevel++;
				return True;
			}
		}
		else
		{
			CurrentLevel++;
			return True;
		}
	}

	return False;
}

// ----------------------------------------------------------------------------
// DecLevel()
// 
// Decrements a skill level, making sure the skill isn't already at 
// the lowest skill level.  Cost of the skill is optionally added back 
// to the player's SkilPointsAvail variable. 
// ----------------------------------------------------------------------------

function bool DecLevel( optional bool bGiveUserPoints, optional DeusExPlayer usePlayer )
{
	local DeusExPlayer localPlayer;

	// First make sure we're not already at the bottom
	if (CurrentLevel > 0)
	{
		// Decrement the skill level 
		CurrentLevel--;

		// If "usePlayer" is passed in, then we want to use this 
		// as the basis for making our calculations, temporarily
		// overriding whatever this skill's player is set to.

		if (usePlayer != None)
			localPlayer = usePlayer;
		else
			localPlayer = Player;

		// If a player exists and the 'bGiveUserPoints' flag is set, 
		// then add the points to the player
		if (( bGiveUserPoints ) && (localPlayer != None))
			localPlayer.SkillPointsAvail += GetCost();

		return True;
	}

	return False;
}

// ----------------------------------------------------------------------------
// CanAffordToUpgrade()
//
// Given the points passed in, checks to see if the skill can be 
// upgraded to the next level.  Will always return False if the 
// skill is already at the maximum level.
// ----------------------------------------------------------------------------

simulated function bool CanAffordToUpgrade( int skillPointsAvailable )
{
	if ( CurrentLevel == 3 ) 
		return False;
	else if ( Cost[CurrentLevel] > skillPointsAvailable )
		return False;
	else
		return True;
}

// ----------------------------------------------------------------------------
// UpdateInfo()
// ----------------------------------------------------------------------------

simulated function bool UpdateInfo(Object winObject)
{
	local HXPersonaInfoWindow winInfo;

	winInfo = HXPersonaInfoWindow(winObject);
	if (winInfo == None)
		return False;

	winInfo.SetTitle(SkillName);
	winInfo.SetText(Description);

	return True;
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	bGameRelevant=True
}
