//=============================================================================
// HXSkillAwardTrigger.
//
// Gives the player skill points when touched or triggered.
// Unset bCollideActors to make it triggered.
//=============================================================================
class HXSkillAwardTrigger extends HXTrigger;

var() int SkillPointsAdded;
var() localized String AwardMessage;

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local SkillAwardTrigger OtherSkillAwardTrigger;

	// Call Super.
	Super.Succeeds( Other );

	// Special SkillAwardTrigger Init.
	OtherSkillAwardTrigger = SkillAwardTrigger(Other);
	if ( OtherSkillAwardTrigger!=None )
	{
		SkillPointsAdded = OtherSkillAwardTrigger.SkillPointsAdded;
		AwardMessage     = OtherSkillAwardTrigger.AwardMessage;
	}
}

// ----------------------------------------------------------------------------
// Trigger()
// ----------------------------------------------------------------------------

function Trigger( Actor Other, Pawn EventInstigator )
{
	local Name OtherName, EventInstigatorName;

	Super.Trigger( Other, EventInstigator );

	// ION code didn't award the skillpoints if Instigator wasn't a PlayerPawn.
	// I removed this requirement for HX, but for now I want to log any cases
	// where this wouldn't have triggered before.
	if ( !EventInstigator.IsA('HXPlayerPawn') )
	{
		if ( Other!=None )
			OtherName = Other.Name;
		if ( EventInstigator!=None )
			EventInstigatorName = EventInstigator.Name;

		Log( Sprintf("SkillAwardTrigger triggered with non PlayerPawn Instigator (Other=%s,EventInstigator=%s,Tag=%s,PrecessorName=%s).",OtherName,EventInstigatorName,Tag,PrecessorName) );
	}

	Game.SkillPointsAdd( SkillPointsAdded, AwardMessage );
}

// ----------------------------------------------------------------------------
// Touch()
// ----------------------------------------------------------------------------

function Touch( Actor Other )
{
	local Name OtherName;

	Super.Touch( Other );

	// Check for HXPlayerPawn irrelevant/bogus? Needed due to legacy maps?
	if ( !IsRelevant(Other) )
		return;

	// ION code didn't award the skillpoints if Other wasn't a PlayerPawn.
	// I removed this requirement for HX, but for now I want to log any cases
	// where this wouldn't have triggered before.
	if ( !Other.IsA('HXPlayerPawn') )
	{
		if ( Other!=None )
			OtherName = Other.Name;

		Log( Sprintf("SkillAwardTrigger touched with by non PlayerPawn (Other=%s,Tag=%s,PrecessorName=%s).",OtherName,Tag,PrecessorName) );
	}

	Game.SkillPointsAdd( SkillPointsAdded, AwardMessage );
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	SkillPointsAdded=10
	AwardMessage="DEFAULT SKILL AWARD MESSAGE - REPORT THIS AS A BUG"
	bTriggerOnceOnly=True
}
