//=============================================================================
// HXSkillManager
//=============================================================================
class HXSkillManager extends SkillManager;

// ----------------------------------------------------------------------
// CalculateSpendSkillPoints()
// ----------------------------------------------------------------------

function int CalculateSpentSkillPoints()
{
	local int i, Total;
	local Skill CurrentSkill;

	CurrentSkill = FirstSkill;

	while ( CurrentSkill != None )
	{
		for ( i = 0; i < CurrentSkill.CurrentLevel; i++ )
			Total += CurrentSkill.Cost[i];
		
		CurrentSkill = CurrentSkill.Next;
	}

	//Log( "Total SkillPoints spent: " $ Total );

	return Total;
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	bGameRelevant=True
	SkillClasses(0)=HX.HXSkillWeaponHeavy
	SkillClasses(1)=HX.HXSkillWeaponPistol
	SkillClasses(2)=HX.HXSkillWeaponRifle
	SkillClasses(3)=HX.HXSkillWeaponLowTech
	SkillClasses(4)=HX.HXSkillDemolition
	SkillClasses(5)=HX.HXSkillEnviro
	SkillClasses(6)=HX.HXSkillLockpicking
	SkillClasses(7)=HX.HXSkillTech
	SkillClasses(8)=HX.HXSkillMedicine
	SkillClasses(9)=HX.HXSkillComputer
	SkillClasses(10)=HXSkillSwimming
}
