//=============================================================================
// HXSphereEffect.
//=============================================================================
class HXSphereEffect extends HXEffects
	transient;

// LifeSpan is not replicated, so this is needed for the bNetTemporary pattern.
var float RemainingLifeSpan;
var float Size;

// -------------------------------------------------------------------------------
// Network replication.
// -------------------------------------------------------------------------------

replication
{
	// Server to client.
	reliable if ( Role==ROLE_Authority )
		RemainingLifeSpan, Size;
}

// ----------------------------------------------------------------------------
// PostNetBeginPlay()
// ----------------------------------------------------------------------------

simulated function PostNetBeginPlay()
{
	Super.PostNetBeginPlay();

	LifeSpan = RemainingLifeSpan;
}

// ----------------------------------------------------------------------------
// Tick()
// ----------------------------------------------------------------------------

simulated function Tick( float DeltaTime )
{
	RemainingLifeSpan = LifeSpan;

	DrawScale = 3.0 * Size * (Default.LifeSpan - LifeSpan) / Default.LifeSpan;
	ScaleGlow = 2.0 * (LifeSpan / Default.LifeSpan);
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	RemoteRole=ROLE_SimulatedProxy
	NetPriority=4.000000
	bNetTemporary=True
	Size=5.000000
	LifeSpan=0.500000
	RemainingLifeSpan=0.500000
	DrawType=DT_Mesh
	Style=STY_Translucent
	Mesh=LodMesh'DeusExItems.SphereEffect'
	bUnlit=True
}
