//=============================================================================
// HXSwitch2.
//
// Notes:
//  * Merged ION's network code out of Button1 here.
//  * Maybe send an AI event when frobbed.
//=============================================================================
class HXSwitch2 extends HXDecoration;

var bool bOn;

/*var Vector	LastLoc, RPCLocation;
var bool		bIsMoving;*/

// ----------------------------------------------------------------------------
// Network replication.
// ----------------------------------------------------------------------------

/*replication
{
	reliable if ( Role==ROLE_Authority )
		RPCLocation;
}*/

// ----------------------------------------------------------------------------
// BeginPlay()
// ----------------------------------------------------------------------------

simulated function BeginPlay()
{
	Super.BeginPlay();

	if ( Role==ROLE_Authority && !IsInRelevant() )
	{

		/*RPCLocation = Location;*/
		bAlwaysRelevant = MoverTag!='';
	}
}

// ----------------------------------------------------------------------------
// Frob()
// ----------------------------------------------------------------------------

function Frob( Actor Frobber, Inventory FrobWith )
{
	Super.Frob( Frobber, FrobWith );

	if ( bOn )
	{
		PlaySound( Sound'Switch4ClickOff' );
		PlayAnim( 'Off' );
	}
	else
	{
		PlaySound( Sound'Switch4ClickOn' );
		PlayAnim( 'On' );
	}

	bOn = !bOn;
}

// ----------------------------------------------------------------------------
// SupportActor()
// ----------------------------------------------------------------------------

singular function SupportActor( Actor StandingActor )
{
	// Do nothing.
}

// ----------------------------------------------------------------------------
// Bump()
// ----------------------------------------------------------------------------

function Bump( Actor Other )
{
	// Do nothing.
}

// ----------------------------------------------------------------------------
// Tick()
// ----------------------------------------------------------------------------

simulated function Tick( float DeltaTime )
{						  	
	/*if ( Level.NetMode!=NM_Standalone )
	{
		if ( Role==ROLE_Authority )
		{
			// Was moving, now at rest.
			if ( bIsMoving && Location==LastLoc )
				RPCLocation = Location;

			bIsMoving = Location!=LastLoc;
			LastLoc = Location;
		}
		else
		{
			// Our replicated location changed which means the button has come to rest.
			if ( LastLoc!=RPCLocation )
			{
				SetLocation( RPCLocation );
				LastLoc = RPCLocation;
			}
		}
	}*/

	Super.Tick( DeltaTime );
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	bInvincible=True
	ItemName="Switch"
	bPushable=False
	Physics=PHYS_None
	RemoteRole=ROLE_SimulatedProxy
	Skin=Switch1Tex2
	Mesh=Switch1
	DrawScale=2.0
	CollisionRadius=5.26
	//CollisionHeight=5.94
	CollisionHeight=5.19
	bCollideWorld=False
	bBlockActors=False
	Mass=10.0
	Buoyancy=12.0
}
