//=============================================================================
// HXTechGoggles.
//=============================================================================
class HXTechGoggles extends HXChargedPickup;

// ----------------------------------------------------------------------------
// ChargedPickupBegin()
// ----------------------------------------------------------------------------

function ChargedPickupBegin(HXPlayerPawn Player)
{
	Super.ChargedPickupBegin(Player);

	//HXRootWindow(Player.rootWindow).hud.augDisplay.activeCount++;
	//UpdateHUDDisplay(Player);

	//moved there
	Player.ClientTechGogglesChargedPickupBegin();
}

// ----------------------------------------------------------------------------
// UpdateHUDDisplay()
// ----------------------------------------------------------------------------

function UpdateHUDDisplay(DeusExPlayer Player)
{
	if ((HXRootWindow(Player.rootWindow).hud.augDisplay.activeCount == 0) && (IsActive()))
		HXRootWindow(Player.rootWindow).hud.augDisplay.activeCount++;
	
	HXRootWindow(Player.rootWindow).hud.augDisplay.bVisionActive = True;
	HXRootWindow(Player.rootWindow).hud.augDisplay.visionLevel = 0;
	HXRootWindow(Player.rootWindow).hud.augDisplay.visionLevelValue = 0;
}

// ----------------------------------------------------------------------------
// ChargedPickupEnd()
// ----------------------------------------------------------------------------

function ChargedPickupEnd(HXPlayerPawn Player)
{
	Super.ChargedPickupEnd(Player);

	//if (--HXRootWindow(Player.rootWindow).hud.augDisplay.activeCount == 0)
		//HXRootWindow(Player.rootWindow).hud.augDisplay.bVisionActive = False;

	// moved there
	Player.ClientTechGogglesChargedPickupEnd();
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	LoopSound=TechGogglesLoop
	ChargedIcon=ChargedIconGoggles
	ExpireMessage="TechGoggles power supply used up"
	ItemName="Tech Goggles"
	ItemArticle="some"
	PlayerViewOffset=(X=20.0,Y=0.0,Z=-6.0)
	PlayerViewMesh=GogglesIR
	PickupViewMesh=GogglesIR
	ThirdPersonMesh=GogglesIR
	Charge=500
	LandSound=PaperHit2
	Icon=BeltIconTechGoggles
	LargeIcon=LargeIconTechGoggles
	LargeIconWidth=49
	LargeIconHeight=36
	Description="Tech goggles are used by many special ops forces throughout the world under a number of different brand names, but they all provide some form of portable light amplification in a disposable package."
	BeltDescription="GOGGLES"
	Mesh=GogglesIR
	CollisionRadius=8.00
	//CollisionHeight=2.80
	CollisionHeight=2.05
	Mass=10.0
	Buoyancy=5.0
}
