//=============================================================================
// HXTeleporter
//
// used instead of Teleporter, which is a NavigationPoint subclass
// and could not be spawned (somehow) as a replacement
// making the teleporter makes somehow more sence
// (it maybe was a NavigationPoint for Navigation Code in Unreal/UT
// where Teleporters were gameplay relevant
//=============================================================================
class HXTeleporter extends HXTriggers;

var() string URL;
var() bool   bEnabled; // Teleporter is turned on;

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local Teleporter OtherTeleporter;

	Super.Succeeds( Other );

	// Special Teleporter Init.
	OtherTeleporter = Teleporter(Other);
	if ( OtherTeleporter!=None )
	{
		// Teleporter.
		URL      = OtherTeleporter.URL;
		bEnabled = OtherTeleporter.bEnabled;

		// Make sure old Teleporter gets disabled.
		OtherTeleporter.bEnabled = false;
	}
}

// ----------------------------------------------------------------------
// Trigger()
// ----------------------------------------------------------------------

function Trigger( Actor Other, Pawn EventInstigator )
{
	local int i;

	bEnabled = !bEnabled;
	if ( bEnabled ) //teleport any pawns already in my radius
		for ( i=0; i<4; i++ )
			if ( Touching[i]!=None )
				Touch( Touching[i] );
}

// ----------------------------------------------------------------------
// Touch()
// ----------------------------------------------------------------------

function Touch( Actor Other )
{	
	if ( !bEnabled || !Other.bCanTeleport || !Other.bIsPawn || !Other.IsA('HXPlayerPawn') || URL=="" )
		return;

	//Log( Self $ ".URL = " $ URL );

	// Set Portal explicit, because engine adds the old portal otherwise D:
	if ( InStr(URL,"/")==-1 && InStr(URL,"#")==-1 )
		URL = URL $ "#";
	
	Level.ServerTravel( URL, true );
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	bEnabled=True
	Texture=S_Teleport
	CollisionRadius=18.0
	CollisionHeight=40.0
	bCollideActors=True
}
