//=============================================================================
// HXTextLogWindow.
//
// Original TextLogWindow didn't time out lines on an individual basis,
// but in order only.
//=============================================================================
class HXTextLogWindow extends TextLogWindow
	native;

struct HXTextLogWindowLine
{
	var float  Timer;
	var string Text;
	var Color  Color;
};

/*
// Log entry timeout
//var float                       textTimeout;  // Time before a log entry disappears
// Internal info
//var native private DynamicArray lines;        // Individual log entries.
//var private bool                bTooTall;     // TRUE if the log won't fit in the window
//var private bool                bPaused;      // TRUE if the log is currently paused
*/

/*
var private native const array<HXTextLogWindowLine> Lines; // Individual log entries.
	
var float TextTimeout;   // Default text duration.
*/
var Color TextColor;     // Default text color.
/*
var const bool bTooTall; // If hte log won't fit in the window.

*/
//var bool bTimeoutSuspended; // Whether timing out of the individual lines is suspended.

/*
//native(1570) final function AddLog(string newText, color linecol); // Optional timeout parameter here would be nice --han
//native(1571) final function ClearLog();
//native(1572) final function SetTextTimeout(float newTimeout); // Could be set directly.
//native(1573) final function PauseLog(bool bNewPauseState);    // Could be set directly.
*/

native final function int WindowScale(); // Returns RootWindows hMultiplier.

native final function AddLine( string Text, optional Color Color, optional float Timeout );
native final function ClearLines();
native final function int NumLines(); // How many lines are remaining which are not yet timed out (aka Lines.Num()).

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	TextTimeout=5.0
	TextColor=(R=255,G=255,B=255,A=255)
	bPaused=False
}
