//=============================================================================
// HXToilet.
//=============================================================================
class HXToilet extends HXDecoration;

enum ESkinColor
{
	SC_Clean,
	SC_Filthy
};
var() ESkinColor SkinColor;

var Texture CleanTexture;  // Texture used for SC_Clean.
var Texture FilthyTexture; // Texture used for SC_Filthy.
var Sound   FlushSound;    // Sound to play when used.
var float   ReuseDelay;    // Delay between usage.
var float   LastUseTime;   // Last time this Toilet was used.

// ----------------------------------------------------------------------------
// BeginPlay()
// ----------------------------------------------------------------------------

simulated function BeginPlay()
{
	Super.BeginPlay();

	if ( Role==ROLE_Authority && !IsInRelevant() )
	{
		switch ( SkinColor )
		{
			case SC_Clean:
				Skin = CleanTexture;
				break;
			case SC_Filthy:
				Skin = FilthyTexture;
				break;
		}
	}
}

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local Toilet OtherToilet;

	// Call Super.
	Super.Succeeds( Other );

	// Special Toilet Init.
	OtherToilet = Toilet(Other);
	if ( OtherToilet!=None )
	{
		SetPropertyText( "SkinColor", OtherToilet.GetPropertyText("SkinColor") );
	}
}

// ----------------------------------------------------------------------------
// Frob()
// ----------------------------------------------------------------------------

function Frob( Actor Frobber, Inventory FrobWith )
{
	Super.Frob( Frobber, FrobWith );

	// Prevent using it again for ReuseDelay seconds.
	if ( (LastUseTime+ReuseDelay)<Level.TimeSeconds )
	{
		LastUseTime = Level.TimeSeconds;

		// Alert AI.
		Instigator = Pawn(Frobber);
		AISendEvent( 'LoudNoise', EAITYPE_Audio, 0.7, 384 );

		// Play FlushSound and Anim.
		PlaySound( FlushSound,,,, 256 );
		PlayAnim( 'Flush' );
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	CleanTexture=ToiletTex1
	FilthyTexture=ToiletTex2
	FlushSound=FlushToilet
	ReuseDelay=9.0
	LastUseTime=-9999.0
	bInvincible=True
	ItemName="Toilet"
	bPushable=False
	Physics=PHYS_None
	Mesh=Toilet
	Skin=ToiletTex1
	CollisionRadius=28.00
	//CollisionHeight=28.00
	CollisionHeight=27.25
	Mass=100.0
	Buoyancy=5.0
}
