//=============================================================================
// HXTrash.
//
// TODO:
//  * This should totally be a Fragment or some less heavy weight actor.
//=============================================================================
class HXTrash extends HXDecoration
	abstract;

var Vector LastLoc, Dir;
var Rotator Rot;
var float Time, TransitionEndTime;
var float Rnd;
var bool bStopped, bDescent;

// bTumble is preferred over bWind.
var() bool bTumble; // Whether to behave as spawned by a Containers.
var() bool bWind;   // Whether to behave as spawned by a TrashGenerator
var() float WindSpeed;

// ----------------------------------------------------------------------------
// Networking replication.
// ----------------------------------------------------------------------------

replication
{
	// Tumbling.
	reliable if ( Role==ROLE_Authority )
		bTumble, bWind;

	// Winding.
	reliable if ( Role==ROLE_Authority && bWind )
		WindSpeed;
}

// ----------------------------------------------------------------------------
// BeginPlay()
// ----------------------------------------------------------------------------

simulated function BeginPlay()
{
	Super.BeginPlay();

	if ( Role==ROLE_Authority && !IsInRelevant() )
	{
		Init();
	}
}

// ----------------------------------------------------------------------------
// PostNetBeginPlay()
// ----------------------------------------------------------------------------

simulated function PostNetBeginPlay()
{
	Super.PostNetBeginPlay();

	// Start.
	Init();
}

// ----------------------------------------------------------------------------
// Init() -- Start to behave as desired.
// ----------------------------------------------------------------------------

simulated function Init()
{
	LastLoc = Location + vect(100,0,0);

	if ( bTumble )
	{
		SetPhysics( PHYS_Rolling );
		Rot = RotRand( True );
		Rot.Yaw = 0;
		Dir = VRand() * 20 + vect(20,20,0);
		Dir.Z = 0;
	}
	else if ( bWind )
	{
		SetPhysics( PHYS_Rolling );
		Rot = RotRand( True );
		Rot.Yaw = 0;
		Dir = Vector(Rotation) * WindSpeed;
		Dir.x +=  5 * FRand();
		Dir.y +=  5 * FRand();
		Dir.z  = -2 * FRand();
	}
}

// ----------------------------------------------------------------------------
// InitTrash ()
//
// Virtual from HXDecoration.
// ----------------------------------------------------------------------------

simulated function InitTrash( bool bInTumble, bool bInWind )
{
	bTumble = bInTumble;
	bWind   = bInWind;

	Init();
}

// ----------------------------------------------------------------------------
// Tick()
// ----------------------------------------------------------------------------

simulated function Tick( float DeltaTime )
{
	local Vector NewLocation;

	//Super.Tick( DeltaTime );

	if ( !bFloating && !bStopped )
	{
		Velocity = Dir * Rnd;

		if ( Time>=1.0 )
		{
			Rnd = FRand() * 0.2 + 0.8;
			RotationRate = Rot * Rnd;
			Time = 0;
		}
		Time += DeltaTime;

		// If we haven't moved much since the last frame, stop moving.
		if ( VSize(Location-LastLoc)<0.1 )
			StopMoving();

		LastLoc = Location;
	}
	else if ( bDescent )
	{
		if ( TransitionEndTime>Level.TimeSeconds )
		{
			// Slowly descent to ground.
			NewLocation    = Location;
			NewLocation.Z -= 10.0 * DeltaTime;
			SetLocation( NewLocation );
		}
		else
		{
			// Stop descent.
			bDescent = False;
		}
	
	}
}

// ----------------------------------------------------------------------------
// Timer()
// ----------------------------------------------------------------------------

simulated function Timer()
{
	SetPhysics( PHYS_Falling );

	// Die after some random time.
	// HX_HAN: Is this a good idea for Tumbleweed?
	LifeSpan = 60 * FRand() + 30;
}

// ----------------------------------------------------------------------------
// StopMoving()
// ----------------------------------------------------------------------------

simulated function StopMoving()
{
	local Vector HitLocation, HitNormal, TraceEnd, TraceStart;
	local Actor HitActor;
	local float TransitionTime;

	// Stop floating randomly.
	bStopped = True;
	bDescent = True;

	// Set CollisionSize for landing on ground.
	SetCollisionSize( Default.CollisionRadius, 0.1 );

	// Move to ground.
	Velocity = vect(0,0,0); // Does nothing.

	// Trace down.
	TraceEnd = Location - Vect(0,0,100);
	HitActor = Trace( HitLocation, HitNormal, TraceEnd, Location, False );

	// Scale TransitionTime based on velocity and distance above ground.
	if ( HitActor!=None )
	{
		TransitionTime = (Location.Z - HitLocation.Z - 0.1) / 10.0;
	}
	else
	{
		TransitionTime = 100.0 / 10.0;
	}

	// Setup DesiredRotation to lay flat on ground.
	bRotateToDesired  = False;
	bFixedRotationDir = False;

	DesiredRotation.Pitch = 0;
	DesiredRotation.Yaw   = FRand() * 65535.0;
	DesiredRotation.Roll  = 0;

	// Calculate RotationRate so rotation happens during the whole StillTime.
	RotationRate.Pitch = Abs( Rotation.Pitch % 65535 ) / TransitionTime;
	RotationRate.Yaw   = Abs( Rotation.Yaw   % 65535 ) / TransitionTime;
	RotationRate.Roll  = Abs( Rotation.Roll  % 65535 ) / TransitionTime;

	// Start rotation.
	SetPhysics( PHYS_Rotating );

	// Tween anim to still during whole StillTime.
	TweenAnim( 'Still', TransitionTime );

	// Set timer to start dropping.
	SetTimer( TransitionTime, False );

	TransitionEndTime = Level.TimeSeconds + TransitionTime;
}

// ----------------------------------------------------------------------------
// ZoneChange()
// ----------------------------------------------------------------------------

simulated function ZoneChange( ZoneInfo NewZone )
{
	if ( NewZone.bWaterZone )
		StopMoving();

	Super.ZoneChange( NewZone );
}

// ----------------------------------------------------------------------------
// HitWall()
// ----------------------------------------------------------------------------

simulated function HitWall( Vector HitNormal, Actor Wall )
{
	Velocity = (Velocity dot HitNormal) * HitNormal * (-2.0) + Velocity;
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	RemoteRole=ROLE_SimulatedProxy
	bNetOptional=True
	Time=1.0
	Rnd=1.0
	bHighlight=False
	bClientHighlight=False
	bPushable=False
	LifeSpan=300.0
	bBlockActors=False
	bBlockPlayers=False
	bFixedRotationDir=True
	Mass=2.0
	Buoyancy=3.0
	bNetTemporary=True
	bTumble=False
	bWind=False
	WindSpeed=100.0
}
