//=============================================================================
// HXTrashGenerator.
//
// Spawns some random trash every so often.
//=============================================================================
class HXTrashGenerator extends HXEffects;

enum ETrashType
{
	TT_Paper,
	TT_Tumbleweed
};

var() float Frequency;		// Use very small numbers (~0.001)
var() float WindSpeed;		// Wind speed in ft/sec
var() ETrashType TrashType;

var Class<HXTrash> TrashPaperClass; // Don't hardcode TrashPaper
var Class<HXTrash> TumbleweedClass; // and Tumbleweed anymore.

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local TrashGenerator OtherTrashGenerator;

	// Call Super.
	Super.Succeeds( Other );

	// Special TrashGenerator Init.
	OtherTrashGenerator = TrashGenerator(Other);
	if ( OtherTrashGenerator!=None )
	{
		Frequency = OtherTrashGenerator.Frequency;
		WindSpeed = OtherTrashGenerator.WindSpeed;

		SetPropertyText( "TrashType", OtherTrashGenerator.GetPropertyText("TrashType") );
	}
}

// ----------------------------------------------------------------------------
// EffectsTimer()
// ----------------------------------------------------------------------------

event EffectsTimer()
{
	local Class<HXTrash> SpawnClass;
	local HXTrash Trash;

	// Just spawn them on the server. Trash uses a bNetTemporary pattern.
	if ( Role<ROLE_Authority )
		return;

	if ( FRand()<Frequency )
	{
		switch ( TrashType )
		{
			case TT_Paper:
				SpawnClass = TrashPaperClass;
				break;

			case TT_Tumbleweed:
				SpawnClass = TumbleWeedClass;
				break;
		}

		if ( SpawnClass==None )
		{
			Warn( "SpawnClass is None (Disabling..)" );
			return;
		}

		Trash = Spawn( SpawnClass, None, '', Location, Rotation );
		if ( Trash!=None )
		{
			Trash.WindSpeed = WindSpeed;
			Trash.bWind     = true;
			Trash.bTumble   = false;
			
			// Needed for SinglePlayer, ListenServer.
			Trash.Init();
		}
	}

	// Fire again in 0.1 seconds.
	EffectsTime = 0.1;
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	EffectsTime=0.1
	RemoteRole=ROLE_None
	Frequency=0.001
	WindSpeed=100.0
	bHidden=True
	bDirectional=True
	DrawType=DT_Sprite
	Texture=S_Inventory
	TrashPaperClass=HXTrashPaper
	TumbleweedClass=HXTumbleweed
}
