//=============================================================================
// HXTree.
//=============================================================================
class HXTree extends HXOutdoorThings
	abstract;

var() float SoundFreq;		// chance of making a sound every 5 seconds

// ----------------------------------------------------------------------------
// Network replication.
// ----------------------------------------------------------------------------

replication
{
	// Server to client.
	reliable if ( Role==ROLE_Authority )
		SoundFreq;
}

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local Tree OtherTree;

	// Call Super.
	Super.Succeeds( Other );

	// Special Tree Init.
	OtherTree = Tree(Other);
	if ( OtherTree!=None )
	{
		SoundFreq = OtherTree.SoundFreq;
	}
}

// ----------------------------------------------------------------------------
// Timer()
// ----------------------------------------------------------------------------

simulated function Timer()
{
	if ( FRand()<SoundFreq )
	{
		// play wind sounds at random pitch offsets
		if ( FRand()<0.5 )
			PlaySound( Sound'WindGust1', SLOT_Misc,,, 2048, 0.7+0.6*FRand() );
		else
			PlaySound( Sound'WindGust2', SLOT_Misc,,, 2048, 0.7+0.6*FRand() );
	}
}

// ----------------------------------------------------------------------------
// PostBeginPlay()
// ----------------------------------------------------------------------------

simulated function PostBeginPlay()
{
	Super.PostBeginPlay();

	SetTimer( 4.0+2.0*FRand(), true );
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	ItemName="Tree"
	SoundFreq=0.2
	Mass=2000.0
	Buoyancy=5.0
}
