//=============================================================================
// HXTree1.
//=============================================================================
class HXTree1 extends HXTree;

enum ESkinColor
{
	SC_Tree1,
	SC_Tree2,
	SC_Tree3
};

var() ESkinColor SkinColor;

// ----------------------------------------------------------------------------
// BeginPlay()
// ----------------------------------------------------------------------------

simulated function BeginPlay()
{
	Super.BeginPlay();

	if ( Role==ROLE_Authority && !IsInRelevant() )
	{
		switch ( SkinColor )
		{
			case SC_Tree1: Skin = Texture'Tree2Tex1'; break;
			case SC_Tree2: Skin = Texture'Tree2Tex2'; break;
			case SC_Tree3: Skin = Texture'Tree2Tex3'; break;
		}
	}
}

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local Tree1 OtherTree1;

	// Call Super.
	Super.Succeeds( Other );

	// Special Tree1 Init.
	OtherTree1 = Tree1(Other);
	if ( OtherTree1!=None )
	{
		SetPropertyText( "SkinColor", OtherTree1.GetPropertyText("SkinColor") );
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	Mesh=Tree1
	Skin=Tree2Tex1
	CollisionRadius=10.00
	//CollisionHeight=125.00
	CollisionHeight=124.25
}
