//=============================================================================
// HXTree2.
//=============================================================================
class HXTree2 extends HXTree;

enum ESkinColor
{
	SC_Tree1,
	SC_Tree2,
	SC_Tree3
};

var() ESkinColor SkinColor;

// ----------------------------------------------------------------------------
// BeginPlay()
// ----------------------------------------------------------------------------

simulated function BeginPlay()
{
	Super.BeginPlay();

	if ( Role==ROLE_Authority && !IsInRelevant() )
	{
		switch ( SkinColor )
		{
			case SC_Tree1: Skin = Texture'Tree2Tex1'; break;
			case SC_Tree2: Skin = Texture'Tree2Tex2'; break;
			case SC_Tree3: Skin = Texture'Tree2Tex3'; break;
		}
	}
}

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local Tree2 OtherTree2;

	// Call Super.
	Super.Succeeds( Other );

	// Special Tree2 Init.
	OtherTree2 = Tree2(Other);
	if ( OtherTree2!=None )
	{
		SetPropertyText( "SkinColor", OtherTree2.GetPropertyText("SkinColor") );
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	Mesh=Tree2
	Skin=Tree2Tex1
	CollisionRadius=10.00
	//CollisionHeight=182.37
	CollisionHeight=181.62
}
