//=============================================================================
// HXUdpBeacon: Base class of beacon sender and receiver.
//=============================================================================
class HXUdpBeacon extends HXUdpLink
	transient
	config;

var() globalconfig bool       DoBeacon;
var() globalconfig int        ServerBeaconPort;		// Listen port
var() globalconfig int        BeaconPort;			// Reply port
var() globalconfig float      BeaconTimeout;
//var() globalconfig string     BeaconProduct;

var string BeaconProduct;

var int	UdpServerQueryPort;
var int boundport;

function BeginPlay()
{
	local IpAddr Addr;

	// Load BeaconProduct out of ini.
	BeaconProduct = GetConfig( "Beacon", "Product" );
	Log( Name $ ": BeaconProduct is " $ BeaconProduct, 'DevGameSpy' );

	boundport = BindPort(ServerBeaconPort, True);
	if ( boundport == 0 )
	{
		Warn( Name $ ": Failed to bind a port." );
		return;
	}
	Log( Name $ ": Port "$boundport$" successfully bound.", 'DevGameSpy' );

	Addr.Addr = BroadcastAddr;
	Addr.Port = BeaconPort;
	BroadcastBeacon(Addr); // Initial notification.
}

function BroadcastBeacon(IpAddr Addr)
{
	SendText( Addr, BeaconProduct @ Mid(Level.GetAddressURL(),InStr(Level.GetAddressURL(),":")+1) @ Level.Game.GetBeaconText() );
	//Log( "UdpBeacon: sending reply to "$IpAddrToString(Addr) );
}

function BroadcastBeaconQuery(IpAddr Addr)
{
	SendText( Addr, BeaconProduct @ UdpServerQueryPort );
	//Log( "UdpBeacon: sending query reply to "$IpAddrToString(Addr) );
}

event ReceivedText( IpAddr Addr, string Text )
{
	if( Text == "REPORT" )
		BroadcastBeacon(Addr);

	if( Text == "REPORTQUERY" )
		BroadcastBeaconQuery(Addr);
}

function Destroyed()
{
	Super.Destroyed();
	//Log("ServerBeacon Destroyed");
}

defaultproperties
{
	DoBeacon=True
	ServerBeaconPort=8777
	BeaconPort=7776
	BeaconTimeout=5.000000
	BeaconProduct="invalid"
	RemoteRole=ROLE_None
}
