//=============================================================================
// HXUnTrigger.
//
// Sends an UnTrigger event when touched or triggered.
// Set bCollideActors to False to make it triggered.
//=============================================================================
class HXUnTrigger extends HXTrigger;

// ----------------------------------------------------------------------------
// Trigger()
// ----------------------------------------------------------------------------

function Trigger( Actor Other, Pawn Instigator )
{
	local Actor A;

	if( Event=='' )
		return;

	// UnTrigger event.
	foreach AllActors( class'Actor', A, Event )
		A.UnTrigger( Other, Instigator );
}

// ----------------------------------------------------------------------------
// Touch()
// ----------------------------------------------------------------------------

function Touch( Actor Other )
{
	local Actor A;

	if( Event=='' )
		return;

	if ( !IsRelevant(Other) )
		return;

	// UnTrigger event.
	foreach AllActors( class'Actor', A, Event )
		A.UnTrigger( Other, Pawn(Other) );
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
}
