//=============================================================================
// HXUniversalConstructorEffect.
//
// Combines what the visual effects played when Universal Constructors in 
// Area 51 create a new ...thing.
//=============================================================================
class HXUniversalConstructorEffect extends HXEffects
	transient;

// ----------------------------------------------------------------------------
// BeginPlay()
// ----------------------------------------------------------------------------

simulated function BeginPlay()
{
	local HXElectricityEmitter ElectricityEmitter;
	local HXSphereEffect SphereEffect;
	local Actor Actor;
	local Vector Temp;
	local int i;

	// Add a light effect.
	Actor = Spawn( Class'ExplosionLight',  , , Location ); 
	if ( Actor!=None )
	{
		Actor.RemoteRole = ROLE_None;
	}

	// Add some volume effects.
	Actor = Spawn( Class'HXEllipseEffect', , , Location );
	if ( Actor!=None )
	{
		Actor.RemoteRole = ROLE_None;
	}

	SphereEffect = Spawn( Class'HXSphereEffect',,, Location );
	if ( SphereEffect!=None )
	{
		SphereEffect.RemoteRole = ROLE_None;
		SphereEffect.Size = 4.0;
	}

	// Add some electricity effects.
	for ( i=0; i<4; i++ )
	{
		Temp   = Vect(0,0,0);
		Temp.Z = 32.0 + 32.0 * i;

		ElectricityEmitter = Spawn( Class'HXElectricityEmitter', , , Location + Temp, Rot(16384,0,0) );
		if ( ElectricityEmitter!=None)
		{
			ElectricityEmitter.RemoteRole  = ROLE_None;
			ElectricityEmitter.RandomAngle = 32768.0;
			ElectricityEmitter.LifeSpan    = 1.0;
			
			// Don't do damage on clients.
			if ( Level.NetMode==NM_Client )
			{
				ElectricityEmitter.DamageAmount = 0;
			}
		}
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	RemoteRole=ROLE_SimulatedProxy
	bNetTemporary=True
	bNetOptional=False
	DrawType=DT_None
	LifeSpan=1.00000
}
