//=============================================================================
// HXVehicles.
//=============================================================================
class HXVehicles extends HXDecoration
	abstract;

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local Vehicles OtherVehicles;

	// Call Super.
	Super.Succeeds( Other );

	// Special Vehicles Init.
	OtherVehicles = Vehicles(Other);
	if ( OtherVehicles!=None )
	{
		bInWorld = OtherVehicles.bInWorld; // Might not be enough!
	}
}

// ----------------------------------------------------------------------------
// PostNetBeginPlay()
// ----------------------------------------------------------------------------

simulated function PostNetBeginPlay()
{
	//local HXInterpolationPoint I;
	local InterpolationPoint I;

	Super.PostNetBeginPlay();

	//Log( Self $ ".PostNetBeginPlay()" );
	
	if ( Event != '' )
	{
		//foreach AllActors (class'HXInterpolationPoint', I, Event )
		foreach AllActors (class'InterpolationPoint', I, Event )
		{
			if (I.Position == 1)		// start at 1 instead of 0 - put 0 at the object's initial position
			{
				Target = I;
				//Log( "Setting " $ Self $ ".Target = " $ I $ " (V)" );
				break;
			}
		}
	}
}


// ----------------------------------------------------------------------------
// state Interpolating.
// ----------------------------------------------------------------------------

state Interpolating
{
	// check to see if we are done interpolating, if so, then destroy us
	event InterpolateEnd(Actor Other)
	{
		Super.InterpolateEnd(Other);

		//Log( Self $ ".InterpolateEnd( " $ Other $ " )" );

		if (InterpolationPoint(Other).bEndOfPath)
		{
			// Reset physics, as InterpolateEnd() on IP will have set them to falling.
			SetPhysics( PHYS_None );

			// Destroy will likely fail for bNoDelete actors.
			Destroy();
		}
	}
}

// ----------------------------------------------------------------------------
// InterpolateEnd()
// ----------------------------------------------------------------------------

simulated event InterpolateEnd( Actor Other )
{
	//Log( Self $ ".InterpolateEnd( " $ Other $ " )" );

	if ( InterpolationPoint(Other).bEndOfPath )
	{
		// Reset physics, as InterpolateEnd() on IP will have set them to falling.
		SetPhysics( PHYS_None );
	}

	Super.InterpolateEnd(Other);
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	RemoteRole=ROLE_SimulatedProxy
	bAlwaysRelevant=True
	bInvincible=True
	bPushable=False
	Physics=PHYS_None
	PhysRate=1.0
	PhysAlpha=0.0
}
