//=============================================================================
// HXVendingMachine.
//=============================================================================
class HXVendingMachine extends HXVendingMachineBase;

#exec OBJ LOAD FILE=Ambient

var() enum ESkinColor
{
	SC_Drink,
	SC_Snack
} SkinColor;

// ----------------------------------------------------------------------------
// PreBeginPlay()
// ----------------------------------------------------------------------------

function PreBeginPlay()
{
	Super.PreBeginPlay();

	if ( bDeleteMe || IsInRelevant() )
		return;

	// Apply SkinColor effect.
	switch ( SkinColor )
	{
		case SC_Drink:
			Skin          = Texture'VendingMachineTex1';
			PurchaseSound = Sound'VendingCan';
			ProductClass  = Class'Sodacan';
 			break;

		case SC_Snack:
			Skin          = Texture'VendingMachineTex2';
			PurchaseSound = Sound'VendingSmokes';
			ProductClass  = Class'Candybar';
			break;
	}
}

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local VendingMachine OtherVendingMachine;

	// Call Super.
	Super.Succeeds( Other );

	// Special VendingMachine Init.
	OtherVendingMachine = VendingMachine(Other);
	if ( OtherVendingMachine!=None )
	{
		SetPropertyText( "SkinColor", OtherVendingMachine.GetPropertyText("SkinColor") );
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	ItemName="Vending Machine"
	Mesh=VendingMachine
	Skin=VendingMachineTex1
	SoundRadius=8
	SoundVolume=96
	AmbientSound=HumLow3
	CollisionRadius=34.00
	//CollisionHeight=50.00
	CollisionHeight=49.25
	Mass=150.0
	Buoyancy=100.0
	bCanBeBase=True
	NumUses=10
	Cost=2
	PaySound=VendingCoin
}
