//=============================================================================
// HXVendingMachineBase.
//
// Common baseclass for Cigarette and VendingMachine.
//=============================================================================
class HXVendingMachineBase extends HXElectronicDevices
	abstract;

var int NumUses;
var int Cost;

var Sound PaySound;
var Sound PurchaseSound;
var Class<Inventory> ProductClass;

var localized String MsgPurchased;
var localized String MsgCost;
var localized String MsgEmpty;

// ----------------------------------------------------------------------------
// BeginPlay()
// ----------------------------------------------------------------------------

function BeginPlay()
{
	Super.BeginPlay();

	if ( bDeleteMe || IsInRelevant() )
		return;

	// Modify ProductClass in BeginPlay, as inside PreBeginPlay
	// mutator logic may modify it.
	if ( ProductClass!=None )
	{
		Game.ModifyInventoryClass( ProductClass );

		// Enfore HX class?
	}
}

// ----------------------------------------------------------------------------
// Frob()
// ----------------------------------------------------------------------------

function Frob( Actor Frobber, Inventory FrobWith )
{
	local HXPlayerPawn Player;
	local Vector SpawnLocation;
	local Inventory Product;

	Super.Frob( Frobber, FrobWith );

	Player = HXPlayerPawn(Frobber);
	if ( Player==None )
		return;

	if ( NumUses<=0 )
	{
		Player.ClientMessage( MsgEmpty );
		return;
	}

	if ( Player.Credits<Cost )
	{
		Player.ClientMessage( Sprintf(MsgCost,Cost) );
		return;
	}

	SpawnLocation    = Location;
	SpawnLocation   += Vector(Rotation)*(CollisionRadius*0.8);
	SpawnLocation.Z -= CollisionHeight*0.6; 

	Product = Spawn( ProductClass, None,, SpawnLocation );
	if ( Product!=None )
	{
		// !!
		PlaySound( PaySound, SLOT_None );
		PlaySound( PurchaseSound, SLOT_None );

		Product.Velocity           = Vector(Rotation)*100.0;
		Product.bFixedRotationDir  = true;
		Product.RotationRate.Pitch = (0.5-FRand())*262144.0;
		Product.RotationRate.Yaw   = (0.5-FRand())*262144.0;

		Player.Credits -= Cost;
		Player.ClientMessage( Sprintf(MsgPurchased,Cost) );
		NumUses--;
	}
	else
	{
		Warn( "Failed to spawn ProductClass" @ ProductClass );
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	MsgPurchased="%s credits deducted from your account."
	MsgCost="Costs %s credits..."
	MsgEmpty="It's empty."
}
