//=============================================================================
// HXVialAmbrosia.
//=============================================================================
class HXVialAmbrosia extends HXInstantUsePickup;

var const localized string MsgNoEffect;
var const localized string MsgWasInfected;

// ----------------------------------------------------------------------------
// InstantUse()
// ----------------------------------------------------------------------------

function InstantUse( Pawn OwnerPawn, Actor FrobTarget )
{
	local HXPlayerPawn OwnerPlayer;
	local bool bWasNanoVirusInfected;

	OwnerPlayer = HXPlayerPawn(OwnerPawn);
	if ( OwnerPlayer==None )
		return;

	bWasNanoVirusInfected = OwnerPlayer.bNanoVirusInfected;

	// Won't affect bWasNanoVirusInfected if immune or not infected.
	OwnerPlayer.DecreaseNanoVirusInfection();

	// Already was infected.
	if ( bWasNanoVirusInfected )
		OwnerPlayer.ClientMessage( MsgWasInfected, 'StatusLine' );

	// Immune or not infected.
	else
		OwnerPlayer.ClientMessage( MsgNoEffect, 'StatusLine' );
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	MsgTooMany="You can't carry any more ambrosia"
	MsgNoEffect="Strange... nothing happens..."
	MsgWasInfected="They say it only lasts for a while..."
	M_Activated=""
	MaxCopies=10
	bCanHaveMultipleCopies=True
	bActivatable=True
	ItemName="Ambrosia Vial"
	ItemArticle="an"
	PlayerViewOffset=(X=30.0,Y=0.0,Z=-12.0)
	PlayerViewMesh=VialAmbrosia
	PickupViewMesh=VialAmbrosia
	ThirdPersonMesh=VialAmbrosia
	LandSound=GlassHit1
	Icon=BeltIconVialAmbrosia
	LargeIcon=LargeIconVialAmbrosia
	LargeIconWidth=18
	LargeIconHeight=44
	Description="The only known vaccine against the 'Gray Death.' Unfortunately, it is quickly metabolized by the body making its effects temporary at best."
	beltDescription="AMBROSIA"
	Mesh=VialAmbrosia
	CollisionRadius=2.20
	//CollisionHeight=4.89
	CollisionHeight=4.14
	Mass=2.0
	Buoyancy=3.0
}
