//=============================================================================
// HXVialVirus.
//
// Not a stock class, but to complement VialAmbrosia.
//=============================================================================
class HXVialVirus extends HXInstantUsePickup;

#exec OBJ LOAD FILE=Effects

// FLAGS=PF_NoSmooth|PF_Masked
#exec TEXTURE IMPORT FILE="Textures\Icons\HXBeltIconVialVirus.bmp"  NAME="HXBeltIconVialVirus"  GROUP="Icons" MIPS=Off FLAGS=2050
#exec TEXTURE IMPORT FILE="Textures\Icons\HXLargeIconVialVirus.bmp" NAME="HXLargeIconVialVirus" GROUP="Icons" MIPS=Off FLAGS=2050

var const localized string MsgNoEffect;
var const localized string MsgGotInfected;
var const localized string MsgWasInfected;

// ----------------------------------------------------------------------------
// InstantUse()
// ----------------------------------------------------------------------------

function InstantUse( Pawn OwnerPawn, Actor FrobTarget )
{
	local HXPlayerPawn OwnerPlayer;
	local bool bWasNanoVirusInfected;

	OwnerPlayer = HXPlayerPawn(OwnerPawn);
	if ( OwnerPlayer==None )
		return;

	bWasNanoVirusInfected = OwnerPlayer.bNanoVirusInfected;

	// Won't affect bWasNanoVirusInfected if immune or already infected.
	OwnerPlayer.IncreaseNanoVirusInfection();

	// Already was infected.
	if ( bWasNanoVirusInfected )
		OwnerPlayer.ClientMessage( MsgWasInfected, 'StatusLine' );

	// Got infected.
	else if ( OwnerPlayer.bNanoVirusInfected )
		OwnerPlayer.ClientMessage( MsgGotInfected, 'StatusLine' );
	// Immune.

	else
		OwnerPlayer.ClientMessage( MsgNoEffect, 'StatusLine' );
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	MsgTooMany="You can't carry any more nanovirus"
	MsgNoEffect="Strange... nothing happens..."
	MsgGotInfected="I shouldn't have done this..."
	MsgWasInfected="I shouldn't be doing this..."
	M_Activated=""
	MaxCopies=10
	bCanHaveMultipleCopies=True
	bActivatable=True
	ItemName="NanoVirus Vial"
	ItemArticle="a"
	PlayerViewOffset=(X=30.0,Y=0.0,Z=-12.0)
	PlayerViewMesh=VialAmbrosia
	PickupViewMesh=VialAmbrosia
	ThirdPersonMesh=VialAmbrosia
	LandSound=GlassHit1
	Icon=HXBeltIconVialVirus
	LargeIcon=HXLargeIconVialVirus
	LargeIconWidth=18
	LargeIconHeight=44
	Description="A handy portion of 'Gray Death'."
	BeltDescription="NANOVIRUS"
	Mesh=VialAmbrosia
	MultiSkins(1)=Virus_SFX
	CollisionRadius=2.20
	//CollisionHeight=4.89
	CollisionHeight=4.14
	Mass=2.0
	Buoyancy=3.0
}
