//=============================================================================
// HXWHChairPink.
//=============================================================================
class HXWHChairPink extends HXSeat;

enum ESeatColor
{
	SC_Pink,
	SC_Blue,
	SC_Green,
	SC_Red,
	SC_BlueFancy,
	SC_RedFancy
};

enum EBackColor
{
	SC_Blue,
	SC_Green,
	SC_Red,
	SC_Wood,
	SC_WoodBars,
	SC_WoodX
};

var() ESeatColor SeatColor;
var() EBackColor BackColor;

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local WHChairPink OtherWHChairPink;

	// Call Super.
	Super.Succeeds( Other );

	// Special WHChairPink Init.
	OtherWHChairPink = WHChairPink(Other);
	if ( OtherWHChairPink!=None )
	{
		SetPropertyText( "SeatColor", OtherWHChairPink.GetPropertyText("SeatColor") );
		SetPropertyText( "BackColor", OtherWHChairPink.GetPropertyText("BackColor") );
	}
}

// ----------------------------------------------------------------------------
// BeginPlay()
// ----------------------------------------------------------------------------

simulated function BeginPlay()
{
	Super.BeginPlay();

	if ( Role==ROLE_Authority && !IsInRelevant() )
	{
		switch ( SeatColor )
		{
			case SC_Pink:      MultiSkins[0] = Texture'WHChairPinkBaseTex1'; break;
			case SC_Blue:      MultiSkins[0] = Texture'WHChairPinkBaseTex2'; break;
			case SC_Green:     MultiSkins[0] = Texture'WHChairPinkBaseTex3'; break;
			case SC_Red:       MultiSkins[0] = Texture'WHChairPinkBaseTex4'; break;
			case SC_BlueFancy: MultiSkins[0] = Texture'WHChairPinkBaseTex5'; break;
			case SC_RedFancy:  MultiSkins[0] = Texture'WHChairPinkBaseTex6'; break;
		}

		switch ( BackColor )
		{
			case SC_Blue:     MultiSkins[1] = Texture'WHChairPinkBackTex1'; break;
			case SC_Green:    MultiSkins[1] = Texture'WHChairPinkBackTex2'; break;
			case SC_Red:      MultiSkins[1] = Texture'WHChairPinkBackTex3'; break;
			case SC_Wood:     MultiSkins[1] = Texture'WHChairPinkBackTex4'; break;
			case SC_WoodBars: MultiSkins[1] = Texture'WHChairPinkBackTex5'; break;
			case SC_WoodX:    MultiSkins[1] = Texture'WHChairPinkBackTex6'; break;
		}
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	BackColor=SC_WoodBars
	SitPoint(0)=(X=0.0,Y=0.0,Z=0.0)
	ItemName="Chair"
	Mesh=WHChairPink
	CollisionRadius=16.00
	//CollisionHeight=24.00
	CollisionHeight=23.25
	Mass=25.00
	Buoyancy=5.0
}
